/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.NullAccumulateMonitor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;

public class AccumulateMonitor
implements AccumulateMonitorInterface {
    protected static final String TOTAL = "Total";
    protected static final String MIN = "Min";
    protected static final String MAX = "Max";
    protected static final String HITS = "Hits";
    protected static final String AVG = "Avg";
    protected static final String STANDARD_DEVIATION = "Std Dev";
    protected static final String ACTIVE = "Active";
    protected static final String AVGACTIVE = "Avg Active";
    protected static final String MAXACTIVE = "Max Active";
    protected long accrued;
    private AccumulateMonitorInterface childMonitor;
    private boolean primary = false;
    protected static final String MILLISECONDS = "ms.";
    protected static final String NONE = "";

    public AccumulateMonitor() {
        this(NullAccumulateMonitor.createInstance());
    }

    public AccumulateMonitor(AccumulateMonitorInterface childMonitor) {
        this.childMonitor = childMonitor;
    }

    protected static String convertToString(double value) {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        numberFormat.applyPattern("#,###.#");
        return numberFormat.format(value);
    }

    public synchronized long getAccrued() {
        return this.accrued;
    }

    public String getAccruedString() {
        return AccumulateMonitor.convertToString(this.getAccrued());
    }

    public void getData(ArrayList rowData) {
        this.getDataThis(rowData);
        this.childMonitor.getData(rowData);
    }

    protected void getDataThis(ArrayList rowData) {
        rowData.add(this.getAccruedString());
    }

    protected String getDisplayString(String type, String value, String units) {
        return String.valueOf(type) + "=" + value + " " + units + " ";
    }

    public void getHeader(ArrayList header) {
        this.getHeaderThis(header);
        this.childMonitor.getHeader(header);
    }

    protected void getHeaderThis(ArrayList header) {
        header.add(String.valueOf(this.getType()) + " " + this.getUnits());
    }

    public String getType() {
        return NONE;
    }

    public String getUnits() {
        return NONE;
    }

    public void increase() {
        this.increase(1L);
    }

    public void increase(long increaseValue) {
        this.increaseThis(increaseValue);
        this.childMonitor.increase(increaseValue);
    }

    protected synchronized void increaseThis(long increase) {
        this.accrued += increase;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public static void main(String[] args) throws Exception {
        AccumulateMonitor m = new AccumulateMonitor();
        System.out.println("0=" + m);
        m.increase(25L);
        System.out.println("25=" + m);
        m.increase(50L);
        System.out.println("75=" + m);
        m.reset();
        System.out.println("0=" + m);
        m.increase(1000L);
        System.out.println("1000=" + m);
    }

    public void reset() {
        this.resetThis();
        this.childMonitor.reset();
    }

    protected synchronized void resetThis() {
        this.accrued = 0L;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.childMonitor.setPrimary(primary);
    }

    public void start() {
        this.startThis();
        this.childMonitor.start();
    }

    protected void startThis() {
    }

    public void stop() {
        this.childMonitor.stop();
        this.stopThis();
    }

    protected void stopThis() {
    }

    public String toString() {
        return String.valueOf(this.toStringThis()) + this.toStringChild();
    }

    protected String toStringChild() {
        return this.childMonitor.toString();
    }

    protected synchronized String toStringThis() {
        return this.getDisplayString(this.getType(), this.getAccruedString(), this.getUnits());
    }
}

