/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import java.util.ArrayList;

public class ActiveStatsMonitor
extends AccumulateMonitor {
    private int max = Integer.MIN_VALUE;
    private int active;
    private int hits;
    private int total;

    public ActiveStatsMonitor() {
    }

    public ActiveStatsMonitor(AccumulateMonitorInterface childMonitor) {
        super(childMonitor);
    }

    final float avg() {
        if (this.hits == 0) {
            return 0.0f;
        }
        return (float)this.total / (float)this.hits;
    }

    public synchronized long getAccrued() {
        return this.active;
    }

    protected synchronized void getDataThis(ArrayList rowData) {
        rowData.add(AccumulateMonitor.convertToString(this.active));
        rowData.add(AccumulateMonitor.convertToString(this.avg()));
        rowData.add(AccumulateMonitor.convertToString(this.max));
    }

    protected void getHeaderThis(ArrayList header) {
        header.add("Active");
        header.add("Avg Active");
        header.add("Max Active");
    }

    protected void increaseThis(long increase) {
    }

    public static void main(String[] args) throws Exception {
        ActiveStatsMonitor mon = new ActiveStatsMonitor();
        System.out.println("should not have 0 divide error=" + mon);
        mon.start();
        mon.start();
        mon.start();
        mon.stop();
        mon.stop();
        mon.start();
        System.out.println("should be active 2, avg 2, max active 3=" + mon);
    }

    protected synchronized void resetThis() {
        this.max = Integer.MIN_VALUE;
        this.total = 0;
        this.active = 0;
        this.hits = 0;
    }

    protected synchronized void startThis() {
        ++this.active;
        ++this.hits;
        this.total += this.active;
        if (this.active > this.max) {
            this.max = this.active;
        }
    }

    protected synchronized void stopThis() {
        if (this.active > 0) {
            --this.active;
        }
    }

    protected synchronized String toStringThis() {
        return String.valueOf(this.getDisplayString("Active", AccumulateMonitor.convertToString(this.active), "")) + this.getDisplayString("Avg Active", AccumulateMonitor.convertToString(this.avg()), "") + this.getDisplayString("Max Active", AccumulateMonitor.convertToString(this.max), "");
    }
}

