/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MinimalMonitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorLeafFactory;
import com.jamonapi.MonitorReportInterface;
import com.jamonapi.TimingMonitor;
import com.jamonapi.utils.AppBaseException;
import com.jamonapi.utils.Command;
import com.jamonapi.utils.CommandIterator;
import com.jamonapi.utils.CompositeNode;
import com.jamonapi.utils.LeafNode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class MonitorComposite
implements MinimalMonitor,
CompositeNode,
MonitorReportInterface {
    private static String displayDelimiter = ".";
    private Map monitorList = new TreeMap();
    private static MonitorLeafFactory leafFactory = new MonitorLeafFactory();

    public void addCompositeNode(String childNodeName, CompositeNode addNode) {
        boolean nodeExists = this.compositeNodeExists(childNodeName);
        if (!nodeExists) {
            this.monitorList.put(this.getCompositeNodeKey(childNodeName), addNode);
        }
    }

    public void addLeafNode(String childNodeName, LeafNode addNode) {
        boolean nodeExists = this.leafNodeExists(childNodeName);
        if (!nodeExists) {
            this.monitorList.put(this.getLeafNodeKey(childNodeName), addNode);
        }
    }

    public boolean compositeNodeExists(String childNodeName) {
        return this.monitorList.containsKey(this.getCompositeNodeKey(childNodeName));
    }

    public long getAccrued() {
        class AccruedCommand
        implements Command {
            long accrued;

            AccruedCommand() {
            }

            public void execute(Object monitor) throws Exception {
                this.accrued = monitor instanceof TimingMonitor ? (this.accrued += ((TimingMonitor)monitor).childMonitor.getAccrued()) : (this.accrued += ((MonitorComposite)monitor).getAccrued());
            }
        }
        AccruedCommand command = new AccruedCommand();
        this.iterate(command);
        return command.accrued;
    }

    public String getAccruedString() {
        DecimalFormat numberFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        numberFormat.applyPattern("#,###");
        return numberFormat.format(this.getAccrued());
    }

    public CompositeNode getCompositeNode(String childNodeName) {
        if (this.compositeNodeExists(childNodeName)) {
            return this.getExistingCompositeNode(childNodeName);
        }
        return new MonitorComposite();
    }

    public String getCompositeNodeKey(String nodeName) {
        String COMPOSITE_NODE_KEY_APPENDER = "C";
        return String.valueOf(nodeName) + "C";
    }

    public String[][] getData() {
        MonitorConverter mc = new MonitorConverter(this);
        return mc.getData();
    }

    public String[][] getData(String label) {
        MonitorConverter mc = new MonitorConverter(this);
        return mc.getData(label);
    }

    public void getData(ArrayList rowData) {
    }

    public CompositeNode getExistingCompositeNode(String childNodeName) {
        return (CompositeNode)this.monitorList.get(this.getCompositeNodeKey(childNodeName));
    }

    public LeafNode getExistingLeafNode(String childNodeName) {
        return (LeafNode)this.monitorList.get(this.getLeafNodeKey(childNodeName));
    }

    protected static String[] getHeader() {
        return leafFactory.getHeader();
    }

    public void getHeader(ArrayList header) {
    }

    protected String getLabelFromKey(String key) {
        int lastCharPos = key.length() - 1;
        String lastChar = "";
        if (key.charAt(lastCharPos) == 'C') {
            lastChar = displayDelimiter;
        }
        return String.valueOf(key.substring(0, lastCharPos)) + lastChar;
    }

    public LeafNode getLeafNode(String childNodeName, String childNodeType) {
        if (this.leafNodeExists(childNodeName)) {
            TimingMonitor mon = (TimingMonitor)this.getExistingLeafNode(childNodeName);
            return mon;
        }
        return leafFactory.createInstance(childNodeType);
    }

    public String getLeafNodeKey(String nodeName) {
        String LEAF_NODE_KEY_APPENDER = "L";
        return String.valueOf(nodeName) + "L";
    }

    public String getReport() throws Exception {
        MonitorConverter mc = new MonitorConverter(this);
        return mc.getReport();
    }

    public String getReport(int sortCol, String sortOrder) throws Exception {
        MonitorConverter mc = new MonitorConverter(this);
        return mc.getReport(sortCol, sortOrder);
    }

    public CompositeNode getRootNode() {
        return this;
    }

    public void increase(long increaseValue) {
        class IncreaseCommand
        implements Command {
            private final /* synthetic */ long val$increaseValue;

            IncreaseCommand(long val$increaseValue) {
                this.val$increaseValue = val$increaseValue;
            }

            public void execute(Object monitor) throws Exception {
                ((MinimalMonitor)monitor).increase(this.val$increaseValue);
            }
        }
        this.iterate(new IncreaseCommand(increaseValue));
    }

    void iterate(Command command) {
        try {
            CommandIterator.iterate(this.monitorList.values().iterator(), command);
        }
        catch (Exception e) {
            throw AppBaseException.getRuntimeException(e);
        }
    }

    void iterateMapEntries(Command command) {
        try {
            CommandIterator.iterate(this.monitorList, command);
        }
        catch (Exception e) {
            throw AppBaseException.getRuntimeException(e);
        }
    }

    public boolean leafNodeExists(String childNodeName) {
        return this.monitorList.containsKey(this.getLeafNodeKey(childNodeName));
    }

    public void reset() {
        class ResetCommand
        implements Command {
            ResetCommand() {
            }

            public void execute(Object monitor) throws Exception {
                ((MinimalMonitor)monitor).reset();
            }
        }
        this.iterate(new ResetCommand());
    }

    public static void setDisplayDelimiter(String localDisplayDelimiter) {
        displayDelimiter = localDisplayDelimiter;
    }

    public String toString() {
        return this.getAccruedString();
    }
}

