/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.MinimalMonitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorReportInterface;
import com.jamonapi.utils.Command;
import com.jamonapi.utils.Misc;
import com.jamonapi.utils.ResultSetUtils;
import java.util.ArrayList;
import java.util.Map;

public class MonitorConverter
implements MonitorReportInterface {
    private ResultSetUtils utils = ResultSetUtils.createInstance();
    private MonitorComposite rootComposite;
    private static String JAMON_ADMIN_PAGE_DEFAULT = "JAMonAdmin.jsp";
    private String JAMonAdminPage = JAMON_ADMIN_PAGE_DEFAULT;
    private static String[][] EMPTY_ARRAY = new String[][]{{""}};
    private ArrayList rowsList = new ArrayList();
    private static int TYPICAL_NUM_CHILDREN = 30;

    protected MonitorConverter(MonitorComposite rootComposite) {
        this.rootComposite = rootComposite;
    }

    protected MonitorConverter(MonitorComposite rootComposite, String JAMonAdminPage) {
        this.rootComposite = rootComposite;
        this.JAMonAdminPage = JAMonAdminPage;
    }

    protected void getCompositeData(String localLabel, MonitorComposite composite) {
        class GetMonitorData
        implements Command {
            private final /* synthetic */ MonitorConverter this$0;
            private final /* synthetic */ MonitorComposite val$composite;
            private final /* synthetic */ String val$localLabel;
            Map.Entry mapEntry;
            MinimalMonitor monitor;

            GetMonitorData(MonitorComposite val$composite, String val$localLabel, MonitorConverter this$0) {
                this.val$composite = val$composite;
                this.val$localLabel = val$localLabel;
                this.this$0 = this$0;
            }

            public void execute(Object value) throws Exception {
                String label = this.val$localLabel;
                this.mapEntry = (Map.Entry)value;
                this.monitor = (MinimalMonitor)this.mapEntry.getValue();
                String key = this.mapEntry.getKey().toString();
                label = String.valueOf(label) + this.val$composite.getLabelFromKey(key);
                this.this$0.getData(label, this.monitor);
            }
        }
        composite.iterateMapEntries(new GetMonitorData(composite, localLabel, this));
    }

    public String[][] getData() {
        return this.getData("");
    }

    public String[][] getData(String label) {
        this.getCompositeData(label, this.rootComposite);
        int rows = this.rowsList.size();
        if (rows == 0) {
            return EMPTY_ARRAY;
        }
        return this.utils.arrayListToString(this.rowsList);
    }

    public Object[][] getData(String label, int sortCol, String sortOrder) {
        Object[][] data = this.getData(label);
        if (data == EMPTY_ARRAY) {
            return data;
        }
        return Misc.sort(data, sortCol, sortOrder);
    }

    protected void getData(String label, MinimalMonitor monitor) {
        if (monitor instanceof MonitorComposite) {
            this.getCompositeData(label, (MonitorComposite)monitor);
        } else {
            this.getLeafData(label, monitor);
        }
    }

    protected void getLeafData(String label, MinimalMonitor monitor) {
        ArrayList<String> rowData = new ArrayList<String>(TYPICAL_NUM_CHILDREN);
        rowData.add(label);
        monitor.getData(rowData);
        String[] rowDataArray = new String[]{};
        this.rowsList.add(rowData.toArray(rowDataArray));
    }

    public String getReport() throws Exception {
        return this.getReport(1, "asc");
    }

    public String getReport(int sortCol, String sortOrder) throws Exception {
        return new MonitorReport(sortCol, sortOrder).getReport();
    }

    protected static void setJAMonAdminPage(String JAMonAdminPage) {
        JAMON_ADMIN_PAGE_DEFAULT = JAMonAdminPage;
    }

    private class MonitorReport {
        private final int sortCol;
        private final String sortOrder;
        private final StringBuffer table = new StringBuffer(20000);

        public MonitorReport(int sortCol, String sortOrder) {
            this.sortCol = sortCol;
            this.sortOrder = sortOrder;
        }

        private void addReportBody() {
            Object[][] data = MonitorConverter.this.getData("", this.sortCol - 1, this.sortOrder);
            int rows = data.length;
            int cols = data[0].length;
            int i = 0;
            while (i < rows) {
                String oddOrEven = i % 2 == 0 ? "odd" : "even";
                String monitorLabel = data[i][0].toString();
                this.table.append("<tr class='" + oddOrEven + "' onMouseOver='rollOnRow(this, \"Statistics for " + monitorLabel + "\")' onMouseOut='rollOffRow(this)'>\n");
                String labelEntry = "<th class='headtextc' align='left' nowrap>" + monitorLabel + "</th>\n";
                this.table.append(labelEntry);
                int j = 1;
                while (j < cols) {
                    this.table.append("<td nowrap>" + data[i][j] + "</td>\n");
                    ++j;
                }
                this.table.append(labelEntry);
                this.table.append("</tr>\n");
                ++i;
            }
            this.table.append("</table>\n</td></tr>\n</table>\n<!-- End Report Sect. -->\n");
        }

        private void addReportHeader() {
            this.table.append("<!-- Begin Report Sect. -->\n");
            this.table.append("<table border='0' cellpadding='0' cellspacing='0'>\n");
            this.table.append("<tr>\n");
            this.table.append("<td>\n");
            this.table.append("<table class='layoutmain' border='1' cellpadding='2' cellspacing='0' rules='all'>\n");
            this.table.append("<tr class='headtextr' valign='top'>\n");
            String[] header = MonitorComposite.getHeader();
            int rows = header.length;
            String currentHeaderCell = null;
            String lastHeaderCell = null;
            int i = 0;
            while (i < rows) {
                int sortIndex = i + 1;
                if (sortIndex == this.sortCol) {
                    String newSortOrder = "asc".equalsIgnoreCase(this.sortOrder) ? "desc" : "asc";
                    currentHeaderCell = "<th><a href='" + MonitorConverter.this.JAMonAdminPage + "?sortCol=" + sortIndex + "&sortOrder=" + newSortOrder + "'>" + header[i] + "</a><br><img src='" + this.sortOrder + ".gif'></th>\n";
                } else {
                    currentHeaderCell = "<th><a href='" + MonitorConverter.this.JAMonAdminPage + "?sortCol=" + sortIndex + "&sortOrder=desc'>" + header[i] + "</a><br></th>\n";
                }
                if (i == 0) {
                    lastHeaderCell = currentHeaderCell;
                }
                this.table.append(currentHeaderCell);
                ++i;
            }
            this.table.append(String.valueOf(lastHeaderCell) + "</tr>\n");
            this.table.append("<tr class='headtextr'>\n");
            this.table.append("<th colspan='13'>&nbsp;</th>\n");
            this.table.append("<th colspan='13'>Hits/Avg ms. &nbsp &nbsp &nbsp &nbsp &nbsp (Avg Active/Primary Active/Global Active)</th>\n");
            this.table.append("<th>&nbsp;</th>\n</tr>\n");
        }

        public String getReport() throws Exception {
            this.addReportHeader();
            this.addReportBody();
            return this.table.toString();
        }
    }
}

