/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorComposite;
import com.jamonapi.MonitorConverter;
import com.jamonapi.MonitorFactoryInterface;
import com.jamonapi.NullMonitor;
import com.jamonapi.TimingMonitor;
import com.jamonapi.utils.AppMap;
import com.jamonapi.utils.NodeTree;
import java.util.Collections;
import java.util.Map;

public class MonitorFactory {
    private static MonitorFactoryEnabled enabledFactory = new MonitorFactoryEnabled();
    private static MonitorFactoryDisabled disabledFactory = new MonitorFactoryDisabled();
    private static boolean debugEnabled = true;
    private static boolean enabled = true;
    private static int debugPriorityLevel = 0;

    public static MonitorComposite getComposite(String locator) {
        return MonitorFactory.getFactory().getComposite(locator);
    }

    public static MonitorFactoryInterface getDebugFactory() {
        return MonitorFactory.getFactory(MonitorFactory.isDebugEnabled());
    }

    public static MonitorFactoryInterface getDebugFactory(int _debugPriorityLevel) {
        return MonitorFactory.getFactory(MonitorFactory.isDebugEnabled(_debugPriorityLevel));
    }

    protected static MonitorFactoryInterface getFactory() {
        return MonitorFactory.getFactory(MonitorFactory.isEnabled());
    }

    protected static MonitorFactoryInterface getFactory(boolean _enabled) {
        if (_enabled) {
            return enabledFactory;
        }
        return disabledFactory;
    }

    public static String getReport() throws Exception {
        return MonitorFactory.getRootMonitor().getReport();
    }

    public static String getReport(String locator) throws Exception {
        return MonitorFactory.getComposite(locator).getReport();
    }

    public static MonitorComposite getRootMonitor() {
        return MonitorFactory.getFactory().getRootMonitor();
    }

    protected static boolean isDebugEnabled() {
        return debugEnabled && MonitorFactory.isEnabled();
    }

    protected static boolean isDebugEnabled(int _debugPriorityLevel) {
        return _debugPriorityLevel >= debugPriorityLevel && MonitorFactory.isDebugEnabled();
    }

    protected static boolean isEnabled() {
        return enabled;
    }

    public static void main(String[] args) throws Exception {
        Monitor testMon = null;
        int i = 0;
        while (i < 50) {
            testMon = MonitorFactory.start("pages/homepage");
            Thread.sleep(10L);
            testMon.stop();
            Thread.sleep(10L);
            ++i;
        }
        System.out.println("\nComposite test1 should be 10 ms., total 500 ms., 50 hits: " + testMon.stop());
        int i2 = 0;
        while (i2 < 50) {
            testMon = MonitorFactory.start("pages.homepage");
            Thread.sleep(10L);
            testMon.stop();
            Thread.sleep(10L);
            ++i2;
        }
        System.out.println("\nComposite test2 (Should be double the previous numbers): " + testMon.stop());
        System.out.println("\ngetting root monitor: " + MonitorFactory.getRootMonitor());
    }

    public static void reset() {
        enabledFactory = new MonitorFactoryEnabled();
    }

    public static void setDebugEnabled(boolean _debugEnabled) {
        debugEnabled = _debugEnabled;
    }

    public static void setDebugPriorityLevel(int _debugPriorityLevel) {
        debugPriorityLevel = _debugPriorityLevel;
    }

    public static void setEnabled(boolean _enabled) {
        enabled = _enabled;
    }

    public static void setJAMonAdminPage(String JAMonAdminPage) {
        MonitorConverter.setJAMonAdminPage(JAMonAdminPage);
    }

    protected static void setNodeTree(NodeTree monitorTree) {
        enabledFactory.setNodeTree(monitorTree);
    }

    public static Monitor start() {
        return MonitorFactory.getFactory().start();
    }

    public static Monitor start(String locator) {
        return MonitorFactory.getFactory().start(locator);
    }

    public static Monitor startPrimary(String locator) {
        return MonitorFactory.getFactory().startPrimary(locator);
    }

    static abstract class MonitorFactoryBase
    implements MonitorFactoryInterface {
        protected MonitorComposite rootMonitor;

        MonitorFactoryBase() {
        }

        protected abstract Monitor createInstance(String var1, String var2);

        public abstract MonitorComposite getComposite(String var1);

        public abstract MonitorComposite getRootMonitor();

        public abstract Monitor start();

        public Monitor start(String locator) {
            return this.createInstance(locator, "def").start();
        }

        public Monitor startPrimary(String locator) {
            return this.createInstance(locator, "primary").start();
        }
    }

    static class MonitorFactoryEnabled
    extends MonitorFactoryBase {
        private NodeTree monitorTree;
        private Map existingLeafNodes = Collections.synchronizedMap(AppMap.createInstance());
        private TimingMonitor simpleMonitor = new TimingMonitor();

        protected MonitorFactoryEnabled() {
            this.rootMonitor = new MonitorComposite();
            this.monitorTree = new NodeTree(this.rootMonitor);
        }

        protected Monitor createInstance(String locator, String type) {
            if (this.monitorExists(locator)) {
                return this.getMonitor(locator);
            }
            return this.createMonitor(locator, type);
        }

        private Monitor createMonitor(String locator, String type) {
            TimingMonitor mon;
            MonitorFactoryEnabled monitorFactoryEnabled = this;
            synchronized (monitorFactoryEnabled) {
                mon = (TimingMonitor)this.monitorTree.getLeafNode(locator, type);
                this.existingLeafNodes.put(locator, mon);
            }
            return mon;
        }

        public MonitorComposite getComposite(String locator) {
            if (!this.monitorTree.compositeNodeExists(locator)) {
                throw new RuntimeException("The requested MonitorComposite does not exist: " + locator);
            }
            return (MonitorComposite)this.monitorTree.getCompositeNode(locator);
        }

        private Monitor getMonitor(String locator) {
            TimingMonitor mon = (TimingMonitor)this.existingLeafNodes.get(locator);
            return mon;
        }

        public MonitorComposite getRootMonitor() {
            return this.rootMonitor;
        }

        private boolean monitorExists(String locator) {
            return this.existingLeafNodes.containsKey(locator);
        }

        public void setNodeTree(NodeTree monitorTree) {
            this.monitorTree = monitorTree;
        }

        public Monitor start() {
            return this.simpleMonitor.start();
        }
    }

    static class MonitorFactoryDisabled
    extends MonitorFactoryBase {
        private Monitor nullMonitor = new NullMonitor();

        MonitorFactoryDisabled() {
        }

        protected Monitor createInstance(String locatory, String type) {
            return this.nullMonitor;
        }

        public MonitorComposite getComposite(String locator) {
            return new MonitorComposite();
        }

        public MonitorComposite getRootMonitor() {
            return new MonitorComposite();
        }

        public Monitor start() {
            return this.nullMonitor;
        }
    }
}

