/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import java.util.ArrayList;

public class TimeStatsMonitor
extends AccumulateMonitor {
    private long min = Integer.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private int hits;
    private long total;
    private long sumOfSquares;

    public TimeStatsMonitor() {
    }

    public TimeStatsMonitor(AccumulateMonitorInterface childMonitor) {
        super(childMonitor);
    }

    private long avg() {
        if (this.hits == 0) {
            return 0L;
        }
        return this.total / (long)this.hits;
    }

    public synchronized long getAccrued() {
        return this.total;
    }

    protected synchronized void getDataThis(ArrayList rowData) {
        rowData.add(AccumulateMonitor.convertToString(this.hits));
        rowData.add(AccumulateMonitor.convertToString(this.avg()));
        rowData.add(AccumulateMonitor.convertToString(this.total));
        rowData.add(AccumulateMonitor.convertToString(this.stdDev()));
        rowData.add(AccumulateMonitor.convertToString(this.min));
        rowData.add(AccumulateMonitor.convertToString(this.max));
    }

    protected void getHeaderThis(ArrayList header) {
        header.add("Hits ");
        header.add("Avg ms.");
        header.add("Total ms.");
        header.add("Std Dev ms.");
        header.add("Min ms.");
        header.add("Max ms.");
    }

    protected synchronized void increaseThis(long value) {
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        ++this.hits;
        this.total += value;
        this.sumOfSquares += value * value;
    }

    public static void main(String[] args) throws Exception {
        TimeStatsMonitor mon = new TimeStatsMonitor();
        System.out.println("should not have 0 divide error=" + mon);
        int i = 1;
        while (i < 5) {
            mon.increase(i);
            ++i;
        }
        mon.increase(100L);
        System.out.println("toString()=" + mon);
    }

    protected synchronized void resetThis() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.hits = 0;
        this.total = this.sumOfSquares = (long)0;
    }

    private long stdDev() {
        long stdDeviation = 0L;
        if (this.hits != 0) {
            long sumOfX = this.total;
            int n = this.hits;
            int nMinus1 = n <= 1 ? 1 : n - 1;
            long numerator = this.sumOfSquares - sumOfX * sumOfX / (long)n;
            stdDeviation = (long)Math.sqrt(numerator / (long)nMinus1);
        }
        return stdDeviation;
    }

    protected synchronized String toStringThis() {
        return String.valueOf(this.getDisplayString("Hits", AccumulateMonitor.convertToString(this.hits), "")) + this.getDisplayString("Avg", AccumulateMonitor.convertToString(this.avg()), "ms.") + this.getDisplayString("Total", AccumulateMonitor.convertToString(this.total), "ms.") + this.getDisplayString("Min", AccumulateMonitor.convertToString(this.min), "ms.") + this.getDisplayString("Max", AccumulateMonitor.convertToString(this.max), "ms.");
    }
}

