/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.BaseMonitor;
import com.jamonapi.Monitor;
import com.jamonapi.NullAccumulateMonitor;
import com.jamonapi.utils.LeafNode;
import java.util.ArrayList;

public class TimingMonitor
extends BaseMonitor
implements LeafNode {
    private long startTime = 0L;
    AccumulateMonitorInterface childMonitor;
    boolean isRunningFlag = true;
    long accrued;
    boolean hasChildren;
    private boolean primary = false;

    TimingMonitor() {
        this(NullAccumulateMonitor.createInstance());
        this.hasChildren = false;
    }

    TimingMonitor(AccumulateMonitorInterface childMonitor) {
        this.childMonitor = childMonitor;
        this.hasChildren = true;
    }

    public long getAccrued() {
        return this.accrued + this.timeElapsedSinceLastStart();
    }

    public void getData(ArrayList rowData) {
        this.childMonitor.getData(rowData);
    }

    public void getHeader(ArrayList header) {
        this.childMonitor.getHeader(header);
    }

    public void increase(long increaseValue) {
        if (this.isRunning()) {
            this.childMonitor.increase(increaseValue);
            this.accrued += increaseValue;
        }
    }

    public boolean isPrimary() {
        return this.primary;
    }

    private boolean isRunning() {
        return this.isRunningFlag;
    }

    public static void main(String[] args) throws Exception {
        Monitor m = new TimingMonitor();
        m = m.start();
        Thread.sleep(1000L);
        m.stop();
        System.out.println("should be about 1000=" + m.getAccrued());
        System.out.println("should be same as above " + m.getAccrued());
        Thread.sleep(1000L);
        System.out.println("should be same as above " + m.getAccrued());
        m.reset();
        Thread.sleep(10L);
        System.out.println("should be 0=" + m.getAccrued());
        m = m.start();
        Thread.sleep(100L);
        System.out.println("should be about 100=" + m.getAccrued());
        m = m.start();
        Thread.sleep(500L);
        m.stop();
        m = m.start();
        Thread.sleep(250L);
        System.out.println("should be about 250=" + m.getAccrued());
        m = m.start();
        Thread.sleep(500L);
        Thread.sleep(250L);
        System.out.println("should be about 750=" + m.getAccrued());
        System.out.println("toString should be about 750=" + m.stop());
        Thread.sleep(250L);
        System.out.println("toString should be about 750=" + m.stop());
        int i = 1;
        while (i <= 5) {
            m = m.start();
            Thread.sleep(i * 10);
            m.stop();
            ++i;
        }
        System.out.println("\ntesting start() and stop() in loop.  should be about 50=" + m);
        m.reset();
        System.out.println("\nreset to 0's: " + m);
    }

    public void reset() {
        this.accrued = 0L;
        this.resetStartTime();
    }

    private void resetStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.childMonitor.setPrimary(primary);
    }

    private void setRunning(boolean flag) {
        this.isRunningFlag = flag;
    }

    public Monitor start() {
        TimingMonitor mon = new TimingMonitor(this.childMonitor);
        mon.resetStartTime();
        mon.hasChildren = this.hasChildren;
        mon.childMonitor.start();
        return mon;
    }

    public Monitor stop() {
        this.increase(this.timeElapsedSinceLastStart());
        if (this.isRunning()) {
            this.childMonitor.stop();
        }
        this.setRunning(false);
        return this;
    }

    private long timeElapsedSinceLastStart() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    public String toString() {
        String message = String.valueOf(this.getAccruedString()) + " ms.";
        if (this.hasChildren) {
            message = String.valueOf(message) + " (" + this.childMonitor.toString() + ")";
        }
        return message;
    }
}

