/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;

public class VariableTable {
    private ObjArray itsVariables = new ObjArray();
    private ObjToIntMap itsVariableNames = new ObjToIntMap(11);
    private int varStart;

    public int size() {
        return this.itsVariables.size();
    }

    public int getParameterCount() {
        return this.varStart;
    }

    public String getVariable(int index) {
        return (String)this.itsVariables.get(index);
    }

    public boolean hasVariable(String name) {
        return this.itsVariableNames.has(name);
    }

    public int getOrdinal(String name) {
        return this.itsVariableNames.get(name, -1);
    }

    public String[] getAllVariables() {
        Object[] array = new String[this.itsVariables.size()];
        this.itsVariables.toArray(array);
        return array;
    }

    public void addParameter(String pName) {
        if (this.varStart != this.itsVariables.size()) {
            Context.codeBug();
        }
        int index = this.varStart++;
        this.itsVariables.add(pName);
        this.itsVariableNames.put(pName, index);
    }

    public void addLocal(String vName) {
        int vIndex = this.itsVariableNames.get(vName, -1);
        if (vIndex != -1) {
            return;
        }
        int index = this.itsVariables.size();
        this.itsVariables.add(vName);
        this.itsVariableNames.put(vName, index);
    }

    public void removeLocal(String name) {
        int i = this.itsVariableNames.get(name, -1);
        if (i != -1) {
            this.itsVariables.remove(i);
            this.itsVariableNames.remove(name);
            ObjToIntMap.Iterator iter = this.itsVariableNames.newIterator();
            iter.start();
            while (!iter.done()) {
                int v = iter.getValue();
                if (v > i) {
                    iter.setValue(v - 1);
                }
                iter.next();
            }
        }
    }
}

