/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class OptFunctionNode
extends FunctionNode {
    private static final String BEFORE_DIRECT_SIG = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;";
    private static final String DIRECT_ARG_SIG = "Ljava/lang/Object;D";
    private static final String AFTER_DIRECT_SIG = "[Ljava/lang/Object;)";
    private static final String ZERO_PARAM_SIG = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)";
    private static final String ONE_PARAM_SIG = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;D[Ljava/lang/Object;)";
    private static final String TWO_PARAM_SIG = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;DLjava/lang/Object;D[Ljava/lang/Object;)";
    private OptLocalVariable[] optVars;
    private String itsClassName;
    private boolean itsIsTargetOfDirectCall;
    private boolean itsContainsCalls;
    private boolean[] itsContainsCallsCount = new boolean[4];
    private boolean itsParameterNumberContext;
    private ObjArray itsDirectCallTargets;

    OptFunctionNode(String name, String className) {
        super(name);
        this.itsClassName = className;
    }

    protected void markVariableTableReady() {
        super.markVariableTableReady();
        VariableTable vars = this.getVariableTable();
        int N = vars.size();
        int parameterCount = this.getParameterCount();
        this.optVars = new OptLocalVariable[N];
        int i = 0;
        while (i != N) {
            String name = vars.getVariable(i);
            this.optVars[i] = new OptLocalVariable(name, i < parameterCount);
            ++i;
        }
    }

    String getDirectCallParameterSignature() {
        int pCount = this.getParameterCount();
        switch (pCount) {
            case 0: {
                return ZERO_PARAM_SIG;
            }
            case 1: {
                return ONE_PARAM_SIG;
            }
            case 2: {
                return TWO_PARAM_SIG;
            }
        }
        StringBuffer sb = new StringBuffer(ZERO_PARAM_SIG.length() + pCount * DIRECT_ARG_SIG.length());
        sb.append(BEFORE_DIRECT_SIG);
        int i = 0;
        while (i != pCount) {
            sb.append(DIRECT_ARG_SIG);
            ++i;
        }
        sb.append(AFTER_DIRECT_SIG);
        return sb.toString();
    }

    String getClassName() {
        return this.itsClassName;
    }

    boolean isTargetOfDirectCall() {
        return this.itsIsTargetOfDirectCall;
    }

    void addDirectCallTarget(FunctionNode target) {
        if (this.itsDirectCallTargets == null) {
            this.itsDirectCallTargets = new ObjArray();
        }
        int i = 0;
        while (i < this.itsDirectCallTargets.size()) {
            if ((FunctionNode)this.itsDirectCallTargets.get(i) == target) {
                return;
            }
            ++i;
        }
        this.itsDirectCallTargets.add(target);
    }

    ObjArray getDirectCallTargets() {
        return this.itsDirectCallTargets;
    }

    void setIsTargetOfDirectCall() {
        this.itsIsTargetOfDirectCall = true;
    }

    void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    boolean containsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length && argCount >= 0) {
            return this.itsContainsCallsCount[argCount];
        }
        return this.itsContainsCalls;
    }

    void setContainsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length) {
            this.itsContainsCallsCount[argCount] = true;
        }
        this.itsContainsCalls = true;
    }

    void incrementLocalCount() {
        int localCount = this.getIntProp(19, 0);
        this.putIntProp(19, localCount + 1);
    }

    int getVarCount() {
        return this.optVars.length;
    }

    OptLocalVariable getVar(int index) {
        return this.optVars[index];
    }

    OptLocalVariable getVar(String name) {
        int index = this.getVariableTable().getOrdinal(name);
        if (index < 0) {
            return null;
        }
        return this.optVars[index];
    }

    void establishVarsIndices() {
        int N = this.optVars.length;
        int i = 0;
        while (i != N) {
            this.optVars[i].setIndex(i);
            ++i;
        }
    }

    OptLocalVariable[] getVarsArray() {
        return this.optVars;
    }
}

