/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.ImageToDicom;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConvertAmicasJPEG2000FilesetToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/ConvertAmicasJPEG2000FilesetToDicom.java,v 1.5 2008/04/04 17:49:01 dclunie Exp $";
    protected String mediaDirectoryPath;
    protected OnlyDirectoriesFileFilter onlyDirectoriesFileFilter = new OnlyDirectoriesFileFilter();
    protected OnlySuffixFilenameFilter onlyXMLFilenameFilter = new OnlySuffixFilenameFilter(".XML");
    protected SpecificCharacterSet specificCharacterSet;
    protected static DicomDictionary dictionary = new DicomDictionary();
    protected static UIDGenerator uidGenerator = new UIDGenerator();

    public ConvertAmicasJPEG2000FilesetToDicom() {
        this.mediaDirectoryPath = null;
    }

    public ConvertAmicasJPEG2000FilesetToDicom(String string) {
        this.mediaDirectoryPath = string;
    }

    public void choosePathsAndConvertAmicasFiles() throws IOException, DicomException, ParserConfigurationException, SAXException {
        String string = null;
        JFileChooser jFileChooser = new JFileChooser(this.mediaDirectoryPath);
        jFileChooser.setDialogTitle("Select Amicas-Patient Folder ...");
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(null) == 0) {
            this.mediaDirectoryPath = jFileChooser.getCurrentDirectory().getAbsolutePath();
            string = jFileChooser.getSelectedFile().getAbsolutePath();
        }
        String string2 = null;
        JFileChooser jFileChooser2 = new JFileChooser(this.mediaDirectoryPath);
        jFileChooser2.setDialogTitle("Select Folder to store DICOM output files ...");
        jFileChooser2.setFileSelectionMode(1);
        if (jFileChooser2.showOpenDialog(null) == 0) {
            this.mediaDirectoryPath = jFileChooser2.getCurrentDirectory().getAbsolutePath();
            string2 = jFileChooser2.getSelectedFile().getAbsolutePath();
        }
        this.convertAmicasFiles(string, string2);
    }

    protected Attribute newAttribute(AttributeTag attributeTag) throws DicomException {
        byte[] byArray = dictionary.getValueRepresentationFromTag(attributeTag);
        return AttributeFactory.newAttribute(attributeTag, byArray, this.specificCharacterSet);
    }

    protected String getNamedAttributeValue(NamedNodeMap namedNodeMap, String string) {
        String string2 = null;
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null && (string2 = node.getNodeValue()) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    protected Attribute makeDicomAttributeFromXmlAttribute(AttributeTag attributeTag, String string, NamedNodeMap namedNodeMap, int n, String string2) throws DicomException {
        String string3 = this.getNamedAttributeValue(namedNodeMap, string);
        if (n == 1 && (string3 == null || string3.length() == 0)) {
            string3 = string2;
        } else if (n == 2 && string3 == null) {
            string3 = "";
        } else if (n == 3 && (string3 == null || string3.length() == 0)) {
            string3 = null;
        }
        Attribute attribute = null;
        if (string3 != null && (attribute = this.newAttribute(attributeTag)) != null) {
            attribute.addValue(string3);
        }
        return attribute;
    }

    protected void addDicomAttributeFromXmlAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, NamedNodeMap namedNodeMap, int n, String string2) throws DicomException {
        Attribute attribute = this.makeDicomAttributeFromXmlAttribute(attributeTag, string, namedNodeMap, n, string2);
        if (attribute != null) {
            attributeList.put(attribute);
        }
    }

    protected AttributeList makeAttributeListForPatient(NamedNodeMap namedNodeMap) throws DicomException {
        AttributeList attributeList = new AttributeList();
        return attributeList;
    }

    protected AttributeList makeAttributeListForStudy(NamedNodeMap namedNodeMap) throws DicomException {
        AttributeList attributeList = new AttributeList();
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientName, "PatientName", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientID, "PatientID", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientBirthDate, "PatientBirthDate", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientSex, "PatientSex", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientAge, "PatientAge", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientWeight, "PatientWeight", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StudyInstanceUID, "StudyInstanceUID", namedNodeMap, 1, uidGenerator.getAnotherNewUID());
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StudyDate, "StudyDate", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StudyTime, "StudyTime", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StudyID, "StudyID", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ReferringPhysicianName, "ReferPhysician", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StudyDescription, "StudyDescription", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.AccessionNumber, "AccessionNumber", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PhysicianReadingStudy, "ReadingPhysician", namedNodeMap, 3, null);
        return attributeList;
    }

    protected AttributeList makeAttributeListForSeries(NamedNodeMap namedNodeMap) throws DicomException {
        AttributeList attributeList = new AttributeList();
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SeriesInstanceUID, "SeriesInstanceUID", namedNodeMap, 1, uidGenerator.getAnotherNewUID());
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SeriesNumber, "SeriesNumber", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SeriesDate, "SeriesDate", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SeriesTime, "SeriesTime", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.Modality, "Modality", namedNodeMap, 1, "OT");
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.StationName, "StationName", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.OperatorName, "OperatorName", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SeriesDescription, "SeriesDescription", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PatientPosition, "PatientPosition", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PositionReferenceIndicator, "PositionReference", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.FrameOfReferenceUID, "FrameOfRefUID", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.InstitutionName, "InstitutionName", namedNodeMap, 3, null);
        Attribute attribute = this.newAttribute(TagFromName.Manufacturer);
        attributeList.put(attribute);
        return attributeList;
    }

    protected AttributeList makeAttributeListForImage(NamedNodeMap namedNodeMap) throws DicomException {
        Attribute attribute;
        Object object;
        AttributeList attributeList = new AttributeList();
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SOPInstanceUID, "SOPInstanceUID", namedNodeMap, 1, uidGenerator.getAnotherNewUID());
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SOPClassUID, "SOPClassUID", namedNodeMap, 1, "1.2.840.10008.5.1.4.1.1.7");
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ImageType, "ImageType", namedNodeMap, 1, "DERIVED\\SECONDARY");
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ContrastBolusAgent, "ContrastBolus", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.InstanceNumber, "ImageNumber", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ContentDate, "ImageDate", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ContentTime, "ImageTime", namedNodeMap, 2, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SliceThickness, "SliceThickness", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.KVP, "KVP", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.RepetitionTime, "RepetitionTime", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.EchoTime, "EchoTime", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.EchoNumber, "EchoNumbers", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.GantryDetectorTilt, "GantryDetector", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.XRayTubeCurrent, "XrayTubeCurrent", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ImagePositionPatient, "ImagePositionPt", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ImageOrientationPatient, "ImageOrientPt", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.SliceLocation, "SliceLocation", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PixelSpacing, "PixelSpacing", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.ImagerPixelSpacing, "ImagerPixelSpacing", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.Rows, "NRows", namedNodeMap, 1, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.Columns, "NColumns", namedNodeMap, 1, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PhotometricInterpretation, "PhotometricI", namedNodeMap, 1, "MONOCHROME2");
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.BitsAllocated, "BitsAlloc", namedNodeMap, 1, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.BitsStored, "BitsStored", namedNodeMap, 1, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PixelRepresentation, "PixelRep", namedNodeMap, 1, "0");
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.NumberOfFrames, "NumberOfFrames", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.RescaleIntercept, "RescaleIntercept", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.RescaleSlope, "RescaleSlope", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.WindowWidth, "WindowWidth", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.WindowCenter, "WindowCenter", namedNodeMap, 3, null);
        this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.LossyImageCompressionRatio, "LossyCompression", namedNodeMap, 3, null);
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.LossyImageCompressionRatio);
        if (string != null && string.length() > 0) {
            object = this.newAttribute(TagFromName.LossyImageCompression);
            ((Attribute)object).addValue("01");
            attributeList.put((Attribute)object);
            object = this.getNamedAttributeValue(namedNodeMap, "CompressionType");
            if (object != null && ((String)object).length() > 0) {
                if (((String)object).equals("JPEG2000")) {
                    object = "ISO_15444_1";
                }
                attribute = this.newAttribute(TagFromName.LossyImageCompressionMethod);
                attribute.addValue((String)object);
                attributeList.put(attribute);
            }
        }
        if ((object = this.getNamedAttributeValue(namedNodeMap, "PixelPaddingFlag")) != null && !((String)object).equals("0")) {
            this.addDicomAttributeFromXmlAttribute(attributeList, TagFromName.PixelPaddingValue, "PixelPadding", namedNodeMap, 3, null);
        }
        attribute = this.newAttribute(TagFromName.AcquisitionNumber);
        attributeList.put(attribute);
        return attributeList;
    }

    protected static SpecificCharacterSet setSpecificCharacterSetFromDocumentEncoding(Document document) {
        String[] stringArray;
        String string = document.getXmlEncoding();
        SpecificCharacterSet specificCharacterSet = null;
        if (string != null && string.equals("US-ASCII")) {
            stringArray = null;
            specificCharacterSet = new SpecificCharacterSet(stringArray);
        }
        if (specificCharacterSet == null) {
            stringArray = new String[]{"ISO_IR 192"};
            specificCharacterSet = new SpecificCharacterSet(stringArray);
        }
        return specificCharacterSet;
    }

    protected void createDicomImageFileFromAmicasImageFile(File file, String string, String string2, String string3, AttributeList attributeList, AttributeList attributeList2, AttributeList attributeList3, AttributeList attributeList4) throws IOException, DicomException {
        File file2 = new File(file, string.trim().replace('\\', File.separatorChar).replace('/', File.separatorChar).replaceFirst("[.]demo$", ".jp2"));
        ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(file2, attributeList4);
        attributeList4.putAll(attributeList);
        attributeList4.putAll(attributeList2);
        attributeList4.putAll(attributeList3);
        Object object = this.specificCharacterSet.getValueToUseInSpecificCharacterSetAttribute();
        if (object != null && ((String)object).length() > 0) {
            Attribute attribute = this.newAttribute(TagFromName.SpecificCharacterSet);
            attribute.addValue((String)object);
            attributeList4.put(attribute);
        }
        FileMetaInformation.addFileMetaInformation(attributeList4, "1.2.840.10008.1.2.1", string3);
        object = new File(string2, Attribute.getSingleStringValueOrNull(attributeList4, TagFromName.SOPInstanceUID) + ".dcm");
        System.err.println("Converting \"" + file2 + "\" -> \"" + object + "\"");
        attributeList4.write((File)object, "1.2.840.10008.1.2.1", true, true);
    }

    public void convertAmicasFiles(String string, String string2) throws IOException, DicomException, ParserConfigurationException, SAXException {
        if (string != null) {
            Object object;
            File file = new File(string);
            Object object2 = null;
            if (file != null && file.exists()) {
                if (file.isDirectory() && file.getName().toUpperCase().equals("AMICAS-PATIENTS")) {
                    object2 = file;
                } else if (file.isDirectory()) {
                    object = new File(file, "AMICAS-PATIENTS");
                    if (object != null && ((File)object).exists() && ((File)object).isDirectory()) {
                        object2 = object;
                    } else {
                        object = new File(file, "Amicas-patients");
                        if (object != null && ((File)object).exists() && ((File)object).isDirectory()) {
                            object2 = object;
                        } else {
                            object = new File(file, "amicas-patients");
                            if (object != null && ((File)object).exists() && ((File)object).isDirectory()) {
                                object2 = object;
                            }
                        }
                    }
                }
            }
            if (object2 != null) {
                object = ((File)object2).listFiles(this.onlyDirectoriesFileFilter);
                for (File file2 : object) {
                    File[] fileArray;
                    for (File file3 : fileArray = file2.listFiles(this.onlyXMLFilenameFilter)) {
                        Object object3;
                        Node node;
                        FileInputStream fileInputStream = new FileInputStream(file3);
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(fileInputStream);
                        fileInputStream.close();
                        this.specificCharacterSet = ConvertAmicasJPEG2000FilesetToDicom.setSpecificCharacterSetFromDocumentEncoding(document);
                        for (node = document.getFirstChild(); !(node == null || (object3 = node.getNodeName()) != null && ((String)object3).equals("DemographicStudy")); node = node.getNextSibling()) {
                        }
                        if (node == null) continue;
                        object3 = null;
                        AttributeList attributeList = null;
                        AttributeList attributeList2 = null;
                        AttributeList attributeList3 = null;
                        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                            NamedNodeMap namedNodeMap;
                            String string3 = node2.getNodeName();
                            if (string3 == null || (namedNodeMap = node2.getAttributes()) == null) continue;
                            if (string3.equals("Demographic_AmicasPatient")) {
                                object3 = this.makeAttributeListForPatient(namedNodeMap);
                                continue;
                            }
                            if (string3.equals("Demographic_AmicasStudy")) {
                                attributeList = this.makeAttributeListForStudy(namedNodeMap);
                                continue;
                            }
                            if (string3.equals("Demographic_AmicasSeries")) {
                                attributeList2 = this.makeAttributeListForSeries(namedNodeMap);
                                continue;
                            }
                            if (!string3.equals("Demographic_AmicasImage")) continue;
                            attributeList3 = this.makeAttributeListForImage(namedNodeMap);
                            String string4 = this.getNamedAttributeValue(namedNodeMap, "ObjectFile");
                            String string5 = this.getNamedAttributeValue(namedNodeMap, "StoringAETitle");
                            this.createDicomImageFileFromAmicasImageFile((File)object2, string4, string2, string5, (AttributeList)object3, attributeList, attributeList2, attributeList3);
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        block4: {
            try {
                if (stringArray.length == 0) {
                    ConvertAmicasJPEG2000FilesetToDicom convertAmicasJPEG2000FilesetToDicom = new ConvertAmicasJPEG2000FilesetToDicom("/");
                    convertAmicasJPEG2000FilesetToDicom.choosePathsAndConvertAmicasFiles();
                    break block4;
                }
                if (stringArray.length == 2) {
                    ConvertAmicasJPEG2000FilesetToDicom convertAmicasJPEG2000FilesetToDicom = new ConvertAmicasJPEG2000FilesetToDicom();
                    convertAmicasJPEG2000FilesetToDicom.convertAmicasFiles(stringArray[0], stringArray[1]);
                    break block4;
                }
                throw new Exception("Argument list must be zero or two values");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    public final class OnlySuffixFilenameFilter
    implements FilenameFilter {
        protected String suffix;

        public OnlySuffixFilenameFilter(String string) {
            this.suffix = string.toUpperCase();
        }

        public boolean accept(File file, String string) {
            return string.toUpperCase().endsWith(this.suffix);
        }
    }

    public final class OnlyDirectoriesFileFilter
    implements FileFilter {
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

