/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DicomDatabaseInformationModel;
import com.pixelmed.database.DicomDictionaryForPatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.sql.Statement;
import javax.swing.JFrame;

public class PatientStudySeriesConcatenationInstanceModel
extends DicomDatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/PatientStudySeriesConcatenationInstanceModel.java,v 1.15 2007/12/19 22:44:14 dclunie Exp $";

    public PatientStudySeriesConcatenationInstanceModel(String string) throws DicomException {
        super(string, InformationEntity.PATIENT, new DicomDictionaryForPatientStudySeriesConcatenationInstanceModel());
    }

    public PatientStudySeriesConcatenationInstanceModel(String string, String string2) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, new DicomDictionaryForPatientStudySeriesConcatenationInstanceModel());
    }

    public PatientStudySeriesConcatenationInstanceModel(String string, DicomDictionary dicomDictionary) throws DicomException {
        super(string, InformationEntity.PATIENT, dicomDictionary);
    }

    public PatientStudySeriesConcatenationInstanceModel(String string, String string2, DicomDictionary dicomDictionary) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, dicomDictionary);
    }

    protected boolean isInformationEntityInModel(InformationEntity informationEntity) {
        return informationEntity == InformationEntity.PATIENT || informationEntity == InformationEntity.STUDY || informationEntity == InformationEntity.SERIES || informationEntity == InformationEntity.CONCATENATION || informationEntity == InformationEntity.INSTANCE;
    }

    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, boolean bl) {
        if (informationEntity == InformationEntity.PATIENT) {
            return InformationEntity.STUDY;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return InformationEntity.SERIES;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return bl ? InformationEntity.CONCATENATION : InformationEntity.INSTANCE;
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return InformationEntity.INSTANCE;
        }
        return null;
    }

    private InformationEntity getChildTypeForParent(InformationEntity informationEntity, String string) {
        return this.getChildTypeForParent(informationEntity, string != null);
    }

    public InformationEntity getChildTypeForParent(InformationEntity informationEntity) {
        return this.getChildTypeForParent(informationEntity, true);
    }

    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ConcatenationUID);
        return this.getChildTypeForParent(informationEntity, string);
    }

    public String getDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return "PatientName";
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "StudyDate";
        }
        if (informationEntity == InformationEntity.PROCEDURESTEP) {
            return null;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SeriesNumber";
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return "InstanceNumber";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "InstanceNumber";
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    public String getOtherDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return null;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "StudyID";
        }
        if (informationEntity == InformationEntity.PROCEDURESTEP) {
            return null;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return null;
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return null;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "InConcatenationNumber";
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    public String getOtherOtherDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return "PatientID";
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "StudyDescription";
        }
        if (informationEntity == InformationEntity.PROCEDURESTEP) {
            return null;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SeriesDescription";
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return null;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "ImageComments";
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    public String getUIDColumnNameForInformationEntity(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return null;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "StudyInstanceUID";
        }
        if (informationEntity == InformationEntity.PROCEDURESTEP) {
            return null;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SeriesInstanceUID";
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return "ConcatenationUID";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "SOPInstanceUID";
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    protected void extendCreateStatementStringWithAnyExtraAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.INSTANCE) {
            String string = "InstanceNumber";
            String string2 = PatientStudySeriesConcatenationInstanceModel.getSQLTypeFromDicomValueRepresentation(ValueRepresentation.IS);
            stringBuffer.append(", ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
    }

    protected void extendStatementStringWithMatchingAttributesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        if (informationEntity == InformationEntity.PATIENT) {
            stringBuffer.append("PATIENT.PatientID");
            PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.PatientID)));
            stringBuffer.append(" AND ");
            stringBuffer.append("PATIENT.PatientName");
            PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.PatientName)));
        } else if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append(" AND ");
            stringBuffer.append("STUDY.StudyInstanceUID");
            PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.StudyInstanceUID)));
        } else if (informationEntity != InformationEntity.PROCEDURESTEP) {
            if (informationEntity == InformationEntity.SERIES) {
                stringBuffer.append(" AND ");
                stringBuffer.append("SERIES.SeriesInstanceUID");
                PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SeriesInstanceUID)));
            } else if (informationEntity == InformationEntity.CONCATENATION) {
                Attribute attribute = attributeList.get(TagFromName.ConcatenationUID);
                Attribute attribute2 = attributeList.get(TagFromName.InstanceNumber);
                if (attribute != null) {
                    stringBuffer.append(" AND ");
                    stringBuffer.append("CONCATENATION.ConcatenationUID");
                    PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attribute));
                } else {
                    stringBuffer.append(" AND ");
                    stringBuffer.append("CONCATENATION.InstanceNumber");
                    PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attribute2));
                }
            } else if (informationEntity == InformationEntity.INSTANCE) {
                stringBuffer.append(" AND ");
                stringBuffer.append("INSTANCE.SOPInstanceUID");
                PatientStudySeriesConcatenationInstanceModel.appendExactOrIsNullMatch(stringBuffer, PatientStudySeriesConcatenationInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SOPInstanceUID)));
            } else if (informationEntity == InformationEntity.FRAME) {
                // empty if block
            }
        }
    }

    protected void createAdditionalIndexes() throws DicomException {
        Statement statement;
        super.createAdditionalIndexes();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX PATIENT_ID_IDX ON PATIENT (PatientID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of PatientID: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX PATIENT_NAME_IDX ON PATIENT (PatientName)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of PatientName: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX STUDY_UID_IDX ON STUDY (StudyInstanceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of StudyInstanceUID: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX SERIES_UID_IDX ON SERIES (SeriesInstanceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of SeriesInstanceUID: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX SERIES_FORUID_IDX ON SERIES (FrameOfReferenceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of FrameOfReferenceUID: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX INSTANCE_UID_IDX ON INSTANCE (SOPInstanceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of SOPInstanceUID: " + exception);
            bl = false;
        }
        if (!bl) {
            throw new DicomException(stringBuffer.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            final PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel("test");
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                System.err.println("reading " + (String)object);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream((String)object)));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                System.err.println("inserting");
                patientStudySeriesConcatenationInstanceModel.insertObject(attributeList, (String)object);
            }
            final JFrame jFrame = new JFrame();
            jFrame.setSize(400, 800);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    patientStudySeriesConcatenationInstanceModel.close();
                    System.exit(0);
                }
            });
            System.err.println("building tree");
            object = new DatabaseTreeBrowser(patientStudySeriesConcatenationInstanceModel, jFrame);
            System.err.println("display tree");
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

