/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.Iterator;

public class CodedSequenceItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodedSequenceItem.java,v 1.9 2008/05/23 16:51:00 dclunie Exp $";
    private AttributeList list;

    public CodedSequenceItem(AttributeList attributeList) {
        this.list = attributeList;
    }

    public CodedSequenceItem(String string, String string2, String string3) throws DicomException {
        this.list = new AttributeList();
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodeValue);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.CodeMeaning);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string3);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
    }

    public CodedSequenceItem(String string, String string2, String string3, String string4) throws DicomException {
        this.list = new AttributeList();
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodeValue);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeVersion);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string3);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.CodeMeaning);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string4);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public String getCodeValue() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeValue);
    }

    public String getCodingSchemeDesignator() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodingSchemeDesignator);
    }

    public String getCodingSchemeVersion() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodingSchemeVersion);
    }

    public String getCodeMeaning() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeMeaning);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.getCodeValue());
        stringBuffer.append(",");
        stringBuffer.append(this.getCodingSchemeDesignator());
        String string = this.getCodingSchemeVersion();
        if (string != null && string.length() > 0) {
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
        stringBuffer.append(",\"");
        stringBuffer.append(this.getCodeMeaning());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        CodedSequenceItem codedSequenceItem = null;
        if (attributeList != null) {
            codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList.get(attributeTag));
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(Attribute attribute) {
        SequenceItem sequenceItem;
        SequenceAttribute sequenceAttribute;
        Iterator iterator;
        CodedSequenceItem codedSequenceItem = null;
        if (attribute != null && attribute instanceof SequenceAttribute && (iterator = (sequenceAttribute = (SequenceAttribute)attribute).iterator()).hasNext() && (sequenceItem = (SequenceItem)iterator.next()) != null) {
            codedSequenceItem = new CodedSequenceItem(sequenceItem.getAttributeList());
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem[] getArrayOfCodedSequenceItemsOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        CodedSequenceItem[] codedSequenceItemArray = null;
        if (attributeList != null) {
            codedSequenceItemArray = CodedSequenceItem.getArrayOfCodedSequenceItemsOrNull(attributeList.get(attributeTag));
        }
        return codedSequenceItemArray;
    }

    public static CodedSequenceItem[] getArrayOfCodedSequenceItemsOrNull(Attribute attribute) {
        SequenceItem sequenceItem;
        SequenceAttribute sequenceAttribute;
        Iterator iterator;
        ArrayList<CodedSequenceItem> arrayList = new ArrayList<CodedSequenceItem>();
        if (attribute != null && attribute instanceof SequenceAttribute && (iterator = (sequenceAttribute = (SequenceAttribute)attribute).iterator()).hasNext() && (sequenceItem = (SequenceItem)iterator.next()) != null) {
            arrayList.add(new CodedSequenceItem(sequenceItem.getAttributeList()));
        }
        return arrayList.size() == 0 ? null : (CodedSequenceItem[])arrayList.toArray();
    }
}

