/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.TagFromName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class DicomDictionaryBase {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDictionaryBase.java,v 1.6 2008/01/13 00:40:25 dclunie Exp $";
    protected TreeSet tagList;
    protected HashMap valueRepresentationsByTag;
    protected HashMap informationEntityByTag;
    protected HashMap nameByTag;
    protected HashMap tagByName;
    protected HashMap fullNameByTag;

    protected abstract void createTagList();

    protected abstract void createValueRepresentationsByTag();

    protected abstract void createInformationEntityByTag();

    protected abstract void createTagByName();

    protected abstract void createNameByTag();

    protected abstract void createFullNameByTag();

    public DicomDictionaryBase() {
        this.createTagList();
        this.createValueRepresentationsByTag();
        this.createInformationEntityByTag();
        this.createNameByTag();
        this.createTagByName();
        this.createFullNameByTag();
    }

    public byte[] getValueRepresentationFromTag(AttributeTag attributeTag) {
        byte[] byArray = (byte[])this.valueRepresentationsByTag.get(attributeTag);
        return byArray;
    }

    public InformationEntity getInformationEntityFromTag(AttributeTag attributeTag) {
        return (InformationEntity)this.informationEntityByTag.get(attributeTag);
    }

    public AttributeTag getTagFromName(String string) {
        return (AttributeTag)this.tagByName.get(string);
    }

    public String getNameFromTag(AttributeTag attributeTag) {
        return (String)this.nameByTag.get(attributeTag);
    }

    public String getFullNameFromTag(AttributeTag attributeTag) {
        String string = (String)this.fullNameByTag.get(attributeTag);
        if (string == null && attributeTag.isGroupLength()) {
            string = "Group Length";
        }
        return string;
    }

    public Iterator getTagIterator() {
        return this.tagList.iterator();
    }

    public static void main(String[] stringArray) {
        try {
            DicomDictionary dicomDictionary = new DicomDictionary();
            System.err.println(new String(dicomDictionary.getValueRepresentationFromTag(TagFromName.PixelRepresentation)));
            System.err.println(new String(dicomDictionary.getValueRepresentationFromTag(new AttributeTag(40, 259))));
            System.err.println(dicomDictionary.getInformationEntityFromTag(TagFromName.PatientName));
            System.err.println(dicomDictionary.getInformationEntityFromTag(TagFromName.StudyDate));
            System.err.println(dicomDictionary.getInformationEntityFromTag(TagFromName.PixelRepresentation));
            System.err.println(dicomDictionary.getNameFromTag(TagFromName.PatientName));
            System.err.println(dicomDictionary.getNameFromTag(TagFromName.StudyDate));
            System.err.println(dicomDictionary.getNameFromTag(TagFromName.PixelRepresentation));
            System.err.println(dicomDictionary.getFullNameFromTag(TagFromName.PatientName));
            System.err.println(dicomDictionary.getFullNameFromTag(TagFromName.StudyDate));
            System.err.println(dicomDictionary.getFullNameFromTag(TagFromName.PixelRepresentation));
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

