/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.display.WindowCenterAndWidth;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class ConsumerFormatImageMaker {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ConsumerFormatImageMaker.java,v 1.10 2005/12/12 17:38:20 dclunie Exp $";
    public static final String ALL_ANNOTATIONS = "all";

    public static final BufferedImage makeEightBitImage(AttributeList attributeList, int n) throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!SOPClass.isImageStorage(string)) {
            throw new DicomException("SOP Class is not an image");
        }
        SourceImage sourceImage = new SourceImage(attributeList);
        BufferedImage bufferedImage = sourceImage.getBufferedImage();
        BufferedImage bufferedImage2 = null;
        if (bufferedImage.getColorModel().getNumComponents() != 1) {
            try {
                bufferedImage2 = BufferedImageUtilities.convertToMostFavorableImageType(bufferedImage);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                bufferedImage2 = bufferedImage;
            }
        } else {
            ModalityTransform modalityTransform = sourceImage.getModalityTransform();
            VOITransform vOITransform = sourceImage.getVOITransform();
            boolean bl = sourceImage.isSigned();
            boolean bl2 = sourceImage.isInverted();
            boolean bl3 = sourceImage.isPadded();
            int n2 = sourceImage.getPadValue();
            int n3 = sourceImage.getMinimum();
            int n4 = sourceImage.getMaximum();
            int n5 = sourceImage.getPaletteColorLargestGray();
            int n6 = sourceImage.getPaletteColorFirstValueMapped();
            int n7 = sourceImage.getPaletteColorNumberOfEntries();
            int n8 = sourceImage.getPaletteColorBitsPerEntry();
            short[] sArray = sourceImage.getPaletteColorRedTable();
            short[] sArray2 = sourceImage.getPaletteColorGreenTable();
            short[] sArray3 = sourceImage.getPaletteColorBlueTable();
            double d = 1.0;
            double d2 = 0.0;
            if (modalityTransform != null) {
                d = modalityTransform.getRescaleSlope(0);
                d2 = modalityTransform.getRescaleIntercept(0);
            }
            double d3 = 0.0;
            double d4 = 0.0;
            if (vOITransform != null && vOITransform.getNumberOfTransforms(0) > 0) {
                d3 = vOITransform.getWidth(0, 0);
                d4 = vOITransform.getCenter(0, 0);
            }
            if (d3 == 0.0) {
                double d5 = (double)n3 * d + d2;
                double d6 = (double)n4 * d + d2;
                d3 = d6 - d5;
                d4 = (d6 + d5) / 2.0;
                if (n > 1) {
                    System.err.println("Using statistically derived center " + d4 + " and width " + d3);
                }
            }
            if (n > 1) {
                System.err.println("Using rescale slope " + d + " and intercept " + d2 + " and window center " + d4 + " and width " + d3);
            }
            boolean bl4 = false;
            bufferedImage2 = n7 == 0 || sArray == null ? (bl4 ? WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d4, d3, bl, bl2, d, d2, bl3, n2) : WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d4, d3, bl, bl2, d, d2, bl3, n2)) : WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d4, d3, sourceImage.isSigned(), bl2, d, d2, bl3, n2, n5, n8, n7, sArray, sArray2, sArray3);
        }
        return bufferedImage2;
    }

    public static void convertFileToEightBitImage(String string, String string2, String string3, int n) throws DicomException, IOException {
        ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, 0.0, 0.0, 0, 0, -1, ALL_ANNOTATIONS, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void convertFileToEightBitImage(String string, String string2, String string3, double d, double d2, int n, int n2, int n3, String string4, int n4) throws DicomException, IOException {
        Object object;
        Object object2;
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        if (d2 != 0.0) {
            object2 = new DecimalStringAttribute(TagFromName.WindowWidth);
            ((Attribute)object2).addValue(d2);
            attributeList.put((Attribute)object2);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
            ((Attribute)decimalStringAttribute).addValue(d);
            attributeList.put(decimalStringAttribute);
        }
        object2 = ConsumerFormatImageMaker.makeEightBitImage(attributeList, n4);
        try {
            double d3;
            if (n4 > 0) {
                System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Requested width = " + n + " height = " + n2);
            }
            int n5 = ((BufferedImage)object2).getWidth();
            int n6 = ((BufferedImage)object2).getHeight();
            if (n4 > 1) {
                System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Source width = " + n5 + " width = " + n6);
            }
            if (n <= 0 && n2 > 0 && n2 != n6) {
                d3 = (double)n2 / (double)n6;
                if (n4 > 1) {
                    System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Resizing - specified desired height only and different from source, scale = " + d3);
                }
                object2 = BufferedImageUtilities.resampleWithAffineTransformOp((BufferedImage)object2, d3, d3);
            } else if (n2 <= 0 && n > 0 && n != n5) {
                d3 = (double)n / (double)n5;
                if (n4 > 1) {
                    System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Resizing - specified desired width only and different from source, scale = " + d3);
                }
                object2 = BufferedImageUtilities.resampleWithAffineTransformOp((BufferedImage)object2, d3, d3);
            } else if (n > 0 && n2 > 0 && (n != n5 || n2 != n6)) {
                if (n4 > 1) {
                    System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Resizing - specified desired width and height and different from source ");
                }
                object2 = BufferedImageUtilities.resampleWithAffineTransformOp((BufferedImage)object2, n, n2);
            }
            if (n4 > 1) {
                System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Resized width = " + ((BufferedImage)object2).getWidth() + " height = " + ((BufferedImage)object2).getHeight());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (string4 != null && string4.equals(ALL_ANNOTATIONS)) {
            Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
            GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = null;
            try {
                geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
            }
            catch (DicomException dicomException) {
                dicomException.printStackTrace(System.err);
            }
            DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations = new DemographicAndTechniqueAnnotations(attributeList, geometryOfVolumeFromAttributeList);
            if (demographicAndTechniqueAnnotations != null) {
                object = "";
                int n7 = 0;
                int n8 = 10;
                Font font = new Font((String)object, n7, n8);
                Color color = Color.pink;
                graphics2D.setColor(color);
                graphics2D.setFont(font);
                Iterator iterator = demographicAndTechniqueAnnotations.iterator(0);
                while (iterator.hasNext()) {
                    TextAnnotationPositioned.drawPositionedString((TextAnnotationPositioned)iterator.next(), graphics2D, ((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 5, 5);
                }
            }
        }
        object2 = BufferedImageUtilities.convertToThreeChannelImageType((BufferedImage)object2);
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string3);
        if (iterator == null || !iterator.hasNext()) throw new DicomException("Cannot find writer for format" + string3);
        ImageWriter imageWriter = iterator.next();
        if (imageWriter == null) throw new DicomException("Cannot find writer for format" + string3);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(new File(string2));
        imageWriter.setOutput(imageOutputStream);
        try {
            object = imageWriter.getDefaultWriteParam();
            if (n3 >= 0 && n3 <= 100) {
                float f = (float)n3 / 100.0f;
                if (n4 > 1) {
                    System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Setting quality = " + f);
                }
                ((ImageWriteParam)object).setCompressionMode(2);
                ((ImageWriteParam)object).setCompressionQuality(f);
            }
            if (((ImageWriteParam)object).canWriteProgressive()) {
                if (n4 > 1) {
                    System.err.println("ConsumerFormatImageMaker.convertFileToEightBitImage(): Setting progressive mode");
                }
                ((ImageWriteParam)object).setProgressiveMode(1);
            }
            imageWriter.getDefaultWriteParam();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            object = null;
        }
        IIOMetadata iIOMetadata = null;
        imageWriter.write(iIOMetadata, new IIOImage((RenderedImage)object2, null, iIOMetadata), (ImageWriteParam)object);
        imageOutputStream.flush();
        imageOutputStream.close();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray.length > 2 ? stringArray[2] : "jpeg";
        double d = stringArray.length > 3 ? Double.parseDouble(stringArray[3]) : 0.0;
        double d2 = stringArray.length > 4 ? Double.parseDouble(stringArray[4]) : 0.0;
        int n = stringArray.length > 5 ? Integer.parseInt(stringArray[5]) : 0;
        int n2 = stringArray.length > 6 ? Integer.parseInt(stringArray[6]) : 0;
        int n3 = stringArray.length > 7 ? Integer.parseInt(stringArray[7]) : -1;
        String string4 = stringArray.length > 8 ? stringArray[8] : ALL_ANNOTATIONS;
        int n4 = stringArray.length > 9 ? Integer.parseInt(stringArray[9]) : -1;
        try {
            ConsumerFormatImageMaker.convertFileToEightBitImage(string, string2, string3, d, d2, n, n2, n3, string4, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

