/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.DisplayShutter;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.RealWorldValueTransform;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.DisplayedAreaSelection;
import com.pixelmed.display.DrawingUtilities;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotation;
import com.pixelmed.display.TextAnnotationPositioned;
import com.pixelmed.display.WindowCenterAndWidth;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.display.event.VOIFunctionChangeEvent;
import com.pixelmed.display.event.WindowCenterAndWidthChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.utils.FloatFormatter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SingleImagePanel
extends JComponent
implements KeyListener,
MouseListener,
MouseMotionListener {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanel.java,v 1.156 2008/05/16 13:56:05 dclunie Exp $";
    SourceImage sImg;
    int currentSrcImageIndex;
    int[] currentSrcImageSortOrder;
    BufferedImage cachedResizedImage;
    BufferedImage cachedResizedSelectedRegionImage;
    BufferedImage cachedPreWindowedImage;
    int offsetDrawingOfResizedSelectedRegionImageX;
    int offsetDrawingOfResizedSelectedRegionImageY;
    Rectangle cachedWindowSize;
    protected boolean useVOILUTNotFunction;
    protected double windowCenter;
    protected double windowWidth;
    protected double voiLUTIdentityWindowWidth;
    protected double voiLUTIdentityWindowCenter;
    protected int voiLUTNumberOfEntries;
    protected int voiLUTFirstValueMapped;
    protected int voiLUTBitsPerEntry;
    protected short[] voiLUTData;
    protected int voiLUTEntryMin;
    protected int voiLUTEntryMax;
    protected int voiLUTTopOfEntryRange;
    double useSlope;
    double useIntercept;
    int imgMin;
    int imgMax;
    private int largestGray;
    private int firstvalueMapped;
    private int numberOfEntries;
    private int bitsPerEntry;
    private short[] redTable;
    private short[] greenTable;
    private short[] blueTable;
    private boolean signed;
    private boolean inverted;
    private int signMask;
    private int signBit;
    int pad;
    int padRangeLimit;
    boolean hasPad;
    RealWorldValueTransform realWorldValueTransform;
    ModalityTransform modalityTransform;
    VOITransform voiTransform;
    DisplayShutter displayShutter;
    private GeometryOfVolume imageGeometry;
    protected Vector preDefinedShapes;
    protected Vector preDefinedText;
    protected Vector localizerShapes;
    protected Vector volumeLocalizationShapes;
    protected Vector interactiveDrawingShapes;
    protected Vector persistentDrawingShapes;
    protected Vector selectedDrawingShapes;
    protected Vector persistentDrawingText;
    private DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations = null;
    private Color demographicAndTechniqueColor;
    private Font demographicAndTechniqueFont;
    protected OrientationAnnotations orientationAnnotations = null;
    protected Color orientationColor;
    protected Font orientationFont;
    protected boolean showOrientationsLeftSide = false;
    protected String sideAndViewAnnotationString;
    protected int sideAndViewAnnotationVerticalOffset;
    protected Color sideAndViewAnnotationColor;
    protected Font sideAndViewAnnotationFont;
    protected boolean showSideAndViewAnnotationLeftSide = false;
    protected DisplayedAreaSelection originalDisplayedAreaSelection = null;
    private DisplayedAreaSelection useDisplayedAreaSelection = null;
    private AffineTransform preTransformImageRelativeCoordinates = null;
    protected boolean showZoomFactor = false;
    protected boolean showZoomFactorLeftSide = false;
    protected double pixelSpacingInSourceImage = 0.0;
    private AffineTransform imageToWindowCoordinateTransform = null;
    private AffineTransform windowToImageCoordinateTransform = null;
    private int useVOIFunction = 0;
    EventContext typeOfPanelEventContext;
    int lastx;
    int lasty;
    int lastmiddley;
    double windowingMultiplier = 1.0;
    double panningMultiplier = 1.0;
    protected LeftMouseMode leftMouseMode = new LeftMouseMode();
    int currentVOITransformInUse;
    protected double[] currentLocationIn3DSpace = new double[3];
    private OurWindowCenterAndWidthChangeListener ourWindowCenterAndWidthChangeListener;
    private OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    private OurFrameSortOrderChangeListener ourFrameSortOrderChangeListener;
    private OurVOIFunctionChangeListener ourVOIFunctionChangeListener;
    private boolean useConvertToMostFavorableImageType;
    private BufferedImageUtilities resampler = null;

    public void dirty() {
        this.dirtySource();
    }

    public void dirtySource() {
        this.cachedResizedImage = null;
        this.cachedResizedSelectedRegionImage = null;
        this.cachedPreWindowedImage = null;
    }

    public void dirtyWindowing() {
        this.cachedPreWindowedImage = null;
    }

    public void dirtyPanned() {
        this.cachedPreWindowedImage = null;
        this.cachedResizedSelectedRegionImage = null;
    }

    public GeometryOfVolume getImageGeometry() {
        return this.imageGeometry;
    }

    public final void setPreDefinedShapes(Vector vector) {
        this.preDefinedShapes = vector;
    }

    public final void setLocalizerShapes(Vector vector) {
        this.localizerShapes = vector;
    }

    public final void setVolumeLocalizationShapes(Vector vector) {
        this.volumeLocalizationShapes = vector;
    }

    public final void setPersistentDrawingShapes(Vector vector) {
        this.persistentDrawingShapes = vector;
    }

    public final Vector getPersistentDrawingShapes() {
        return this.persistentDrawingShapes;
    }

    public final void setSelectedDrawingShapes(Vector vector) {
        this.selectedDrawingShapes = vector;
    }

    public final Vector getSelectedDrawingShapes() {
        return this.selectedDrawingShapes;
    }

    public final void setDemographicAndTechniqueAnnotations(DemographicAndTechniqueAnnotations demographicAndTechniqueAnnotations, String string, int n, int n2, Color color) {
        this.demographicAndTechniqueAnnotations = demographicAndTechniqueAnnotations;
        this.demographicAndTechniqueFont = new Font(string, n, n2);
        this.demographicAndTechniqueColor = color;
    }

    public final void setOrientationAnnotations(OrientationAnnotations orientationAnnotations, String string, int n, int n2, Color color) {
        this.setOrientationAnnotations(orientationAnnotations, string, n, n2, color, false);
    }

    public final void setOrientationAnnotations(OrientationAnnotations orientationAnnotations, String string, int n, int n2, Color color, boolean bl) {
        this.orientationAnnotations = orientationAnnotations;
        this.orientationFont = new Font(string, n, n2);
        this.orientationColor = color;
        this.showOrientationsLeftSide = bl;
    }

    public final void setSideAndViewAnnotationString(String string, int n, String string2, int n2, int n3, Color color, boolean bl) {
        this.sideAndViewAnnotationString = string;
        this.sideAndViewAnnotationVerticalOffset = n;
        this.sideAndViewAnnotationFont = new Font(string2, n2, n3);
        this.sideAndViewAnnotationColor = color;
        this.showSideAndViewAnnotationLeftSide = bl;
    }

    public final void setDisplayedAreaSelection(DisplayedAreaSelection displayedAreaSelection) {
        this.originalDisplayedAreaSelection = displayedAreaSelection;
        this.useDisplayedAreaSelection = null;
    }

    public void displayReset() {
        this.dirtySource();
        this.useDisplayedAreaSelection = null;
        this.establishInitialWindowOrVOILUT();
    }

    public void displaySelectedMagnificationRatio(double d) {
        this.dirtySource();
        try {
            this.useDisplayedAreaSelection = (DisplayedAreaSelection)this.originalDisplayedAreaSelection.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.useDisplayedAreaSelection = null;
        }
        if (this.useDisplayedAreaSelection != null) {
            this.useDisplayedAreaSelection.setPixelMagnificationRatio(d);
            this.useDisplayedAreaSelection = this.useDisplayedAreaSelection.shapeSelectionToMatchAvailableWindow(this.cachedWindowSize);
        }
    }

    public final void setPreTransformImageRelativeCoordinates(AffineTransform affineTransform) {
        this.preTransformImageRelativeCoordinates = affineTransform;
    }

    public final void setShowZoomFactor(boolean bl, boolean bl2, double d) {
        this.showZoomFactor = bl;
        this.showZoomFactorLeftSide = bl2;
        this.pixelSpacingInSourceImage = d;
    }

    public final void setPixelSpacingInSourceImage(double d) {
        this.pixelSpacingInSourceImage = d;
    }

    public final void setVOIFunctionToLinear() {
        this.useVOIFunction = 0;
    }

    public final void setVOIFunctionToLogistic() {
        this.useVOIFunction = 1;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.windowingMultiplier = 50.0;
            this.panningMultiplier = 5.0;
        } else if (keyEvent.getKeyCode() == 18) {
            this.leftMouseMode.setPanning();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 16) {
            this.windowingMultiplier = 1.0;
            this.panningMultiplier = 1.0;
        } else if (keyEvent.getKeyCode() == 18) {
            this.leftMouseMode.setWindowing();
        } else if (keyEvent.getKeyCode() == 82) {
            this.displayReset();
            this.repaint();
        } else if (keyEvent.getKeyCode() == 49) {
            this.displaySelectedMagnificationRatio(1.0);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 50) {
            this.displaySelectedMagnificationRatio(2.0);
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            System.err.println("Left dragged " + mouseEvent.getX() + " " + mouseEvent.getY());
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.lastx;
            int n4 = n2 - this.lasty;
            if (n3 != 0 || n4 != 0) {
                this.lastx = n;
                this.lasty = n2;
                if (this.leftMouseMode.isWindowing()) {
                    double d = this.windowWidth + (double)n3 * this.windowingMultiplier;
                    if (d < 1.0) {
                        d = 1.0;
                    }
                    double d2 = this.windowCenter + (double)n4 * this.windowingMultiplier;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowCenterAndWidthChangeEvent(this.typeOfPanelEventContext, d2, d));
                } else if (this.leftMouseMode.isPanning() && this.useDisplayedAreaSelection != null) {
                    int n5 = (int)((double)(-n3) * this.panningMultiplier);
                    int n6 = (int)((double)(-n4) * this.panningMultiplier);
                    this.useDisplayedAreaSelection.translate(n5, n6);
                    this.dirtyPanned();
                    this.repaint();
                }
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            int n = mouseEvent.getY() - this.lastmiddley;
            int n7 = this.currentSrcImageIndex + n;
            if (n7 >= this.sImg.getNumberOfBufferedImages()) {
                n7 = this.sImg.getNumberOfBufferedImages() - 1;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n7 != this.currentSrcImageIndex) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(this.typeOfPanelEventContext, n7));
            }
            this.lastmiddley = mouseEvent.getY();
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    protected int getSourceImageHeight() {
        return this.sImg.getHeight();
    }

    protected int getSourceImageWidth() {
        return this.sImg.getWidth();
    }

    protected Point getImageCoordinateFromWindowCoordinate(double d, double d2) {
        int n = 0;
        int n2 = 0;
        if (this.windowToImageCoordinateTransform != null) {
            int n3;
            Point2D point2D = new Point2D.Double(d, d2);
            point2D = this.windowToImageCoordinateTransform.transform(point2D, point2D);
            n = (int)(point2D.getX() + 0.5);
            n2 = (int)(point2D.getY() + 0.5);
            if (n < 0) {
                n = 0;
            } else {
                n3 = this.getSourceImageWidth();
                if (n >= n3) {
                    n = n3 - 1;
                }
            }
            if (n2 < 0) {
                n2 = 0;
            } else {
                n3 = this.getSourceImageHeight();
                if (n2 >= n3) {
                    n2 = n3 - 1;
                }
            }
        }
        return new Point(n, n2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        Point point = this.getImageCoordinateFromWindowCoordinate(d, d2);
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = this.currentSrcImageSortOrder == null ? this.currentSrcImageIndex : this.currentSrcImageSortOrder[this.currentSrcImageIndex];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(n);
        stringBuffer.append(",");
        stringBuffer.append(n2);
        if (this.imageGeometry != null) {
            this.imageGeometry.lookupImageCoordinate(this.currentLocationIn3DSpace, n, n2, n3);
            stringBuffer.append(": ");
            stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[0]));
            stringBuffer.append(",");
            stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[1]));
            stringBuffer.append(",");
            stringBuffer.append(FloatFormatter.toString(this.currentLocationIn3DSpace[2]));
        }
        stringBuffer.append(")");
        BufferedImage bufferedImage = this.sImg.getBufferedImage(n3);
        if (n >= 0 && n < bufferedImage.getWidth() && n2 >= 0 && n2 < bufferedImage.getHeight()) {
            int[] nArray = bufferedImage.getSampleModel().getPixel(n, n2, (int[])null, bufferedImage.getRaster().getDataBuffer());
            int n4 = nArray[0];
            if (this.signed && (n4 & this.signBit) != 0) {
                n4 |= this.signMask;
            }
            if (this.realWorldValueTransform != null) {
                stringBuffer.append(" = ");
                stringBuffer.append(this.realWorldValueTransform.toString(n3, n4));
                stringBuffer.append(" [");
                stringBuffer.append(n4);
                stringBuffer.append("]");
            }
        }
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(stringBuffer.toString()));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastx = mouseEvent.getX();
            this.lasty = mouseEvent.getY();
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
            this.lastmiddley = mouseEvent.getY();
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.leftMouseMode.isWindowing()) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowCenterAndWidthChangeEvent(this.typeOfPanelEventContext, this.windowCenter, this.windowWidth));
            }
        } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent)) {
            // empty if block
        }
    }

    public static final BufferedImage applyVOILUT(BufferedImage bufferedImage, double d, double d2, double d3, double d4, boolean bl, boolean bl2, double d5, double d6, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, int n6, int n7, int n8) {
        return WindowCenterAndWidth.applyVOILUT(bufferedImage, d, d2, d3, d4, bl, bl2, d5, d6, bl3, n, n2, n3, n4, n5, sArray, n6, n7, n8);
    }

    public static final BufferedImage applyWindowCenterAndWidthLogistic(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLogistic(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2);
    }

    public static final BufferedImage applyWindowCenterAndWidthLinear(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthLinear(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2);
    }

    public static final BufferedImage applyWindowCenterAndWidthWithPaletteColor(BufferedImage bufferedImage, double d, double d2, boolean bl, boolean bl2, double d3, double d4, boolean bl3, int n, int n2, int n3, int n4, int n5, short[] sArray, short[] sArray2, short[] sArray3) {
        return WindowCenterAndWidth.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, d, d2, bl, bl2, d3, d4, bl3, n, n2, n3, n4, n5, sArray, sArray2, sArray3);
    }

    protected void establishInitialWindowOrVOILUT() {
        this.useVOILUTNotFunction = false;
        this.windowWidth = 0.0;
        this.windowCenter = 0.0;
        this.voiLUTIdentityWindowCenter = 0.0;
        this.voiLUTIdentityWindowWidth = 0.0;
        this.voiLUTNumberOfEntries = 0;
        this.voiLUTFirstValueMapped = 0;
        this.voiLUTBitsPerEntry = 0;
        this.voiLUTData = null;
        this.voiLUTEntryMin = 0;
        this.voiLUTEntryMax = 0;
        this.voiLUTTopOfEntryRange = 0;
        if (this.voiTransform != null) {
            int n = this.voiTransform.getNumberOfTransforms(this.currentSrcImageIndex);
            this.currentVOITransformInUse = 0;
            while (this.currentVOITransformInUse < n) {
                if (this.voiTransform.isLUTTransform(this.currentSrcImageIndex, this.currentVOITransformInUse)) {
                    this.voiLUTNumberOfEntries = this.voiTransform.getNumberOfEntries(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTFirstValueMapped = this.voiTransform.getFirstValueMapped(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTBitsPerEntry = this.voiTransform.getBitsPerEntry(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTData = this.voiTransform.getLUTData(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTEntryMin = this.voiTransform.getEntryMinimum(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTEntryMax = this.voiTransform.getEntryMaximum(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    this.voiLUTTopOfEntryRange = this.voiTransform.getTopOfEntryRange(this.currentSrcImageIndex, this.currentVOITransformInUse);
                    if (this.voiLUTData == null || this.voiLUTData.length != this.voiLUTNumberOfEntries) break;
                    this.useVOILUTNotFunction = true;
                    System.err.println("SingleImagePanel.establishInitialWindowOrVOILUT(): using good LUT " + this.currentVOITransformInUse);
                    this.voiLUTIdentityWindowWidth = this.voiLUTNumberOfEntries;
                    this.voiLUTIdentityWindowCenter = this.voiLUTFirstValueMapped + this.voiLUTNumberOfEntries / 2;
                    this.windowWidth = this.voiLUTIdentityWindowWidth;
                    this.windowCenter = this.voiLUTIdentityWindowCenter;
                    break;
                }
                ++this.currentVOITransformInUse;
            }
            if (!this.useVOILUTNotFunction) {
                this.currentVOITransformInUse = 0;
                while (this.currentVOITransformInUse < n) {
                    if (this.voiTransform.isWindowTransform(this.currentSrcImageIndex, this.currentVOITransformInUse)) {
                        this.useVOILUTNotFunction = false;
                        this.windowWidth = this.voiTransform.getWidth(this.currentSrcImageIndex, this.currentVOITransformInUse);
                        this.windowCenter = this.voiTransform.getCenter(this.currentSrcImageIndex, this.currentVOITransformInUse);
                        System.err.println("SingleImagePanel.establishInitialWindowOrVOILUT(): Initially using preselected center " + this.windowCenter + " and width " + this.windowWidth);
                        break;
                    }
                    ++this.currentVOITransformInUse;
                }
            }
        }
        if (!this.useVOILUTNotFunction && this.windowWidth == 0.0) {
            double d = (double)this.imgMin * this.useSlope + this.useIntercept;
            double d2 = (double)this.imgMax * this.useSlope + this.useIntercept;
            this.windowWidth = d2 - d;
            this.windowCenter = (d2 + d) / 2.0;
            this.currentVOITransformInUse = -1;
            System.err.println("SingleImagePanel.establishInitialWindowOrVOILUT(): Initially using statistically derived center " + this.windowCenter + " and width " + this.windowWidth);
        }
    }

    private void doCommonConstructorStuff(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        BufferedImage bufferedImage;
        this.sImg = sourceImage;
        boolean bl = false;
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0 && (bufferedImage = sourceImage.getBufferedImage(0)) != null && bufferedImage.getRaster().getNumBands() > 1) {
            bl = true;
        }
        try {
            this.useConvertToMostFavorableImageType = bl;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.currentSrcImageIndex = 0;
        this.currentSrcImageSortOrder = nArray;
        this.dirtySource();
        this.typeOfPanelEventContext = eventContext;
        this.ourWindowCenterAndWidthChangeListener = new OurWindowCenterAndWidthChangeListener(eventContext);
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(eventContext);
        this.ourFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(eventContext);
        this.ourVOIFunctionChangeListener = new OurVOIFunctionChangeListener(eventContext);
        this.largestGray = sourceImage.getPaletteColorLargestGray();
        this.firstvalueMapped = sourceImage.getPaletteColorFirstValueMapped();
        this.numberOfEntries = sourceImage.getPaletteColorNumberOfEntries();
        this.bitsPerEntry = sourceImage.getPaletteColorBitsPerEntry();
        this.redTable = sourceImage.getPaletteColorRedTable();
        this.greenTable = sourceImage.getPaletteColorGreenTable();
        this.blueTable = sourceImage.getPaletteColorBlueTable();
        this.signed = sourceImage.isSigned();
        this.inverted = sourceImage.isInverted();
        this.hasPad = sourceImage.isPadded();
        this.pad = sourceImage.getPadValue();
        this.padRangeLimit = sourceImage.getPadRangeLimit();
        if (sourceImage != null && sourceImage.getNumberOfBufferedImages() > 0) {
            bufferedImage = sourceImage.getBufferedImage(0);
            this.imgMin = sourceImage.getMinimum();
            this.imgMax = sourceImage.getMaximum();
            this.signBit = 0;
            this.signMask = 0;
            if (this.signed) {
                if (bufferedImage.getSampleModel().getDataType() == 0) {
                    this.signBit = 128;
                    this.signMask = -128;
                } else {
                    this.signBit = 32768;
                    this.signMask = Short.MIN_VALUE;
                }
            }
        }
        this.realWorldValueTransform = sourceImage.getRealWorldValueTransform();
        this.modalityTransform = sourceImage.getModalityTransform();
        this.voiTransform = sourceImage.getVOITransform();
        this.displayShutter = sourceImage.getDisplayShutter();
        if (this.modalityTransform != null) {
            this.useSlope = this.modalityTransform.getRescaleSlope(this.currentSrcImageIndex);
            this.useIntercept = this.modalityTransform.getRescaleIntercept(this.currentSrcImageIndex);
        } else {
            this.useSlope = 1.0;
            this.useIntercept = 0.0;
        }
        this.establishInitialWindowOrVOILUT();
        this.preDefinedShapes = vector;
        this.preDefinedText = vector2;
        this.imageGeometry = geometryOfVolume;
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        this.doCommonConstructorStuff(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        this.doCommonConstructorStuff(sourceImage, eventContext, null, null, null, geometryOfVolume);
    }

    public SingleImagePanel(SourceImage sourceImage, EventContext eventContext) {
        this.doCommonConstructorStuff(sourceImage, eventContext, null, null, null, null);
    }

    public SingleImagePanel(SourceImage sourceImage) {
        this.doCommonConstructorStuff(sourceImage, null, null, null, null, null);
    }

    public void deconstruct() {
        if (this.ourWindowCenterAndWidthChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourWindowCenterAndWidthChangeListener);
            this.ourWindowCenterAndWidthChangeListener = null;
        }
        if (this.ourFrameSelectionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSelectionChangeListener);
            this.ourFrameSelectionChangeListener = null;
        }
        if (this.ourFrameSortOrderChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourFrameSortOrderChangeListener);
            this.ourFrameSortOrderChangeListener = null;
        }
        if (this.ourVOIFunctionChangeListener != null) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().removeListener(this.ourVOIFunctionChangeListener);
            this.ourVOIFunctionChangeListener = null;
        }
    }

    public static void deconstructAllSingleImagePanelsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof SingleImagePanel)) continue;
            ((SingleImagePanel)component).deconstruct();
        }
    }

    protected void finalize() throws Throwable {
        this.deconstruct();
        super.finalize();
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        int n;
        long l = System.currentTimeMillis();
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n2 = this.currentSrcImageSortOrder == null ? this.currentSrcImageIndex : this.currentSrcImageSortOrder[this.currentSrcImageIndex];
        BufferedImage bufferedImage = this.sImg.getBufferedImage(n2);
        Rectangle rectangle = this.getBounds();
        if (this.cachedWindowSize != null && rectangle.width != this.cachedWindowSize.width && rectangle.height != this.cachedWindowSize.height) {
            System.err.println("SingleImagePanel.paintComponent(): window size changed, so flushing cache and resetting selection to original");
            this.dirtySource();
            this.useDisplayedAreaSelection = null;
        }
        this.cachedWindowSize = rectangle;
        if (this.useDisplayedAreaSelection == null) {
            if (this.originalDisplayedAreaSelection == null) {
                this.originalDisplayedAreaSelection = new DisplayedAreaSelection(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.useDisplayedAreaSelection = this.originalDisplayedAreaSelection.shapeSelectionToMatchAvailableWindow(rectangle);
        }
        double d = (double)rectangle.width / (double)this.useDisplayedAreaSelection.getSelectionWidth();
        this.imageToWindowCoordinateTransform = AffineTransform.getTranslateInstance((double)(-this.useDisplayedAreaSelection.getXOffset()) * d, (double)(-this.useDisplayedAreaSelection.getYOffset()) * d);
        this.imageToWindowCoordinateTransform.concatenate(AffineTransform.getScaleInstance(d, d));
        if (this.preTransformImageRelativeCoordinates != null) {
            this.imageToWindowCoordinateTransform.concatenate(this.preTransformImageRelativeCoordinates);
        }
        try {
            this.windowToImageCoordinateTransform = this.imageToWindowCoordinateTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace(System.err);
            this.windowToImageCoordinateTransform = null;
        }
        if (this.cachedPreWindowedImage == null) {
            if (this.cachedResizedSelectedRegionImage == null) {
                int n3;
                int n4;
                int n5;
                if (this.cachedResizedImage == null) {
                    if (this.resampler == null) {
                        this.resampler = new BufferedImageUtilities();
                    }
                    int n6 = this.sImg.getBackgroundValue();
                    n5 = bufferedImage.getWidth();
                    n4 = bufferedImage.getHeight();
                    this.cachedResizedImage = this.resampler.resample(bufferedImage, n5, n4, 0, 0, (int)Math.round((double)n5 * d), (int)Math.round((double)n4 * d), this.signed, n6);
                }
                int n7 = (int)Math.round((double)this.useDisplayedAreaSelection.getXOffset() * d);
                n5 = (int)Math.round((double)this.useDisplayedAreaSelection.getYOffset() * d);
                n4 = (int)Math.round((double)this.useDisplayedAreaSelection.getSelectionWidth() * d);
                int n8 = (int)Math.round((double)this.useDisplayedAreaSelection.getSelectionHeight() * d);
                if (n7 < 0) {
                    this.offsetDrawingOfResizedSelectedRegionImageX = -n7;
                    n7 = 0;
                } else {
                    this.offsetDrawingOfResizedSelectedRegionImageX = 0;
                }
                if (n5 < 0) {
                    this.offsetDrawingOfResizedSelectedRegionImageY = -n5;
                    n5 = 0;
                } else {
                    this.offsetDrawingOfResizedSelectedRegionImageY = 0;
                }
                n = this.cachedResizedImage.getWidth();
                if (n7 + n4 > n) {
                    n4 = n - n7;
                } else if (n7 + n4 < n) {
                    n4 = n - n7;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 + n8 > (n3 = this.cachedResizedImage.getHeight())) {
                    n8 = n3 - n5;
                } else if (n5 + n8 < n3) {
                    n8 = n3 - n5;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                BufferedImage bufferedImage2 = this.cachedResizedSelectedRegionImage = n8 > 0 && n4 > 0 ? this.cachedResizedImage.getSubimage(n7, n5, n4, n8) : null;
            }
            if ((bufferedImage = this.cachedResizedSelectedRegionImage) == null) {
                this.cachedPreWindowedImage = null;
            } else if (bufferedImage.getColorModel().getNumComponents() == 1) {
                if (this.currentVOITransformInUse != -1 && !this.useVOILUTNotFunction && this.voiTransform != null && this.voiTransform.getNumberOfTransforms(n2) > this.currentVOITransformInUse) {
                    this.windowWidth = this.voiTransform.getWidth(n2, this.currentVOITransformInUse);
                    this.windowCenter = this.voiTransform.getCenter(n2, this.currentVOITransformInUse);
                }
                if (this.modalityTransform != null) {
                    this.useSlope = this.modalityTransform.getRescaleSlope(n2);
                    this.useIntercept = this.modalityTransform.getRescaleIntercept(n2);
                } else {
                    this.useSlope = 1.0;
                    this.useIntercept = 0.0;
                }
                long l2 = System.currentTimeMillis();
                this.cachedPreWindowedImage = this.useVOILUTNotFunction ? SingleImagePanel.applyVOILUT(bufferedImage, this.windowCenter, this.windowWidth, this.voiLUTIdentityWindowCenter, this.voiLUTIdentityWindowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit, this.voiLUTNumberOfEntries, this.voiLUTFirstValueMapped, this.voiLUTBitsPerEntry, this.voiLUTData, this.voiLUTEntryMin, this.voiLUTEntryMax, this.voiLUTTopOfEntryRange) : (this.numberOfEntries != 0 && this.redTable != null ? SingleImagePanel.applyWindowCenterAndWidthWithPaletteColor(bufferedImage, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit, this.largestGray, this.bitsPerEntry, this.numberOfEntries, this.redTable, this.greenTable, this.blueTable) : (this.useVOIFunction == 1 ? SingleImagePanel.applyWindowCenterAndWidthLogistic(bufferedImage, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit) : SingleImagePanel.applyWindowCenterAndWidthLinear(bufferedImage, this.windowCenter, this.windowWidth, this.signed, this.inverted, this.useSlope, this.useIntercept, this.hasPad, this.pad, this.padRangeLimit)));
            } else {
                this.cachedPreWindowedImage = bufferedImage;
            }
            if (this.cachedPreWindowedImage != null && this.useConvertToMostFavorableImageType) {
                this.cachedPreWindowedImage = BufferedImageUtilities.convertToMostFavorableImageType(this.cachedPreWindowedImage);
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.cachedPreWindowedImage != null) {
            Shape shape = null;
            if (this.displayShutter != null) {
                double d2;
                double d3;
                Point2D point2D;
                shape = graphics2D.getClip();
                if (this.displayShutter.isCircularShutter()) {
                    Point2D point2D2 = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getCircularShutterTLHC(), null);
                    double d4 = point2D2.getX();
                    double d5 = point2D2.getY();
                    point2D = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getCircularShutterBRHC(), null);
                    d3 = point2D.getX();
                    d2 = point2D.getY();
                    graphics2D.clip(new Ellipse2D.Double(d4, d5, d3 - d4, d2 - d5));
                }
                if (this.displayShutter.isRectangularShutter()) {
                    Point2D point2D3 = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getRectangularShutterTLHC(), null);
                    double d6 = point2D3.getX();
                    double d7 = point2D3.getY();
                    point2D = this.imageToWindowCoordinateTransform.transform(this.displayShutter.getRectangularShutterBRHC(), null);
                    d3 = point2D.getX();
                    d2 = point2D.getY();
                    graphics2D.clip(new Rectangle2D.Double(d6, d7, d3 - d6, d2 - d7));
                }
                if (this.displayShutter.isPolygonalShutter()) {
                    Point2D[] point2DArray = this.displayShutter.getVerticesOfPolygonalShutterAsPoint2D();
                    Polygon polygon = new Polygon();
                    for (n = 0; n < point2DArray.length; ++n) {
                        Point2D point2D4 = this.imageToWindowCoordinateTransform.transform(point2DArray[n], null);
                        polygon.addPoint((int)point2D4.getX(), (int)point2D4.getY());
                    }
                    graphics2D.clip(polygon);
                }
            }
            graphics2D.drawImage((Image)this.cachedPreWindowedImage, this.offsetDrawingOfResizedSelectedRegionImageX, this.offsetDrawingOfResizedSelectedRegionImageY, this);
            if (shape != null) {
                graphics2D.setClip(shape);
            }
        }
        Color color = Color.red;
        Color color2 = Color.green;
        Color color3 = Color.red;
        Color color4 = Color.green;
        Color color5 = Color.blue;
        Color color6 = Color.yellow;
        int n9 = 2;
        Font font = new Font("SansSerif", 1, 14);
        Font font2 = new Font("SansSerif", 1, 10);
        if (this.demographicAndTechniqueAnnotations != null) {
            graphics2D.setColor(this.demographicAndTechniqueColor);
            graphics2D.setFont(this.demographicAndTechniqueFont);
            Iterator iterator = this.demographicAndTechniqueAnnotations.iterator(n2);
            while (iterator.hasNext()) {
                TextAnnotationPositioned.drawPositionedString((TextAnnotationPositioned)iterator.next(), graphics2D, this, 5, 5);
            }
        }
        graphics2D.setColor(this.orientationColor);
        graphics2D.setFont(this.orientationFont);
        if (this.orientationAnnotations != null) {
            Object object3;
            String string = this.orientationAnnotations.getRowOrientation(n2);
            if (string != null && string.length() > 0) {
                TextAnnotationPositioned.drawVerticallyCenteredString(string, this.showOrientationsLeftSide, graphics2D, this, 5);
            }
            if ((object3 = this.orientationAnnotations.getColumnOrientation(n2)) != null && ((String)object3).length() > 0) {
                TextAnnotationPositioned.drawHorizontallyCenteredString((String)object3, false, graphics2D, this, 5);
            }
        }
        if (this.showZoomFactor) {
            double d8 = Math.abs(this.imageToWindowCoordinateTransform.getScaleX());
            object2 = "1:" + FloatFormatter.toString(d8);
            TextAnnotationPositioned.drawVerticallyCenteredString((String)object2, this.showZoomFactorLeftSide, graphics2D, this, 2, 5);
            object = "[" + FloatFormatter.toString(this.pixelSpacingInSourceImage / d8) + "mm]";
            TextAnnotationPositioned.drawVerticallyCenteredString((String)object, this.showZoomFactorLeftSide, graphics2D, this, 3, 5);
        }
        if (this.sideAndViewAnnotationString != null) {
            graphics2D.setColor(this.sideAndViewAnnotationColor);
            graphics2D.setFont(this.sideAndViewAnnotationFont);
            TextAnnotationPositioned.drawPositionedString(new TextAnnotationPositioned(this.sideAndViewAnnotationString, this.showSideAndViewAnnotationLeftSide, true, 0), graphics2D, this, this.sideAndViewAnnotationVerticalOffset, 5);
        }
        if (this.persistentDrawingText != null) {
            graphics2D.setColor(color2);
            graphics2D.setFont(font2);
            for (Object object3 : this.persistentDrawingText) {
                object2 = ((TextAnnotation)object3).getAnchorPoint();
                object = this.imageToWindowCoordinateTransform.transform((Point2D)object2, null);
                String string = ((TextAnnotation)object3).getString();
                int n10 = 5;
                int n11 = (int)graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getWidth();
                DrawingUtilities.drawShadowedString(string, this.showOrientationsLeftSide ? n10 : this.getBounds().width - n10 - n11, (int)((Point2D)object).getY(), graphics2D);
            }
        }
        graphics2D.transform(this.imageToWindowCoordinateTransform);
        if (this.interactiveDrawingShapes != null) {
            graphics2D.setColor(color);
            Iterator iterator = this.interactiveDrawingShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.persistentDrawingShapes != null) {
            graphics2D.setColor(color2);
            Iterator iterator = this.persistentDrawingShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.selectedDrawingShapes != null) {
            graphics2D.setColor(color3);
            Iterator iterator = this.selectedDrawingShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.volumeLocalizationShapes != null) {
            graphics2D.setColor(color5);
            Iterator iterator = this.volumeLocalizationShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.localizerShapes != null) {
            graphics2D.setColor(color4);
            Iterator iterator = this.localizerShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.preDefinedShapes != null) {
            graphics2D.setColor(color6);
            graphics2D.setStroke(new BasicStroke(n9));
            Iterator iterator = this.preDefinedShapes.iterator();
            while (iterator.hasNext()) {
                DrawingUtilities.drawShadowedShape((Shape)iterator.next(), graphics2D);
            }
        }
        if (this.preDefinedText != null) {
            graphics2D.setColor(color6);
            graphics2D.setFont(font);
            for (Object object3 : this.preDefinedText) {
                DrawingUtilities.drawShadowedString(((TextAnnotation)object3).getString(), ((TextAnnotation)object3).getAnchorPointXAsInt(), ((TextAnnotation)object3).getAnchorPointYAsInt(), graphics2D);
            }
        }
        this.setCursor(cursor);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                JFrame jFrame = new JFrame();
                jFrame.add(new SingleImagePanel(new SourceImage(stringArray[0])));
                jFrame.setBackground(Color.BLACK);
                jFrame.setSize(512, 512);
                jFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    class OurVOIFunctionChangeListener
    extends SelfRegisteringListener {
        public OurVOIFunctionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.VOIFunctionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            VOIFunctionChangeEvent vOIFunctionChangeEvent = (VOIFunctionChangeEvent)event;
            if (vOIFunctionChangeEvent.isLinearFunction()) {
                SingleImagePanel.this.setVOIFunctionToLinear();
            } else if (vOIFunctionChangeEvent.isLogisticFunction()) {
                SingleImagePanel.this.setVOIFunctionToLogistic();
            }
            SingleImagePanel.this.dirtyWindowing();
            SingleImagePanel.this.repaint();
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            int[] nArray = frameSortOrderChangeEvent.getSortOrder();
            int n = frameSortOrderChangeEvent.getIndex();
            if (SingleImagePanel.this.currentSrcImageIndex != n || SingleImagePanel.this.currentSrcImageSortOrder != nArray || !Arrays.equals(SingleImagePanel.this.currentSrcImageSortOrder, nArray)) {
                SingleImagePanel.this.currentSrcImageIndex = n;
                SingleImagePanel.this.currentSrcImageSortOrder = nArray;
                SingleImagePanel.this.dirtySource();
                SingleImagePanel.this.repaint();
            }
        }
    }

    class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            int n = frameSelectionChangeEvent.getIndex();
            if (SingleImagePanel.this.currentSrcImageIndex != n) {
                SingleImagePanel.this.currentSrcImageIndex = n;
                SingleImagePanel.this.dirtySource();
                SingleImagePanel.this.repaint();
            }
        }
    }

    class OurWindowCenterAndWidthChangeListener
    extends SelfRegisteringListener {
        public OurWindowCenterAndWidthChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.WindowCenterAndWidthChangeEvent", eventContext);
        }

        public void changed(Event event) {
            WindowCenterAndWidthChangeEvent windowCenterAndWidthChangeEvent = (WindowCenterAndWidthChangeEvent)event;
            double d = windowCenterAndWidthChangeEvent.getWindowCenter();
            double d2 = windowCenterAndWidthChangeEvent.getWindowWidth();
            if (SingleImagePanel.this.windowCenter != d || SingleImagePanel.this.windowWidth != d2) {
                SingleImagePanel.this.windowCenter = d;
                SingleImagePanel.this.windowWidth = d2;
                SingleImagePanel.this.cachedPreWindowedImage = null;
                SingleImagePanel.this.currentVOITransformInUse = -1;
                SingleImagePanel.this.repaint();
            }
        }
    }

    protected class LeftMouseMode {
        public static final int WINDOWING = 1;
        public static final int PANNING = 2;
        protected int mode = 1;

        LeftMouseMode() {
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void setWindowing() {
            this.mode = 1;
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void setPanning() {
            this.mode = 2;
            SingleImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public boolean isWindowing() {
            return this.mode == 1;
        }

        public boolean isPanning() {
            return this.mode == 2;
        }
    }
}

