/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import java.net.InetAddress;

public class NetworkDefaultValues {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkDefaultValues.java,v 1.4 2007/04/19 13:32:31 dclunie Exp $";
    public static final int StandardDicomPrivilegedPortNumber = 104;
    public static final int StandardDicomReservedPortNumber = 11112;
    public static final int VendorGECommonDicomPortNumber = 4006;
    public static final int VendorSiemensCommonDicomPortNumber = 3004;
    public static final int VendorPhilipsCommonDicomPortNumber = 3010;
    public static final int VendorOsirixCommonDicomPortNumber = 4096;
    public static final int VendorConquestCommonDicomPortNumber = 5678;
    public static final int VendorTianniCommonDicomPortNumber = 2350;
    public static final int VendorKPACSCommonDicomPortNumber = 111;
    public static int[] commonPortNumbers = new int[]{104, 11112, 4006, 3004, 3010, 5678, 4096, 2350, 111};
    public static final int DefaultWADOPort = 7091;
    private static final String DefaultApplicationEntityTitlePrefix = "PIXELMED";
    private static final String DefaultDNSServiceInstanceNamePrefix = "PixelMedWADO";
    private static final String DefaultPrimaryDeviceType = "WSD";

    public static final String getDefaultPrimaryDeviceType() {
        return DefaultPrimaryDeviceType;
    }

    public static final String getDefaultApplicationEntityTitle(int n) {
        String string = NetworkDefaultValues.getNameOrDefaultPlusPort(NetworkDefaultValues.getUnqualifiedLocalHostName(), DefaultApplicationEntityTitlePrefix, n);
        if (string != null) {
            if (string.length() > 16) {
                string = string.substring(0, 16);
            }
            string = string.toUpperCase();
        }
        return string;
    }

    public static final String getDefaultDNSServiceInstanceName(int n) {
        String string = NetworkDefaultValues.getNameOrDefaultPlusPort(NetworkDefaultValues.getUnqualifiedLocalHostName(), DefaultDNSServiceInstanceNamePrefix, n);
        return string;
    }

    private static final String getNameOrDefaultPlusPort(String string, String string2, int n) {
        if (string == null) {
            string = string2;
        }
        if (n >= 0) {
            string = string + "_" + Integer.toString(n);
        }
        return string;
    }

    public static final String getUnqualifiedLocalHostName() {
        String string = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null && (string = inetAddress.getHostName()) != null) {
                int n = string.indexOf(46);
                if (n > -1) {
                    string = string.substring(0, n);
                }
                if (string.length() == 0) {
                    string = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }
}

