/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.FindSOPClassSCU;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.MoveSOPClassSCU;
import com.pixelmed.query.QueryTreeModel;
import java.io.IOException;
import java.util.HashSet;

public abstract class QueryInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryInformationModel.java,v 1.23 2008/01/24 19:03:49 dclunie Exp $";
    private String hostname;
    private int port;
    private String calledAETitle;
    private String callingAETitle;
    protected int debugLevel;

    public final String getCalledAETitle() {
        return this.calledAETitle;
    }

    protected abstract InformationEntity getRoot();

    protected abstract InformationEntity getChildTypeForParent(InformationEntity var1);

    protected abstract HashSet getAllInformationEntitiesToIncludeAtThisQueryLevel(InformationEntity var1);

    protected abstract String getFindSOPClassUID();

    protected abstract String getMoveSOPClassUID();

    protected abstract String getStringValueForTreeFromResponseIdentifier(InformationEntity var1, AttributeList var2);

    public String getQueryLevelName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return "PATIENT";
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDY";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIES";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "IMAGE";
        }
        return null;
    }

    public AttributeTag getUniqueKeyForInformationEntity(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return TagFromName.PatientID;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return TagFromName.StudyInstanceUID;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return TagFromName.SeriesInstanceUID;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return TagFromName.SOPInstanceUID;
        }
        return null;
    }

    protected AttributeTag getAttributeTagOfCountOfChildren(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return TagFromName.NumberOfPatientRelatedStudies;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return TagFromName.NumberOfStudyRelatedSeries;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return TagFromName.NumberOfSeriesRelatedInstances;
        }
        return null;
    }

    private AttributeList makeIdentifierFromAttributesAtThisQueryLevel(AttributeList attributeList, AttributeList attributeList2, InformationEntity informationEntity) throws DicomException {
        Object object;
        Object object22;
        if (this.debugLevel > 1) {
            System.err.println("makeIdentifierFromAttributesAtThisQueryLevel: queryLevel=" + informationEntity);
        }
        HashSet hashSet = this.getAllInformationEntitiesToIncludeAtThisQueryLevel(informationEntity);
        DicomDictionary dicomDictionary = attributeList.getDictionary();
        AttributeList attributeList3 = new AttributeList();
        for (Object object22 : attributeList.values()) {
            object = ((Attribute)object22).getTag();
            InformationEntity informationEntity2 = dicomDictionary.getInformationEntityFromTag((AttributeTag)object);
            if (!((AttributeTag)object).equals(TagFromName.SpecificCharacterSet) && (informationEntity2 == null || !hashSet.contains(informationEntity2))) continue;
            attributeList3.put((AttributeTag)object, (Attribute)object22);
        }
        object22 = TagFromName.QueryRetrieveLevel;
        object = new CodeStringAttribute((AttributeTag)object22);
        ((Attribute)object).addValue(this.getQueryLevelName(informationEntity));
        attributeList3.put((AttributeTag)object22, (Attribute)object);
        if (attributeList2 != null) {
            attributeList3.putAll(attributeList2);
        }
        if (!attributeList3.containsKey(object22 = this.getUniqueKeyForInformationEntity(informationEntity)) && (object = (Object)dicomDictionary.getValueRepresentationFromTag((AttributeTag)object22)) != null) {
            if (ValueRepresentation.isShortStringVR((byte[])object)) {
                attributeList3.put((AttributeTag)object22, new ShortStringAttribute((AttributeTag)object22, null));
            } else if (ValueRepresentation.isUniqueIdentifierVR((byte[])object)) {
                attributeList3.put((AttributeTag)object22, new UniqueIdentifierAttribute((AttributeTag)object22));
            } else {
                throw new DicomException("Internal error: cannot get suitable VR for unique key in query " + object22);
            }
        }
        if (this.debugLevel > 1) {
            System.err.println("makeIdentifierFromAttributesAtThisQueryLevel: identifier=" + attributeList3);
        }
        return attributeList3;
    }

    public String toString() {
        return "host=" + this.hostname + " port=" + this.port + " calledAETitle=" + this.calledAETitle + " callingAETitle=" + this.callingAETitle;
    }

    void performQuery(AttributeList attributeList, AttributeList attributeList2, InformationEntity informationEntity, IdentifierHandler identifierHandler) throws IOException, DicomException, DicomNetworkException {
        if (this.debugLevel > 0) {
            System.err.println("QueryInformationModel.performQuery(): queryLevel=" + informationEntity);
        }
        if (this.debugLevel > 0) {
            System.err.println("QueryInformationModel.performQuery(): parentUniqueKeys=" + attributeList2);
        }
        AttributeList attributeList3 = this.makeIdentifierFromAttributesAtThisQueryLevel(attributeList, attributeList2, informationEntity);
        if (this.debugLevel > 1) {
            System.err.println("QueryInformationModel.performQuery(): requestIdentifier=" + attributeList3);
        }
        new FindSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, this.getFindSOPClassUID(), attributeList3, identifierHandler, this.debugLevel);
    }

    public QueryTreeModel performHierarchicalQuery(AttributeList attributeList) throws IOException, DicomException, DicomNetworkException {
        return new QueryTreeModel(this, attributeList, this.debugLevel);
    }

    public void performHierarchicalMove(AttributeList attributeList) throws IOException, DicomException, DicomNetworkException {
        new MoveSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, this.callingAETitle, this.getMoveSOPClassUID(), attributeList, this.debugLevel);
    }

    public void performHierarchicalMove(AttributeList attributeList, String string) throws IOException, DicomException, DicomNetworkException {
        this.performHierarchicalMoveFrom(attributeList, string);
    }

    public void performHierarchicalMoveFrom(AttributeList attributeList, String string) throws IOException, DicomException, DicomNetworkException {
        new MoveSOPClassSCU(this.hostname, this.port, string, this.callingAETitle, this.callingAETitle, this.getMoveSOPClassUID(), attributeList, this.debugLevel);
    }

    public void performHierarchicalMoveTo(AttributeList attributeList, String string) throws IOException, DicomException, DicomNetworkException {
        new MoveSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, string, this.getMoveSOPClassUID(), attributeList, this.debugLevel);
    }

    public void performHierarchicalMoveFromTo(AttributeList attributeList, String string, String string2) throws IOException, DicomException, DicomNetworkException {
        new MoveSOPClassSCU(this.hostname, this.port, string, this.callingAETitle, string2, this.getMoveSOPClassUID(), attributeList, this.debugLevel);
    }

    public QueryInformationModel(String string, int n, String string2, String string3, int n2) {
        this.hostname = string;
        this.port = n;
        this.calledAETitle = string2;
        this.callingAETitle = string3;
        this.debugLevel = n2;
    }
}

