/*
 * Decompiled with CFR 0.152.
 */
package guilib.common;

import guilib.common.NameValueField;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileNameValueField
extends NameValueField
implements ActionListener {
    protected JButton browseButton;
    protected boolean dirOnly;
    protected JFileChooser fileChooser;
    protected int type = -1;
    public static final int FILE_ONLY = 1;
    public static final int DIR_ONLY = 2;
    public static final int BOTH_FILE_AND_DIR = 3;
    private static final long serialVersionUID = -2212011267873207416L;

    public FileNameValueField(String fieldLabel, int fieldSize, int type) {
        super(fieldLabel, fieldSize);
        this.type = type;
    }

    public FileNameValueField(String fieldLabel, int fieldSize) {
        this(fieldLabel, fieldSize, 1);
    }

    public FileNameValueField(String fieldLabel, int fieldSize, boolean dirOnly) {
        super(fieldLabel, fieldSize);
        this.dirOnly = dirOnly;
    }

    protected void init(String fieldLabel, int fieldSize) {
        this.setLayout(new BoxLayout(this, 0));
        if (fieldLabel != null) {
            this.name = new JLabel(fieldLabel, 2);
            this.add(this.name);
            this.add(Box.createHorizontalGlue());
        }
        this.value = new JTextField(fieldSize > 0 ? fieldSize : 10);
        this.browseButton = new JButton("...");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.value);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this.browseButton);
        this.browseButton.addActionListener(this);
        this.add(panel);
    }

    public void setDirOnly(boolean newDirOnly) {
        this.dirOnly = newDirOnly;
    }

    public boolean isDirOnly() {
        return this.dirOnly;
    }

    public int getType() {
        return this.type;
    }

    public void actionPerformed(ActionEvent e) {
        String curDir = this.getValue();
        if (curDir != null && curDir.trim().length() > 0) {
            File f = new File(curDir);
            if (!(f.isDirectory() || (f = new File(curDir = f.getParent())) != null && f.isDirectory())) {
                curDir = System.getProperty("user.home");
            }
        } else {
            curDir = System.getProperty("user.home");
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setCurrentDirectory(new File(curDir));
        if (this.getType() > 0) {
            switch (this.getType()) {
                case 2: {
                    this.fileChooser.setFileSelectionMode(1);
                    break;
                }
                case 1: {
                    this.fileChooser.setFileSelectionMode(0);
                    break;
                }
                case 3: {
                    this.fileChooser.setFileSelectionMode(2);
                }
            }
        } else if (this.isDirOnly()) {
            this.fileChooser.setFileSelectionMode(1);
        } else {
            this.fileChooser.setFileSelectionMode(0);
        }
        int returnValue = this.fileChooser.showOpenDialog(this);
        if (returnValue == 0) {
            this.setValue(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

