/*
 * Decompiled with CFR 0.152.
 */
package guilib.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class PropertyEditorPane
extends JPanel {
    protected JTable table;
    protected Object data = null;
    protected boolean readOnly;
    private static final long serialVersionUID = 5090824457178059649L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public PropertyEditorPane() {
        this(false);
    }

    public PropertyEditorPane(boolean readOnly) {
        this.setLayout(new BorderLayout());
        this.table = new JTable(new PETableModel(new ArrayList(), readOnly));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.add(scrollPane);
        this.readOnly = readOnly;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public void clearData() {
        PETableModel model = (PETableModel)this.table.getModel();
        model.clear();
        System.out.println("cleared the model");
    }

    public void setData(Object data) throws Exception {
        ArrayList<Object[]> rowData = new ArrayList<Object[]>();
        Field[] fields = data.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            block14: {
                Class<?> type;
                Object[] row;
                block13: {
                    row = new Object[2];
                    row[0] = fields[i].getName();
                    type = fields[i].getType();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (type == clazz || type == Integer.TYPE) break block13;
                    Class<?> clazz2 = class$2;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("[C");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (type != clazz2 && type != Boolean.TYPE) break block14;
                }
                String accessorName = PropertyEditorPane.getAccessorName(fields[i].getName(), type == Boolean.TYPE);
                try {
                    Method m = data.getClass().getMethod(accessorName, new Class[0]);
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("[C");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    row[1] = type == clazz ? new String((char[])m.invoke(data, new Object[0])) : m.invoke(data, new Object[0]);
                    rowData.add(row);
                }
                catch (NoSuchMethodException nsme) {
                    System.out.println(String.valueOf(accessorName) + " is not found!");
                }
            }
            ++i;
        }
        PETableModel model = new PETableModel(rowData, this.readOnly);
        this.table.setModel(model);
        this.data = data;
    }

    public static String getAccessorName(String fieldName, boolean isBoolean) {
        StringBuffer buf = new StringBuffer();
        if (isBoolean) {
            buf.append("is");
        } else {
            buf.append("get");
        }
        buf.append(Character.toUpperCase(fieldName.charAt(0)));
        buf.append(fieldName.substring(1));
        return buf.toString();
    }

    public static String getMutatorName(String fieldName) {
        StringBuffer buf = new StringBuffer();
        buf.append("set");
        buf.append(Character.toUpperCase(fieldName.charAt(0)));
        buf.append(fieldName.substring(1));
        return buf.toString();
    }

    public Field getField(Class clazz, String fieldName) {
        block9: {
            Field field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                if (field != null) {
                    return field;
                }
            }
            catch (NoSuchFieldException nse) {
                Class superClazz = clazz.getSuperclass();
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (superClazz == clazz2) break block9;
                try {
                    return superClazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static class PETableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Attribute", "Value"};
        List rowData;
        boolean readOnly;
        private static final long serialVersionUID = 847412082482313665L;

        public PETableModel(List data, boolean readOnly) {
            this.rowData = data;
            this.readOnly = readOnly;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return this.rowData.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (this.rowData.size() > row) {
                return ((Object[])this.rowData.get(row))[col];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            if (this.readOnly) {
                return false;
            }
            return col > 0;
        }

        public void setValueAt(Object value, int row, int col) {
            Object[] r = null;
            if (row == this.rowData.size()) {
                r = new Object[this.columnNames.length];
                this.rowData.add(r);
            } else if (row < this.rowData.size()) {
                r = (Object[])this.rowData.get(row);
            }
            r[col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void clear() {
            int size = this.rowData.size();
            this.rowData.clear();
            if (size > 0) {
                this.fireTableRowsDeleted(0, size - 1);
            }
        }
    }
}

