/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.net.URI;

public class MetaDataTest {
    GeneralAccount account = null;
    GeneralFileSystem fileSystem = null;
    GeneralFile file = null;
    MetaDataRecordList[] rl = null;

    public MetaDataTest() throws Throwable {
        this(new String[0]);
    }

    public MetaDataTest(GeneralFile generalFile) throws Throwable {
        if (generalFile != null) {
            this.file = generalFile;
            this.fileSystem = generalFile.getFileSystem();
            this.run();
        } else {
            String[] stringArray = new String[]{generalFile.toString()};
            new MetaDataTest(stringArray);
        }
    }

    public MetaDataTest(String[] stringArray) throws Throwable {
        System.out.println("\n Connect to the fileSystem.");
        if (stringArray == null || stringArray.length == 0) {
            this.fileSystem = FileFactory.newFileSystem(new SRBAccount());
            String string = "myJARGONMetaDataTestFile";
            this.file = FileFactory.newFile(this.fileSystem, string);
        } else if (stringArray.length == 1) {
            this.file = FileFactory.newFile(new URI(stringArray[0]));
            this.fileSystem = this.file.getFileSystem();
        } else {
            throw new IllegalArgumentException("Wrong number of arguments sent to Test.");
        }
        this.run();
    }

    private void run() throws Throwable {
        this.file.createNewFile();
        String[] stringArray = new String[]{"sysadmin", "staff", "public"};
        System.out.println("\n Query the file system for all files matching certain query conditions");
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("file size", 2, 5000), MetaDataSet.newCondition("directory name", 0, this.file.getParent())};
        String[] stringArray2 = new String[]{"file name", "File Comments", "file size", "user name"};
        MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray2);
        int n = 2;
        this.rl = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Get further results from the query.");
        if (this.rl != null) {
            this.rl = !this.rl[this.rl.length - 1].isQueryComplete() ? this.rl[this.rl.length - 1].getMoreResults() : null;
        }
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Change the metadata of a file.");
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = FileFactory.newMetaDataRecordList(this.fileSystem, MetaDataSet.getField("file size"), 123);
        this.rl[0].addRecord(MetaDataSet.getField("File Comments"), "new comments go here.");
        System.out.println("\n Query a single file/directory.");
        this.rl = this.file.getParentFile().query(stringArray2);
        MetaDataTest.printQueryResults(this.rl);
        System.out.println("\n Set the definable metadata.");
        String[][] stringArray3 = new String[2][2];
        stringArray3[0][0] = "a";
        stringArray3[0][1] = "1";
        stringArray3[1][0] = "b";
        stringArray3[1][1] = "2";
        int[] nArray = new int[stringArray3.length];
        nArray[0] = 0;
        nArray[1] = 4;
        MetaDataTable metaDataTable = null;
        if (this.fileSystem instanceof SRBFileSystem) {
            metaDataTable = new MetaDataTable(nArray, stringArray3);
            this.rl = new MetaDataRecordList[1];
            this.rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("definable metadata for files"), metaDataTable);
            this.rl[0].addRecord(SRBMetaDataSet.getField("File Comments"), "Hi.");
            this.file.modifyMetaData(this.rl[0]);
            this.rl = this.file.getParentFile().query(metaDataSelectArray);
            MetaDataTest.printQueryResults(this.rl);
        }
        System.out.println("\n Using the user definable metadata.");
        if (this.fileSystem instanceof SRBFileSystem) {
            metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("definable metadata for files", metaDataTable)};
            metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("definable metadata for files")};
            this.rl = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
            MetaDataTest.printQueryResults(this.rl);
        }
    }

    public static void printQueryResults(MetaDataRecordList[] metaDataRecordListArray) {
        if (metaDataRecordListArray != null) {
            System.out.print("\n");
            for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                System.out.print("\n" + metaDataRecordListArray[i]);
            }
        }
        System.out.println("\n");
    }

    public static void main(String[] stringArray) {
        try {
            MetaDataTest metaDataTest = new MetaDataTest(stringArray);
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

