/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.irods.IRODSAccount;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBContainer;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;

public class Test {
    public static String TEST_DIR = "myJargonTestDir";
    public static String TEST_FILE = "myJargonTestFile";
    public static String LOCAL_TEST_FILE = "myLocalJargonFile";
    public static String INITIAL_FILE = "myInitialJargonFile";

    public static void main(String[] stringArray) {
        GeneralFile[] generalFileArray;
        String[] stringArray2;
        Object var1_1 = null;
        GeneralFileSystem generalFileSystem = null;
        LocalFile localFile = null;
        GeneralFile generalFile = null;
        SRBContainer sRBContainer = null;
        GeneralRandomAccessFile generalRandomAccessFile = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            System.out.println("\n Connect to the remote server.");
            if (stringArray.length >= 1) {
                if (stringArray[0].equals("-copy")) {
                    bl = true;
                }
                if (stringArray[0].equals("-fullTest")) {
                    bl = true;
                    bl2 = true;
                }
            }
            GeneralAccount[] generalAccountArray = new GeneralAccount[3];
            try {
                generalAccountArray[0] = new IRODSAccount();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.print("No ~/.irods/.irodsEnv account file, cannot test iRODS");
            }
            try {
                generalAccountArray[1] = new SRBAccount();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.print("No ~/.srb/.MdasEnv account file, cannot test SRB");
            }
            generalAccountArray[2] = FileFactory.newFileSystem(new URI("http://www.yahoo.com")).getAccount();
            Test.copy(FileFactory.newFile(new URI("ftp://ftp.gnu.org/welcome.msg")), new LocalFile(Test.fakeName(LOCAL_TEST_FILE)));
            for (int i = 0; i < generalAccountArray.length; ++i) {
                String string;
                block43: {
                    String[] stringArray3;
                    int n2;
                    block42: {
                        if (generalAccountArray[i] == null) continue;
                        generalFileSystem = FileFactory.newFileSystem(generalAccountArray[i]);
                        if (generalFileSystem instanceof SRBFileSystem) {
                            System.out.println("\n Make a new container in your SRB called mySRBJargonTestContainer.");
                            sRBContainer = new SRBContainer((SRBFileSystem)generalFileSystem, Test.fakeName("mySRBJargonTestContainer"));
                            sRBContainer.createNewFile();
                        }
                        System.out.println("\n Make a new collection in your remote server home called " + TEST_DIR);
                        generalFile = FileFactory.newFile(generalFileSystem, TEST_DIR);
                        String string2 = "" + generalFile.mkdir();
                        System.out.println(string2);
                        System.out.println("\n Put an example local file in the new collection as " + TEST_FILE);
                        localFile = new LocalFile(Test.fakeName(INITIAL_FILE));
                        if (!localFile.exists()) {
                            stringArray2 = new LocalRandomAccessFile(localFile, "rw");
                            stringArray2.write(new String("This file is used to test the Jargon API. It is ok to delete.").getBytes());
                            stringArray2.close();
                        }
                        generalFile = FileFactory.newFile(generalFile, Test.fakeName(TEST_FILE));
                        generalFile.copyFrom(localFile, true);
                        localFile.delete();
                        System.out.println(generalFile.toString());
                        System.out.println("\n Random access read and write to the file\n" + generalFile);
                        try {
                            generalRandomAccessFile = generalFile.canWrite() ? FileFactory.newRandomAccessFile(generalFile, "rw") : FileFactory.newRandomAccessFile(generalFile, "r");
                            stringArray2 = (String[])new byte[1000];
                            n2 = generalRandomAccessFile.read((byte[])stringArray2);
                            string = new String((byte[])stringArray2, 0, n2);
                            int n3 = string.indexOf("It is ok to delete.");
                            if (n3 >= 0) {
                                generalRandomAccessFile.seek(n3);
                            }
                            if (generalFile.canWrite()) {
                                // empty if block
                            }
                            generalRandomAccessFile.close();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            if (System.getProperty("jargon.debug").equals(0)) break block42;
                            unsupportedOperationException.printStackTrace();
                        }
                    }
                    System.out.println("\n List the contents of the new collection:");
                    stringArray2 = generalFile.list();
                    if (stringArray2 != null) {
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            System.out.println(stringArray2[n2]);
                        }
                    }
                    System.out.println("\n List the contents of the new container:");
                    if (generalFileSystem instanceof SRBFileSystem && (stringArray3 = sRBContainer.list()) != null) {
                        for (int j = 0; j < stringArray3.length; ++j) {
                            System.out.println(stringArray3[j]);
                        }
                    }
                    System.out.println("\n Replicate " + generalFile);
                    if (generalFileSystem instanceof SRBFileSystem) {
                        ((RemoteFile)generalFile).replicate(((RemoteFile)generalFile).getResource());
                    }
                    System.out.println("\n Add read/write permissions to the file for \"testuser\".");
                    if (generalFileSystem instanceof SRBFileSystem) {
                        String string3 = "rw";
                        String string4 = "testuser";
                        String string5 = "sdsc";
                        ((SRBFile)generalFile).changePermissions(string3, string4, string5);
                        MetaDataTest.printQueryResults(((SRBFile)generalFile).getPermissions(true));
                    }
                    System.out.println("\n Copy " + generalFile + " to another" + TEST_FILE);
                    if (generalFile.canWrite()) {
                        generalFile.copyTo(FileFactory.newFile(generalFileSystem, TEST_DIR, Test.fakeName(TEST_FILE)), true);
                    }
                    System.out.println("\n Rename " + generalFile + " to new" + TEST_FILE);
                    if (generalFile.canWrite()) {
                        generalFile.renameTo(FileFactory.newFile(generalFileSystem, TEST_DIR, Test.fakeName(TEST_FILE)));
                    }
                    System.out.println("\n Get myJargonTestDir from the remote server and\n put it in the current local directory as " + LOCAL_TEST_FILE);
                    generalFile = FileFactory.newFile(generalFileSystem, TEST_DIR);
                    localFile = new LocalFile(Test.fakeName(LOCAL_TEST_FILE));
                    generalFile.copyTo(localFile);
                    System.out.println("\n Execute the 'hello' proxy command on the SRB.");
                    if (generalFileSystem instanceof SRBFileSystem) {
                        InputStream inputStream = ((SRBFileSystem)generalFileSystem).executeProxyCommand("hello", null);
                        int n4 = inputStream.read();
                        while (n4 != -1) {
                            System.out.print((char)n4);
                            n4 = inputStream.read();
                        }
                    }
                    System.out.println("\n Link a HTML page to act as if it were a SRBFile.");
                    System.out.println("\n Run the MetaDataTest");
                    try {
                        new MetaDataTest(FileFactory.newFile(generalFileSystem, TEST_DIR, Test.fakeName(TEST_FILE)));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        String string6 = System.getProperty("jargon.debug");
                        if (string6 == null || string6.equals("0")) break block43;
                        unsupportedOperationException.printStackTrace();
                    }
                }
                System.out.println("\n Run the CopyTest ");
                if (bl) {
                    localFile = new LocalFile(localFile, "5017_files");
                    CopyTest copyTest = new CopyTest(localFile, FileFactory.newFile(generalFileSystem, TEST_DIR, "Copy" + TEST_DIR));
                    copyTest.copy();
                    try {
                        copyTest.compare();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        n = 1;
                    }
                }
                System.out.println("\n Run the full test");
                if (bl2) {
                    MoreTests moreTests = new MoreTests(generalFile);
                    moreTests.run();
                }
                System.out.println("\n Remove the files created by this program from the remote server.");
                generalFileArray = FileFactory.newFile(generalFileSystem, TEST_DIR).listFiles();
                if (generalFileArray != null) {
                    for (int j = 0; j < generalFileArray.length; ++j) {
                        if (!generalFileArray.toString().startsWith("my")) continue;
                        generalFileArray[j].delete();
                    }
                }
                System.out.println("\n Remove " + TEST_DIR + " from the remote server.");
                string = generalFileSystem.getHomeDirectory() + generalFile.getPathSeparator() + TEST_DIR;
                generalFile = FileFactory.newFile(generalFileSystem, string);
                generalFile.delete();
                System.out.println("\n Remove mySRBJargonTestContainer from the SRB.");
                if (sRBContainer != null) {
                    sRBContainer.delete();
                    sRBContainer = null;
                }
                System.out.println("\n Exit.");
                generalFileSystem = null;
            }
        }
        catch (SRBException sRBException) {
            System.out.println("\n Handling an error.");
            int n5 = sRBException.getType();
            System.out.println("Standardized SRB Server Error Type: " + n5);
            stringArray2 = sRBException.getStandardMessage();
            System.out.println("Standardized SRB Server Error Message: " + (String)stringArray2);
            System.out.println("\nJargon Error Message: " + sRBException.getMessage());
            sRBException.printStackTrace();
            for (generalFileArray = sRBException.getCause(); generalFileArray != null; generalFileArray = generalFileArray.getCause()) {
                generalFileArray.printStackTrace();
            }
            n = n5;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                throwable2.printStackTrace();
            }
            n = 1;
        }
        try {
            if (generalFile == null && generalFileSystem != null) {
                generalFile = FileFactory.newFile(generalFileSystem, "asdf");
                System.out.println("\nSocket Exception test, file.length=" + generalFile.length());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            for (Throwable throwable3 = throwable.getCause(); throwable3 != null; throwable3 = throwable3.getCause()) {
                throwable3.printStackTrace();
            }
            n = 1;
        }
        System.exit(n);
    }

    static void copy(GeneralFile generalFile, GeneralFile generalFile2) throws IOException {
        if (generalFile.isDirectory()) {
            System.out.println("Copying directory: " + generalFile + " to: " + generalFile2);
            GeneralFile[] generalFileArray = generalFile.listFiles();
            generalFile2.mkdir();
            if (generalFileArray != null) {
                for (int i = 0; i < generalFileArray.length; ++i) {
                    generalFileArray[i].copyTo(FileFactory.newFile(generalFile2.getFileSystem(), generalFile2.getAbsolutePath(), generalFileArray[i].getName()), true);
                }
            }
        } else {
            System.out.println("Copying file: " + generalFile + " to: " + generalFile2);
            generalFile.copyTo(generalFile2);
        }
    }

    static String fakeName(String string) {
        return string + new Date().getTime();
    }
}

