/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTreeModel;
import edu.sdsc.grid.gui.MetaDataDisplay;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeCellEditor;

public class JargonTreeCellEditor
implements TreeCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private JComponent currentComponent;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.listenerList != null) {
            this.listenerList = null;
        }
        if (this.currentComponent != null) {
            this.currentComponent = null;
        }
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        return this.currentComponent;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        if (object instanceof String) {
            this.currentComponent = object.equals(JargonTreeModel.TOP_LEVEL) ? new JLabel((String)object, JargonTreeModel.FOLDER_ICON, 0) : (bl3 ? new JLabel((String)object, JargonTreeModel.FILE_ICON, 0) : new JLabel((String)object, JargonTreeModel.FOLDER_ICON, 0));
        } else if (object instanceof LocalFile) {
            this.currentComponent = bl3 ? new JLabel(((LocalFile)object).getName(), JargonTreeModel.FILE_ICON, 0) : new JLabel(((LocalFile)object).getName(), JargonTreeModel.FOLDER_ICON, 0);
        } else {
            JargonTreeModel jargonTreeModel = (JargonTreeModel)jTree.getModel();
            GeneralFile generalFile = (GeneralFile)object;
            MetaDataRecordList[] metaDataRecordListArray = new MetaDataRecordList[]{jargonTreeModel.getMetaDataRecordList(generalFile)};
            if (metaDataRecordListArray[0] == null) {
                if (bl3) {
                    if (generalFile instanceof SRBFile) {
                        metaDataRecordListArray[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), generalFile.getName());
                        metaDataRecordListArray[0].addRecord(SRBMetaDataSet.getField("directory name"), generalFile.getParent());
                    }
                } else if (generalFile instanceof SRBFile) {
                    metaDataRecordListArray[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("directory name"), generalFile.getAbsolutePath());
                }
            }
            this.currentComponent = new MetaDataDisplay(generalFile, metaDataRecordListArray[0]);
            JScrollPane jScrollPane = new JScrollPane(this.currentComponent);
            Dimension dimension = this.currentComponent.getPreferredSize();
            dimension.setSize(dimension.width, dimension.height + MetaDataDisplay.fontPixelHeight + 4);
            jScrollPane.setPreferredSize(dimension);
            return jScrollPane;
        }
        return this.currentComponent;
    }
}

