/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JargonTreeModel
implements TreeModel {
    public static String TOP_LEVEL = "DataGrid";
    private Object root;
    private Object[] subRoots;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean showMetaData = false;
    private MetaDataCondition[] conditions;
    private MetaDataSelect[] selects;
    private MetaDataField[] fields;
    private int fieldsLength;
    private Hashtable table = new Hashtable();
    private HashSet nodeSet = new HashSet();
    private HashSet leafSet = new HashSet();
    private Hashtable resultTable = new Hashtable();
    public static Icon FOLDER_ICON = new MetalIconFactory.FolderIcon16();
    public static Icon FILE_ICON = new MetalIconFactory.FileIcon16();

    public JargonTreeModel(GeneralFile generalFile) {
        this.root = generalFile;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    public JargonTreeModel(GeneralFile[] generalFileArray) {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
    }

    public JargonTreeModel(GeneralFile generalFile, MetaDataCondition[] metaDataConditionArray) throws IOException {
        this.root = generalFile;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
        this.conditions = metaDataConditionArray;
    }

    public JargonTreeModel(GeneralFile[] generalFileArray, MetaDataCondition[] metaDataConditionArray) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        this.selects = new MetaDataSelect[2];
        this.selects[0] = MetaDataSet.newSelection("file name");
        this.selects[1] = MetaDataSet.newSelection("directory name");
        this.conditions = metaDataConditionArray;
    }

    public JargonTreeModel(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = generalFile;
        if (metaDataSelectArray == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            this.showMetaData = this.loadFields(generalFile, null, metaDataSelectArray);
        }
    }

    public JargonTreeModel(GeneralFile[] generalFileArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        if (metaDataSelectArray == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            for (int i = 0; i < generalFileArray.length; ++i) {
                this.showMetaData = this.showMetaData || this.loadFields(generalFileArray[i], null, metaDataSelectArray);
            }
        }
    }

    public JargonTreeModel(GeneralFile generalFile, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = generalFile;
        this.conditions = metaDataConditionArray;
        if (metaDataSelectArray == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            this.showMetaData = this.loadFields(generalFile, metaDataConditionArray, metaDataSelectArray);
        }
    }

    public JargonTreeModel(GeneralFile[] generalFileArray, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.root = TOP_LEVEL;
        this.subRoots = generalFileArray;
        this.conditions = metaDataConditionArray;
        if (metaDataSelectArray == null) {
            this.selects = new MetaDataSelect[2];
            this.selects[0] = MetaDataSet.newSelection("file name");
            this.selects[1] = MetaDataSet.newSelection("directory name");
        } else {
            for (int i = 0; i < generalFileArray.length; ++i) {
                this.showMetaData = this.showMetaData || this.loadFields(generalFileArray[i], metaDataConditionArray, metaDataSelectArray);
            }
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeStructureChanged(Object object) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{object});
        EventListener[] eventListenerArray = this.listenerList.getListeners(TreeModelListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((TreeModelListener)eventListenerArray[i]).treeStructureChanged(treeModelEvent);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void setRoot(Object object) {
        Object object2 = this.root;
        if (object != null) {
            if (!(object instanceof GeneralFile)) {
                throw new ClassCastException("Root must be an instance of GeneralFile");
            }
        } else {
            throw new NullPointerException("Root cannot be null");
        }
        this.root = object;
        this.fireTreeStructureChanged(object2);
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object object, int n) {
        System.out.println("index in getChild is " + n);
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                System.out.println("1st if statement = " + this.subRoots[n]);
                return this.subRoots[n];
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray = ((LocalFile)object).list();
            if (stringArray == null || n >= stringArray.length) {
                return null;
            }
            return "asdf";
        }
        System.out.println("testing ");
        String[] stringArray = (String[])this.table.get(object);
        if (stringArray == null) {
            stringArray = ((GeneralFile)object).list(this.conditions);
            this.table.put(object, stringArray);
        }
        System.out.println("reached end of method = " + FileFactory.newFile((GeneralFile)object, stringArray[n]));
        return FileFactory.newFile((GeneralFile)object, stringArray[n]);
    }

    public int getChildCount(Object object) {
        String[] stringArray;
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                return this.subRoots.length;
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray2 = ((LocalFile)object).list();
            if (stringArray2 == null) {
                return 0;
            }
            return stringArray2.length;
        }
        if ((stringArray = (String[])this.table.get(object)) == null) {
            this.store(object);
            stringArray = ((GeneralFile)object).list(this.conditions);
            if (stringArray != null) {
                this.table.put(object, stringArray);
            }
        }
        if (stringArray != null) {
            System.out.println("list is " + stringArray.length);
            return stringArray.length;
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                int n;
                for (n = 0; n < this.subRoots.length; ++n) {
                    if (!object2.equals(this.subRoots[n])) continue;
                    return n;
                }
                for (n = 0; n < this.subRoots.length; ++n) {
                    if (!this.subRoots[n].getClass().equals(object2.getClass())) continue;
                    object = this.subRoots[n];
                }
            }
        } else if (object instanceof LocalFile) {
            String[] stringArray = ((LocalFile)object).list();
            if (stringArray == null) {
                return -1;
            }
            String string = ((LocalFile)object2).getName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return i;
            }
            return -1;
        }
        String string = ((GeneralFile)object2).getName();
        String[] stringArray = (String[])this.table.get(object);
        if (stringArray == null) {
            stringArray = ((GeneralFile)object).list(this.conditions);
            this.table.put(object, stringArray);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            System.out.println(" i is " + i);
            return i;
        }
        return -1;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof String) {
            if (object.equals(TOP_LEVEL)) {
                return false;
            }
        } else if (object instanceof LocalFile) {
            return ((LocalFile)object).isFile();
        }
        if (this.leafSet.contains(object)) {
            return true;
        }
        if (this.nodeSet.contains(object)) {
            return false;
        }
        if (object instanceof GeneralFile) {
            GeneralFile generalFile = (GeneralFile)object;
            if (generalFile.isDirectory()) {
                this.nodeSet.add(object);
                return false;
            }
            this.leafSet.add(object);
            return true;
        }
        return true;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("valueForPathChanged : " + treePath + " --> " + object);
    }

    private void store(Object object) {
        if (object instanceof SRBFile) {
            GeneralFileSystem generalFileSystem = ((GeneralFile)object).getFileSystem();
            GeneralFile generalFile = null;
            String string = ((GeneralFile)object).getAbsolutePath();
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataRecordList[] metaDataRecordListArray2 = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, string)};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                int n;
                metaDataConditionArray = MetaDataSet.mergeConditions(this.conditions, metaDataConditionArray);
                metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, this.selects);
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
                if (metaDataRecordListArray != null) {
                    for (n = 0; n < metaDataRecordListArray.length; ++n) {
                        generalFile = FileFactory.newFile(generalFileSystem, metaDataRecordListArray[n].getValue("directory name").toString(), metaDataRecordListArray[n].getValue("file name").toString());
                        this.leafSet.add(generalFile);
                        if (!this.showMetaData) continue;
                        this.resultTable.put(generalFile, metaDataRecordListArray[n]);
                    }
                }
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("parent directory name", 0, string)};
                metaDataRecordListArray2 = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray);
                if ((metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2)) != null) {
                    for (n = 0; n < metaDataRecordListArray2.length; ++n) {
                        generalFile = FileFactory.newFile(generalFileSystem, metaDataRecordListArray2[n].getValue("directory name").toString());
                        this.nodeSet.add(generalFile);
                        if (!this.showMetaData) continue;
                        this.resultTable.put(generalFile, metaDataRecordListArray2[n]);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private boolean loadFields(GeneralFile generalFile, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        if (generalFile instanceof LocalFile) {
            return false;
        }
        GeneralFileSystem generalFileSystem = generalFile.getFileSystem();
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataSelect[] metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        metaDataSelectArray = MetaDataSet.mergeSelects(metaDataSelectArray, metaDataSelectArray2);
        if ((metaDataSelectArray = (MetaDataSelect[])JargonTreeModel.cleanNulls(metaDataSelectArray)) == null) {
            throw new NullPointerException("No valid Selects");
        }
        this.selects = metaDataSelectArray;
        if (metaDataConditionArray == null) {
            metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("file size", 0, "0")};
            metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray, 1);
            if (metaDataRecordListArray == null) {
                metaDataConditionArray[0] = MetaDataSet.newCondition("file size", 1, "0");
                metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray, 1);
            }
        } else {
            metaDataRecordListArray = generalFileSystem.query(metaDataConditionArray, metaDataSelectArray, 1);
        }
        if (metaDataRecordListArray != null) {
            int n = metaDataRecordListArray[0].getFieldCount();
            this.fields = new MetaDataField[n];
            for (int i = 0; i < n; ++i) {
                this.fields[i] = metaDataRecordListArray[0].getField(i);
            }
            this.fieldsLength = this.fields.length;
            return true;
        }
        return false;
    }

    JTable getMetaData(GeneralFile generalFile) {
        GeneralFile generalFile2 = generalFile;
        MetaDataRecordList metaDataRecordList = (MetaDataRecordList)this.resultTable.get(generalFile2);
        if (metaDataRecordList == null) {
            return null;
        }
        int n = metaDataRecordList.getFieldCount();
        Object[][] objectArray = new Object[1][n];
        Object[] objectArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = metaDataRecordList.getFieldName(i);
            objectArray[0][i] = metaDataRecordList.getValue(i);
        }
        return new JTable(objectArray, objectArray2);
    }

    public MetaDataRecordList getMetaDataRecordList(Object object) {
        return (MetaDataRecordList)this.resultTable.get(object);
    }

    public boolean showMetaData() {
        return this.showMetaData;
    }

    static final Object[] cleanNulls(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            for (n2 = n + 1; n2 < objectArray.length; ++n2) {
                if (!objectArray[n].equals(objectArray[n2])) continue;
                bl = false;
                n2 = objectArray.length;
            }
            if (bl) {
                vector.add(objectArray[n]);
            }
            bl = true;
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            return vector.toArray((Object[])Array.newInstance(objectArray[n].getClass(), 0));
        }
        return null;
    }
}

