/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Host;

public final class BinaryDataFormat {
    private byte shortSize = 0;
    private byte intSize = 0;
    private byte longSize = 0;
    private byte longLongSize = 0;
    private byte floatSize = 0;
    private byte doubleSize = 0;
    private byte longDoubleSize = 0;
    private boolean isMBF = true;
    private boolean sameByteOrder = true;
    private boolean sameShortSize = true;
    private boolean sameIntSize = true;
    private boolean sameLongSize = true;
    private boolean sameLongLongSize = true;
    private boolean sameFloatSize = true;
    private boolean sameDoubleSize = true;
    private boolean sameLongDoubleSize = true;

    public BinaryDataFormat() {
        this.isMBF = Host.isMBFByteOrder();
        this.sameByteOrder = true;
        this.shortSize = Host.getStorageSize(1);
        this.intSize = Host.getStorageSize(2);
        this.longSize = Host.getStorageSize(3);
        this.longLongSize = Host.getStorageSize(4);
        this.floatSize = Host.getStorageSize(5);
        this.doubleSize = Host.getStorageSize(6);
        this.longDoubleSize = Host.getStorageSize(7);
        this.sameShortSize = true;
        this.sameIntSize = true;
        this.sameLongSize = true;
        this.sameLongLongSize = true;
        this.sameFloatSize = true;
        this.sameDoubleSize = true;
        this.sameLongDoubleSize = true;
    }

    public BinaryDataFormat(BinaryDataFormat binaryDataFormat) throws NullPointerException {
        if (binaryDataFormat == null) {
            throw new NullPointerException();
        }
        this.isMBF = binaryDataFormat.isMBF;
        this.shortSize = binaryDataFormat.shortSize;
        this.intSize = binaryDataFormat.intSize;
        this.longSize = binaryDataFormat.longSize;
        this.longLongSize = binaryDataFormat.longLongSize;
        this.floatSize = binaryDataFormat.floatSize;
        this.doubleSize = binaryDataFormat.doubleSize;
        this.longDoubleSize = binaryDataFormat.longDoubleSize;
        this.sameByteOrder = Host.isMBFByteOrder() == this.isMBF;
        this.sameShortSize = Host.getStorageSize(1) == this.shortSize;
        this.sameIntSize = Host.getStorageSize(2) == this.intSize;
        this.sameLongSize = Host.getStorageSize(3) == this.longSize;
        this.sameLongLongSize = Host.getStorageSize(4) == this.longLongSize;
        this.sameFloatSize = Host.getStorageSize(5) == this.floatSize;
        this.sameDoubleSize = Host.getStorageSize(6) == this.doubleSize;
        this.sameLongDoubleSize = Host.getStorageSize(7) == this.longDoubleSize;
    }

    public final void finalize() {
    }

    public final boolean equals(BinaryDataFormat binaryDataFormat) {
        if (this.isMBF != binaryDataFormat.isMBF) {
            return false;
        }
        if (this.shortSize != binaryDataFormat.shortSize) {
            return false;
        }
        if (this.intSize != binaryDataFormat.intSize) {
            return false;
        }
        if (this.longSize != binaryDataFormat.longSize) {
            return false;
        }
        if (this.longLongSize != binaryDataFormat.longLongSize) {
            return false;
        }
        if (this.floatSize != binaryDataFormat.floatSize) {
            return false;
        }
        if (this.doubleSize != binaryDataFormat.doubleSize) {
            return false;
        }
        return this.longDoubleSize == binaryDataFormat.longDoubleSize;
    }

    public final boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BinaryDataFormat binaryDataFormat = (BinaryDataFormat)object;
        return this.equals(binaryDataFormat);
    }

    public final void setMBFByteOrder() {
        this.isMBF = true;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final void setLBFByteOrder() {
        this.isMBF = false;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final boolean isMBFByteOrder() {
        return this.isMBF;
    }

    public final boolean isLBFByteOrder() {
        return !this.isMBF;
    }

    public final void setShortSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.shortSize = (byte)n;
        this.sameShortSize = n == Host.getStorageSize(1);
    }

    public final void setIntSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.intSize = (byte)n;
        this.sameIntSize = n == Host.getStorageSize(2);
    }

    public final void setLongSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.longSize = (byte)n;
        this.sameLongSize = n == Host.getStorageSize(3);
    }

    public final void setLongLongSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.longLongSize = (byte)n;
        this.sameLongLongSize = n == Host.getStorageSize(4);
    }

    public final void setFloatSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.floatSize = (byte)n;
        this.sameFloatSize = n == Host.getStorageSize(5);
    }

    public final void setDoubleSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.doubleSize = (byte)n;
        this.sameDoubleSize = n == Host.getStorageSize(6);
    }

    public final void setLongDoubleSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.longDoubleSize = (byte)n;
        this.sameLongDoubleSize = n == Host.getStorageSize(7);
    }

    public final int getShortSize() {
        return this.shortSize;
    }

    public final int getIntSize() {
        return this.intSize;
    }

    public final int getLongSize() {
        return this.longSize;
    }

    public final int getLongLongSize() {
        return this.longLongSize;
    }

    public final int getFloatSize() {
        return this.floatSize;
    }

    public final int getDoubleSize() {
        return this.doubleSize;
    }

    public final int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    public final short shortValue(byte[] byArray) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return Host.castToShort(byArray);
        }
        int n = this.shortSize;
        short s = 0;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                s = -1;
            }
            for (int i = 0; i < n; ++i) {
                s = (short)(s << 8 | byArray[i] & 0xFF);
            }
            return s;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            s = -1;
        }
        for (int i = n - 1; i >= 0; --i) {
            s = (short)(s << 8 | byArray[i] & 0xFF);
        }
        return s;
    }

    public final int unsignedShortValue(byte[] byArray) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return Host.castToShort(byArray);
        }
        int n = this.shortSize;
        int n2 = 0;
        if (this.isMBF) {
            for (int i = 0; i < n; ++i) {
                n2 = n2 << 8 | byArray[i] & 0xFF;
            }
            return n2 &= ~(-1 << Host.getSignificantBits(1));
        }
        for (int i = n - 1; i >= 0; --i) {
            n2 = n2 << 8 | byArray[i] & 0xFF;
        }
        return n2 &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] byArray) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return Host.castToInt(byArray);
        }
        int n = this.intSize;
        int n2 = 0;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                n2 = -1;
            }
            for (int i = 0; i < n; ++i) {
                n2 = n2 << 8 | byArray[i] & 0xFF;
            }
            return n2;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            n2 = -1;
        }
        for (int i = n - 1; i >= 0; --i) {
            n2 = n2 << 8 | byArray[i] & 0xFF;
        }
        return n2;
    }

    public final long unsignedIntValue(byte[] byArray) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return Host.castToInt(byArray);
        }
        int n = this.intSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        for (int i = n - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] byArray) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return Host.castToLong(byArray);
        }
        int n = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        for (int i = n - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public final long unsignedLongValue(byte[] byArray) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return Host.castToLong(byArray);
        }
        int n = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        for (int i = n - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public final long longLongValue(byte[] byArray) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return Host.castToLongLong(byArray);
        }
        int n = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        for (int i = n - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public final long unsignedLongLongValue(byte[] byArray) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return Host.castToLongLong(byArray);
        }
        int n = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        for (int i = n - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public final float floatValue(byte[] byArray) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return Host.castToFloat(byArray);
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return (float)Host.castToDouble(byArray);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return (float)Host.castToLongDouble(byArray);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] byArray) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.doubleSize);
            }
            return Host.castToDouble(byArray);
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToFloat(byArray);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToLongDouble(byArray);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] byArray) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longDoubleSize);
            }
            return Host.castToLongDouble(byArray);
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToFloat(byArray);
        }
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToDouble(byArray);
        }
        return 0.0;
    }

    public final short shortValue(byte[] byArray, int n) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return Host.castToShort(byArray, n);
        }
        int n2 = this.shortSize;
        short s = 0;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                s = -1;
            }
            for (int i = 0; i < n2; ++i) {
                s = (short)(s << 8 | byArray[n + i] & 0xFF);
            }
            return s;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            s = -1;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            s = (short)(s << 8 | byArray[n + i] & 0xFF);
        }
        return s;
    }

    public final int unsignedShortValue(byte[] byArray, int n) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return Host.castToShort(byArray, n);
        }
        int n2 = this.shortSize;
        int n3 = 0;
        if (this.isMBF) {
            for (int i = 0; i < n2; ++i) {
                n3 = n3 << 8 | byArray[n + i] & 0xFF;
            }
            return n3 &= ~(-1 << Host.getSignificantBits(1));
        }
        for (int i = n2 - 1; i >= 0; --i) {
            n3 = n3 << 8 | byArray[n + i] & 0xFF;
        }
        return n3 &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] byArray, int n) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return Host.castToInt(byArray, n);
        }
        int n2 = this.intSize;
        int n3 = 0;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                n3 = -1;
            }
            for (int i = 0; i < n2; ++i) {
                n3 = n3 << 8 | byArray[n + i] & 0xFF;
            }
            return n3;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            n3 = -1;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            n3 = n3 << 8 | byArray[n + i] & 0xFF;
        }
        return n3;
    }

    public final long unsignedIntValue(byte[] byArray, int n) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return Host.castToInt(byArray, n);
        }
        int n2 = this.intSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n2; ++i) {
                l = l << 8 | (long)byArray[n + i] & 0xFFL;
            }
            return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[n + i] & 0xFFL;
        }
        return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] byArray, int n) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return Host.castToLong(byArray, n);
        }
        int n2 = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            for (int i = 0; i < n2; ++i) {
                l = l << 8 | (long)byArray[n + i] & 0xFFL;
            }
            return l;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[n + i] & 0xFFL;
        }
        return l;
    }

    public final long unsignedLongValue(byte[] byArray, int n) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return Host.castToLong(byArray, n);
        }
        int n2 = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n2; ++i) {
                l = l << 8 | (long)byArray[n + i] & 0xFFL;
            }
            return l;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[n + i] & 0xFFL;
        }
        return l;
    }

    public final long longLongValue(byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return Host.castToLongLong(byArray, n);
        }
        int n2 = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            for (int i = 0; i < n2; ++i) {
                l = l << 8 | (long)byArray[n + i] & 0xFFL;
            }
            return l;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[n + i] & 0xFFL;
        }
        return l;
    }

    public final long unsignedLongLongValue(byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return Host.castToLongLong(byArray, n);
        }
        int n2 = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            for (int i = 0; i < n2; ++i) {
                l = l << 8 | (long)byArray[n + i] & 0xFFL;
            }
            return l;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            l = l << 8 | (long)byArray[n + i] & 0xFFL;
        }
        return l;
    }

    public final float floatValue(byte[] byArray, int n) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return Host.castToFloat(byArray, n);
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return (float)Host.castToDouble(byArray, n);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return (float)Host.castToLongDouble(byArray, n);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] byArray, int n) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.doubleSize);
            }
            return Host.castToDouble(byArray, n);
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToFloat(byArray, n);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToLongDouble(byArray, n);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] byArray, int n) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longDoubleSize);
            }
            return Host.castToLongDouble(byArray, n);
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToFloat(byArray, n);
        }
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToDouble(byArray, n);
        }
        return 0.0;
    }

    public final void shortValues(byte[] byArray, short[] sArray, int n) {
        byte by = this.shortSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            sArray[i] = this.shortValue(byArray, n2);
            n2 += by;
        }
    }

    public final void unsignedShortValues(byte[] byArray, short[] sArray, int n) {
        byte by = this.shortSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            sArray[i] = (short)this.unsignedShortValue(byArray, n2);
            n2 += by;
        }
    }

    public final void intValues(byte[] byArray, int[] nArray, int n) {
        byte by = this.intSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            nArray[i] = this.intValue(byArray, n2);
            n2 += by;
        }
    }

    public final void unsignedIntValues(byte[] byArray, int[] nArray, int n) {
        byte by = this.intSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            nArray[i] = (int)this.unsignedIntValue(byArray, n2);
            n2 += by;
        }
    }

    public final void longValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            lArray[i] = this.longValue(byArray, n2);
            n2 += by;
        }
    }

    public final void unsignedLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            lArray[i] = this.unsignedLongValue(byArray, n2);
            n2 += by;
        }
    }

    public final void longLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longLongSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            lArray[i] = this.longLongValue(byArray, n2);
            n2 += by;
        }
    }

    public final void unsignedLongLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longLongSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            lArray[i] = this.unsignedLongLongValue(byArray, n2);
            n2 += by;
        }
    }

    public final void floatValues(byte[] byArray, float[] fArray, int n) {
        byte by = this.floatSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            fArray[i] = this.floatValue(byArray, n2);
            n2 += by;
        }
    }

    public final void doubleValues(byte[] byArray, double[] dArray, int n) {
        byte by = this.doubleSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            dArray[i] = this.doubleValue(byArray, n2);
            n2 += by;
        }
    }

    public final void longDoubleValues(byte[] byArray, double[] dArray, int n) {
        byte by = this.longDoubleSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            dArray[i] = this.longDoubleValue(byArray, n2);
            n2 += by;
        }
    }

    public final int encodeShort(short s, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyShort(s, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n = this.shortSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)s;
                s = (short)(s >> 8);
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)s;
            s = (short)(s >> 8);
        }
        return n;
    }

    public final int encodeShort(int n, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyShort(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = (byte)s;
                s = (short)(s >> 8);
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)s;
            s = (short)(s >> 8);
        }
        return n2;
    }

    public final int encodeUnsignedShort(short s, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(s, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n = this.shortSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)s;
                s = (short)(s >>> 8);
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)s;
            s = (short)(s >>> 8);
        }
        return n;
    }

    public final int encodeUnsignedShort(int n, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = (byte)s;
                s = (short)(s >>> 8);
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)s;
            s = (short)(s >>> 8);
        }
        return n2;
    }

    public final int encodeInt(int n, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyInt(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = (byte)n;
                n >>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)n;
            n >>= 8;
        }
        return n2;
    }

    public final int encodeUnsignedInt(int n, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = (byte)n;
                n >>>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)n;
            n >>>= 8;
        }
        return n2;
    }

    public final int encodeUnsignedInt(long l, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt((int)l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n = this.intSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>>= 8;
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        return n;
    }

    public final int encodeLong(long l, byte[] byArray) {
        if (this.sameLongSize) {
            Host.copyLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return this.longSize;
        }
        int n = this.longSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>= 8;
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return n;
    }

    public final int encodeUnsignedLong(long l, byte[] byArray) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return this.longSize;
        }
        int n = this.longSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>>= 8;
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        return n;
    }

    public final int encodeLongLong(long l, byte[] byArray) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n = this.longLongSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>= 8;
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return n;
    }

    public final int encodeUnsignedLongLong(long l, byte[] byArray) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n = this.longLongSize;
        if (this.isMBF) {
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>>= 8;
            }
            return n;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)l;
            l >>>= 8;
        }
        return n;
    }

    public final int encodeFloat(float f, byte[] byArray) {
        if (this.sameFloatSize) {
            Host.copyFloat(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeFloat(double d, byte[] byArray) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeDouble(double d, byte[] byArray) {
        if (this.sameDoubleSize) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeLongDouble(double d, byte[] byArray) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeShort(short s, byte[] byArray, int n) {
        if (this.sameShortSize) {
            Host.copyShort(s, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)s;
                s = (short)(s >> 8);
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)s;
            s = (short)(s >> 8);
        }
        return n2;
    }

    public final int encodeShort(int n, byte[] byArray, int n2) {
        if (this.sameShortSize) {
            Host.copyShort((short)n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.shortSize);
            }
            return this.shortSize;
        }
        int n3 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            for (int i = n3 - 1; i >= 0; --i) {
                byArray[n2 + i] = (byte)s;
                s = (short)(s >> 8);
            }
            return n3;
        }
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)s;
            s = (short)(s >> 8);
        }
        return n3;
    }

    public final int encodeUnsignedShort(short s, byte[] byArray, int n) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(s, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)s;
                s = (short)(s >>> 8);
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)s;
            s = (short)(s >>> 8);
        }
        return n2;
    }

    public final int encodeUnsignedShort(int n, byte[] byArray, int n2) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort((short)n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.shortSize);
            }
            return this.shortSize;
        }
        int n3 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            for (int i = n3 - 1; i >= 0; --i) {
                byArray[n2 + i] = (byte)s;
                s = (short)(s >>> 8);
            }
            return n3;
        }
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)s;
            s = (short)(s >>> 8);
        }
        return n3;
    }

    public final int encodeInt(int n, byte[] byArray, int n2) {
        if (this.sameIntSize) {
            Host.copyInt(n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.intSize);
            }
            return this.intSize;
        }
        int n3 = this.intSize;
        if (this.isMBF) {
            for (int i = n3 - 1; i >= 0; --i) {
                byArray[n2 + i] = (byte)n;
                n >>= 8;
            }
            return n3;
        }
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)n;
            n >>= 8;
        }
        return n3;
    }

    public final int encodeUnsignedInt(int n, byte[] byArray, int n2) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.intSize);
            }
            return this.intSize;
        }
        int n3 = this.intSize;
        if (this.isMBF) {
            for (int i = n3 - 1; i >= 0; --i) {
                byArray[n2 + i] = (byte)n;
                n >>>= 8;
            }
            return n3;
        }
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = (byte)n;
            n >>>= 8;
        }
        return n3;
    }

    public final int encodeUnsignedInt(long l, byte[] byArray, int n) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        int n3 = (int)l;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)n3;
                n3 >>>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)n3;
            n3 >>>= 8;
        }
        return n2;
    }

    public final int encodeLong(long l, byte[] byArray, int n) {
        if (this.sameLongSize) {
            Host.copyLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return this.longSize;
        }
        int n2 = this.longSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)l;
                l >>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)l;
            l >>= 8;
        }
        return n2;
    }

    public final int encodeUnsignedLong(long l, byte[] byArray, int n) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return this.longSize;
        }
        int n2 = this.longSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)l;
                l >>>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)l;
            l >>>= 8;
        }
        return n2;
    }

    public final int encodeLongLong(long l, byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n2 = this.longLongSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)l;
                l >>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)l;
            l >>= 8;
        }
        return n2;
    }

    public final int encodeUnsignedLongLong(long l, byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n2 = this.longLongSize;
        if (this.isMBF) {
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[n + i] = (byte)l;
                l >>>= 8;
            }
            return n2;
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = (byte)l;
            l >>>= 8;
        }
        return n2;
    }

    public final int encodeFloat(float f, byte[] byArray, int n) {
        if (this.sameFloatSize) {
            Host.copyFloat(f, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeFloat(double d, byte[] byArray, int n) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeDouble(double d, byte[] byArray, int n) {
        if (this.sameDoubleSize) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeLongDouble(double d, byte[] byArray, int n) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeShorts(short[] sArray, int n, byte[] byArray) {
        byte by = this.shortSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeShort(sArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeUnsignedShorts(short[] sArray, int n, byte[] byArray) {
        byte by = this.shortSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeUnsignedShort(sArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeInts(int[] nArray, int n, byte[] byArray) {
        byte by = this.intSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeInt(nArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeUnsignedInts(int[] nArray, int n, byte[] byArray) {
        byte by = this.intSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeUnsignedInt(nArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeLong(lArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeUnsignedLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeUnsignedLong(lArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeLongLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longLongSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeLongLong(lArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeUnsignedLongLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longLongSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeUnsignedLongLong(lArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeFloats(float[] fArray, int n, byte[] byArray) {
        byte by = this.floatSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeFloat(fArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeDoubles(double[] dArray, int n, byte[] byArray) {
        byte by = this.doubleSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeDouble(dArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }

    public final int encodeLongDoubles(double[] dArray, int n, byte[] byArray) {
        byte by = this.longDoubleSize;
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.encodeDouble(dArray[i], byArray, n2);
            n2 += by;
        }
        return n2;
    }
}

