/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataCondition;
import java.lang.reflect.Array;
import java.util.Vector;

public class MetaDataTable {
    private Vector values;
    private Vector operators;

    public MetaDataTable(int[] nArray, String[][] stringArray) {
        if (stringArray == null || nArray == null) {
            throw new NullPointerException("Values and operators cannot be null.");
        }
        if (nArray.length != stringArray.length) {
            throw new IllegalArgumentException("Values and operators must have equal length");
        }
        if (stringArray.length <= 0) {
            throw new IllegalArgumentException("No values were given.");
        }
        this.values = new Vector(stringArray.length);
        this.operators = new Vector(nArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addRow(stringArray[i], nArray[i]);
        }
    }

    public void setStringValue(int n, int n2, String string) {
        Object e = this.values.get(n);
        Array.set(e, n2, string);
        this.values.set(n, e);
    }

    public int[] getOperators() {
        int[] nArray = new int[this.operators.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.operators.get(i);
        }
        return nArray;
    }

    public int getOperator(int n) {
        return (Integer)this.operators.get(n);
    }

    public int getIntValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(string.toString());
    }

    public float getFloatValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return Float.parseFloat(string.toString());
    }

    public String getStringValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public String getStringValue(String string) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.getStringValue(i, 0).equals(string)) continue;
            return this.getStringValue(i, 1);
        }
        return null;
    }

    public String getStringValue(String string, int n) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.getStringValue(i, 0).equals(string)) continue;
            return this.getStringValue(i, n);
        }
        return null;
    }

    public int getRowCount() {
        return this.values.size();
    }

    public int getColumnCount() {
        return ((String[])this.values.get(0)).length;
    }

    private void setOperator(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("Invalid operator.");
        }
        this.operators.add(new Integer(n));
    }

    public void addRow(String[] stringArray, int n) {
        if (stringArray != null) {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    bl = true;
                    break;
                }
                stringArray[i] = "";
            }
            if (bl) {
                this.setOperator(n);
                this.values.add(stringArray);
            }
        } else {
            throw new NullPointerException("Values array cannot be null");
        }
    }

    public void removeRow(int n) {
        this.values.remove(n);
        this.operators.remove(n);
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            string = string + "\n";
            string = string + this.getStringValue(i, 0) + " " + MetaDataCondition.getOperatorString(this.getOperator(i)) + " ";
            for (int j = 1; j < this.getColumnCount(); ++j) {
                string = string + this.getStringValue(i, j) + "\t";
            }
        }
        return string;
    }

    public boolean equals(Object object) {
        MetaDataTable metaDataTable = null;
        if (object == null) {
            return false;
        }
        try {
            metaDataTable = (MetaDataTable)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (metaDataTable.getRowCount() == this.getRowCount() && metaDataTable.getColumnCount() == this.getColumnCount()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    if (this.getStringValue(i, j).equals(metaDataTable.getStringValue(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

