/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.ftp;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.ftp.FTPAccount;
import edu.sdsc.grid.io.ftp.FTPFileSystem;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import org.globus.ftp.FTPClient;
import org.globus.ftp.exception.FTPException;

public class FTPFile
extends RemoteFile {
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    protected FTPClient ftpClient;

    public FTPFile(FTPFileSystem fTPFileSystem, String string) throws IOException {
        this(fTPFileSystem, "", string);
    }

    public FTPFile(FTPFileSystem fTPFileSystem, String string, String string2) throws IOException {
        super(fTPFileSystem, string, string2);
        this.ftpClient = fTPFileSystem.getFTPClient();
    }

    public FTPFile(FTPFile fTPFile, String string) throws IOException {
        this((FTPFileSystem)fTPFile.getFileSystem(), fTPFile.getParent(), string);
    }

    public FTPFile(URI uRI) throws IOException, URISyntaxException {
        super(uRI);
        if (uRI.getScheme().equals("ftp")) {
            String string = uRI.getUserInfo();
            if (string != null) {
                int n = string.indexOf(":");
                if (n >= 0) {
                    this.setFileSystem(new FTPFileSystem(new FTPAccount(uRI.getHost(), uRI.getPort(), string.substring(0, n - 1), string.substring(n + 1), uRI.getPath())));
                } else {
                    this.setFileSystem(new FTPFileSystem(new FTPAccount(uRI.getHost(), uRI.getPort(), string, "", uRI.getPath())));
                }
            } else {
                this.fileSystem = new FTPFileSystem(new FTPAccount(uRI.getHost(), uRI.getPort(), null, "", uRI.getPath()));
            }
        } else {
            throw new URISyntaxException(uRI.toString(), "Wrong URI scheme");
        }
        this.setFileName(uRI.getPath());
        this.ftpClient = ((FTPFileSystem)this.fileSystem).getFTPClient();
    }

    FTPClient getFTPClient() {
        return this.ftpClient;
    }

    public void replicate(String string) {
        throw new UnsupportedOperationException();
    }

    public String getResource() {
        throw new UnsupportedOperationException();
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        block8: {
            block7: {
                if (generalFile == null) {
                    throw new NullPointerException();
                }
                if (!this.isDirectory()) break block7;
                GeneralFile[] generalFileArray = this.listFiles();
                generalFile.mkdir();
                if (generalFileArray == null) break block8;
                for (int i = 0; i < generalFileArray.length; ++i) {
                    generalFileArray[i].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), generalFileArray[i].getName()), bl);
                }
                break block8;
            }
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            try {
                if (generalFile instanceof LocalFile) {
                    this.ftpClient.get(this.getPath(), ((LocalFile)generalFile).getFile());
                }
                if (generalFile instanceof FTPFile) {
                    this.ftpClient.transfer(this.getPath(), ((FTPFile)generalFile).getFTPClient(), generalFile.getPath(), !bl, null);
                }
                super.copyTo(generalFile);
            }
            catch (FTPException fTPException) {
                IOException iOException = new IOException();
                iOException.initCause(fTPException);
                throw iOException;
            }
        }
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        block8: {
            block7: {
                if (generalFile == null) {
                    throw new NullPointerException();
                }
                if (!generalFile.isDirectory()) break block7;
                GeneralFile[] generalFileArray = generalFile.listFiles();
                this.mkdir();
                if (generalFileArray == null) break block8;
                for (int i = 0; i < generalFileArray.length; ++i) {
                    FileFactory.newFile(this, generalFileArray[i].getName()).copyFrom(generalFileArray[i], bl);
                }
                break block8;
            }
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile);
                return;
            }
            try {
                if (generalFile instanceof LocalFile) {
                    this.ftpClient.put(((LocalFile)generalFile).getFile(), this.getPath(), !bl);
                }
                if (generalFile instanceof FTPFile) {
                    this.ftpClient.transfer(generalFile.getPath(), this.ftpClient, this.getPath(), !bl, null);
                }
                super.copyTo(generalFile);
            }
            catch (FTPException fTPException) {
                IOException iOException = new IOException();
                iOException.initCause(fTPException);
                throw iOException;
            }
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean delete() {
        try {
            if (this.isDirectory()) {
                this.ftpClient.deleteDir(this.getPath());
            } else {
                this.ftpClient.deleteFile(this.getPath());
            }
        }
        catch (IOException iOException) {
            return false;
        }
        catch (FTPException fTPException) {
            return false;
        }
        return true;
    }

    public String getPath() {
        return this.getAbsolutePath();
    }

    public boolean exists() {
        try {
            this.ftpClient.exists(this.getPath());
        }
        catch (IOException iOException) {
            return false;
        }
        catch (FTPException fTPException) {
            return false;
        }
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public long lastModified() {
        try {
            Date date = this.ftpClient.lastModified(this.getPath());
            return date.getTime();
        }
        catch (IOException iOException) {
            return 0L;
        }
        catch (FTPException fTPException) {
            return 0L;
        }
    }

    public long length() {
        try {
            return this.ftpClient.size(this.getPath());
        }
        catch (IOException iOException) {
            return 0L;
        }
        catch (FTPException fTPException) {
            return 0L;
        }
    }

    public String[] list() {
        try {
            Vector vector = this.ftpClient.list(this.getPath());
            Object[] objectArray = vector.toArray();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            return stringArray;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (FTPException fTPException) {
            return null;
        }
    }

    public boolean mkdir() {
        try {
            this.ftpClient.makeDir(this.getPath());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (FTPException fTPException) {
            return false;
        }
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException, NullPointerException {
        block7: {
            try {
                if (generalFile instanceof FTPFile) {
                    if (this.ftpClient.equals(((FTPFile)generalFile).ftpClient)) {
                        this.ftpClient.rename(this.getPath(), generalFile.getPath());
                        break block7;
                    }
                    if (!generalFile.exists()) {
                        this.copyTo(generalFile);
                        this.delete();
                        break block7;
                    }
                    return false;
                }
                if (!generalFile.exists()) {
                    this.copyTo(generalFile);
                    this.delete();
                    break block7;
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (FTPException fTPException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String string = ((FTPFileSystem)this.fileSystem).getUserName();
        int n = ((FTPFileSystem)this.fileSystem).getPort();
        string = string != null ? string + "@" : "";
        String string2 = n > 0 && n != 21 ? ":" + n : "";
        return "http://" + string + ((FTPFileSystem)this.fileSystem).getHost() + string2 + this.getAbsolutePath();
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.DEBUG > 0) {
                uRISyntaxException.printStackTrace();
            }
            return null;
        }
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }
}

