/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.http;

import edu.sdsc.grid.io.RemoteAccount;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class HTTPAccount
extends RemoteAccount {
    HTTPAccount(String string, int n, String string2, String string3, String string4) {
        super(string, n, string2, string3, string4);
        try {
            new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URI");
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public void setHomeDirectory(String string) {
        this.homeDirectory = string == null || string.equals("") ? "/" : string;
    }

    public void setPort(int n) {
        if (n > 0) {
            this.port = n;
        } else {
            n = 80;
        }
    }

    URI getURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URI");
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid URI");
            illegalArgumentException.initCause(malformedURLException);
            throw illegalArgumentException;
        }
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            HTTPAccount hTTPAccount = (HTTPAccount)object;
            if (!this.getHost().equals(hTTPAccount.getHost())) {
                return false;
            }
            if (this.getPort() != hTTPAccount.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(hTTPAccount.getUserName())) {
                return false;
            }
            return this.getPassword().equals(hTTPAccount.getPassword());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        String string = this.getUserName();
        int n = this.getPort();
        string = string != null ? string + "@" : "";
        String string2 = n > 0 && n != 80 ? ":" + n : "";
        return "http://" + string + this.getHost() + string2 + this.getHomeDirectory();
    }
}

