/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.http;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.http.HTTPFileSystem;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class HTTPFile
extends RemoteFile {
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    HTTPFileSystem httpFileSystem;

    public HTTPFile(HTTPFileSystem hTTPFileSystem, String string) throws IOException {
        this(hTTPFileSystem, string, "");
    }

    public HTTPFile(HTTPFileSystem hTTPFileSystem, String string, String string2) throws IOException {
        super(hTTPFileSystem, string, string2);
        this.httpFileSystem = hTTPFileSystem;
    }

    public HTTPFile(HTTPFile hTTPFile, String string) throws IOException {
        this((HTTPFileSystem)hTTPFile.getFileSystem(), hTTPFile.getAbsolutePath(), string);
    }

    public HTTPFile(URI uRI) throws IOException, URISyntaxException {
        super(uRI);
        this.setFileSystem(new HTTPFileSystem(uRI));
        this.setFileName(uRI.getPath());
        this.httpFileSystem = (HTTPFileSystem)this.fileSystem;
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException();
        }
        if (generalFile.isDirectory()) {
            GeneralFile[] generalFileArray = generalFile.listFiles();
            this.mkdir();
            if (generalFileArray != null) {
                for (int i = 0; i < generalFileArray.length; ++i) {
                    FileFactory.newFile(this, generalFileArray[i].getName()).copyFrom(generalFileArray[i], bl);
                }
            }
        } else {
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile);
                return;
            }
            if (!(generalFile instanceof LocalFile) && !(generalFile instanceof HTTPFile)) {
                super.copyTo(generalFile);
            }
        }
    }

    public String getResource() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void replicate(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean createNewFile() throws IOException {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public String getPath() {
        return this.getAbsolutePath();
    }

    public boolean exists() {
        return true;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        try {
            return this.httpFileSystem.getNewInputStream().available();
        }
        catch (IOException iOException) {
            if (this.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
    }

    public String[] list() {
        return null;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException, NullPointerException {
        block5: {
            try {
                if (generalFile instanceof HTTPFile) {
                    if (this.httpFileSystem.conn.equals(((HTTPFile)generalFile).httpFileSystem.conn)) break block5;
                    if (!generalFile.exists()) {
                        this.copyTo(generalFile);
                        this.delete();
                        break block5;
                    }
                    return false;
                }
                if (!generalFile.exists()) {
                    this.copyTo(generalFile);
                    this.delete();
                    break block5;
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String string = this.httpFileSystem.getUserName();
        int n = this.httpFileSystem.getPort();
        string = string != null ? string + "@" : "";
        String string2 = n > 0 && n != 80 ? ":" + n : "";
        return "http://" + string + this.httpFileSystem.getHost() + string2 + this.getAbsolutePath();
    }

    public URI toURI() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            if (this.DEBUG > 0) {
                uRISyntaxException.printStackTrace();
            }
            return null;
        }
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toString());
    }
}

