/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.Base64;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.irods.IRODSAccount;
import edu.sdsc.grid.io.irods.IRODSException;
import edu.sdsc.grid.io.irods.IRODSFile;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import edu.sdsc.grid.io.irods.IRODSMetaDataRecordList;
import edu.sdsc.grid.io.irods.IRODSMetaDataSet;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.TreeMap;

class IRODSCommands {
    private long date;
    private static int DEBUG = 0;
    public static final int CHAR_LENGTH = 2;
    public static final int SHORT_LENGTH = 2;
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;
    static int OUTPUT_BUFFER_LENGTH;
    static final int HEADER_INT_LENGTH = 4;
    static final int MAX_PASSWORD_LENGTH = 50;
    static final int CHALLENGE_LENGTH = 64;
    static final int MAX_SQL_ATTR = 50;
    static final String RODS_CONNECT = "RODS_CONNECT";
    static final String RODS_VERSION = "RODS_VERSION";
    static final String RODS_API_REQ = "RODS_API_REQ";
    static final String RODS_DISCONNECT = "RODS_DISCONNECT";
    static final String RODS_REAUTH = "RODS_REAUTH";
    static final String RODS_API_REPLY = "RODS_API_REPLY";
    static final int DONE_OPR = 9999;
    static final int PUT_OPR = 1;
    static final int GET_OPR = 2;
    static final int SAME_HOST_COPY_OPR = 3;
    static final int COPY_TO_LOCAL_OPR = 4;
    static final int COPY_TO_REM_OPR = 5;
    static final int REPLICATE_OPR = 6;
    static final int REPLICATE_DEST = 7;
    static final int REPLICATE_SRC = 8;
    static final int COPY_DEST = 9;
    static final int COPY_SRC = 10;
    static final int RENAME_DATA_OBJ = 11;
    static final int RENAME_COLL = 12;
    static final int MOVE_OPR = 13;
    static final int RSYNC_OPR = 14;
    static final int PHYMV_OPR = 15;
    static final int PHYMV_SRC = 16;
    static final int PHYMV_DEST = 17;
    static final int FILE_CREATE_AN = 500;
    static final int FILE_OPEN_AN = 501;
    static final int FILE_WRITE_AN = 502;
    static final int FILE_CLOSE_AN = 503;
    static final int FILE_LSEEK_AN = 504;
    static final int FILE_READ_AN = 505;
    static final int FILE_UNLINK_AN = 506;
    static final int FILE_MKDIR_AN = 507;
    static final int FILE_CHMOD_AN = 508;
    static final int FILE_RMDIR_AN = 509;
    static final int FILE_STAT_AN = 510;
    static final int FILE_FSTAT_AN = 511;
    static final int FILE_FSYNC_AN = 512;
    static final int FILE_STAGE_AN = 513;
    static final int FILE_GET_FS_FREE_SPACE_AN = 514;
    static final int FILE_OPENDIR_AN = 515;
    static final int FILE_CLOSEDIR_AN = 516;
    static final int FILE_READDIR_AN = 517;
    static final int FILE_PUT_AN = 518;
    static final int FILE_CHKSUM_AN = 520;
    static final int CHK_N_V_PATH_PERM_AN = 521;
    static final int FILE_RENAME_AN = 522;
    static final int DATA_OBJ_CREATE_AN = 601;
    static final int DATA_OBJ_OPEN_AN = 602;
    static final int DATA_OBJ_READ_AN = 603;
    static final int DATA_OBJ_WRITE_AN = 604;
    static final int DATA_OBJ_CLOSE_AN = 605;
    static final int DATA_OBJ_PUT_AN = 606;
    static final int DATA_PUT_AN = 607;
    static final int DATA_OBJ_GET_AN = 608;
    static final int DATA_GET_AN = 609;
    static final int DATA_OBJ_REPL_AN = 610;
    static final int DATA_COPY_AN = 611;
    static final int DATA_OBJ_LSEEK_AN = 612;
    static final int DATA_OBJ_COPY_AN = 613;
    static final int SIMPLE_QUERY_AN = 614;
    static final int DATA_OBJ_UNLINK_AN = 615;
    static final int COLL_CREATE_AN = 616;
    static final int RM_COLL_AN = 617;
    static final int REG_COLL_AN = 618;
    static final int REG_DATA_OBJ_AN = 619;
    static final int UNREG_DATA_OBJ_AN = 620;
    static final int REG_REPLICA_AN = 621;
    static final int MOD_DATA_OBJ_META_AN = 622;
    static final int RULE_EXEC_SUBMIT_AN = 623;
    static final int RULE_EXEC_DEL_AN = 624;
    static final int EXEC_MY_RULE_AN = 625;
    static final int OPR_COMPLETE_AN = 626;
    static final int DATA_OBJ_RENAME_AN = 627;
    static final int DATA_OBJ_RSYNC_AN = 628;
    static final int DATA_OBJ_CHKSUM_AN = 629;
    static final int PHY_PATH_REG_AN = 630;
    static final int DATA_OBJ_PHYMV_AN = 631;
    static final int DATA_OBJ_TRIM_AN = 632;
    static final int OBJ_STAT_AN = 633;
    static final int GET_MISC_SVR_INFO_AN = 700;
    static final int GENERAL_ADMIN_AN = 701;
    static final int GEN_QUERY_AN = 702;
    static final int AUTH_REQUEST_AN = 703;
    static final int AUTH_RESPONSE_AN = 704;
    static final int AUTH_CHECK_AN = 705;
    static final int MOD_AVU_METADATA_AN = 706;
    static final int MOD_ACCESS_CONTROL_AN = 707;
    static final int RULE_EXEC_MOD_AN = 708;
    static TreeMap tagList;
    static final String type = "type";
    static final String msgLen = "msgLen";
    static final String errorLen = "errorLen";
    static final String bsLen = "bsLen";
    static final String intInfo = "intInfo";
    static final String irodsProt = "irodsProt";
    static final String connectCnt = "connectCnt";
    static final String proxyUser = "proxyUser";
    static final String proxyRcatZone = "proxyRcatZone";
    static final String clientUser = "clientUser";
    static final String clientRcatZone = "clientRcatZone";
    static final String relVersion = "relVersion";
    static final String apiVersion = "apiVersion";
    static final String option = "option";
    static final String status = "status";
    static final String challenge = "challenge";
    static final String response = "response";
    static final String username = "username";
    static final String objPath = "objPath";
    static final String createMode = "createMode";
    static final String openFlags = "openFlags";
    static final String offset = "offset";
    static final String dataSize = "dataSize";
    static final String numThreads = "numThreads";
    static final String oprType = "oprType";
    static final String ssLen = "ssLen";
    static final String objSize = "objSize";
    static final String objType = "objType";
    static final String numCopies = "numCopies";
    static final String dataId = "dataId";
    static final String chksum = "chksum";
    static final String ownerName = "ownerName";
    static final String ownerZone = "ownerZone";
    static final String createTime = "createTime";
    static final String modifyTime = "modifyTime";
    static final String inx = "inx";
    static final String maxRows = "maxRows";
    static final String continueInx = "continueInx";
    static final String ivalue = "ivalue";
    static final String svalue = "svalue";
    static final String iiLen = "iiLen";
    static final String isLen = "isLen";
    static final String keyWord = "keyWord";
    static final String rowCnt = "rowCnt";
    static final String attriCnt = "attriCnt";
    static final String attriInx = "attriInx";
    static final String reslen = "reslen";
    static final String queryValue = "value";
    static final String collName = "collName";
    static final String recursiveFlag = "recursiveFlag";
    static final String accessLevel = "accessLevel";
    static final String userName = "userName";
    static final String zone = "zone";
    static final String path = "path";
    static final String l1descInx = "l1descInx";
    static final String len = "len";
    static final String fileInx = "fileInx";
    static final String whence = "whence";
    static final String dataObjInx = "dataObjInx";
    static final String bytesWritten = "bytesWritten";
    static final String msg = "msg";
    static final String myRule = "myRule";
    static final String outParamDesc = "outParamDesc";
    static final String hostAddr = "hostAddr";
    static final String rodsZone = "rodsZone";
    static final String port = "port";
    static final String paramLen = "paramLen";
    static final String MsgHeader_PI = "MsgHeader_PI";
    static final String StartupPack_PI = "StartupPack_PI";
    static final String Version_PI = "Version_PI";
    static final String authRequestOut_PI = "authRequestOut_PI";
    static final String authResponseInp_PI = "authResponseInp_PI";
    static final String DataObjInp_PI = "DataObjInp_PI";
    static final String GenQueryInp_PI = "GenQueryInp_PI";
    static final String InxIvalPair_PI = "InxIvalPair_PI";
    static final String InxValPair_PI = "InxValPair_PI";
    static final String KeyValPair_PI = "KeyValPair_PI";
    static final String RodsObjStat_PI = "RodsObjStat_PI";
    static final String SqlResult_PI = "SqlResult_PI";
    static final String CollInp_PI = "CollInp_PI";
    static final String DataObjCopyInp_PI = "DataObjCopyInp_PI";
    static final String ExecMyRuleInp_PI = "ExecMyRuleInp_PI";
    static final String RHostAddr_PI = "RHostAddr_PI";
    static final String MsParamArray_PI = "MsParamArray_PI";
    static final String modAccessControlInp_PI = "modAccessControlInp_PI";
    static final String dataObjReadInp_PI = "dataObjReadInp_PI";
    static final String dataObjWriteInp_PI = "dataObjWriteInp_PI";
    static final String fileLseekInp_PI = "fileLseekInp_PI";
    static final String dataObjCloseInp_PI = "dataObjCloseInp_PI";
    static final String RErrMsg_PI = "RErrMsg_PI";
    private Socket connection;
    private InputStream in = null;
    private OutputStream out = null;
    private byte[] outputBuffer = new byte[OUTPUT_BUFFER_LENGTH];
    private int outputOffset = 0;
    private IRODSAccount account;
    static final String OPEN_START_TAG = "<";
    static final String CLOSE_START_TAG = ">";
    static final String OPEN_END_TAG = "</";
    static final String CLOSE_END_TAG = ">";

    IRODSCommands() {
    }

    protected void finalize() throws IOException {
        this.close();
        if (this.out != null) {
            this.out = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.connection != null) {
            this.connection = null;
        }
    }

    void connect(IRODSAccount iRODSAccount) throws IOException {
        this.account = (IRODSAccount)iRODSAccount.clone();
        if (DEBUG > 1) {
            this.date = new Date().getTime();
            System.err.println("Connecting to server, " + iRODSAccount.getHost() + ":" + iRODSAccount.getPort() + " running version: " + IRODSAccount.version + " as username: " + iRODSAccount.getUserName() + "\ntime: " + this.date);
        }
        this.openSocket(iRODSAccount.getHost(), iRODSAccount.getPort());
        Tag tag = this.sendStartupPacket(iRODSAccount);
        this.status(tag);
        this.send(this.createHeader(RODS_API_REQ, 0, 0, 0L, 703));
        this.flush();
        tag = this.readMessage();
        String string = this.challengeResponse(tag.getTag(challenge).getStringValue(), iRODSAccount.getPassword());
        Tag[] tagArray = new Tag[2];
        tagArray[0] = new Tag(response, string);
        tagArray[1] = new Tag(username, iRODSAccount.getUserName());
        tag = new Tag(authResponseInp_PI, tagArray);
        try {
            tag = this.irodsFunction(RODS_API_REQ, tag, 704);
        }
        catch (IRODSException iRODSException) {
            if (iRODSException.getType() == -826000) {
                SecurityException securityException = new SecurityException("Invalid authentication");
                securityException.initCause(iRODSException);
                throw securityException;
            }
            throw iRODSException;
        }
    }

    synchronized void close() throws IOException {
        if (this.isConnected()) {
            this.send(this.createHeader(RODS_DISCONNECT, 0, 0, 0L, 0));
            this.flush();
            this.out.close();
            this.in.close();
            this.connection.close();
        }
    }

    synchronized boolean isClosed() throws IOException {
        if (this.connection == null) {
            return true;
        }
        if (this.connection.isClosed()) {
            return true;
        }
        if (this.out == null) {
            return true;
        }
        return this.in == null;
    }

    private Tag sendStartupPacket(IRODSAccount iRODSAccount) throws IOException {
        Tag[] tagArray = new Tag[9];
        tagArray[0] = new Tag(irodsProt, "1");
        tagArray[1] = new Tag(connectCnt, "0");
        tagArray[2] = new Tag(proxyUser, iRODSAccount.getUserName());
        tagArray[3] = new Tag(proxyRcatZone, iRODSAccount.getZone());
        tagArray[4] = new Tag(clientUser, iRODSAccount.getUserName());
        tagArray[5] = new Tag(clientRcatZone, iRODSAccount.getZone());
        tagArray[6] = new Tag(relVersion, iRODSAccount.getVersion());
        tagArray[7] = new Tag(apiVersion, iRODSAccount.getAPIVersion());
        tagArray[8] = new Tag(option, iRODSAccount.getOption());
        Tag tag = new Tag(StartupPack_PI, tagArray);
        String string = tag.parseTag();
        this.send(this.createHeader(RODS_CONNECT, string.length(), 0, 0L, 0));
        this.send(string);
        this.flush();
        return this.readMessage();
    }

    private String challengeResponse(String string, String string2) throws SecurityException, IOException {
        byte[] byArray = null;
        byte[] byArray2 = Base64.fromString(string);
        if (string2.length() >= 50) {
            throw new IllegalArgumentException("Password is too long");
        }
        byArray = new byte[114];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        byArray2 = string2.getBytes();
        System.arraycopy(byArray2, 0, byArray, 64, byArray2.length);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray = messageDigest.digest(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(generalSecurityException);
            throw securityException;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            byArray[i] = 1;
        }
        return Base64.toString(byArray);
    }

    private void openSocket(String string, int n) throws IOException {
        try {
            this.connection = new Socket(string, n);
            this.in = this.connection.getInputStream();
            this.out = this.connection.getOutputStream();
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException("Connection cannot be made to: " + string + " at port: " + n);
            connectException2.initCause(connectException);
            throw connectException2;
        }
        catch (SocketException socketException) {
            SocketException socketException2 = new SocketException("A socket error occured when connecting to: " + string + " at port: " + n);
            socketException2.initCause(socketException);
            throw socketException2;
        }
    }

    boolean isConnected() {
        block3: {
            try {
                if (this.connection != null && this.connection.isConnected() && !this.connection.isClosed()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (DEBUG <= 0) break block3;
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void send(byte[] byArray) throws IOException {
        if (byArray.length + this.outputOffset >= OUTPUT_BUFFER_LENGTH) {
            this.out.write(this.outputBuffer, 0, this.outputOffset);
            this.out.write(byArray);
            this.out.flush();
            this.outputOffset = 0;
        } else {
            System.arraycopy(byArray, 0, this.outputBuffer, this.outputOffset, byArray.length);
            this.outputOffset += byArray.length;
        }
    }

    private void send(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.send(byArray2);
    }

    private void send(String string) throws IOException {
        this.send(string.getBytes());
    }

    private void send(int n) throws IOException {
        byte[] byArray = new byte[4];
        Host.copyInt(n, byArray);
        Host.swap(byArray, 4);
        this.send(byArray);
    }

    private void send(long l) throws IOException {
        byte[] byArray = new byte[8];
        Host.copyLong(l, byArray);
        Host.swap(byArray, 8);
        this.send(byArray);
    }

    private void send(InputStream inputStream, long l) throws IOException {
        byte[] byArray = new byte[Math.min(IRODSFileSystem.BUFFER_SIZE, (int)l)];
        while (l > 0L) {
            if ((long)byArray.length > l) {
                byArray = new byte[(int)l];
            }
            l -= (long)inputStream.read(byArray, 0, byArray.length);
            this.send(byArray);
        }
    }

    void flush() throws IOException {
        if (this.connection.isClosed()) {
            throw new ClosedChannelException();
        }
        this.out.write(this.outputBuffer, 0, this.outputOffset);
        this.outputOffset = 0;
    }

    private byte read() throws IOException {
        return (byte)this.in.read();
    }

    private int read(byte[] byArray) throws ClosedChannelException, InterruptedIOException, IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private void read(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[Math.min(IRODSFileSystem.BUFFER_SIZE, (int)l)];
        while (l > 0L) {
            if ((long)byArray.length > l) {
                byArray = new byte[(int)l];
            }
            l -= (long)this.read(byArray, 0, byArray.length);
            outputStream.write(byArray);
        }
    }

    private int read(byte[] byArray, int n, int n2) throws ClosedChannelException, InterruptedIOException, IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        if (n >= byArray.length) {
            return 0;
        }
        if (n2 + n > byArray.length) {
            throw new IllegalArgumentException("debuging protocol read");
        }
        try {
            int n4 = 1448;
            boolean bl = false;
            if (n2 > n4) {
                for (n3 = 0; n2 > n3 + n4 - 1 && n3 >= 0; n3 += this.in.read(byArray, n3, n4)) {
                }
                while (n2 - n3 - 1 > 0 && n3 >= 0) {
                    n3 += this.in.read(byArray, n3, n2 - n3);
                }
            } else {
                while (n2 - n3 > 0 && n3 >= 0) {
                    n3 += this.in.read(byArray, n3, n2 - n3);
                }
            }
            if (n3 < 0) {
                throw new SocketException("iRODS socket connection is closed.");
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("read() -- couldn't read complete packet");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        return n3;
    }

    void status(Tag tag) throws IOException {
        Tag tag2 = tag.getTag(status);
        if (tag2 != null && tag2.getIntValue() < 0) {
            throw new IRODSException("" + tag2.getIntValue());
        }
    }

    private byte[] createHeader(String string, int n, int n2, long l, int n3) {
        String string2 = "<MsgHeader_PI><type>" + string + "</type>" + "<msgLen>" + n + "</msgLen>" + "<errorLen>" + n2 + "</errorLen>" + "<bsLen>" + l + "</bsLen>" + "<intInfo>" + n3 + "</intInfo>" + "</MsgHeader_PI>";
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4 + string2.length()];
        Host.copyInt(string2.length(), byArray);
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        System.arraycopy(string2.getBytes(), 0, byArray2, 4, string2.length());
        return byArray2;
    }

    private Tag readMessage() throws IOException {
        Tag tag = this.readHeader();
        Tag tag2 = null;
        String string = tag.tags[0].getStringValue();
        int n = tag.tags[1].getIntValue();
        int n2 = tag.tags[2].getIntValue();
        int n3 = tag.tags[3].getIntValue();
        int n4 = tag.tags[4].getIntValue();
        if (n4 < 0) {
            if (n > 0) {
                this.read(new byte[n], 0, n);
            }
            if (n4 == -808000) {
                return null;
            }
            if (n4 == -312000) {
                throw new IRODSException("Attempt to overwrite file without force flag. ", n4);
            }
            if (n2 != 0) {
                byte[] byArray = new byte[n2];
                this.read(byArray, 0, n2);
                Tag tag3 = this.readNextTag(byArray);
                throw new IRODSException("IRODS error occured " + tag3.getTag(RErrMsg_PI).getTag(msg), n4);
            }
            throw new IRODSException("IRODS error occured " + n4, n4);
        }
        if (n > 0) {
            tag2 = this.readMessageBody(n);
        }
        if (n3 != 0 || n4 > 0) {
            if (tag2 == null) {
                tag2 = new Tag(MsgHeader_PI);
            }
            tag2.addTag(tag);
        }
        return tag2;
    }

    private Tag readHeader() throws IOException {
        int n = this.readHeaderLength();
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return this.readNextTag(byArray);
    }

    private int readHeaderLength() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray, 0, 4);
        return Host.castToInt(byArray);
    }

    private Tag readMessageBody(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return this.readNextTag(byArray);
    }

    private Tag readNextTag(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = new String(byArray);
        int n = string.indexOf(OPEN_START_TAG);
        int n2 = string.indexOf(">", n);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        n2 = string.lastIndexOf(OPEN_END_TAG + string2 + ">");
        Tag tag = new Tag(string2);
        String string3 = string.substring(n + string2.length() + 2, n2);
        if (string3.indexOf(OPEN_START_TAG) > 2) {
            tag.setValue(string3);
        } else {
            while (string3.indexOf(OPEN_START_TAG) >= 0 && n >= 0 && n < string3.length()) {
                string3 = string3.substring(n);
                n = this.readSubTag(tag, string3.getBytes());
            }
        }
        return tag;
    }

    private int readSubTag(Tag tag, byte[] byArray) {
        if (byArray == null) {
            return Integer.MAX_VALUE;
        }
        String string = new String(byArray);
        int n = string.indexOf(OPEN_START_TAG);
        int n2 = string.indexOf(">", n);
        if (n < 0 && string.length() == 0) {
            return 1;
        }
        if (n < 0 || n2 < 0) {
            return n2;
        }
        String string2 = string.substring(n + 1, n2);
        n2 = string.indexOf(OPEN_END_TAG + string2 + ">");
        if (n2 < 0) {
            return string.indexOf(">", n) + 1;
        }
        Tag tag2 = new Tag(string2);
        tag.addTag(tag2);
        String string3 = string.substring(n + string2.length() + 2, n2);
        int n3 = string3.indexOf(OPEN_START_TAG);
        int n4 = string3.indexOf(OPEN_END_TAG);
        if (n3 < 0) {
            tag2.setValue(string3);
            n2 += string2.length() + 4;
        } else if (n3 == n4) {
            tag2.setValue(string3.substring(0, n4));
            n2 = n + string2.length() + 2 + n4 + string2.length() + 4;
        } else {
            while (string3.indexOf(OPEN_START_TAG) >= 0 && n >= 0 && n < string3.length()) {
                string3 = string3.substring(n);
                n = this.readSubTag(tag2, string3.getBytes());
            }
        }
        return n2;
    }

    Tag createKeyValueTag(String string, String string2) {
        return this.createKeyValueTag(new String[][]{{string, string2}});
    }

    Tag createKeyValueTag(String[][] stringArray) {
        int n;
        Tag tag = new Tag(KeyValPair_PI, new Tag(ssLen, 0));
        if (stringArray == null) {
            return tag;
        }
        for (n = 0; n < stringArray.length; ++n) {
            tag.addTag(keyWord, stringArray[n][0]);
        }
        tag.tags[0].setValue(n);
        if (n == 0) {
            return tag;
        }
        for (n = 0; n < stringArray.length; ++n) {
            tag.addTag(svalue, stringArray[n][1]);
        }
        return tag;
    }

    Tag irodsFunction(String string, Tag tag, int n) throws IOException {
        return this.irodsFunction(string, tag, 0, null, 0L, null, n);
    }

    Tag irodsFunction(String string, Tag tag, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) throws IOException {
        String string2 = tag.parseTag();
        this.send(this.createHeader(RODS_API_REQ, string2.length(), n2, n4, n5));
        this.send(string2);
        if (n4 > 0) {
            this.send(byArray2, n3, n4);
        }
        this.flush();
        return this.readMessage();
    }

    Tag irodsFunction(String string, Tag tag, int n, InputStream inputStream, long l, InputStream inputStream2, int n2) throws IOException {
        String string2 = tag.parseTag();
        this.send(this.createHeader(RODS_API_REQ, string2.length(), n, l, n2));
        this.send(string2);
        if (n > 0) {
            this.send(inputStream, n);
        }
        if (l > 0L) {
            this.send(inputStream2, l);
        }
        this.flush();
        return this.readMessage();
    }

    void chmod(IRODSFile iRODSFile, String string, String string2, boolean bl) throws IOException {
        Tag tag = new Tag(modAccessControlInp_PI, new Tag[]{new Tag(recursiveFlag, bl ? 1 : 0), new Tag(accessLevel, string), new Tag(userName, string2), new Tag(zone, ""), new Tag(path, iRODSFile.getAbsolutePath())});
        this.irodsFunction(RODS_API_REQ, tag, 707);
    }

    void copy(IRODSFile iRODSFile, IRODSFile iRODSFile2, boolean bl) throws IOException {
        String[][] stringArray = null;
        stringArray = bl ? new String[][]{{"forceFlag", ""}, {"destRescName", iRODSFile2.getResource()}} : new String[][]{{"destRescName", iRODSFile2.getResource()}};
        Tag tag = new Tag(DataObjCopyInp_PI, new Tag[]{new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, iRODSFile.length()), new Tag(numThreads, 0), new Tag(oprType, 10), this.createKeyValueTag(null)}), new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile2.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 9), this.createKeyValueTag(stringArray)})});
        this.irodsFunction(RODS_API_REQ, tag, 613);
    }

    void deleteDirectory(IRODSFile iRODSFile) throws IOException {
        Tag tag = new Tag(CollInp_PI, new Tag[]{new Tag(collName, iRODSFile.getAbsolutePath()), this.createKeyValueTag("recursiveOpr", "")});
        this.irodsFunction(RODS_API_REQ, tag, 617);
    }

    void deleteFile(IRODSFile iRODSFile) throws IOException {
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 0), this.createKeyValueTag(null)});
        this.irodsFunction(RODS_API_REQ, tag, 615);
    }

    int fileCreate(IRODSFile iRODSFile) throws IOException {
        String[][] stringArray = new String[][]{{"dataType", iRODSFile.getDataType()}, {"destRescName", iRODSFile.getResource()}};
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 488), new Tag(openFlags, 1), new Tag(offset, 0), new Tag(dataSize, -1), new Tag(numThreads, 0), new Tag(oprType, 0), this.createKeyValueTag(stringArray)});
        tag = this.irodsFunction(RODS_API_REQ, tag, 601);
        return tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue();
    }

    void fileClose(int n) throws IOException {
        Tag tag = new Tag(dataObjCloseInp_PI, new Tag[]{new Tag(l1descInx, n), new Tag(bytesWritten, 0)});
        this.irodsFunction(RODS_API_REQ, tag, 605);
    }

    int fileOpen(IRODSFile iRODSFile) throws IOException {
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 0), this.createKeyValueTag(null)});
        tag = this.irodsFunction(RODS_API_REQ, tag, 602);
        return tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue();
    }

    int fileRead(int n, OutputStream outputStream, long l) throws IOException {
        Tag tag = new Tag(dataObjReadInp_PI, new Tag[]{new Tag(l1descInx, n), new Tag(len, l)});
        tag = this.irodsFunction(RODS_API_REQ, tag, 603);
        l = tag.getTag(MsgHeader_PI).getTag(bsLen).getIntValue();
        this.read(outputStream, l);
        return tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue();
    }

    int fileRead(int n, byte[] byArray, int n2, int n3) throws IOException {
        Tag tag = new Tag(dataObjReadInp_PI, new Tag[]{new Tag(l1descInx, n), new Tag(len, n3)});
        n3 = (tag = this.irodsFunction(RODS_API_REQ, tag, 603)).getTag(MsgHeader_PI).getTag(bsLen).getIntValue();
        int n4 = this.read(byArray, n2, n3);
        if (n4 == tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue()) {
            return n4;
        }
        throw new ProtocolException("Bytes read mismatch");
    }

    int fileSeek(int n, long l, int n2) throws IOException {
        Tag[] tagArray = new Tag[3];
        tagArray[0] = new Tag(fileInx, n);
        tagArray[1] = new Tag(offset, l);
        tagArray[2] = new Tag(whence, n2);
        Tag tag = new Tag(fileLseekInp_PI, tagArray);
        tag = this.irodsFunction(RODS_API_REQ, tag, 612);
        return tag.getTag(offset).getIntValue();
    }

    int fileWrite(int n, InputStream inputStream, long l) throws IOException {
        Tag tag = new Tag(dataObjWriteInp_PI, new Tag[]{new Tag(dataObjInx, n), new Tag(len, l)});
        tag = this.irodsFunction(RODS_API_REQ, tag, 0, null, l, inputStream, 604);
        return tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue();
    }

    int fileWrite(int n, byte[] byArray, int n2, int n3) throws IOException {
        Tag tag = new Tag(dataObjWriteInp_PI, new Tag[]{new Tag(dataObjInx, n), new Tag(len, n3)});
        tag = this.irodsFunction(RODS_API_REQ, tag, null, 0, 0, byArray, n2, n3, 604);
        return tag.getTag(MsgHeader_PI).getTag(intInfo).getIntValue();
    }

    void get(IRODSFile iRODSFile, LocalFileOutputStream localFileOutputStream, boolean bl) throws IOException {
        String[][] stringArray = null;
        if (bl) {
            stringArray = new String[][]{{"forceFlag", ""}};
        }
        int n = 0;
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 2), this.createKeyValueTag(stringArray)});
        tag = this.irodsFunction(RODS_API_REQ, tag, 608);
        n = tag.getTag(MsgHeader_PI).getTag(bsLen).getIntValue();
        this.read(localFileOutputStream, n);
    }

    void mkdir(IRODSFile iRODSFile) throws IOException {
        if (iRODSFile == null) {
            throw new NullPointerException("Directory path cannot be null");
        }
        Tag tag = new Tag(CollInp_PI, new Tag[]{new Tag(collName, iRODSFile.getAbsolutePath()), this.createKeyValueTag(null)});
        this.irodsFunction(RODS_API_REQ, tag, 616);
    }

    void put(GeneralFileInputStream generalFileInputStream, long l, boolean bl, IRODSFile iRODSFile) throws IOException {
        String[][] stringArray = null;
        stringArray = bl ? new String[][]{{"dataType", iRODSFile.getDataType()}, {"forceFlag", ""}, {"destRescName", "demoResc"}, {"dataIncluded", ""}} : new String[][]{{"dataType", iRODSFile.getDataType()}, {"destRescName", iRODSFile.getResource()}, {"dataIncluded", ""}};
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 448), new Tag(openFlags, 1), new Tag(offset, 0), new Tag(dataSize, l), new Tag(numThreads, 0), new Tag(oprType, 1), this.createKeyValueTag(stringArray)});
        this.irodsFunction(RODS_API_REQ, tag, 0, null, l, generalFileInputStream, 606);
    }

    MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        int n2;
        int n3;
        Tag tag = new Tag(GenQueryInp_PI, new Tag[]{new Tag(maxRows, n), new Tag(continueInx, 0), this.createKeyValueTag(null)});
        Tag[] tagArray = null;
        int n4 = 1;
        if (metaDataSelectArray == null) {
            throw new NullPointerException("Query must have at least one select value");
        }
        tagArray = new Tag[metaDataSelectArray.length * 2 + 1];
        tagArray[0] = new Tag(iiLen, metaDataSelectArray.length);
        for (n3 = 0; n3 < metaDataSelectArray.length; ++n3) {
            tagArray[n4] = new Tag(inx, IRODSMetaDataSet.getID(metaDataSelectArray[n3].getFieldName()));
            ++n4;
        }
        for (n3 = 0; n3 < metaDataSelectArray.length; ++n3) {
            tagArray[n4] = new Tag(ivalue, metaDataSelectArray[n3].getOperation());
            ++n4;
        }
        tag.addTag(new Tag(InxIvalPair_PI, tagArray));
        if (metaDataConditionArray != null) {
            tagArray = new Tag[metaDataConditionArray.length * 2 + 1];
            tagArray[0] = new Tag(isLen, metaDataConditionArray.length);
            n4 = 1;
            for (n3 = 0; n3 < metaDataConditionArray.length; ++n3) {
                tagArray[n4] = new Tag(inx, IRODSMetaDataSet.getID(metaDataConditionArray[n3].getFieldName()));
                ++n4;
            }
            for (n3 = 0; n3 < metaDataConditionArray.length; ++n3) {
                tagArray[n4] = new Tag(svalue, " " + metaDataConditionArray[n3].getOperatorString() + " '" + metaDataConditionArray[n3].getStringValue() + "'");
                ++n4;
            }
            tag.addTag(new Tag(InxValPair_PI, tagArray));
        } else {
            tag.addTag(new Tag(InxValPair_PI, new Tag(isLen, 0)));
        }
        tag = this.irodsFunction(RODS_API_REQ, tag, 702);
        if (tag == null) {
            return null;
        }
        n3 = tag.getTag(rowCnt).getIntValue();
        int n5 = tag.getTag(attriCnt).getIntValue();
        int n6 = tag.getTag(continueInx).getIntValue();
        Object[] objectArray = new String[n5];
        MetaDataField[] metaDataFieldArray = new MetaDataField[n5];
        MetaDataRecordList[] metaDataRecordListArray = new MetaDataRecordList[n3];
        for (n2 = 0; n2 < n5; ++n2) {
            metaDataFieldArray[n2] = IRODSMetaDataSet.getField(tag.tags[4 + n2].getTag(attriInx).getStringValue());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n4 = 0; n4 < n5; ++n4) {
                objectArray[n4] = tag.tags[4 + n4].tags[2 + n2].getStringValue();
            }
            metaDataRecordListArray[n2] = new IRODSMetaDataRecordList(metaDataFieldArray, objectArray, n6);
        }
        return metaDataRecordListArray;
    }

    void rename(IRODSFile iRODSFile, IRODSFile iRODSFile2) throws IOException {
        Tag tag = new Tag(DataObjCopyInp_PI, new Tag[]{new Tag(DataObjInp_PI, new Tag[]{new Tag(collName, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 11), this.createKeyValueTag(null)}), new Tag(DataObjInp_PI, new Tag[]{new Tag(collName, iRODSFile2.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 11), this.createKeyValueTag(null)})});
        this.irodsFunction(RODS_API_REQ, tag, 627);
    }

    void replicate(IRODSFile iRODSFile, String string) throws IOException {
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 6), this.createKeyValueTag("destRescName", string)});
        this.irodsFunction(RODS_API_REQ, tag, 610);
    }

    String[] stat(IRODSFile iRODSFile) throws IOException {
        Tag tag = new Tag(DataObjInp_PI, new Tag[]{new Tag(objPath, iRODSFile.getAbsolutePath()), new Tag(createMode, 0), new Tag(openFlags, 0), new Tag(offset, 0), new Tag(dataSize, 0), new Tag(numThreads, 0), new Tag(oprType, 0), this.createKeyValueTag(null)});
        this.irodsFunction(RODS_API_REQ, tag, 633);
        String[] stringArray = null;
        return stringArray;
    }

    String executeRule(String string, String string2, String string3, Tag[] tagArray) throws IOException {
        if (string3 == null) {
            string3 = "";
        }
        Tag tag = new Tag(ExecMyRuleInp_PI, new Tag[]{new Tag(myRule, string), new Tag(RHostAddr_PI, new Tag[]{new Tag(hostAddr, ""), new Tag(rodsZone, ""), new Tag(port, 0)}), this.createKeyValueTag(null), new Tag(outParamDesc, string3), tagArray != null ? new Tag(MsParamArray_PI, tagArray) : null});
        int n = (tag = this.irodsFunction(RODS_API_REQ, tag, 625)).getTag(paramLen).getIntValue();
        if (n <= 0) {
            return null;
        }
        Tag[] tagArray2 = tag.getTags();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Tag tag2 = tagArray2[n2];
        }
        return null;
    }

    static {
        try {
            DEBUG = new Integer(System.getProperty("jargon.debug", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG = 0;
        }
        OUTPUT_BUFFER_LENGTH = 65535;
        tagList = new TreeMap();
    }

    class Tag
    implements Cloneable {
        String tagName;
        Tag[] tags;
        String value;

        Tag(String string) {
            this.tagName = string;
        }

        Tag(String string, int n) {
            this.tagName = string;
            this.value = "" + n;
        }

        Tag(String string, long l) {
            this.tagName = string;
            this.value = "" + l;
        }

        Tag(String string, String string2) {
            this.tagName = string;
            this.value = string2;
        }

        Tag(String string, Tag tag) {
            this(string, new Tag[]{tag});
        }

        Tag(String string, Tag[] tagArray) {
            this.tagName = string;
            this.tags = tagArray;
        }

        void setValue(int n) {
            this.value = "" + n;
        }

        void setValue(long l) {
            this.value = "" + l;
        }

        void setValue(String string) {
            this.value = string;
        }

        void setTagValues(Object[] objectArray) {
            if (objectArray instanceof Tag[]) {
                this.tags = (Tag[])objectArray;
            } else {
                if (this.tags.length != objectArray.length) {
                    throw new IllegalArgumentException("Schema mismatch " + this + " does not have these " + objectArray + "   " + objectArray.length + " values.");
                }
                for (int i = 0; i < this.tags.length; ++i) {
                    if (objectArray[i] instanceof String) {
                        this.tags[i].setValue((String)objectArray[i]);
                        continue;
                    }
                    if (objectArray[i] instanceof Tag) {
                        this.tags[i] = (Tag)objectArray[i];
                        continue;
                    }
                    if (objectArray[i] instanceof Object[]) {
                        this.tags[i].setTagValues((Object[])objectArray[i]);
                        continue;
                    }
                    throw new IllegalArgumentException("Protocol error: This " + objectArray[i] + " shouldn't be here");
                }
            }
        }

        Object getValue() {
            if (this.tags != null) {
                return this.tags.clone();
            }
            return this.value;
        }

        int getIntValue() {
            return Integer.parseInt(this.value);
        }

        String getStringValue() {
            return this.value;
        }

        String getName() {
            return this.tagName;
        }

        int getLength() {
            return this.tags.length;
        }

        Tag getTag(String string) {
            if (this.tags == null) {
                return null;
            }
            for (int i = 0; i < this.tags.length; ++i) {
                if (!this.tags[i].getName().equals(string)) continue;
                return this.tags[i];
            }
            return null;
        }

        Tag[] getTags() {
            if (this.tags != null) {
                return this.tags;
            }
            return null;
        }

        Object[] getTagValues() {
            if (this.tags == null) {
                return null;
            }
            Object[] objectArray = new Object[this.tags.length];
            for (int i = 0; i < this.tags.length; ++i) {
                objectArray[i] = this.tags[i].getValue();
            }
            return objectArray;
        }

        void addTag(String string, String string2) {
            this.addTag(new Tag(string, string2));
        }

        void addTag(Tag tag) {
            if (this.tags != null) {
                Tag[] tagArray = this.tags;
                this.tags = new Tag[tagArray.length + 1];
                System.arraycopy(tagArray, 0, this.tags, 0, tagArray.length);
                this.tags[tagArray.length] = tag;
            } else {
                this.tags = new Tag[]{tag};
            }
        }

        void addTags(Tag[] tagArray) {
            if (this.tags != null) {
                Tag[] tagArray2 = this.tags;
                this.tags = new Tag[tagArray2.length + tagArray.length];
                System.arraycopy(tagArray2, 0, this.tags, 0, tagArray2.length);
                System.arraycopy(tagArray, 0, this.tags, tagArray2.length, tagArray.length);
            } else {
                this.tags = tagArray;
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public boolean equals(Object object) {
            Tag tag;
            return object instanceof Tag && (tag = (Tag)object).getName().equals(this.tagName) && tag.getValue().equals(this.value) && tag.getTags().equals(this.tags);
        }

        public String toString() {
            return this.tagName;
        }

        String parseTag() {
            StringBuffer stringBuffer = new StringBuffer(IRODSCommands.OPEN_START_TAG + this.tagName + ">");
            if (this.tags != null) {
                for (int i = 0; i < this.tags.length; ++i) {
                    stringBuffer.append(this.tags[i].parseTag());
                }
            } else {
                stringBuffer.append(this.value);
            }
            stringBuffer.append(IRODSCommands.OPEN_END_TAG + this.tagName + ">" + "\n");
            return stringBuffer.toString();
        }
    }
}

