/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.irods.IRODSAccount;
import edu.sdsc.grid.io.irods.IRODSException;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;

public class IRODSFile
extends RemoteFile {
    public static final String PATH_SEPARATOR = "/";
    public static final char PATH_SEPARATOR_CHAR = '/';
    static final int PATH_IS_UNKNOWN = 0;
    static final int PATH_IS_FILE = 1;
    static final int PATH_IS_DIRECTORY = 2;
    IRODSFileSystem iRODSFileSystem;
    String resource;
    String dataType = "generic";
    boolean deleteOnExit = false;
    int pathNameType = 0;
    boolean useCache = false;

    public IRODSFile(IRODSFileSystem iRODSFileSystem, String string) {
        this(iRODSFileSystem, "", string);
    }

    public IRODSFile(IRODSFileSystem iRODSFileSystem, String string, String string2) {
        super(iRODSFileSystem, string, string2);
        this.resource = this.iRODSFileSystem.getDefaultStorageResource();
        this.makePathCanonical(string);
    }

    public IRODSFile(IRODSFile iRODSFile, String string) {
        this((IRODSFileSystem)iRODSFile.getFileSystem(), iRODSFile.getAbsolutePath(), string);
    }

    public IRODSFile(URI uRI) throws IOException, URISyntaxException {
        super(uRI);
        String string;
        String string2;
        String string3;
        String string4;
        if (uRI.getScheme().equals("irods")) {
            String string5 = uRI.getUserInfo();
            String string6 = uRI.getHost();
            int n = uRI.getPort();
            string4 = null;
            string3 = "";
            string2 = "";
            string = null;
            int n2 = -1;
            if (string5 == null || string5 == "") {
                throw new IllegalArgumentException("URI must have user info");
            }
            n2 = string5.indexOf(":");
            if (n2 >= 0) {
                string3 = string5.substring(n2 + 1);
                string5 = string5.substring(0, n2);
            }
            if ((n2 = string5.indexOf(".")) >= 0) {
                string4 = string5.substring(0, n2);
                string2 = string5.substring(n2 + 1);
                string = PATH_SEPARATOR + string2 + PATH_SEPARATOR + string4;
            } else {
                string4 = string5;
                string = uRI.getPath();
            }
        } else {
            throw new URISyntaxException(uRI.toString(), "Wrong URI scheme");
        }
        this.setFileSystem(new IRODSFileSystem(new IRODSAccount(uRI.getHost(), uRI.getPort(), string4, string3, string, string2, "")));
        this.iRODSFileSystem.setDefaultStorageResource(IRODSFile.getAvailableResource(this.iRODSFileSystem));
        this.setFileName(uRI.getPath());
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnExit) {
            this.delete();
        }
        super.finalize();
        if (this.resource != null) {
            this.resource = null;
        }
        if (this.dataType != null) {
            this.dataType = null;
        }
    }

    static String getAvailableResource(IRODSFileSystem iRODSFileSystem) throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = iRODSFileSystem.query(MetaDataSet.newSelection("Resource Name"));
        if (metaDataRecordListArray != null) {
            int n = (int)Math.round((double)(metaDataRecordListArray.length - 1) * Math.random());
            return metaDataRecordListArray[n].getValue("Resource Name").toString();
        }
        throw new FileNotFoundException("No resources available");
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
        this.iRODSFileSystem = (IRODSFileSystem)generalFileSystem;
    }

    protected void setFileName(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!string2.equals(PATH_SEPARATOR)) {
            n = string.lastIndexOf(string2);
            while (n >= 0 && string.substring(n + 1).length() > 0) {
                string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
                n = string.lastIndexOf(string2);
            }
        }
        this.fileName = string;
        if (this.fileName.length() > 1) {
            n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            while (n == this.fileName.length() - 1 && n >= 0) {
                this.fileName = this.fileName.substring(0, n);
                n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            }
            if (n >= 0 && this.fileName.substring(n + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, n + 1));
                this.fileName = this.fileName.substring(n + 1);
            }
        }
    }

    protected void setDirectory(String string) {
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        if (n >= 0 && string.substring(n + 1).length() > 0) {
            string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
            n = string.lastIndexOf(string2);
        }
        while (this.directory.size() > 0 && string.startsWith(PATH_SEPARATOR)) {
            string = string.substring(1);
        }
        n = string.indexOf(PATH_SEPARATOR);
        if (n >= 0) {
            do {
                this.directory.add(string.substring(0, n));
                while ((n = (string = string.substring(n + 1)).indexOf(PATH_SEPARATOR)) == 0) {
                }
            } while (n >= 0);
        }
        if (!string.equals("") && string != null) {
            this.directory.add(string);
        }
    }

    void makePathCanonical(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            string = "";
        }
        if (this.fileName.equals(PATH_SEPARATOR) && string == "") {
            return;
        }
        if (this.fileName.equals("") && string.equals("")) {
            String string3 = this.iRODSFileSystem.getHomeDirectory();
            int n2 = string3.lastIndexOf(separator);
            this.setDirectory(string3.substring(0, n2));
            this.setFileName(string3.substring(n2 + 1));
            return;
        }
        if (string.startsWith(PATH_SEPARATOR)) {
            bl = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            bl = true;
        }
        if (!bl) {
            String string4 = this.iRODSFileSystem.getHomeDirectory();
            int n3 = string4.indexOf(separator);
            if (n3 >= 0) {
                do {
                    this.directory.add(n, string4.substring(0, n3));
                    string4 = string4.substring(n3 + 1);
                    n3 = string4.indexOf(separator);
                    ++n;
                } while (n3 > 0);
            }
            if (!string4.equals("") && string4 != null) {
                this.directory.add(n, string4);
            }
        }
        for (n = 0; n < this.directory.size(); ++n) {
            string2 = this.directory.get(n).toString();
            if (string2.equals(".")) {
                this.directory.remove(n);
                --n;
                continue;
            }
            if (string2.equals("..") && n >= 2) {
                this.directory.remove(n);
                this.directory.remove(n - 1);
                if (--n <= 0) continue;
                --n;
                continue;
            }
            if (string2.equals("..")) {
                this.directory.remove(n);
                --n;
                continue;
            }
            if (!string2.startsWith(separator)) continue;
            while ((string2 = string2.substring(1)).startsWith(separator)) {
            }
            this.directory.remove(n);
            this.directory.add(n, string2);
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = separator;
                this.directory.remove(this.directory.size() - 1);
            }
        }
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public char getPathSeparatorChar() {
        return '/';
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        block8: {
            block7: {
                if (generalFile == null) {
                    throw new NullPointerException();
                }
                if (!this.isDirectory()) break block7;
                GeneralFile[] generalFileArray = this.listFiles();
                generalFile.mkdir();
                if (generalFileArray == null) break block8;
                for (int i = 0; i < generalFileArray.length; ++i) {
                    generalFileArray[i].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), generalFileArray[i].getName()), bl);
                }
                break block8;
            }
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            try {
                if (generalFile instanceof LocalFile) {
                    this.iRODSFileSystem.commands.get(this, (LocalFileOutputStream)FileFactory.newFileOutputStream(generalFile), bl);
                }
                if (generalFile instanceof IRODSFile) {
                    this.iRODSFileSystem.commands.copy(this, (IRODSFile)generalFile, bl);
                }
                super.copyTo(generalFile, bl);
            }
            catch (IRODSException iRODSException) {
                IOException iOException = new IOException();
                iOException.initCause(iRODSException);
                throw iOException;
            }
        }
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        block8: {
            block7: {
                if (generalFile == null) {
                    throw new NullPointerException();
                }
                if (!generalFile.isDirectory()) break block7;
                GeneralFile[] generalFileArray = generalFile.listFiles();
                this.mkdir();
                if (generalFileArray == null) break block8;
                for (int i = 0; i < generalFileArray.length; ++i) {
                    FileFactory.newFile(this, generalFileArray[i].getName()).copyFrom(generalFileArray[i], bl);
                }
                break block8;
            }
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile);
                return;
            }
            try {
                if (generalFile instanceof LocalFile) {
                    this.iRODSFileSystem.commands.put(FileFactory.newFileInputStream(generalFile), generalFile.length(), bl, this);
                }
                if (generalFile instanceof IRODSFile) {
                    this.iRODSFileSystem.commands.copy((IRODSFile)generalFile, this, bl);
                }
                super.copyTo(generalFile, bl);
            }
            catch (IRODSException iRODSException) {
                IOException iOException = new IOException();
                iOException.initCause(iRODSException);
                throw iOException;
            }
        }
    }

    public void setResource(String string) throws IOException, NullPointerException, IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.resource = string;
    }

    public String getResource() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        if (this.resource != null) {
            return this.resource;
        }
        return null;
    }

    public String getDataType() throws IOException {
        if (this.isDirectory()) {
            return this.dataType;
        }
        return "generic";
    }

    public void replicate(String string) throws IOException {
        this.iRODSFileSystem.commands.replicate(this, string);
    }

    public void changePermissions(String string, String string2, boolean bl) throws IOException {
        if (string == null) {
            string = "";
        }
        if ((string = string.toLowerCase()).equals("n") || string.equals("null")) {
            string = "";
        } else if (string.equals("r") || string.equals("read")) {
            string = "read";
        } else if (string.equals("w") || string.equals("write")) {
            string = "write";
        } else if (string.equals("all") || string.equals("ownership") || string.equals("own") || string.equals("o")) {
            string = "own";
        } else {
            throw new IllegalArgumentException("Permission type not valid: " + string);
        }
        this.iRODSFileSystem.commands.chmod(this, string, string2, bl);
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean createNewFile() throws IOException {
        block3: {
            try {
                if (!this.isFile()) {
                    this.getParentFile().mkdirs();
                    int n = this.iRODSFileSystem.commands.fileCreate(this);
                    this.iRODSFileSystem.commands.fileClose(n);
                    return true;
                }
            }
            catch (IRODSException iRODSException) {
                if (IRODSFileSystem.DEBUG <= 0) break block3;
                iRODSException.printStackTrace();
            }
        }
        return false;
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException, IllegalArgumentException {
        GeneralFile generalFile2;
        String string3 = "";
        for (int i = 0; i < 8; ++i) {
            string3 = string3 + (char)(65.0 + Math.random() * 25.0);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (generalFile == null) {
            IRODSFileSystem iRODSFileSystem = new IRODSFileSystem();
            generalFile = FileFactory.newFile((GeneralFileSystem)iRODSFileSystem, iRODSFileSystem.getHomeDirectory(), "temp");
            generalFile.mkdir();
        }
        if ((generalFile2 = FileFactory.newFile(generalFile, string + string3 + string2)).createNewFile()) {
            return generalFile2;
        }
        throw new IOException("The temp file already exists.");
    }

    public boolean delete() {
        try {
            if (this.isDirectory()) {
                this.iRODSFileSystem.commands.deleteDirectory(this);
            } else if (this.isFile(false)) {
                this.iRODSFileSystem.commands.deleteFile(this);
            }
            return true;
        }
        catch (IOException iOException) {
            if (IRODSFileSystem.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return false;
        }
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    public String getPath() {
        return this.getAbsolutePath();
    }

    public boolean equals(Object object) {
        block5: {
            try {
                if (object == null) {
                    return false;
                }
                if (object instanceof IRODSFile) {
                    IRODSFile iRODSFile = (IRODSFile)object;
                    if (iRODSFile.iRODSFileSystem.getHost().equals(this.iRODSFileSystem.getHost()) && iRODSFile.iRODSFileSystem.getPort() == this.iRODSFileSystem.getPort()) {
                        return this.getAbsolutePath().equals(iRODSFile.getAbsolutePath());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                if (IRODSFileSystem.DEBUG <= 0) break block5;
                classCastException.printStackTrace();
            }
        }
        return false;
    }

    public boolean exists() {
        block4: {
            try {
                MetaDataRecordList[] metaDataRecordListArray = null;
                int n = 0;
                MetaDataCondition[] metaDataConditionArray = null;
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getAbsolutePath())};
                metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (IRODSFileSystem.DEBUG <= 0) break block4;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            for (int i = 1; i < n; ++i) {
                string = string + separator + this.directory.get(i);
            }
            return string + separator + this.fileName;
        }
        return this.fileName;
    }

    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isDirectory() {
        if (this.useCache) {
            return this.isDirectory(false);
        }
        return this.isDirectory(true);
    }

    boolean isDirectory(boolean bl) {
        block6: {
            if (!bl && this.pathNameType != 0) {
                if (this.pathNameType == 1) {
                    return false;
                }
                if (this.pathNameType == 2) {
                    return true;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null && metaDataRecordListArray.length > 0) {
                    this.pathNameType = 2;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (IRODSFileSystem.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isFile() {
        if (this.useCache) {
            return this.isFile(false);
        }
        return this.isFile(true);
    }

    public boolean isFile(boolean bl) {
        block6: {
            if (this.pathNameType != 0 && !bl) {
                if (this.pathNameType == 1) {
                    return true;
                }
                if (this.pathNameType == 2) {
                    return false;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.getName())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
            try {
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    this.pathNameType = 1;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (IRODSFileSystem.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        long l = 0L;
        String string = null;
        try {
            string = this.firstQueryResult("file modification date");
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (IOException iOException) {
            if (IRODSFileSystem.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
        return l;
    }

    public String[] list() {
        return this.list(null);
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        MetaDataRecordList[] metaDataRecordListArray;
        MetaDataRecordList[] metaDataRecordListArray2;
        MetaDataRecordList[] metaDataRecordListArray3;
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name")};
        Vector<String> vector = null;
        MetaDataCondition[] metaDataConditionArray2 = null;
        if (metaDataConditionArray == null) {
            metaDataConditionArray2 = new MetaDataCondition[1];
        } else {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 1];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 1, metaDataConditionArray.length);
        }
        try {
            String string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray2[0] = MetaDataSet.newCondition("directory name", 0, string);
            metaDataRecordListArray3 = this.fileSystem.query(metaDataConditionArray2, metaDataSelectArray);
            metaDataSelectArray[0] = null;
            metaDataConditionArray2[0] = MetaDataSet.newCondition("parent directory name", 0, string);
            metaDataRecordListArray2 = this.iRODSFileSystem.query(metaDataConditionArray2, metaDataSelectArray);
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                for (int i = 0; i < metaDataRecordListArray2.length; ++i) {
                    string2 = metaDataRecordListArray2[i].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf(PATH_SEPARATOR) + 1);
                    metaDataRecordListArray2[i].setValue(0, string3);
                }
            }
        }
        catch (IOException iOException) {
            if (IRODSFileSystem.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        if (metaDataRecordListArray3 != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray = new MetaDataRecordList[metaDataRecordListArray3.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray3, 0, metaDataRecordListArray, 0, metaDataRecordListArray3.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray, metaDataRecordListArray3.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray3 != null) {
            metaDataRecordListArray = metaDataRecordListArray3;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        for (int i = 0; i < metaDataRecordListArray.length; ++i) {
            if (metaDataRecordListArray[i].getStringValue(0) == null) continue;
            vector.add(metaDataRecordListArray[i].getStringValue(0));
        }
        return vector.toArray(new String[0]);
    }

    public boolean mkdir() {
        block3: {
            try {
                if (!this.isDirectory()) {
                    this.iRODSFileSystem.commands.mkdir(this);
                    return true;
                }
            }
            catch (IOException iOException) {
                if (IRODSFileSystem.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException, NullPointerException {
        block7: {
            try {
                if (generalFile instanceof IRODSFile) {
                    try {
                        this.iRODSFileSystem.commands.rename(this, (IRODSFile)generalFile);
                        break block7;
                    }
                    catch (IOException iOException) {
                        if (!generalFile.exists()) {
                            this.copyTo(generalFile);
                            this.delete();
                            break block7;
                        }
                        return false;
                    }
                }
                if (!generalFile.exists()) {
                    this.copyTo(generalFile);
                    this.delete();
                    break block7;
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return new String("irods://" + this.iRODSFileSystem.getUserName() + "@" + this.iRODSFileSystem.getHost() + ":" + this.iRODSFileSystem.getPort() + this.getAbsolutePath());
    }
}

