/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.RemoteAccount;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SRBAccount
extends RemoteAccount {
    static final String PUBLIC_USERNAME = "public";
    static final String PUBLIC_DOMAINNAME = "npaci";
    static final String PUBLIC_PASSWORD = "CANDO";
    static final String PUBLIC_HOME_DIRECTORY = "/home/public.npaci/";
    public static final int PASSWD_AUTH = 48;
    public static final int GSI_AUTH = 51;
    public static final int ENCRYPT1 = 53;
    public static final int GSI_DELEGATE = 54;
    static final String extraVersionInfo = "jargon_v2.0.0beta";
    public static final String SRB_VERSION_3_5 = "SRB-3.5jargon_v2.0.0beta&G";
    public static final String SRB_VERSION_3_4 = "SRB-3.4jargon_v2.0.0beta&G";
    public static final String SRB_VERSION_3_3_1 = "SRB-3.3.1jargon_v2.0.0beta&G";
    public static final String SRB_VERSION_3_3 = "SRB-3.3jargon_v2.0.0beta&G";
    public static final String SRB_VERSION_3_0_2 = "SRB-3.0.2jargon_v2.0.0beta&F";
    public static final String SRB_VERSION_3 = "SRB-3.0.0jargon_v2.0.0beta&E";
    public static final String SRB_VERSION_2 = "SRB2.0.0jargon_v2.0.0beta&D";
    public static final String SRB_VERSION_1_1_8 = "SRB1.1.8jargon_v2.0.0beta&C";
    protected String proxyUserName;
    protected String proxyDomainName;
    protected String domainName;
    protected String defaultStorageResource;
    protected int options = 53;
    protected String proxyMcatZone;
    protected String clientMcatZone;
    protected String execFile;
    protected String certificateAuthority;
    protected Object gssCredential;
    protected static String version = "SRB-3.5jargon_v2.0.0beta&G";
    static HashMap versionNumber = new HashMap(10, 1.0f);

    static boolean systemPropertyVersion(String string) {
        String string2 = null;
        if (string != null) {
            if (string.equals(version)) {
                return false;
            }
            string2 = string;
        } else {
            string2 = System.getProperty("jargon.version");
            if (string2 == null) {
                return false;
            }
        }
        if (string2.startsWith("SRB-3.5") || string2.startsWith("SRB3.5") || string2.startsWith("3.5") || string2.startsWith("SRB-3.5") || string2.startsWith("SRB3.5") || string2.startsWith("3.5")) {
            if (version != SRB_VERSION_3_5) {
                version = SRB_VERSION_3_5;
                return true;
            }
        } else if (string2.startsWith("SRB-3.4") || string2.startsWith("SRB3.4") || string2.startsWith("3.4") || string2.startsWith("SRB-3.4") || string2.startsWith("SRB3.4") || string2.startsWith("3.4")) {
            if (version != SRB_VERSION_3_4) {
                version = SRB_VERSION_3_4;
                return true;
            }
        } else if (string2.startsWith("SRB-3.3.1") || string2.startsWith("SRB3.3.1") || string2.startsWith("3.3.1") || string2.startsWith("SRB-3.31") || string2.startsWith("SRB3.31") || string2.startsWith("3.31")) {
            if (version != SRB_VERSION_3_3_1) {
                version = SRB_VERSION_3_3_1;
                return true;
            }
        } else if (string2.startsWith("SRB-3.3") || string2.startsWith("SRB3.3") || string2.startsWith("3.3")) {
            if (version != SRB_VERSION_3_3) {
                version = SRB_VERSION_3_3;
                return true;
            }
        } else if (string2.startsWith("SRB-3.2") || string2.startsWith("SRB3.2") || string2.startsWith("3.2")) {
            if (version != SRB_VERSION_3_0_2) {
                version = SRB_VERSION_3_0_2;
                return true;
            }
        } else if (string2.startsWith("SRB-3.0.2") || string2.startsWith("SRB3.0.2") || string2.startsWith("3.0.2")) {
            if (version != SRB_VERSION_3_0_2) {
                version = SRB_VERSION_3_0_2;
                return true;
            }
        } else if (string2.startsWith("SRB-3") || string2.startsWith("SRB3") || string2.startsWith("3")) {
            if (version != SRB_VERSION_3) {
                version = SRB_VERSION_3;
                return true;
            }
        } else if (string2.startsWith("SRB-2") || string2.startsWith("SRB2") || string2.startsWith("2")) {
            if (version != SRB_VERSION_2) {
                version = SRB_VERSION_2;
                return true;
            }
        } else if ((string2.startsWith("SRB-1") || string2.startsWith("SRB1") || string2.startsWith("1")) && version != SRB_VERSION_1_1_8) {
            version = SRB_VERSION_1_1_8;
            return true;
        }
        return false;
    }

    public SRBAccount() throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        LocalFile localFile = new LocalFile(System.getProperty("user.home") + "/.srb/");
        if (!localFile.exists()) {
            localFile = new LocalFile(System.getProperty("user.home") + "/srb/");
        }
        if (!localFile.exists()) {
            throw new FileNotFoundException("Cannot find default srb account info");
        }
        this.setUserInfo(localFile);
    }

    public SRBAccount(String string) throws FileNotFoundException, IOException {
        this(new LocalFile(string));
    }

    public SRBAccount(File file) throws FileNotFoundException, IOException {
        this(new LocalFile(file));
    }

    public SRBAccount(GeneralFile generalFile) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (generalFile.equals(null)) {
            throw new NullPointerException("UserInfoDirectory cannot be null");
        }
        this.setUserInfo(generalFile);
    }

    public SRBAccount(String string, String string2) throws FileNotFoundException, IOException {
        this(new LocalFile(string), new LocalFile(string2));
    }

    public SRBAccount(File file, File file2) throws FileNotFoundException, IOException {
        this(new LocalFile(file), new LocalFile(file2));
    }

    public SRBAccount(GeneralFile generalFile, GeneralFile generalFile2) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (generalFile.equals(null) || generalFile2.equals(null)) {
            throw new NullPointerException("Mdas files cannot be null");
        }
        this.setMdasUserInfo(generalFile);
        this.readMdasAuth(generalFile2);
    }

    public SRBAccount(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        super(string, n, string2, string3, string4);
        this.setProxyUserName(string2);
        this.setProxyDomainName(string5);
        this.setDomainName(string5);
        this.setDefaultStorageResource(string6);
    }

    public SRBAccount(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, n, string2, string3, string4);
        this.setProxyUserName(string2);
        this.setProxyDomainName(string5);
        this.setDomainName(string5);
        this.setDefaultStorageResource(string6);
        this.setProxyMcatZone(string7);
        this.setMcatZone(string7);
    }

    public SRBAccount(String string, int n, Object object) {
        super(string, n, null, null, "");
        this.setGSSCredential(object);
    }

    public SRBAccount(String string, int n, Object object, String string2, String string3, int n2) {
        super(string, n, null, null, string2);
        this.setGSSCredential(object);
        this.setOptions(n2);
        this.setDefaultStorageResource(string3);
    }

    protected void finalize() {
        super.finalize();
        this.proxyUserName = null;
        this.proxyDomainName = null;
        this.domainName = null;
        this.defaultStorageResource = null;
    }

    public void setHomeDirectory(String string) {
        if (string == null) {
            throw new NullPointerException("The home directory string cannot be null");
        }
        this.homeDirectory = string;
    }

    public String getHomeDirectory() throws NullPointerException {
        if (this.homeDirectory != null) {
            return this.homeDirectory;
        }
        String string = "/home/";
        if (this.userName != null && this.domainName != null) {
            string = string + this.userName + "." + this.domainName;
        }
        return string;
    }

    public void setPort(int n) {
        this.port = n > 0 ? n : 5544;
    }

    protected void setProxyUserName(String string) {
        if (string == null) {
            throw new NullPointerException("The proxy user name cannot be null");
        }
        this.proxyUserName = string;
    }

    protected void setProxyDomainName(String string) {
        if (string == null) {
            throw new NullPointerException("The proxy domain name cannot be null");
        }
        this.proxyDomainName = string;
    }

    public void setDomainName(String string) {
        if (string == null) {
            throw new NullPointerException("The domain name cannot be null");
        }
        this.domainName = string;
    }

    public void setDefaultStorageResource(String string) {
        if (string == null) {
            throw new NullPointerException("The default storage resource cannot be null");
        }
        this.defaultStorageResource = string;
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public static void setVersion(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid version");
        }
        if (versionNumber.get(string) == null) {
            throw new IllegalArgumentException("Invalid version");
        }
        version = string;
    }

    public void setProxyMcatZone(String string) {
        this.proxyMcatZone = string;
    }

    public void setMcatZone(String string) {
        this.clientMcatZone = string;
    }

    public void setExecFile(String string) {
        this.execFile = string;
    }

    public void setCertificateAuthority(String string) {
        this.certificateAuthority = string;
    }

    public void setGSSCredential(Object object) {
        this.gssCredential = object;
        if (object == null) {
            return;
        }
        if (this.options != 51 || this.options != 54) {
            this.options = 51;
        }
    }

    protected String getProxyUserName() {
        return this.proxyUserName;
    }

    protected String getProxyDomainName() {
        return this.proxyDomainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public int getOptions() {
        return this.options;
    }

    public static String getVersion() {
        return version;
    }

    static float getVersionNumber() {
        return ((Float)versionNumber.get(version)).floatValue();
    }

    public String getProxyMcatZone() {
        return this.proxyMcatZone;
    }

    public String getMcatZone() {
        return this.clientMcatZone;
    }

    public String getExecFile() {
        return this.execFile;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public Object getGSSCredential() {
        return this.gssCredential;
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    boolean equals(Object object, boolean bl) {
        try {
            if (object == null) {
                return false;
            }
            SRBAccount sRBAccount = (SRBAccount)object;
            if (!this.getHost().equals(sRBAccount.getHost())) {
                return false;
            }
            if (this.getPort() != sRBAccount.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(sRBAccount.getUserName())) {
                return false;
            }
            if (!this.getPassword().equals(sRBAccount.getPassword())) {
                return false;
            }
            if (!(this.getOptions() != 51 && this.getOptions() != 54 || this.getCertificateAuthority().equals(sRBAccount.getCertificateAuthority()))) {
                return false;
            }
            if (!this.getProxyUserName().equals(sRBAccount.getProxyUserName())) {
                return false;
            }
            if (!this.getProxyDomainName().equals(sRBAccount.getProxyDomainName())) {
                return false;
            }
            if (!this.getDomainName().equals(sRBAccount.getDomainName())) {
                return false;
            }
            return SRBAccount.getVersion().equals(SRB_VERSION_2) || SRBAccount.getVersion().equals(SRB_VERSION_1_1_8) || !bl || this.getProxyMcatZone().equals(sRBAccount.getProxyMcatZone()) || this.getMcatZone().equals(sRBAccount.getMcatZone());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return new String("srb://" + this.getUserName() + "." + this.getDomainName() + "@" + this.getHost() + ":" + this.getPort());
    }

    public void setUserInfo(GeneralFile generalFile) throws FileNotFoundException, IOException {
        GeneralFile generalFile2 = FileFactory.newFile(generalFile, ".MdasEnv");
        if (!generalFile2.exists()) {
            generalFile2 = FileFactory.newFile(generalFile, "MdasEnv");
        }
        this.setMdasUserInfo(generalFile2);
        generalFile2 = FileFactory.newFile(generalFile, ".MdasAuth");
        if (!generalFile2.exists()) {
            generalFile2 = FileFactory.newFile(generalFile, "MdasAuth");
        }
        this.readMdasAuth(generalFile2);
    }

    public void setMdasUserInfo(GeneralFile generalFile) throws FileNotFoundException, IOException {
        int n = 0;
        GeneralFileInputStream generalFileInputStream = null;
        try {
            generalFileInputStream = FileFactory.newFileInputStream(generalFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!version.equals(SRB_VERSION_2) && !version.equals(SRB_VERSION_1_1_8)) {
                this.setProxyUserName("ticketuser");
                this.setUserName("ticketuser");
                this.setHomeDirectory("/home/public.npaci");
                this.setPassword("");
                return;
            }
            throw fileNotFoundException;
        }
        byte[] byArray = new byte[(int)generalFile.length()];
        generalFileInputStream.read(byArray);
        String string = new String(byArray);
        while (n >= 0) {
            if ((n = string.indexOf("#", n)) < 0) continue;
            string = string.substring(0, n) + string.substring(string.indexOf(10, n + 1), string.length());
        }
        n = string.indexOf("srbHost");
        if (n < 0) {
            throw new NullPointerException("No host name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setHost(string.substring(n, string.indexOf(39, n)));
        n = string.indexOf("srbPort");
        if (n < 0) {
            this.setPort(5544);
        } else {
            n = string.indexOf(39, n) + 1;
            this.setPort(Integer.parseInt(string.substring(n, string.indexOf(39, n))));
        }
        n = string.indexOf("srbUser");
        if (n < 0) {
            throw new NullPointerException("No user name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setProxyUserName(string.substring(n, string.indexOf(39, n)));
        this.setUserName(this.proxyUserName);
        n = string.indexOf("mdasDomain");
        if (n < 0) {
            throw new NullPointerException("No home domain name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setProxyDomainName(string.substring(n, string.indexOf(39, n)));
        this.setDomainName(this.proxyDomainName);
        n = string.indexOf("defaultResource");
        if (n < 0) {
            throw new NullPointerException("No default resource found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setDefaultStorageResource(string.substring(n, string.indexOf(39, n)));
        n = string.indexOf("AUTH_SCHEME");
        if (n < 0) {
            this.setOptions(53);
        } else {
            String string2 = null;
            string2 = string.substring(n = string.indexOf(39, n) + 1, string.indexOf(39, n));
            if (string2.equals("PASSWD_AUTH")) {
                this.setOptions(48);
            } else if (string2.equals("GSI_AUTH")) {
                this.setOptions(51);
            } else if (string2.equals("ENCRYPT1")) {
                this.setOptions(53);
            } else {
                if (string2.equals("SEA_AUTH")) {
                    throw new IllegalArgumentException("SEA_AUTH not supported");
                }
                if (string2.equals("SEA_ENCRYPT")) {
                    throw new IllegalArgumentException("SEA_ENCRYPT not supported");
                }
                if (string2.equals("GSI_SECURE_COMM")) {
                    throw new IllegalArgumentException("GSI_SECURE_COMM not supported");
                }
            }
        }
        n = string.indexOf("mcatZone");
        if (n >= 0) {
            n = string.indexOf(39, n) + 1;
            this.setProxyMcatZone(string.substring(n, string.indexOf(39, n)));
        }
        this.setMcatZone(this.proxyMcatZone);
        n = string.indexOf("execFile");
        if (n >= 0) {
            n = string.indexOf(39, n) + 1;
            this.setDefaultStorageResource(string.substring(n, string.indexOf(39, n)));
        }
        if ((n = string.indexOf("mdasCollection")) < 0) {
            if (this.proxyMcatZone == null) {
                this.setHomeDirectory(SRBFile.separator + this.proxyMcatZone + SRBFile.separator + "home" + SRBFile.separator + this.userName + "." + this.domainName);
            } else {
                this.setHomeDirectory(SRBFile.separator + "home" + SRBFile.separator + this.userName + "." + this.domainName);
            }
        } else {
            n = string.indexOf(39, n) + 1;
            this.setHomeDirectory(string.substring(n, string.indexOf(39, n)));
        }
        n = string.indexOf("srbVersion");
        if (n > 0) {
            n = string.indexOf(39, n) + 1;
            SRBAccount.setVersion(string.substring(n, string.indexOf(39, n)));
        }
    }

    public void readMdasAuth(GeneralFile generalFile) throws FileNotFoundException, IOException {
        int n = 0;
        GeneralFileInputStream generalFileInputStream = FileFactory.newFileInputStream(generalFile);
        byte[] byArray = new byte[(int)generalFile.length()];
        generalFileInputStream.read(byArray);
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator") + "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            n = string2.indexOf(System.getProperty("line.separator")) + string2.indexOf("\n") + 1;
            if (n >= 0) {
                string = string2.substring(0, n);
                continue;
            }
            string = string2;
        }
        this.setPassword(string);
    }

    static {
        versionNumber.put(SRB_VERSION_3_5, new Float(3.5));
        versionNumber.put(SRB_VERSION_3_4, new Float(3.4));
        versionNumber.put(SRB_VERSION_3_3_1, new Float(3.31));
        versionNumber.put(SRB_VERSION_3_3, new Float(3.3));
        versionNumber.put(SRB_VERSION_3_0_2, new Float(3.0f));
        versionNumber.put(SRB_VERSION_2, new Float(2.0f));
        versionNumber.put(SRB_VERSION_1_1_8, new Float(1.0f));
        SRBAccount.systemPropertyVersion(null);
    }
}

