/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.GSIAuth;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataCommands;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Date;

class SRBCommands {
    static int DEBUG = 0;
    static final char STATUS_OK = '\u0000';
    public static final int CHAR_LENGTH = 2;
    public static final int SHORT_LENGTH = 2;
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;
    private static final int ERROR_MSG_LENGTH = 4096;
    private static final String STARTUP_HEADER = "START SRB\u0000";
    static int OUTPUT_BUFFER_LENGTH;
    private static final int ENCRYPT1_MESSAGE_SIZE = 64;
    private static final int OPR_COMMAND = 1;
    private static final int F_E_CREATE = 1000;
    private static final int F_E_OPEN = 1001;
    private static final int F_E_CLOSE = 1002;
    private static final int F_E_UNLINK = 1003;
    private static final int F_E_READ = 1004;
    private static final int F_E_WRITE = 1005;
    private static final int F_E_SEEK = 1006;
    private static final int F_E_SYNC = 1007;
    private static final int F_E_STAT = 1008;
    private static final int F_E_MKDIR = 1009;
    private static final int F_E_CHMOD = 1010;
    private static final int F_E_RMDIR = 1011;
    private static final int F_E_OPENDIR = 1012;
    private static final int F_E_READDIR = 1013;
    private static final int F_E_CLOSEDIR = 1014;
    private static final int F_E_SETSTORATTRI = 1015;
    private static final int F_E_MIGRATE = 1016;
    private static final int F_E_STAGE = 1017;
    private static final int F_E_PURGE = 1018;
    private static final int F_E_FSTAT = 1019;
    private static final int F_E_CHKSUM = 1020;
    private static final int F_E_GET_FS_FREESPACE = 1021;
    private static final int F_E_FSTAGE = 1022;
    private static final int F_E_LOCK_RANGE = 1023;
    private static final int F_E_CHOWN = 1024;
    private static final int F_E_VAULT_INFO = 1050;
    private static final int F_GET_SVR_VER = 1051;
    private static final int F_SRBO_CREATE = 2000;
    private static final int F_SRBO_OPEN = 2001;
    private static final int F_SRBO_CLOSE = 2002;
    private static final int F_SRBO_UNLINK = 2003;
    private static final int F_SRBO_READ = 2004;
    private static final int F_SRBO_WRITE = 2005;
    private static final int F_SRBO_SEEK = 2006;
    private static final int F_SRBO_SYNC = 2007;
    private static final int F_SRBO_STAT = 2008;
    private static final int F_SRBO_REPLICATE = 2009;
    private static final int F_SRBO_MOVE = 2010;
    private static final int F_SRBO_PROXY_OPR = 2011;
    private static final int F_SRBO_GET_DENTS = 2012;
    private static final int F_SRBO_GET_DENTS64 = 2013;
    private static final int F_SRBC_SEEK = 2014;
    private static final int F_SRBO_CHKSUM = 2015;
    private static final int F_SRBO_LOCK_RANGE = 2016;
    private static final int F_SRBO_PROC = 2017;
    private static final int F_SRBO_GET_LOID_INFO = 2100;
    static final int F_SRBO_GET_DATADIR_INFO = 2101;
    private static final int F_SRBO_REGISTER_FILE = 2102;
    private static final int F_SRBO_MODIFY_FILE = 2103;
    private static final int F_CHK_MDAS_AUTH = 2104;
    private static final int F_CREATE_DIRECTORY = 2105;
    private static final int F_LIST_DIRECTORY = 2106;
    private static final int F_MODIFY_DIRECTORY = 2107;
    private static final int F_CHK_MDAS_SYS_AUTH = 2108;
    private static final int F_REGISTER_USER_GROUP = 2109;
    private static final int F_REGISTER_USER = 2110;
    private static final int F_MODIFY_USER = 2111;
    private static final int F_SET_AUDIT_TRAIL = 2112;
    private static final int F_SRBO_AUDIT = 2113;
    private static final int F_REGISTER_REPLICA = 2114;
    private static final int F_GET_PRIV_USERS = 2115;
    private static final int F_GET_MORE_ROWS = 2116;
    private static final int F_ISSUE_TICKET = 2117;
    private static final int F_REMOVE_TICKET = 2118;
    private static final int F_UNREGISTER_FILE = 2119;
    private static final int F_CONTAINER_CREATE = 2120;
    private static final int F_REGISTER_CONTAINER = 2121;
    private static final int F_REGISTER_IN_CONTAINER = 2122;
    private static final int F_GET_CONTAINER_INFO = 2123;
    private static final int F_GET_RESC_ON_CHOICE = 2124;
    private static final int F_REMOVE_CONTAINER = 2125;
    private static final int F_SYNC_CONTAINER = 2126;
    private static final int F_REPLICATION_CONTAINER = 2127;
    private static final int F_CHK_ENCRYPT1_AUTH = 2128;
    private static final int F_SRBO_LOCK = 2129;
    private static final int F_CONTAINER_OPEN = 2130;
    private static final int F_CONTAINER_CLOSE = 2131;
    private static final int F_FILE_COPY = 2132;
    private static final int F_SRBO_COPY = 2133;
    private static final int F_FILE_PUT = 2134;
    private static final int F_SRBO_PUT = 2135;
    private static final int F_FILE_GET = 2136;
    private static final int F_SRBO_GET = 2137;
    private static final int F_BULK_REGISTER = 2138;
    private static final int F_SRBO_SYNC_DATA = 2139;
    private static final int F_MOD_RESC_INFO = 2140;
    private static final int F_SRBO_REG_FILE_INT = 2141;
    private static final int F_REGISTER_LOCATION = 2142;
    private static final int F_INGEST_TOKEN = 2143;
    private static final int F_REGISTER_RESOURCE = 2144;
    private static final int F_REGISTER_LOGICAL_RESOURCE = 2145;
    private static final int F_REGISTER_REPLICATE_RESOURCE_INFO = 2146;
    private static final int F_DELETE_VALUE = 2147;
    private static final int F_SETUP_SESSION = 2148;
    private static final int F_SETUP_SESSION_PUBLIC_KEY = 2149;
    private static final int F_BULK_LOAD = 2150;
    private static final int F_GET_MCAT_NAME = 2151;
    private static final int F_MODIFY_ZONE = 2152;
    private static final int F_BULK_QUERY_ANSWER = 2153;
    private static final int F_BULK_MCAT_INGEST = 2154;
    static final int F_GEN_QUERY = 2155;
    private static final int F_BULK_UNLOAD = 2156;
    private static final int F_GEN_GET_MORE_ROWS = 2157;
    private static final int F_BULK_UNLOAD_C = 2158;
    private static final int F_BACKUP_DATA = 2159;
    private static final int F_REMOVE_TICKET_WITH_ZONE = 2160;
    private static final int F_MODIFY_USER_NP = 2161;
    private static final int F_MODIFY_RESOURCE = 2162;
    private static final int F_SRBO_GET_C = 2163;
    private static final int F_DATA_GET_C = 2164;
    private static final int F_SRBO_PUT_C = 2165;
    private static final int F_DATA_PUT_C = 2166;
    private static final int F_SRBO_FSTAGE = 2167;
    private static final int F_MODIFY_EXT_META_DATA = 2168;
    private static final int F_GET_USER_BY_DN = 2169;
    private static final int F_GET_HOST_CONFIG = 2200;
    private static final int F_DB_LOBJ_CREATE = 3000;
    private static final int F_DB_LOBJ_OPEN = 3001;
    private static final int F_DB_LOBJ_CLOSE = 3002;
    private static final int F_DB_LOBJ_READ = 3004;
    private static final int F_DB_LOBJ_WRITE = 3005;
    private static final int F_DB_LOBJ_SEEK = 3006;
    private static final int F_DB_LOBJ_UNLINK = 3007;
    private static final int F_DB_TABLE_CREATE = 4000;
    private static final int F_DB_TABLE_OPEN = 4001;
    private static final int F_DB_TABLE_CLOSE = 4002;
    private static final int F_DB_TABLE_READ = 4004;
    private static final int F_DB_TABLE_WRITE = 4005;
    private static final int F_DB_TABLE_SEEK = 4006;
    private static final int F_DB_TABLE_UNLINK = 4007;
    private static final int F_TAPELIB_MNT_CART = 5000;
    private static final int F_TAPELIB_DISMNT_CART = 5001;
    private static final int F_TAPELIB_GET_CART_PRI = 5002;
    private static final int F_CMP_DUMP_FILE_LIST = 5100;
    private static final int F_CMP_STAGE_COMP_OBJ = 5101;
    private static final int F_CMP_REG_INT_COMP_OBJ = 5102;
    private static final int F_CMP_RM_INT_COMP_OBJ = 5103;
    private static final int F_CMP_RM_COMP_OBJ = 5104;
    private static final int F_CMP_MOD_INT_COMP_OBJ = 5105;
    private static final int F_MDRIVER_CREATE = 6000;
    private static final int F_MDRIVER_OPEN = 6001;
    private static final int F_MDRIVER_CLOSE = 6002;
    private static final int F_MDRIVER_READ = 6004;
    private static final int F_MDRIVER_WRITE = 6005;
    private static final int F_MDRIVER_SEEK = 6006;
    private static final int F_MDRIVER_UNLINK = 6007;
    private static final int F_MDRIVER_SYNC = 6008;
    private static final int F_MDRIVER_PROC = 6009;
    private static final int NEW_PORTLIST = 888888;
    private static final int F_DUMMY = 999999;
    static final int MSG_USE_SINGLE_PORT = -99999999;
    static boolean singleServerPort;
    private long date;
    private Socket connection;
    private InputStream in = null;
    private OutputStream out = null;
    private byte[] outputBuffer = new byte[OUTPUT_BUFFER_LENGTH];
    private int outputOffset = 0;
    private SRBAccount account;
    private String zone;
    float versionNumber;
    boolean singlePortBulkUnload = false;
    int srbGetDataDirInfoCount = 0;
    long totalBytesMoved = 0L;
    long bytesMoved = 0L;
    long srcLength;
    static final int MAX_THREADS = 32;
    static final int READ = 1;
    static final int WRITE = 2;
    static final int PUT = 3;
    static final int GET = 4;
    static final int DONE = 0;

    SRBCommands() throws IOException {
    }

    protected void finalize() throws IOException {
        if (this.outputBuffer != null) {
            this.outputBuffer = null;
        }
        this.close();
        if (this.out != null) {
            this.out = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.connection != null) {
            this.connection = null;
        }
    }

    int connect(SRBAccount sRBAccount, byte[] byArray) throws IOException {
        int n = -1;
        String string = sRBAccount.getHost();
        int n2 = sRBAccount.getPort();
        this.versionNumber = sRBAccount.getVersionNumber();
        this.zone = sRBAccount.getMcatZone();
        this.account = (SRBAccount)sRBAccount.clone();
        if (DEBUG > 1) {
            this.date = new Date().getTime();
            System.err.println("Connecting to master server, " + string + ":" + n2 + " running version: " + this.versionNumber + " as username@domain: " + sRBAccount.getUserName() + "@" + sRBAccount.getDomainName() + "\ntime: " + this.date);
        }
        this.openSocket(string, n2);
        this.send(STARTUP_HEADER.getBytes());
        this.flush();
        if (this.versionNumber >= 3.3f) {
            byte[] byArray2 = this.read(4);
            n2 = Host.castToInt(byArray2);
            if (n2 == 0) {
                byArray2 = this.read(4);
                n2 = Host.castToInt(byArray2);
            }
        } else {
            byte[] byArray3 = this.read(4);
            n2 = Host.castToInt(byArray3);
        }
        if (n2 < 0) {
            this.close();
            throw new ProtocolException("connect() -- couldn't read port number: " + n2);
        }
        if (n2 > 0) {
            this.close();
            if (DEBUG > 1) {
                System.err.println("Redirected by srbMaster to srbServer:" + n2);
            }
            this.openSocket(string, n2);
        } else if (DEBUG > 1) {
            System.err.println("Connecting to srbServer through srbMaster server.");
        }
        return this.sendUserInfo(sRBAccount, byArray, n2);
    }

    int sendUserInfo(SRBAccount sRBAccount, byte[] byArray, int n) throws IOException {
        int n2 = -1;
        String string = sRBAccount.getPassword();
        this.send(byArray);
        this.flush();
        byte[] byArray2 = this.read(4);
        n2 = Host.castToInt(byArray2);
        if (n2 < 0) {
            this.close();
            return n2;
        }
        this.outputBuffer = new byte[OUTPUT_BUFFER_LENGTH];
        if (DEBUG > 1) {
            System.err.println("Sending password...");
        }
        if (sRBAccount.getUserName().equals(SRBFileSystem.TICKET_USER) && sRBAccount.getDomainName().equals(SRBFileSystem.TICKET_USER_DOMAIN)) {
            return n;
        }
        switch (sRBAccount.getOptions()) {
            case 48: {
                if (string == null) {
                    throw new IllegalArgumentException("Password cannot be null");
                }
                this.send(string);
                break;
            }
            case 51: {
                new GSIAuth(sRBAccount, this.connection, this.out, this.in);
                break;
            }
            case 54: {
                new GSIAuth(sRBAccount, this.connection, this.out, this.in);
                break;
            }
            case 53: {
                if (string == null) {
                    throw new IllegalArgumentException("Password cannot be null");
                }
                this.sendEncrypt1Auth(string);
                break;
            }
            case -1: {
                break;
            }
            default: {
                if (string == null) {
                    throw new IllegalArgumentException("Password cannot be null");
                }
                this.send(string);
            }
        }
        this.flush();
        byArray2 = this.read(4);
        n2 = Host.castToInt(byArray2);
        if (n2 == -1004 || n2 == -1005 || n2 == -1006 || n2 == -1017) {
            SRBException sRBException = new SRBException("connect() -- couldn't connect to SRB. ", n2);
            throw new SecurityException(sRBException.getMessage() + sRBException.getStandardMessage());
        }
        if (n2 == -1006 || n2 == -1017) {
            SRBException sRBException = new SRBException("connect() -- couldn't connect to SRB. If this is not you home zone, it may be down?", n2);
            throw new SecurityException(sRBException.getMessage() + sRBException.getStandardMessage());
        }
        if (n2 < 0) {
            this.close();
            return n2;
        }
        boolean bl = SRBAccount.systemPropertyVersion(this.srbGetSvrVersion());
        if (bl) {
            this.versionNumber = sRBAccount.getVersionNumber();
        }
        if (n2 == -1004 || n2 == -1005 || n2 == -1006 || n2 == -1017) {
            SRBException sRBException = new SRBException("connect() -- couldn't connect to SRB. ", n2);
            throw new SecurityException(sRBException.getMessage() + sRBException.getStandardMessage());
        }
        if (n2 < 0) {
            this.close();
            throw new SRBException("connect() -- couldn't connect to SRB. ", n2);
        }
        if (bl) {
            return -1118;
        }
        if (DEBUG > 1) {
            System.err.println("Successful connection. Time to connect: " + (this.date - new Date().getTime()));
            this.date = new Date().getTime();
        }
        return n;
    }

    synchronized void close() throws IOException {
        if (this.isConnected()) {
            this.out.write(new String("X").getBytes());
            this.out.close();
            this.in.close();
            this.connection.close();
        }
    }

    synchronized boolean isClosed() throws IOException {
        if (this.connection == null) {
            return true;
        }
        if (this.connection.isClosed()) {
            return true;
        }
        if (this.out == null) {
            return true;
        }
        return this.in == null;
    }

    void sendEncrypt1Auth(String string) throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = 0L;
        long l2 = 0L;
        long l3 = 64L;
        double d = 2.6035084875658576;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        byte[] byArray = new byte[64];
        int[] nArray = new int[63];
        this.in.read(byArray, 0, 63);
        for (int i = 0; i < 63; ++i) {
            nArray[i] = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
        }
        this.read(1);
        if (string != null) {
            int n4;
            int[] nArray2 = new int[string.length()];
            byte[] byArray2 = string.getBytes();
            for (n4 = 0; n4 < nArray2.length; ++n4) {
                nArray2[n4] = byArray2[n4];
            }
            SRBCommands.vHashString(lArray, nArray2);
            SRBCommands.vHashString(lArray2, nArray);
            l3 = 0x3FFFFFFFL;
            d = l3;
            l = (lArray[0] ^ lArray2[0]) % l3;
            l2 = (lArray[1] ^ lArray2[1]) % l3;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                l = (l * 3L + l2) % l3;
                l2 = (l + l2 + 33L) % l3;
                byArray[n4] = (byte)(Math.floor((double)l / d * 31.0) + 64.0);
            }
        }
        this.send(byArray, 0, byArray.length);
        if (byArray.length != 64 && DEBUG > 1) {
            System.err.println("bytes written," + byArray.length + " != ENCRYPT1_MESSAGE_SIZE," + 64);
        }
    }

    static void vHashString(long[] lArray, int[] nArray) {
        long l = 1345345333L;
        long l2 = 7L;
        long l3 = 305419889L;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            long l4 = l << 8;
            long l5 = 0x100000000L;
            if (l4 > l5) {
                l4 = (int)l4;
            }
            if (l4 < -l5) {
                l4 = l5 + l4;
            }
            if ((l ^= ((l & 0x3FL) + l2) * (long)n + l4) < 0L) {
                l = l5 + l;
            }
            if ((l4 = l3 << 8) > l5) {
                l4 = (int)l4;
            }
            if (l4 < 0L) {
                l4 = l5 + l4;
            }
            if ((l3 += l4 ^ l) > l5) {
                l3 = (int)l3;
            }
            if (l3 < 0L) {
                l3 = l5 + l3;
            }
            l2 += (long)n;
        }
        lArray[0] = l & Integer.MAX_VALUE;
        lArray[1] = l3 & Integer.MAX_VALUE;
    }

    String getZone() {
        return this.zone;
    }

    private void openSocket(String string, int n) throws IOException {
        try {
            this.connection = new Socket(string, n);
            this.in = this.connection.getInputStream();
            this.out = this.connection.getOutputStream();
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException("Connection cannot be made to: " + string + " at port: " + n);
            connectException2.initCause(connectException);
            throw connectException2;
        }
        catch (SocketException socketException) {
            SocketException socketException2 = new SocketException("A socket error occured when connecting to: " + string + " at port: " + n);
            socketException2.initCause(socketException);
            throw socketException2;
        }
    }

    boolean isConnected() {
        block3: {
            try {
                if (this.connection != null && this.connection.isConnected() && !this.connection.isClosed()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (DEBUG <= 0) break block3;
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void send(byte[] byArray) throws IOException {
        if (byArray.length + this.outputOffset >= OUTPUT_BUFFER_LENGTH) {
            this.out.write(this.outputBuffer, 0, this.outputOffset);
            this.out.write(byArray);
            this.out.flush();
            this.outputOffset = 0;
        } else {
            System.arraycopy(byArray, 0, this.outputBuffer, this.outputOffset, byArray.length);
            this.outputOffset += byArray.length;
            if (DEBUG > 5) {
                System.err.print("Send: " + new String(byArray));
                if (DEBUG > 6) {
                    for (int i = 0; i < byArray.length; ++i) {
                        System.err.print(byArray[i] + " ");
                    }
                }
            }
        }
    }

    private void send(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.send(byArray2);
    }

    private void send(String string) throws IOException {
        this.send(string.getBytes());
    }

    private void send(int n) throws IOException {
        byte[] byArray = new byte[4];
        Host.copyInt(n, byArray);
        Host.swap(byArray, 4);
        this.send(byArray);
    }

    private void send(long l) throws IOException {
        byte[] byArray = new byte[8];
        Host.copyLong(l, byArray);
        Host.swap(byArray, 8);
        this.send(byArray);
    }

    void flush() throws IOException {
        if (this.connection.isClosed()) {
            throw new ClosedChannelException();
        }
        this.out.write(this.outputBuffer, 0, this.outputOffset);
        this.out.flush();
        this.outputOffset = 0;
    }

    private byte read() throws IOException {
        return (byte)this.in.read();
    }

    private byte[] read(int n) throws ClosedChannelException, InterruptedIOException, IOException {
        int n2;
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        try {
            int n3;
            n2 = 1448;
            if (n > n2) {
                for (n3 = 0; n > n3 + n2 - 1 && n3 >= 0; n3 += this.in.read(byArray, n3, n2)) {
                }
                while (n - n3 - 1 > 0 && n3 >= 0) {
                    n3 += this.in.read(byArray, n3, n - n3);
                }
            } else {
                while (n - n3 > 0 && n3 >= 0) {
                    n3 += this.in.read(byArray, n3, n - n3);
                }
            }
            if (n3 < 0) {
                throw new SocketException("SRB socket connection is closed.");
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("read() -- couldn't read complete packet");
            iOException2.initCause(iOException);
            throw iOException2;
        }
        if (DEBUG > 5) {
            System.err.print("Read: " + new String(byArray));
            if (DEBUG > 6) {
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    System.err.print(byArray[n2] + " ");
                }
            }
        }
        return byArray;
    }

    private char readChar() throws IOException {
        byte[] byArray = this.read(2);
        Host.swap(byArray, 2);
        char c = (char)Host.castToShort(byArray);
        return c;
    }

    private short readShort() throws IOException {
        byte[] byArray = this.read(2);
        Host.swap(byArray, 2);
        short s = Host.castToShort(byArray);
        return s;
    }

    private int readInt() throws IOException {
        byte[] byArray = this.read(4);
        Host.swap(byArray, 4);
        int n = Host.castToInt(byArray);
        return n;
    }

    private long readUnsignedInt() throws IOException {
        long l = Host.castToUnsignedInt(this.read(4));
        return l;
    }

    private long readLong() throws IOException {
        byte[] byArray = this.read(8);
        Host.swap(byArray, 8);
        long l = Host.castToLong(byArray);
        return l;
    }

    private String readString() throws IOException {
        String string = "";
        byte by = this.read();
        while (by != 0) {
            string = string + (char)by;
            by = this.read();
        }
        return string;
    }

    private String readString(int n) throws IOException {
        String string = new String(this.read(n));
        return string;
    }

    private void status() throws IOException {
        byte[] byArray = this.read(1);
        if (byArray[0] < 0) {
            throw new SRBException("Unknown error received from server.");
        }
    }

    void startSRBCommand(int n, int n2) throws IOException {
        String string = "F \u0000";
        this.send(string.getBytes());
        this.send(n);
        this.send(n2);
    }

    void sendArg(int n) throws IOException {
        this.send(4);
        this.send(n);
    }

    void sendArg(long l) throws IOException {
        this.send(8);
        this.send(l);
    }

    void sendArg(String string) throws IOException {
        if (string == null) {
            this.send(new byte[4]);
        } else {
            this.send(string.length());
            this.send(string.getBytes());
        }
    }

    void sendArg(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.send(new byte[4]);
        } else {
            this.send(byArray.length);
            this.send(byArray);
        }
    }

    void sendArg(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            this.send(new byte[4]);
        } else {
            this.send(n);
            this.send(byArray, 0, n);
        }
    }

    void sendArg(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.send(new byte[4]);
        } else {
            this.send(n2);
            this.send(byArray, n, n2);
        }
    }

    void sendArg(int[] nArray) throws IOException {
        this.send(nArray.length * 4);
        for (int i = 0; i < nArray.length; ++i) {
            this.send(nArray[i]);
        }
    }

    void sendArg(char[][] cArray) throws IOException {
        int n = cArray.length * cArray[0].length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            for (int j = 0; j < cArray[i].length; ++j) {
                byArray[n2] = (byte)cArray[i][j];
                ++n2;
            }
        }
        this.send(n);
        this.send(byArray);
    }

    void sendArg(SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        int n;
        byte[] byArray = new byte[]{0};
        String string = new String(byArray);
        boolean bl = false;
        int n2 = sRBMetaDataRecordListArray[0].getFieldCount();
        byte[] byArray2 = new byte[4];
        Host.copyInt(n2, byArray2);
        int n3 = sRBMetaDataRecordListArray.length;
        byte[] byArray3 = new byte[4];
        Host.copyInt(n3, byArray3);
        String string2 = "";
        int n4 = 0;
        for (int i = 0; i < sRBMetaDataRecordListArray[0].getFieldCount(); ++i) {
            string2 = string2 + SRBMetaDataSet.getSRBDatabaseName(sRBMetaDataRecordListArray[0].getFieldName(i));
            for (n = 0; n < sRBMetaDataRecordListArray.length; ++n) {
                string2 = string2 + sRBMetaDataRecordListArray[n].getStringValue(i) + string;
            }
        }
        byte[] byArray4 = new byte[(100 - sRBMetaDataRecordListArray[0].getFieldCount()) * 2 * 3];
        byArray4[0] = 1;
        for (n = 1; n < byArray4.length - 1; n += 2) {
            byArray4[n] = 0;
            byArray4[n + 1] = 1;
        }
        this.send(12 + string2.length() + byArray4.length + 4);
        this.send(0);
        this.send(byArray2);
        this.send(byArray3);
        this.send(string2);
        this.send(byArray4);
        this.send(n4);
        if (DEBUG > 2) {
            System.err.print("sendArg(rl): " + new String(byArray2));
            System.err.println(new String(byArray3));
            System.err.println(string2);
            System.err.println(new String(byArray4));
            System.err.println(n4);
        }
    }

    void commandStatus() throws IOException {
        byte[] byArray = this.read(1);
        String string = "\nThe SRB server returned an error: ";
        if (DEBUG > 1) {
            System.err.println("\n" + (new Date().getTime() - this.date) + " millisecs");
        }
        if ((char)byArray[0] == 'A') {
            byte[] byArray2 = new byte[]{0, 0, 0, (byte)(this.account.getOptions() - 48)};
            this.out.write(byArray2);
            switch (this.account.getOptions()) {
                case 48: {
                    this.send(this.account.getPassword());
                    break;
                }
                case 51: {
                    new GSIAuth(this.account, this.connection, this.out, this.in);
                    break;
                }
                case 54: {
                    new GSIAuth(this.account, this.connection, this.out, this.in);
                    break;
                }
                case 53: {
                    this.sendEncrypt1Auth(this.account.getPassword());
                    break;
                }
                default: {
                    this.send(this.account.getPassword());
                }
            }
            this.send(new byte[38]);
            this.read(4);
            this.commandStatus();
            return;
        }
        if ((char)byArray[0] != 'V') {
            int n = -1;
            int n2 = 0;
            int n3 = 10;
            byArray = new byte[4096 * n3];
            boolean bl = true;
            block12: while (bl && (n2 = this.in.read(byArray, 0, 4096 * n3)) > 0) {
                for (int i = 0; i < n2; ++i) {
                    if ((char)byArray[i] == 'V') {
                        byte[] byArray3;
                        if (byArray[i + 1] == 71) {
                            if (byArray[i + 2] == 8) {
                                byArray3 = new byte[]{byArray[i + 6], byArray[i + 7], byArray[i + 8], byArray[i + 9]};
                                Host.swap(byArray3, 4);
                                n = Host.castToInt(byArray3);
                                bl = false;
                                i = n2;
                                continue;
                            }
                            byArray3 = new byte[]{byArray[i + 6], byArray[i + 7], byArray[i + 8], byArray[i + 9]};
                            n = (int)Host.castToUnsignedInt(byArray3);
                            if (n > 0) {
                                Host.swap(byArray3, 4);
                                n = Host.castToInt(byArray3);
                            }
                            bl = false;
                            i = n2;
                            continue;
                        }
                        if (byArray[i - 1] == 0) {
                            byArray3 = new byte[]{byArray[i + 6], byArray[i + 7], byArray[i + 8], byArray[i + 9]};
                            n = (int)Host.castToUnsignedInt(byArray3);
                            if (n > 0) {
                                Host.swap(byArray3, 4);
                                n = Host.castToInt(byArray3);
                            }
                            bl = false;
                            continue block12;
                        }
                        string = string + (char)byArray[i];
                        continue;
                    }
                    string = string + (char)byArray[i];
                }
            }
            if (byArray[n2 - 1] != 48) {
                this.status();
            }
            throw new SRBException(string, n);
        }
        byArray = this.read(1);
        switch ((char)byArray[0]) {
            case 'G': {
                return;
            }
            case 'E': {
                throw new SRBException("SRB Server: returned an unknown error");
            }
            case 'N': {
                byArray = new byte[4096];
                this.in.read(byArray);
                if (byArray.length == 1) {
                    throw new SRBException("Return detected, but error message cannot be read");
                }
                string = new String(byArray);
                throw new SRBException(string);
            }
            case '0': {
                return;
            }
        }
        string = "FATAL: SRB protocol error: ";
        string = string + new String(byArray);
        throw new SRBException(string);
    }

    private int returnInt() throws IOException {
        byte[] byArray = this.read(1);
        int n = -1;
        if (byArray[0] > 4) {
            byArray = this.read(byArray[0] + 1);
            String string = "The SRB server returned an error: ";
            string = string + new String(byArray);
            throw new SRBException(string);
        }
        byArray = this.read(3);
        n = this.readInt();
        this.status();
        return n;
    }

    private long returnLong() throws IOException {
        byte[] byArray = this.read(1);
        long l = -1L;
        if (byArray[0] > 8) {
            byArray = this.read(byArray[0] + 1);
            String string = "The SRB server returned an error: ";
            string = string + new String(byArray);
            throw new SRBException(string);
        }
        byArray = this.read(3);
        l = this.readLong();
        this.status();
        return l;
    }

    private byte[] returnBytes() throws IOException {
        byte[] byArray = this.read(4);
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            n = byArray[i] < 0 ? (n << 8) + 256 + byArray[i] : (n << 8) + byArray[i];
        }
        if (n > 4) {
            this.read(4);
            byArray = this.read(n -= 4);
            this.read(1);
            return byArray;
        }
        String string = "\nThe SRB server returned an error: ";
        byArray = this.read(4);
        int n2 = (int)Host.castToUnsignedInt(byArray);
        string = string + n2;
        this.read(1);
        if (n2 < 0) {
            throw new SRBException(string);
        }
        if (n2 == 0) {
            return null;
        }
        return byArray;
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean bl, InputStream inputStream) throws IOException {
        InputStream inputStream2 = null;
        if (inputStream != null) {
            inputStream2 = this.in;
            this.in = inputStream;
            this.read(4);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        if (this.singlePortBulkUnload) {
            this.read(4);
        }
        int n4 = bl ? Host.castToInt(this.read(4)) : this.readInt();
        int n5 = (int)this.readUnsignedInt();
        if (n4 == 0 && inputStream != null) {
            if (n5 == 0) {
                this.read(4);
                this.in = inputStream2;
                return null;
            }
            if (n5 < 0) {
                throw new SRBException("Protocol error in returnSRBMetaDataRecordList", n5);
            }
            System.err.print("Protocol error in returnSRBMetaDataRecordList");
        }
        if (bl) {
            this.read(4);
        }
        if (n5 < 0) {
            if (DEBUG > 2) {
                System.err.println(n5);
            }
            if (n5 == -3005) {
                this.read(1);
                return null;
            }
            String string = "\nSRB server status: " + n5;
            this.read(1);
            throw new SRBException(string);
        }
        int n6 = (int)this.readUnsignedInt();
        int n7 = (int)this.readUnsignedInt();
        int n8 = 16;
        if (bl) {
            n8 += 7;
        }
        byte[] byArray = this.read(n4 - n8);
        if (bl) {
            this.read(3);
        }
        byte[] byArray2 = this.read(4);
        short s = (short)Host.castToInt(byArray2);
        if (bl) {
            this.read(7);
        }
        if (DEBUG > 2) {
            System.err.println("bufferLength " + n4);
            System.err.println("status " + n5);
            System.err.println("fieldCount " + n6);
            System.err.println("recordCount " + n7);
            System.err.println("continuationIndex " + s);
            System.err.println("resultBuffer " + byArray.length);
            if (DEBUG > 4) {
                for (n = 0; n < byArray.length; ++n) {
                    if (byArray[n] > 32) {
                        System.err.print((char)byArray[n]);
                        continue;
                    }
                    if (byArray[n] > 1) {
                        System.err.print(byArray[n]);
                        continue;
                    }
                    if (n <= 1 || byArray[n - 1] == 1 || byArray[n - 2] == 0 || byArray[n] == 1) continue;
                    System.err.print(byArray[n]);
                }
                System.err.print("\n");
                for (n = 0; n < byArray.length; ++n) {
                    System.err.print(" " + byArray[n]);
                }
            }
        }
        if (inputStream != null) {
            this.in = inputStream2;
        } else {
            this.status();
        }
        String[] stringArray = new String[n6];
        String[] stringArray2 = new String[n6];
        String[][] stringArray3 = new String[n6][n7];
        for (n = 0; n < n6; ++n) {
            stringArray[n] = "";
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n9 = n;
                stringArray[n9] = stringArray[n9] + (char)byArray[n2];
                ++n2;
            }
            if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            stringArray2[n] = "";
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n10 = n;
                stringArray2[n10] = stringArray2[n10] + (char)byArray[n2];
                ++n2;
            }
            if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            for (n3 = 0; n3 < n7; ++n3) {
                stringArray3[n][n3] = "";
                while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                    if (byArray[n2] > 0) {
                        String[] stringArray4 = stringArray3[n];
                        int n11 = n3;
                        stringArray4[n11] = stringArray4[n11] + (char)byArray[n2];
                    } else {
                        String[] stringArray5 = stringArray3[n];
                        int n12 = n3;
                        stringArray5[n12] = stringArray5[n12] + (char)(256 + byArray[n2]);
                    }
                    ++n2;
                }
                if (byArray[n2] != 0 || n2 >= byArray.length - 1) continue;
                ++n2;
            }
            if (byArray[n2] != 0) continue;
            ++n2;
        }
        return this.parseSRBMetaDataRecordList(n6, n7, s, stringArray, stringArray2, stringArray3);
    }

    SRBMetaDataRecordList[] parseSRBMetaDataRecordList(int n, int n2, int n3, String[] stringArray, String[] stringArray2, String[][] stringArray3) throws IOException {
        MetaDataField[] metaDataFieldArray = null;
        Object[] objectArray = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        MetaDataField[] metaDataFieldArray2 = new MetaDataField[n];
        for (n4 = 0; n4 < n; ++n4) {
            metaDataFieldArray2[n4] = SRBMetaDataSet.getGeneralMetaData(stringArray[n4], stringArray2[n4]);
        }
        if (DEBUG > 3) {
            for (n4 = 0; n4 < n; ++n4) {
                System.err.println("fields " + metaDataFieldArray2[n4]);
            }
        }
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[n2];
        Object[] objectArray2 = new Object[n];
        int n8 = 0;
        int n9 = 0;
        String string = null;
        for (n4 = 0; n4 < n2; ++n4) {
            int n10 = 0;
            for (n5 = 0; n5 < n; ++n5) {
                string = metaDataFieldArray2[n5].getName();
                String string2 = null;
                String string3 = null;
                String string4 = null;
                int n11 = -1;
                int n12 = -1;
                if (string == "definable metadata file0" || string == "definable metadata directory0" || string == "definable metadata resource0" || string == "definable metadata user0") {
                    if (n5 + 1 < n) {
                        string2 = metaDataFieldArray2[n5 + 1].getName();
                    }
                    if (string2 == "definable metadata file1") {
                        for (n6 = 0; n6 < n; ++n6) {
                            if (metaDataFieldArray2[n6].getName() == "file name") {
                                string3 = stringArray3[n6][n4];
                                n11 = n6;
                                if (n12 >= 0) break;
                            }
                            if (metaDataFieldArray2[n6].getName() != "directory name") continue;
                            string4 = stringArray3[n6][n4];
                            n12 = n6;
                            if (n11 < 0) {
                                continue;
                            }
                            break;
                        }
                    } else if (string2 == "definable metadata directory1") {
                        for (n6 = 0; n6 < n; ++n6) {
                            if (metaDataFieldArray2[n6].getName() != "directory name") continue;
                            string3 = stringArray3[n6][n4];
                            n11 = n6;
                            break;
                        }
                    } else if (string2 == "definable metadata resource1") {
                        for (n6 = 0; n6 < n; ++n6) {
                            if (metaDataFieldArray2[n6].getName() != "Resource Name") continue;
                            string3 = stringArray3[n6][n4];
                            n11 = n6;
                            break;
                        }
                    } else if (string2 == "definable metadata user1") {
                        for (n6 = 0; n6 < n; ++n6) {
                            if (metaDataFieldArray2[n6].getName() == "user name") {
                                string3 = stringArray3[n6][n4];
                                n11 = n6;
                                if (n12 >= 0) break;
                            }
                            if (metaDataFieldArray2[n6].getName() != "user domain") continue;
                            string4 = stringArray3[n6][n4];
                            n12 = n6;
                            if (n11 < 0) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (string3 != null) {
                        int n13;
                        for (n7 = 0; n7 < n2; ++n7) {
                            if (!stringArray3[n11][n7].equals(string3) || string4 != null && !stringArray3[n12][n7].equals(string4)) continue;
                            ++n8;
                        }
                        String[][] stringArray4 = new String[n8][10];
                        int[] nArray = new int[n8];
                        boolean bl2 = true;
                        for (n6 = 0; n6 < n8; ++n6) {
                            for (n7 = 0; n7 < stringArray4[n6].length; ++n7) {
                                stringArray4[n6][n7] = stringArray3[n5 + n7][n6 + n4];
                                if (!bl2 || stringArray4[n6][n7].equals("")) continue;
                                bl2 = false;
                            }
                            nArray[n6] = 0;
                            if (!bl2) continue;
                            stringArray4[n6] = null;
                        }
                        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray4.length);
                        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(stringArray4.length);
                        for (n13 = 0; n13 < stringArray4.length; ++n13) {
                            if (stringArray4[n13] == null) continue;
                            arrayList.add(stringArray4[n13]);
                            arrayList2.add(new Integer(nArray[n13]));
                        }
                        if (arrayList.size() == 0) {
                            stringArray4 = null;
                            nArray = null;
                        } else {
                            stringArray4 = (String[][])arrayList.toArray((T[])new String[0][0]);
                            nArray = new int[stringArray4.length];
                            for (n13 = 0; n13 < arrayList2.size(); ++n13) {
                                nArray[n13] = (Integer)arrayList2.get(n13);
                            }
                        }
                        if (stringArray4 == null) {
                            objectArray2[n5] = null;
                            ++n10;
                        } else {
                            objectArray2[n5] = new MetaDataTable(nArray, stringArray4);
                        }
                        n10 += 9;
                        if (stringArray4 != null) {
                            n4 += n8 - 1;
                        }
                        n5 += 9;
                        n8 = 0;
                        continue;
                    }
                    objectArray2[n5] = stringArray3[n5][n4];
                    continue;
                }
                objectArray2[n5] = stringArray3[n5][n4];
            }
            if (n10 > 0) {
                metaDataFieldArray = new MetaDataField[n - n10];
                objectArray = new Object[n - n10];
                n7 = 0;
                for (n6 = 0; n6 < objectArray2.length; ++n6) {
                    if (objectArray2[n6] == null) continue;
                    objectArray[n7] = objectArray2[n6];
                    metaDataFieldArray[n7] = metaDataFieldArray2[n6].getName() == "definable metadata file0" ? MetaDataSet.getField("definable metadata for files") : (metaDataFieldArray2[n6].getName() == "definable metadata directory0" ? MetaDataSet.getField("definable metadata for directories") : (metaDataFieldArray2[n6].getName() == "definable metadata user0" ? MetaDataSet.getField("definable metadata for users") : (metaDataFieldArray2[n6].getName() == "definable metadata resource0" ? MetaDataSet.getField("definable metadata for resources") : metaDataFieldArray2[n6])));
                    ++n7;
                }
                sRBMetaDataRecordListArray[n4] = new SRBMetaDataRecordList(metaDataFieldArray, objectArray, n3, this);
                metaDataFieldArray = null;
            } else {
                sRBMetaDataRecordListArray[n4] = new SRBMetaDataRecordList(metaDataFieldArray2, objectArray2, n3, this);
            }
            ++n9;
        }
        if (DEBUG > 3) {
            for (n4 = 0; n4 < sRBMetaDataRecordListArray.length; ++n4) {
                if (sRBMetaDataRecordListArray[n4] == null) continue;
                for (n5 = 0; n5 < sRBMetaDataRecordListArray[n4].getFieldCount(); ++n5) {
                    System.err.println("rl[" + n4 + "]." + n5 + " " + sRBMetaDataRecordListArray[n4].getValue(n5));
                }
            }
        }
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = new SRBMetaDataRecordList[n9];
        n5 = 0;
        for (n4 = 0; n4 < sRBMetaDataRecordListArray.length; ++n4) {
            if (sRBMetaDataRecordListArray[n4] == null) continue;
            sRBMetaDataRecordListArray2[n5] = sRBMetaDataRecordListArray[n4];
            ++n5;
        }
        return sRBMetaDataRecordListArray2;
    }

    synchronized int srbObjCreate(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjCreate " + string + " " + string4 + " " + string3);
        }
        this.startSRBCommand(2000, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        return n2;
    }

    synchronized int srbObjOpen(String string, int n, String string2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjOpen");
        }
        this.startSRBCommand(2001, 3);
        this.sendArg(string);
        this.sendArg(n);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        return n2;
    }

    synchronized void srbObjClose(int n) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjClose");
        }
        this.startSRBCommand(2002, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbObjUnlink(String string, String string2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjUnlink");
        }
        this.startSRBCommand(2003, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized byte[] srbObjRead(int n, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjRead");
        }
        this.startSRBCommand(2004, 2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized int srbObjWrite(int n, byte[] byArray, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjWrite");
        }
        this.startSRBCommand(2005, 2);
        this.sendArg(n);
        this.sendArg(byArray, n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException("Write failed", n3);
        }
        return n3;
    }

    synchronized void srbObjSeek(int n, long l, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjSeek");
        }
        this.startSRBCommand(2006, 3);
        this.sendArg(n);
        this.sendArg(l);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = (int)this.returnLong();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbObjSync(int n) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjSync");
        }
        this.startSRBCommand(2007, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized long[] srbObjStat(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjStat");
        }
        long[] lArray = new long[30];
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        this.startSRBCommand(2008, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        byte[] byArray = this.returnBytes();
        if (byArray != null) {
            for (n4 = 0; n4 < 8; ++n4) {
                l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
            }
            lArray[0] = l;
            ++n3;
            while (n3 < lArray.length - 7) {
                l = 0L;
                n5 = n4 + 4;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
            while (n3 < lArray.length - 5) {
                l = 0L;
                n5 = n4 + 2;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
            while (n3 < lArray.length) {
                l = 0L;
                n5 = n4 + 4;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
        }
        return lArray;
    }

    long[] srbObjStat64(int n, String string) throws IOException {
        return this.srbObjStat(n, string, 0);
    }

    synchronized void srbObjReplicate(int n, String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjReplicate");
        }
        this.startSRBCommand(2009, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbObjMove(int n, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjMove");
        }
        if (this.versionNumber >= 3.31f) {
            this.startSRBCommand(2010, 7);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(string2);
            this.sendArg(string3);
            this.sendArg(string4);
            this.sendArg(string5);
            this.sendArg(string6);
        } else {
            this.startSRBCommand(2010, 5);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(string2);
            this.sendArg(string4);
            this.sendArg(string5);
        }
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized byte[] srbObjProxyOpr(int n, int n2, int n3, int n4, int n5, String string, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2011, 12);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string2);
        this.sendArg(string4);
        this.sendArg(byArray);
        this.sendArg(byArray2);
        this.sendArg(byArray3);
        this.flush();
        this.commandStatus();
        byte[] byArray4 = this.read(4);
        int n6 = 0;
        for (int i = byArray4.length - 1; i >= 0; --i) {
            n6 = byArray4[i] < 0 ? (n6 << 8) + 256 + byArray4[i] : (n6 << 8) + byArray4[i];
        }
        if (n6 > 4) {
            this.read(4);
            byArray4 = this.read(n6 -= 4);
            this.read(1);
            return byArray4;
        }
        byArray4 = this.read(4);
        this.status();
        return byArray4;
    }

    synchronized void srbCollSeek(int n, int n2, int n3, int n4) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbCollSeek");
        }
        this.startSRBCommand(2014, 4);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.flush();
        this.commandStatus();
        int n5 = this.returnInt();
        if (n5 < 0) {
            throw new SRBException(n5);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetDatasetInfo(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetDatasetInfo");
        }
        this.startSRBCommand(2100, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList(false, null);
    }

    synchronized SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGenQuery " + this.srbGetDataDirInfoCount);
            ++this.srbGetDataDirInfoCount;
        }
        SRBMetaDataCommands sRBMetaDataCommands = new SRBMetaDataCommands(this);
        return sRBMetaDataCommands.srbGenQuery(n, string, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
    }

    synchronized void srbRegisterDataset(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterDataset");
        }
        this.startSRBCommand(2102, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized int srbModifyDataset(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            System.err.println("\n srbModifyDataset");
            if (DEBUG > 2) {
                System.err.println(" catType: " + n + " objID: " + string + " collectionName: " + string2 + " resourceName: " + string3 + " pathName: " + string4 + " dataValue1: " + string5 + " dataValue2: " + string6 + " actionType: " + n2);
            }
        }
        this.startSRBCommand(2103, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
        return n3;
    }

    synchronized void srbChkMdasAuth(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbChkMdasAuth");
        }
        this.startSRBCommand(2104, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbCreateCollect(int n, String string, String string2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbCreateCollect");
        }
        this.startSRBCommand(2105, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbListCollect(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbListCollect");
        }
        this.startSRBCommand(2106, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList(false, null);
    }

    synchronized void srbModifyCollect(int n, String string, String string2, String string3, String string4, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyCollect " + n + " " + string + " " + string2 + " " + string3 + " " + string4 + " " + n2);
        }
        this.startSRBCommand(2107, 6);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbChkMdasSysAuth(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbChkMdasSysAuth");
        }
        this.startSRBCommand(2108, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterUserGrp(int n, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterUserGrp");
        }
        this.startSRBCommand(2109, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterUser(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterUser");
        }
        this.startSRBCommand(2110, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbModifyUser(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyUser");
        }
        this.startSRBCommand(2111, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized int srbSetAuditTrail(int n) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbSetAuditTrail");
        }
        this.startSRBCommand(2112, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbObjAudit(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n2, String string8) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjAudit");
        }
        this.startSRBCommand(2113, 10);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.sendArg(n2);
        this.sendArg(string8);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbRegisterReplica(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterReplica");
        }
        this.startSRBCommand(2114, 9);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.sendArg(string8);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetPrivUsers(int n, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetPrivUsers");
        }
        this.startSRBCommand(2115, 2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList(false, null);
    }

    synchronized SRBMetaDataRecordList[] srbGetMoreRows(int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetMoreRows " + n + " " + n2 + " " + n3);
        }
        if (n2 < 0) {
            return null;
        }
        return this.srbGenGetMoreRows(n, n2, n3);
    }

    SRBMetaDataRecordList[] srbGenGetMoreRows(int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGenGetMoreRows " + n + " " + n2 + " " + n3);
        }
        if (n2 < 0) {
            return null;
        }
        try {
            this.startSRBCommand(2157, 3);
            this.sendArg(n);
            this.sendArg(n2);
            this.sendArg(n3);
            this.flush();
            this.commandStatus();
            return this.returnSRBMetaDataRecordList(false, null);
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
    }

    synchronized void srbIssueTicket(String string, String string2, String string3, String string4, String string5, int n, String string6) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbIssueTicket");
        }
        this.startSRBCommand(2117, 7);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n);
        this.sendArg(string6);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRemoveTicket(String string) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRemoveTicket");
        }
        this.startSRBCommand(2118, 1);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbUnregisterDataset(String string, String string2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbUnregisterDataset");
        }
        this.startSRBCommand(2119, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbContainerCreate(int n, String string, String string2, String string3, long l) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbContainerCreate");
        }
        this.startSRBCommand(2120, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterContainer(int n, String string, String string2, long l) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterContainer");
        }
        this.startSRBCommand(2000, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterInContDataset(int n, String string, String string2, String string3, String string4, long l, long l2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterInContDataset");
        }
        this.startSRBCommand(2122, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(l);
        this.sendArg(l2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetContainerInfo(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetContainerInfo");
        }
        this.startSRBCommand(2123, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList(false, null);
    }

    synchronized String srbGetResOnChoice(int n, String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2124, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        return new String(this.returnBytes());
    }

    synchronized void srbRmContainer(int n, String string, boolean bl) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRmContainer");
        }
        if (this.versionNumber <= 3.0f) {
            this.startSRBCommand(2125, 2);
            this.sendArg(n);
            this.sendArg(string);
        } else if (bl) {
            this.startSRBCommand(2125, 3);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(1);
        } else {
            this.startSRBCommand(2125, 3);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(1006);
        }
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbSyncContainer(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbSyncContainer");
        }
        this.startSRBCommand(2126, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbReplContainer(int n, String string, String string2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbReplContainer");
        }
        this.startSRBCommand(2127, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegInternalCompObj(String string, String string2, int n, int n2, String string3, String string4, long l, long l2, int n3, int n4, int n5, String string5) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegInternalCompObj");
        }
        this.startSRBCommand(5102, 12);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(l);
        this.sendArg(l2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n6 = this.returnInt();
        if (n6 < 0) {
            throw new SRBException(n6);
        }
    }

    synchronized void srbRmIntCompObj(String string, String string2, int n, int n2, int n3, int n4) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRmIntCompObj");
        }
        this.startSRBCommand(5101, 6);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.flush();
        this.commandStatus();
        int n5 = this.returnInt();
        if (n5 < 0) {
            throw new SRBException(n5);
        }
    }

    synchronized void srbRmCompObj(String string, String string2, int n, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRmCompObj");
        }
        this.startSRBCommand(5104, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbModInternalCompObj(String string, String string2, int n, int n2, int n3, int n4, String string3, String string4, String string5, String string6, int n5) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModInternalCompObj");
        }
        this.startSRBCommand(5105, 11);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n5);
        this.flush();
        this.commandStatus();
        int n6 = this.returnInt();
        if (n6 < 0) {
            throw new SRBException(n6);
        }
    }

    synchronized void srbModifyRescInfo(int n, String string, int n2, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyRescInfo");
        }
        this.startSRBCommand(2140, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbRegisterLocation(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterLocation");
        }
        this.startSRBCommand(2142, 5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbIngestToken(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbIngestToken");
        }
        this.startSRBCommand(2143, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterResource(String string, String string2, String string3, String string4, String string5, int n) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterResource");
        }
        this.startSRBCommand(2144, 6);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterLogicalResource(String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterLogicalResource");
        }
        this.startSRBCommand(2145, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterReplicateResourceInfo(String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbRegisterReplicateResourceInfo");
        }
        this.startSRBCommand(2146, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbDeleteValue(int n, String string) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbDeleteValue");
        }
        this.startSRBCommand(2147, 2);
        this.sendArg(n);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBulkRegister(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbBulkRegister");
        }
        this.startSRBCommand(2138, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        this.status();
    }

    synchronized InputStream srbExecCommand(String string, String string2, String string3, int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (n2 >= 0) {
            do {
                block7: {
                    if (n2 > n3) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        serverSocket = new ServerSocket(n2);
                    }
                    catch (IOException iOException) {
                        if (DEBUG <= 0) break block7;
                        iOException.printStackTrace();
                    }
                }
                ++n2;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n4 = serverSocket.getLocalPort();
        String string4 = this.connection.getLocalAddress().getHostAddress();
        Socket socket = null;
        DataInputStream dataInputStream = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(n);
        this.sendArg(n4);
        this.sendArg(0);
        this.sendArg(0);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg("");
        this.sendArg("");
        this.sendArg("");
        this.flush();
        socket = serverSocket.accept();
        dataInputStream = new DataInputStream(socket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return dataInputStream;
    }

    synchronized InputStream srbExecCommand(String string, String string2, String string3, String string4, int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (n2 >= 0) {
            do {
                block7: {
                    if (n2 > n3) {
                        throw new IOException("The bind operation failed, all ports already bound.");
                    }
                    try {
                        serverSocket = new ServerSocket(n2);
                    }
                    catch (IOException iOException) {
                        if (DEBUG <= 0) break block7;
                        iOException.printStackTrace();
                    }
                }
                ++n2;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n4 = serverSocket.getLocalPort();
        int n5 = 1;
        String string5 = this.connection.getLocalAddress().getHostAddress();
        Socket socket = null;
        DataInputStream dataInputStream = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(n);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(0);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string5);
        this.sendArg(string4);
        this.sendArg("");
        this.sendArg("");
        this.flush();
        socket = serverSocket.accept();
        dataInputStream = new DataInputStream(socket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return dataInputStream;
    }

    synchronized void srbSyncData(int n, String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbSyncData");
        }
        this.startSRBCommand(2139, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized int srbContainerOpen(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbContainerOpen");
        }
        this.startSRBCommand(2130, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbContainerClose(int n) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbContainerClose");
        }
        this.startSRBCommand(2131, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized long srbObjCopy(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjCopy");
        }
        this.startSRBCommand(2133, 5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        long l = this.returnLong();
        if (l < 0L) {
            throw new SRBException("", (int)l);
        }
        return l;
    }

    synchronized long srbObjPutClientInitiated(String string, String string2, String string3, String string4, String string5, String string6, long l, int n, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjPutClientInitiated destObjID " + string + " destCollection " + string2 + " destResLoc " + string3 + " dataType " + string4 + " destPath " + string5 + " localFilePath " + string6 + " srcSize " + l + " forceFlag " + n + " numThreads " + n2);
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        byte[] byArray = null;
        LocalFile localFile = new LocalFile(string6);
        if (!((GeneralFile)localFile).exists()) {
            this.srbObjCreate(0, string, string4, string3, string2, "", 0L);
        }
        LocalRandomAccessFile localRandomAccessFile = new LocalRandomAccessFile(string6, "rw");
        if (l <= 0L) {
            this.srbObjCreate(0, string, string4, string3, string2, "", 0L);
            return 0L;
        }
        this.startSRBCommand(2165, 8);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(l);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.readInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
        int n4 = (int)this.readUnsignedInt();
        if (n4 == 888888) {
            block23: {
                int n5;
                int n6;
                TransferThread transferThread = null;
                Thread thread = null;
                int n7 = 0;
                int n8 = (int)this.readUnsignedInt();
                int[] nArray = new int[n8];
                int[] nArray2 = new int[n8];
                String[] stringArray = new String[n8];
                byte[] byArray2 = null;
                for (n6 = 0; n6 < n8; ++n6) {
                    byArray2 = this.read(4);
                    nArray2[n6] = ((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF);
                    nArray[n6] = ((byArray2[2] & 0xFF) << 8) + (byArray2[3] & 0xFF);
                }
                for (n6 = 0; n6 < n8; ++n6) {
                    stringArray[n6] = this.readString();
                }
                this.status();
                byte[] byArray3 = new byte[]{0, 0, byArray2[0], byArray2[1]};
                Socket[] socketArray = new Socket[n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    socketArray[n5] = new Socket(stringArray[0], nArray[0]);
                    socketArray[n5].getOutputStream().write(byArray3);
                }
                byArray = new byte[4];
                n7 = socketArray[0].getInputStream().read(byArray);
                while (n7 < 4) {
                    if (n7 < 0) {
                        throw new ProtocolException();
                    }
                    byArray[n7 - 1] = (byte)socketArray[0].getInputStream().read();
                }
                n7 = socketArray[0].getInputStream().read(byArray);
                while (n7 < 4) {
                    if (n7 < 0) {
                        throw new ProtocolException();
                    }
                    byArray[n7 - 1] = (byte)socketArray[0].getInputStream().read();
                }
                if (n2 > Host.castToInt(byArray)) {
                    throw new ProtocolException("Server requires more ports from client for transfer");
                }
                n2 = Host.castToInt(byArray);
                byArray = new byte[8];
                n7 = socketArray[0].getInputStream().read(byArray);
                while (n7 < 8) {
                    if (n7 < 0) {
                        throw new ProtocolException();
                    }
                    byArray[n7 - 1] = (byte)socketArray[0].getInputStream().read();
                }
                if (l != Host.castToLong(byArray) && DEBUG > 0) {
                    System.err.println("Local file size " + l + " does not equal file size expected by server " + Host.castToLong(byArray));
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    transferThread = new TransferThread(new Object(), socketArray[n5], localRandomAccessFile, l, new Object(), n5);
                    thread = new Thread(transferThread);
                    thread.start();
                }
                try {
                    if (thread.isAlive()) {
                        thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (DEBUG <= 2) break block23;
                    System.err.println("Probably not an important error");
                    interruptedException.printStackTrace();
                }
            }
            if (localRandomAccessFile != null) {
                ((GeneralRandomAccessFile)localRandomAccessFile).close();
                localRandomAccessFile = null;
            }
            this.commandStatus();
            int n9 = this.returnInt();
            if (n9 >= 0) {
                return n9;
            }
            throw new SRBException(n9);
        }
        if (n4 < 0) {
            throw new SRBException(n4);
        }
        return n3;
    }

    synchronized long srbObjGetClientInitiated(String string, String string2, GeneralFile generalFile, int n, int n2, boolean bl) throws IOException {
        int n3;
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjGetClientInitiated " + string + " " + string2 + " " + generalFile + " " + n + " " + n2);
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        this.startSRBCommand(2163, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        long l = 1L;
        int n4 = this.readInt();
        if (n4 < 0) {
            throw new SRBException(n4);
        }
        int n5 = (int)this.readUnsignedInt();
        while (n5 == 888888) {
            int n6;
            int n7;
            n3 = (int)this.readUnsignedInt();
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            String[] stringArray = new String[n3];
            byte[] byArray = null;
            Socket[] socketArray = new Socket[n2];
            GeneralRandomAccessFile generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "rw");
            if (bl && generalFile.length() > l) {
                try {
                    generalRandomAccessFile.setLength(l);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (DEBUG > 0) {
                        unsupportedOperationException.printStackTrace();
                    }
                    generalFile.delete();
                    generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "rw");
                }
                catch (IOException iOException) {
                    if (DEBUG > 0) {
                        iOException.printStackTrace();
                    }
                    generalFile.delete();
                    generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "rw");
                }
            } else if (!bl) {
                generalRandomAccessFile.seek(generalRandomAccessFile.length());
            }
            Thread[] threadArray = new Thread[n2];
            TransferThread[] transferThreadArray = new TransferThread[n2];
            for (n7 = 0; n7 < n3; ++n7) {
                byArray = this.read(4);
                nArray2[n7] = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
                nArray[n7] = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
            }
            for (n7 = 0; n7 < n3; ++n7) {
                stringArray[n7] = this.readString();
            }
            this.status();
            byte[] byArray2 = new byte[]{0, 0, byArray[0], byArray[1]};
            for (n6 = 0; n6 < n2; ++n6) {
                socketArray[n6] = new Socket(stringArray[0], nArray[0]);
                OutputStream outputStream = socketArray[n6].getOutputStream();
                outputStream.write(byArray2);
                if (n6 == 0) {
                    DataInputStream dataInputStream = new DataInputStream(socketArray[n6].getInputStream());
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    l = dataInputStream.readLong();
                }
                transferThreadArray[n6] = new TransferThread((Object)generalRandomAccessFile, socketArray[n6], generalRandomAccessFile, l, new Object(), n6);
                threadArray[n6] = new Thread(transferThreadArray[n6]);
                threadArray[n6].start();
            }
            try {
                for (n6 = 0; n6 < n2; ++n6) {
                    if (threadArray[n6].isAlive()) {
                        threadArray[n6].join();
                    }
                    if (socketArray[n6] == null) continue;
                    socketArray[n6].close();
                    socketArray[n6] = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (generalRandomAccessFile != null) {
                generalRandomAccessFile.close();
                generalRandomAccessFile = null;
            }
            this.commandStatus();
            n5 = (int)this.readUnsignedInt();
        }
        if (n5 < 0) {
            throw new SRBException(n5);
        }
        n3 = this.readInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
        this.status();
        if (DEBUG > 2) {
            System.err.println("srbObjGetClientInitiated bytesMoved: " + this.bytesMoved);
        }
        return l;
    }

    long getBytesMoved() {
        return this.bytesMoved;
    }

    synchronized void srbGetMcatZone(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetMcatZone");
        }
        this.startSRBCommand(2151, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized String srbSetupSessionPublicKey() throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbSetupSessionPublicKey");
        }
        this.startSRBCommand(2149, 0);
        this.flush();
        this.commandStatus();
        long l = this.readLong();
        String string = new String(this.read((int)l - 4));
        this.status();
        return string;
    }

    synchronized void srbSetupSession(String string) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbSetupSession");
        }
        this.startSRBCommand(2148, 1);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbBulkLoad(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbBulkLoad");
        }
        this.startSRBCommand(2150, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBulkUnload(int n, int n2, String string, String string2) throws IOException {
        block17: {
            int n3;
            if (DEBUG > 0) {
                this.date = new Date().getTime();
                System.err.println("\n srbBulkUnload");
            }
            this.totalBytesMoved = 0L;
            this.bytesMoved = 0L;
            int n4 = 0;
            Socket[] socketArray = null;
            InputStream[] inputStreamArray = null;
            OutputStream[] outputStreamArray = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
            int n5 = 1;
            int[] nArray = null;
            int[] nArray2 = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            String string3 = null;
            InputStream inputStream = this.in;
            TransferThread[] transferThreadArray = null;
            Thread[] threadArray = null;
            this.startSRBCommand(2158, 3);
            this.sendArg(n);
            this.sendArg(n2);
            this.sendArg(string);
            this.flush();
            this.commandStatus();
            n4 = this.readInt();
            byArray = this.read(4);
            n4 = Host.castToInt(byArray);
            if (n4 == -99999999) {
                this.singlePortBulkUnload = true;
                n5 = 1;
                this.status();
            } else {
                if (n4 < 0) {
                    throw new SRBException(n4);
                }
                n5 = Host.castToInt(this.read(4));
                nArray = new int[n5];
                nArray2 = new int[n5];
                byArray = new byte[4];
                byArray2 = new byte[4];
                for (n3 = 0; n3 < n5; ++n3) {
                    byArray[2] = this.read();
                    byArray[3] = this.read();
                    nArray[n3] = Host.castToInt(byArray);
                    byArray2[2] = this.read();
                    byArray2[3] = this.read();
                    nArray2[n3] = Host.castToInt(byArray2);
                }
                string3 = this.readString();
                this.status();
                socketArray = new Socket[n5];
                inputStreamArray = new InputStream[n5];
                outputStreamArray = new OutputStream[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    try {
                        socketArray[n3] = new Socket(string3, nArray2[n3]);
                        inputStreamArray[n3] = socketArray[n3].getInputStream();
                        outputStreamArray[n3] = socketArray[n3].getOutputStream();
                        continue;
                    }
                    catch (ConnectException connectException) {
                        ConnectException connectException2 = new ConnectException("Bulk download connection cannot be made to: " + string3 + " at port: " + nArray2[n3]);
                        connectException2.initCause(connectException);
                        throw connectException2;
                    }
                    catch (SocketException socketException) {
                        SocketException socketException2 = new SocketException("A bulk download socket error occured when connecting to: " + string3 + " at port: " + nArray2[n3]);
                        socketException2.initCause(socketException);
                        throw socketException2;
                    }
                }
            }
            transferThreadArray = new TransferThread[n5];
            threadArray = new Thread[n5];
            if (n4 == -99999999) {
                sRBMetaDataRecordListArray = this.returnSRBMetaDataRecordList(true, null);
                if (sRBMetaDataRecordListArray != null) {
                    transferThreadArray[0] = new TransferThread(this.connection, sRBMetaDataRecordListArray, string2, string);
                    threadArray[0] = new Thread(transferThreadArray[0]);
                    threadArray[0].start();
                }
            } else {
                inputStream = this.in;
                for (n3 = 0; n3 < n5; ++n3) {
                    outputStreamArray[n3].write(byArray);
                    this.in = inputStreamArray[n3];
                    this.read(4);
                    sRBMetaDataRecordListArray = this.returnSRBMetaDataRecordList(true, null);
                    this.in = inputStream;
                    transferThreadArray[n3] = new TransferThread(socketArray[n3], sRBMetaDataRecordListArray, string2, string);
                    threadArray[n3] = new Thread(transferThreadArray[n3]);
                    threadArray[n3].start();
                }
            }
            try {
                for (n3 = 0; n3 < threadArray.length; ++n3) {
                    if (threadArray[n3] == null || !threadArray[n3].isAlive()) continue;
                    threadArray[n3].join();
                }
            }
            catch (InterruptedException interruptedException) {
                if (DEBUG <= 0) break block17;
                interruptedException.printStackTrace();
            }
        }
        if (this.singlePortBulkUnload) {
            this.singlePortBulkUnload = false;
        }
    }

    synchronized void srbModifyZone(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyZone");
        }
        this.startSRBCommand(2152, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized MetaDataRecordList[] srbBulkQueryAnswer(int n, String string, MetaDataRecordList metaDataRecordList, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbBulkQueryAnswer");
        }
        this.startSRBCommand(2153, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList(false, null);
    }

    synchronized void srbBulkMcatIngest(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbBulkMcatIngest");
        }
        this.startSRBCommand(2154, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBackupData(int n, String string, String string2, String string3, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbBackupData");
        }
        this.startSRBCommand(2159, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized byte[] srbObjChksum(String string, String string2, int n, String string3) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjChksum");
        }
        this.startSRBCommand(2015, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n2 = this.readInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        byte[] byArray = null;
        byte[] byArray2 = this.read(n2);
        this.status();
        for (int i = 4; i < n2; ++i) {
            if (byArray2[i] != 0) continue;
            byArray = new byte[i - 4];
            System.arraycopy(byArray2, 4, byArray, 0, i - 4);
            i = n2;
        }
        return byArray;
    }

    synchronized void srbModifyUserNonPriv(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyUserNonPriv");
        }
        this.startSRBCommand(2161, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbModifyResource(int n, String string, String string2, String string3, String string4, String string5, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyResource");
        }
        this.startSRBCommand(2162, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    String srbGetSvrVersion() throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetSvrVersion");
        }
        int n = 512;
        byte[] byArray = new byte[1];
        String string = "";
        this.startSRBCommand(1051, 0);
        this.flush();
        this.commandStatus();
        this.read(8);
        byArray = this.read(1);
        while (byArray[0] != 0) {
            string = string + (char)byArray[0];
            byArray = this.read(1);
        }
        this.status();
        return string;
    }

    String srbGetUserByDn(int n, int n2, String string) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbGetUserByDn");
        }
        this.startSRBCommand(2169, 3);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        try {
            byte[] byArray = this.returnBytes();
            if (byArray != null) {
                return new String(byArray);
            }
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
        return null;
    }

    byte[] srbObjProc(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbObjProc");
        }
        this.startSRBCommand(2017, 4);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    void srbModifyExtMetaData(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n2) throws IOException {
        if (DEBUG > 0) {
            this.date = new Date().getTime();
            System.err.println("\n srbModifyExtMetaData");
        }
        this.startSRBCommand(2168, 9);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    static {
        try {
            DEBUG = new Integer(System.getProperty("jargon.debug", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG = 0;
        }
        OUTPUT_BUFFER_LENGTH = SRBFileSystem.writeBufferSize;
        singleServerPort = false;
    }

    class TransferThread
    implements Runnable {
        private Socket transferSocket;
        private GeneralFile file;
        private GeneralRandomAccessFile raf;
        private long srcSize;
        private Object listener;
        private SRBMetaDataRecordList[] rl;
        private String directoryPath;
        private String sourcePath;
        private Object syncObject;
        long length;
        int whichThread;

        TransferThread(Object object, Socket socket, GeneralFile generalFile, long l, Object object2, int n) {
            this.whichThread = n;
            this.transferSocket = socket;
            this.file = generalFile;
            this.srcSize = l;
            this.listener = object2;
            this.syncObject = object;
        }

        TransferThread(Object object, Socket socket, GeneralRandomAccessFile generalRandomAccessFile, long l, Object object2, int n) {
            this.whichThread = n;
            this.transferSocket = socket;
            this.raf = generalRandomAccessFile;
            this.srcSize = l;
            this.listener = object2;
            this.syncObject = object;
        }

        TransferThread(Socket socket, SRBMetaDataRecordList[] sRBMetaDataRecordListArray, String string, String string2) throws IOException {
            this.transferSocket = socket;
            this.rl = sRBMetaDataRecordListArray;
            this.directoryPath = string;
            this.sourcePath = string2;
            this.srcSize = -1L;
            this.listener = null;
            this.raf = this.correctedRAFPath(0);
            this.length = Long.parseLong(sRBMetaDataRecordListArray[0].getValue(sRBMetaDataRecordListArray[0].getFieldIndex("file size")).toString());
        }

        protected void finalize() throws Throwable {
            if (this.transferSocket != null) {
                this.transferSocket.close();
                this.transferSocket = null;
            }
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            super.finalize();
        }

        private GeneralRandomAccessFile correctedRAFPath(int n) throws IOException {
            LocalFile localFile;
            String string = this.rl[n].getValue("directory name").toString();
            if (!string.equals(this.sourcePath)) {
                string = string.substring(this.sourcePath.length() + 1);
                localFile = new LocalFile(this.directoryPath, string);
            } else {
                localFile = new LocalFile(this.directoryPath);
            }
            localFile.mkdirs();
            return FileFactory.newRandomAccessFile(new LocalFile(localFile, this.rl[n].getValue("file name").toString()), "rw");
        }

        public void run() {
            try {
                DataInputStream dataInputStream = new DataInputStream(this.transferSocket.getInputStream());
                OutputStream outputStream = this.transferSocket.getOutputStream();
                byte[] byArray = null;
                int n = 0;
                int n2 = 0;
                int n3 = 1448;
                GeneralRandomAccessFile generalRandomAccessFile = null;
                int n4 = dataInputStream.readInt();
                if (n4 < 0 || n4 > 4) {
                    throw new ProtocolException("Unknown transfer operation");
                }
                if (n4 == 3 || n4 == 4) {
                    generalRandomAccessFile = FileFactory.newRandomAccessFile(this.raf.getFile(), "rw");
                }
                long l = dataInputStream.readInt();
                byArray = new byte[8];
                dataInputStream.read(byArray);
                long l2 = Host.castToUnsignedLong(byArray);
                if (l2 < 0L) {
                    return;
                }
                if (l <= 0L) {
                    return;
                }
                byArray = new byte[(int)l];
                block13: while (l > 0L) {
                    switch (n4) {
                        case 4: {
                            if (this.listener == null) {
                                int n5 = 1;
                                int n6 = 0x800000;
                                byArray = new byte[n6];
                                while (n5 > 0) {
                                    int n7 = 0;
                                    for (n = 0; n < this.rl.length; ++n) {
                                        while (this.length > 0L) {
                                            if (l <= 0L) {
                                                n4 = dataInputStream.readInt();
                                                l = dataInputStream.readInt();
                                                byte[] byArray2 = new byte[8];
                                                dataInputStream.read(byArray2);
                                            }
                                            long l3 = this.length > (long)n6 ? ((long)n6 > l ? l : (long)n6) : (this.length > l ? l : this.length);
                                            n7 = 0;
                                            while (l3 > 0L) {
                                                int n8 = l3 > (long)n3 ? n3 : (int)l3;
                                                int n9 = dataInputStream.read(byArray, n7, n8);
                                                if (n9 <= 0) {
                                                    System.err.print("BulkUnload sock read error." + n8 + "bytes more to read" + "\n");
                                                    break;
                                                }
                                                l3 -= (long)n9;
                                                n7 += n9;
                                            }
                                            generalRandomAccessFile.write(byArray, (int)l2, n7);
                                            this.length -= (long)n7;
                                            l -= (long)n7;
                                            SRBCommands.this.bytesMoved += (long)n7;
                                            n7 = 0;
                                        }
                                        generalRandomAccessFile.close();
                                        if (n + 1 >= this.rl.length) continue;
                                        this.length = Long.parseLong(this.rl[n + 1].getValue(this.rl[n + 1].getFieldIndex("file size")).toString());
                                        generalRandomAccessFile = this.correctedRAFPath(n + 1);
                                    }
                                    if (!this.rl[this.rl.length - 1].isQueryComplete()) {
                                        this.rl = SRBCommands.this.returnSRBMetaDataRecordList(true, dataInputStream);
                                        if (this.rl != null) {
                                            this.length = Long.parseLong(this.rl[0].getValue(this.rl[0].getFieldIndex("file size")).toString());
                                            if (this.rl == null) {
                                                n5 = 0;
                                                l = 0L;
                                                continue block13;
                                            }
                                            generalRandomAccessFile = this.correctedRAFPath(0);
                                            dataInputStream.read();
                                            n5 = 1;
                                        } else {
                                            n5 = 0;
                                        }
                                        l = 0L;
                                        continue;
                                    }
                                    n5 = 0;
                                    l = 0L;
                                    continue block13;
                                }
                                continue block13;
                            }
                            n2 = 0;
                            if (l > (long)n3) {
                                while (l > (long)(n2 + n3 - 1)) {
                                    n2 += dataInputStream.read(byArray, n2, n3);
                                }
                                while (l - (long)n2 - 1L > 0L) {
                                    n2 += dataInputStream.read(byArray, n2, (int)l - n2);
                                }
                            } else {
                                while (l - (long)n2 > 0L) {
                                    n2 += dataInputStream.read(byArray, n2, (int)l - n2);
                                }
                            }
                            SRBCommands.this.bytesMoved += (long)n2;
                            n2 = 0;
                            if (generalRandomAccessFile.getFilePointer() != l2) {
                                generalRandomAccessFile.seek(l2);
                            }
                            if (l > 0L) {
                                generalRandomAccessFile.write(byArray);
                            }
                            if ((n4 = dataInputStream.readInt()) < 0 || n4 > 4 && n4 != 0xA000000) {
                                throw new ProtocolException("Unknown transfer operation");
                            }
                            l = dataInputStream.readInt();
                            byArray = new byte[8];
                            dataInputStream.read(byArray);
                            l2 = Host.castToUnsignedLong(byArray);
                            if (l2 < 0L || l <= 0L) continue block13;
                            if (l >= Integer.MAX_VALUE) {
                                byArray = new byte[0x7FFFFFFE];
                                continue block13;
                            }
                            byArray = new byte[(int)l];
                            continue block13;
                        }
                        case 3: {
                            generalRandomAccessFile.seek(l2);
                            SRBCommands.this.bytesMoved += (long)generalRandomAccessFile.read(byArray);
                            outputStream.write(byArray);
                            n4 = dataInputStream.readInt();
                            if (n4 < 0 || n4 > 4) {
                                throw new ProtocolException("Unknown transfer operation");
                            }
                            l = dataInputStream.readInt();
                            byArray = new byte[8];
                            dataInputStream.read(byArray);
                            l2 = Host.castToUnsignedLong(byArray);
                            if (l2 < 0L || l <= 0L || l == (long)byArray.length) continue block13;
                            if (l >= Integer.MAX_VALUE) {
                                byArray = new byte[0x7FFFFFFE];
                                continue block13;
                            }
                            byArray = new byte[(int)l];
                            continue block13;
                        }
                    }
                    l = 0L;
                }
                SRBCommands.this.totalBytesMoved += SRBCommands.this.bytesMoved;
                if (SRBCommands.this.totalBytesMoved >= this.srcSize && this.listener != null && this.listener instanceof ServerSocket) {
                    ((ServerSocket)this.listener).close();
                }
                if (generalRandomAccessFile != null) {
                    generalRandomAccessFile.close();
                    generalRandomAccessFile = null;
                }
            }
            catch (SocketException socketException) {
                if (SRBCommands.this.out != null) {
                    try {
                        SRBCommands.this.out.close();
                    }
                    catch (IOException iOException) {
                        iOException.initCause(socketException);
                        throw new RuntimeException("IOException in thread.", iOException);
                    }
                    SRBCommands.this.out = null;
                }
                if (SRBCommands.this.in != null) {
                    try {
                        SRBCommands.this.in.close();
                    }
                    catch (IOException iOException) {
                        iOException.initCause(socketException);
                        throw new RuntimeException("IOException in thread.", iOException);
                    }
                    SRBCommands.this.in = null;
                }
                if (this.transferSocket != null) {
                    try {
                        this.transferSocket.close();
                    }
                    catch (IOException iOException) {
                        iOException.initCause(socketException);
                        throw new RuntimeException("IOException in thread.", iOException);
                    }
                    this.transferSocket = null;
                }
                if (DEBUG > 0) {
                    socketException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in thread.", iOException);
            }
        }
    }
}

