/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBProtocol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;

public class SRBFile
extends RemoteFile {
    public static final int MDAS_CATALOG = 0;
    public static final int LDAP_CATALOG = 1;
    public static final int FILE_CATALOG = 2;
    static final int OPR_COPY = 0;
    static int MAX_NUMBER_OF_PARALLEL_THREADS = 4;
    static int MAX_NUMBER_OF_BULK_THREADS = 1;
    static int MIN_THREAD_SIZE = 30000000;
    static final int BULK_LOAD_BUFFER_SIZE = 0x200000;
    static final int MAX_BULK_FILE_SIZE = 0x200000;
    static final int MAX_REGISTRATION_FILES = 300;
    static final int LIST_CHECKSUM = 16;
    static final int COMPUTE_CHECKSUM = 128;
    static final int FORCE_CHECKSUM = 32;
    static String ZONE_AUTHORITY = "http://www.sdsc.edu/srb/cgi-bin/zoneList.cgi?zone=";
    static boolean USE_BULKCOPY = true;
    private static String MODIFY_DEFINABLE_METADATA_SEPARATOR = "|";
    static final int PATH_IS_UNKNOWN = 0;
    static final int PATH_IS_FILE = 1;
    static final int PATH_IS_DIRECTORY = 2;
    static final String LOCAL_CONTAINER_DIRECTORY = "container";
    static final String LOCAL_HOME_DIRECTORY = "home";
    static final String LOCAL_STYLES_DIRECTORY = "styles";
    static final String LOCAL_TRASH_DIRECTORY = "trash";
    protected SRBFileSystem srbFileSystem;
    static int catalogType = 0;
    String resource;
    String dataType = "generic";
    boolean deleteOnExit = false;
    static Vector uriFileSystems = new Vector();
    String originalFilePath;
    private int replicaNumber = -1;
    public boolean completeDirectoryList = true;
    int pathNameType = 0;
    String serverLocalPath = "";
    boolean useCache = false;
    private volatile int loadBufferCount = 0;
    int activeRegistrationThread = 0;
    int filesReadyToRegister = 0;

    public SRBFile(SRBFileSystem sRBFileSystem, String string) throws NullPointerException {
        this(sRBFileSystem, "", string);
        this.checkResource();
        this.originalFilePath = string;
    }

    public SRBFile(SRBFileSystem sRBFileSystem, String string, String string2) throws NullPointerException, IllegalArgumentException {
        super(sRBFileSystem, string, string2);
        this.makePathCanonical(string);
        this.checkResource();
        this.originalFilePath = string != null ? (!string.equals("") ? string + separator + string2 : string2) : string2;
    }

    public SRBFile(SRBFile sRBFile, String string) throws NullPointerException {
        this((SRBFileSystem)sRBFile.getFileSystem(), sRBFile.getPath(), string);
    }

    public SRBFile(URI uRI) throws NullPointerException, IOException {
        super(uRI);
        if (!uRI.getScheme().equals("srb")) {
            throw new IllegalArgumentException();
        }
        SRBAccount sRBAccount = SRBFile.uriInitialAccount(uRI);
        SRBFileSystem sRBFileSystem = SRBFile.uriAccountTest(sRBAccount);
        String string = null;
        String string2 = uRI.getPath();
        String string3 = uRI.getQuery();
        this.originalFilePath = string2;
        if (sRBFileSystem != null) {
            this.setFileSystem(sRBFileSystem);
        } else {
            this.setFileSystem(new SRBFileSystem(sRBAccount));
            string = SRBFile.getLocalZone(this.srbFileSystem);
            this.srbFileSystem.setProxyMcatZone(string);
            this.srbFileSystem.setMcatZone(string);
            this.srbFileSystem.setDefaultStorageResource(SRBFile.getAvailableResource(this.srbFileSystem));
            this.setFileSystem(SRBFile.uriTest(this.srbFileSystem));
        }
        if (string3 != null) {
            int n = string3.indexOf("GUID=");
            String string4 = null;
            if (n >= 0) {
                String[] stringArray;
                MetaDataSelect[] metaDataSelectArray;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{this.getZoneCondition(), MetaDataSet.newCondition("guid", 0, string3.substring(n + 5))};
                MetaDataRecordList[] metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = MetaDataSet.newSelection(stringArray = new String[]{"file name", "directory name"}));
                if (metaDataRecordListArray == null) {
                    throw new FileNotFoundException("Invalid GUID");
                }
                string2 = metaDataRecordListArray[0].getValue("directory name").toString();
                string4 = metaDataRecordListArray[0].getValue("file name").toString();
                if (string4 != null) {
                    string2 = string2 + separator + string4;
                }
            }
            this.setFileName(string2);
        } else if (string2 == null || string2 == "") {
            this.setFileName(separator);
        } else {
            this.setFileName(string2);
        }
    }

    protected void finalize() throws Throwable {
        if (this.deleteOnExit) {
            this.delete();
        }
        super.finalize();
        if (this.resource != null) {
            this.resource = null;
        }
        if (this.dataType != null) {
            this.dataType = null;
        }
    }

    static SRBAccount uriInitialAccount(URI uRI) throws IOException {
        String string = uRI.getHost();
        int n = uRI.getPort();
        String string2 = uRI.getUserInfo();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = -1;
        if (string2 == null || string2 == "") {
            string3 = "public";
            string4 = "npaci";
            string5 = "CANDO";
            string6 = "/home/public.npaci/";
        } else {
            n2 = string2.indexOf(".");
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            string3 = string2.substring(0, n2);
            if (n2 < 0) {
                throw new MalformedURLException();
            }
            if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf(":")) > 0) {
                string4 = string2.substring(0, n2);
                string5 = string2.substring(n2 + 1);
            } else {
                string4 = string2;
            }
            string6 = "/home/" + string3 + "." + string4;
        }
        n2 = string.indexOf(".");
        if (n2 < 0) {
            URL uRL = new URL(ZONE_AUTHORITY + string);
            InputStream inputStream = uRL.openConnection().getInputStream();
            int n3 = -1;
            String string7 = null;
            byte[] byArray = new byte[1000];
            inputStream.read(byArray);
            string7 = new String(byArray);
            inputStream.read(byArray);
            string7 = string7 + new String(byArray);
            n2 = string7.indexOf("ns1:server");
            n3 = string7.indexOf("/ns1:server", n2 + 11);
            if (n2 < 0 || n3 < 0) {
                throw new ConnectException("Invalid zone name.");
            }
            string = string7.substring(n2 + 11, n3 - 1);
            n2 = string7.indexOf("ns1:port");
            if ((string7 = string7.substring(n2 + 9, (n3 = string7.indexOf("/ns1:port", n2 + 9)) - 1)) != null && string7.length() > 0) {
                n = Integer.parseInt(string7);
            }
        }
        if (n < 0) {
            n = 5544;
        }
        return new SRBAccount(string, n, string3, string5, string6, string4, "");
    }

    static String getLocalZone(SRBFileSystem sRBFileSystem) throws IOException {
        if (sRBFileSystem.getVersionNumber() >= 3.0f) {
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("zone locality", 0, 1)};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("Zone Name")};
            MetaDataRecordList[] metaDataRecordListArray = sRBFileSystem.query(metaDataConditionArray, metaDataSelectArray);
            if (metaDataRecordListArray != null) {
                return metaDataRecordListArray[0].getValue("Zone Name").toString();
            }
        }
        return null;
    }

    static String getAvailableResource(SRBFileSystem sRBFileSystem) throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = null;
        if (sRBFileSystem.getVersionNumber() >= 3.0f) {
            MetaDataSelect[] metaDataSelectArray;
            String string = sRBFileSystem.getUserName();
            String string2 = sRBFileSystem.getDomainName();
            String string3 = sRBFileSystem.getMcatZone();
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("resource access privilege", 10, "%write%"), MetaDataSet.newCondition("user name used for resource access", 0, string), MetaDataSet.newCondition("user domn used for resource access", 0, string2), MetaDataSet.newCondition("user zone used for resource access", 0, string3)};
            metaDataRecordListArray = sRBFileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("Resource Name")});
            if (metaDataRecordListArray == null && (metaDataRecordListArray = sRBFileSystem.query("Resource Name")) == null && !string.equals("public")) {
                throw new FileNotFoundException("No resources available");
            }
        }
        if (metaDataRecordListArray != null) {
            int n = (int)Math.round((double)(metaDataRecordListArray.length - 1) * Math.random());
            return metaDataRecordListArray[n].getValue("Resource Name").toString();
        }
        return "";
    }

    static synchronized SRBFileSystem uriTest(SRBFileSystem sRBFileSystem) {
        SRBFileSystem sRBFileSystem2 = null;
        for (int i = 0; i < uriFileSystems.size(); ++i) {
            sRBFileSystem2 = (SRBFileSystem)uriFileSystems.get(i);
            if (sRBFileSystem.equals(sRBFileSystem2)) {
                sRBFileSystem = sRBFileSystem2;
                return sRBFileSystem;
            }
            if (sRBFileSystem2.isConnected()) continue;
            uriFileSystems.remove(i);
        }
        uriFileSystems.add(sRBFileSystem);
        return sRBFileSystem;
    }

    static synchronized SRBFileSystem uriAccountTest(SRBAccount sRBAccount) {
        SRBFileSystem sRBFileSystem = null;
        for (int i = 0; i < uriFileSystems.size(); ++i) {
            sRBFileSystem = (SRBFileSystem)uriFileSystems.get(i);
            if (sRBAccount.equals((SRBAccount)sRBFileSystem.getAccount(), false)) {
                if (!sRBFileSystem.isConnected()) continue;
                return sRBFileSystem;
            }
            if (sRBFileSystem.isConnected()) continue;
            uriFileSystems.remove(i);
        }
        return null;
    }

    private void checkResource() {
        if (this.resource == null && !this.exists()) {
            this.resource = this.srbFileSystem.getDefaultStorageResource();
        }
    }

    protected void setFileName(String string) {
        int n;
        String string2 = File.separator;
        if (string == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!string2.equals(separator)) {
            n = string.lastIndexOf(string2);
            while (n >= 0 && string.substring(n + 1).length() > 0) {
                string = string.substring(0, n) + separator + string.substring(n + 1);
                n = string.lastIndexOf(string2);
            }
        }
        this.fileName = string;
        if (this.fileName.length() > 1) {
            n = this.fileName.lastIndexOf(separator);
            while (n == this.fileName.length() - 1 && n >= 0) {
                this.fileName = this.fileName.substring(0, n);
                n = this.fileName.lastIndexOf(separator);
            }
            if (n >= 0 && this.fileName.substring(n + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, n + 1));
                this.fileName = this.fileName.substring(n + 1);
            }
        }
    }

    protected void setDirectory(String string) {
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (string == null) {
            return;
        }
        String string2 = File.separator;
        int n = string.lastIndexOf(string2);
        if (n >= 0 && string.substring(n + 1).length() > 0) {
            string = string.substring(0, n) + separator + string.substring(n + 1);
            n = string.lastIndexOf(string2);
        }
        while (this.directory.size() > 0 && string.startsWith(separator)) {
            string = string.substring(1);
        }
        n = string.indexOf(separator);
        if (n >= 0) {
            do {
                this.directory.add(string.substring(0, n));
                while ((n = (string = string.substring(n + 1)).indexOf(separator)) == 0) {
                }
            } while (n >= 0);
        }
        if (!string.equals("") && string != null) {
            this.directory.add(string);
        }
    }

    void makePathCanonical(String string) {
        int n = 0;
        boolean bl = false;
        String string2 = null;
        if (string == null) {
            string = "";
        }
        if (this.fileName.equals("/") && string == "") {
            return;
        }
        if (this.fileName.equals("") && string.equals("")) {
            String string3 = this.fileSystem.getHomeDirectory();
            int n2 = string3.lastIndexOf(separator);
            this.setDirectory(string3.substring(0, n2));
            this.setFileName(string3.substring(n2 + 1));
            return;
        }
        if (string.startsWith("/")) {
            bl = true;
        }
        if (this.directory.size() > 0 && this.directory.get(0).toString().length() == 0) {
            bl = true;
        }
        if (!bl) {
            String string4 = this.fileSystem.getHomeDirectory();
            int n3 = string4.indexOf(separator);
            if (n3 >= 0) {
                do {
                    this.directory.add(n, string4.substring(0, n3));
                    string4 = string4.substring(n3 + 1);
                    n3 = string4.indexOf(separator);
                    ++n;
                } while (n3 > 0);
            }
            if (!string4.equals("") && string4 != null) {
                this.directory.add(n, string4);
            }
        }
        for (n = 0; n < this.directory.size(); ++n) {
            string2 = this.directory.get(n).toString();
            if (string2.equals(".")) {
                this.directory.remove(n);
                --n;
                continue;
            }
            if (string2.equals("..") && n >= 2) {
                this.directory.remove(n);
                this.directory.remove(n - 1);
                if (--n <= 0) continue;
                --n;
                continue;
            }
            if (string2.equals("..")) {
                this.directory.remove(n);
                --n;
                continue;
            }
            if (!string2.startsWith(separator)) continue;
            while ((string2 = string2.substring(1)).startsWith(separator)) {
            }
            this.directory.remove(n);
            this.directory.add(n, string2);
        }
        if (this.fileName.equals(".")) {
            this.fileName = this.directory.get(this.directory.size() - 1).toString();
            this.directory.remove(this.directory.size() - 1);
        } else if (this.fileName.equals("..")) {
            if (this.directory.size() > 1) {
                this.fileName = this.directory.get(this.directory.size() - 2).toString();
                this.directory.remove(this.directory.size() - 1);
                this.directory.remove(this.directory.size() - 1);
            } else {
                this.fileName = separator;
                this.directory.remove(this.directory.size() - 1);
            }
        }
        this.getReplicaNumber();
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
        this.srbFileSystem = (SRBFileSystem)this.fileSystem;
    }

    public void setResource(String string) throws IOException, NullPointerException, IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        this.resource = string;
    }

    public void setDataType(String string) throws IOException {
        if (string == null) {
            string = "generic";
        }
        if (this.isFile()) {
            if (this.getReplicaNumber() >= 0) {
                this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), null, null, string, null, 5);
            } else {
                this.srbFileSystem.srbModifyDataset(catalogType, this.getName(), this.getParent(), null, null, string, null, 5);
            }
        }
        this.dataType = string;
    }

    public void setReplicaNumber(int n) {
        if (n >= 0) {
            this.fileName = this.getName() + "&COPY=" + n;
            this.replicaNumber = n;
        } else {
            this.fileName = this.getName();
            this.replicaNumber = -1;
        }
    }

    public void setServerLocalPath(String string) {
        this.serverLocalPath = string;
    }

    MetaDataCondition getZoneCondition() {
        String string = (String)this.directory.get(1);
        if (string == null || string == LOCAL_CONTAINER_DIRECTORY || string == LOCAL_HOME_DIRECTORY || string == LOCAL_STYLES_DIRECTORY || string == LOCAL_TRASH_DIRECTORY) {
            return null;
        }
        return MetaDataSet.newCondition("current zone", 0, string);
    }

    public int getReplicaNumber() {
        if (this.replicaNumber >= 0) {
            return this.replicaNumber;
        }
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            this.replicaNumber = new Integer(this.fileName.substring(n + 6));
            return this.replicaNumber;
        }
        return -1;
    }

    public String getResource() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        if (this.resource != null) {
            return this.resource;
        }
        return this.firstQueryResult("physical resource name");
    }

    public String getDataType() throws IOException {
        if (this.isDirectory()) {
            return this.dataType;
        }
        return this.firstQueryResult("File Type");
    }

    public int getCatalogType() {
        return catalogType;
    }

    public final String getPathSeparator() {
        return separator;
    }

    public final char getPathSeparatorChar() {
        return separatorChar;
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.srbFileSystem != null) {
            return this.srbFileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public String getServerLocalPath() {
        block3: {
            if (this.serverLocalPath == null || this.serverLocalPath.equals("")) {
                try {
                    return this.firstQueryResult("PATH_NAME");
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG <= 0) break block3;
                    iOException.printStackTrace();
                }
            }
        }
        return this.serverLocalPath;
    }

    public MetaDataRecordList[] query(String string) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection(string)};
        return this.query(metaDataSelectArray, 300);
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        return this.query(MetaDataSet.newSelection(stringArray), 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect metaDataSelect) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{metaDataSelect};
        return this.query(metaDataSelectArray, 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataSelectArray, 300);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray = new MetaDataCondition[1];
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray = new MetaDataCondition[3];
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.getName();
            metaDataConditionArray[1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "File Replica Number";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataConditionArray, metaDataSelectArray, 300);
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray2 = null;
        String string = null;
        int n2 = 0;
        String string2 = null;
        if (this.isDirectory()) {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 1];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
        } else {
            metaDataConditionArray2 = new MetaDataCondition[metaDataConditionArray.length + 3];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, metaDataConditionArray.length);
            string = "directory name";
            n2 = 0;
            string2 = this.getParent();
            metaDataConditionArray2[metaDataConditionArray.length] = MetaDataSet.newCondition(string, n2, string2);
            string = "file name";
            string2 = this.fileName;
            metaDataConditionArray2[metaDataConditionArray.length + 1] = MetaDataSet.newCondition(string, n2, string2);
            if (this.getReplicaNumber() >= 0) {
                string = "File Replica Number";
                string2 = "" + this.replicaNumber;
                metaDataConditionArray2[2] = MetaDataSet.newCondition(string, n2, string2);
            }
        }
        return this.fileSystem.query(metaDataConditionArray2, metaDataSelectArray, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        SRBProtocol sRBProtocol = new SRBProtocol();
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.isFile();
        String string8 = null;
        if (this.serverLocalPath == null || this.serverLocalPath.equals("")) {
            if (this.getReplicaNumber() < 0 && bl3) {
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("PATH_NAME"), MetaDataSet.newSelection("Resource Name")};
                MetaDataRecordList[] metaDataRecordListArray = this.query(metaDataSelectArray);
                if (metaDataRecordListArray == null) throw new FileNotFoundException("Vault path/resource not found.");
                string8 = metaDataRecordListArray[0].getValue("PATH_NAME").toString();
                this.resource = metaDataRecordListArray[0].getValue("Resource Name").toString();
            }
        } else {
            string8 = this.serverLocalPath;
        }
        int n = -1;
        boolean bl4 = false;
        for (int i = 0; i < metaDataRecordList.getFieldCount(); ++i) {
            int n2;
            int n3;
            int n4;
            Object object;
            bl4 = metaDataRecordList.getValue(i) == null;
            string4 = metaDataRecordList.getFieldName(i);
            if (string4 == "File Comments") {
                if (bl4) {
                    n = 12;
                } else {
                    n = 13;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "file size") {
                n = 4;
                string = metaDataRecordList.getStringValue(i);
                bl = true;
            } else if (string4 == "File Type") {
                n = 5;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "directory name") {
                n = 6;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "offset") {
                n = 35;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "is dirty") {
                n = 36;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "File Replica Number") {
                n = 132;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file lock num") {
                n = 85;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "File Checksum") {
                n = 137;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file hide") {
                n = 138;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file auditflag") {
                n = 139;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file pin val") {
                n = 140;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file expiry date") {
                n = 141;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file expire date 2") {
                n = 142;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file is compressed") {
                n = 143;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file is encrypted") {
                n = 144;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file name") {
                n = 29;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file annotation") {
                object = metaDataRecordList.getValue("file annotation timestamp");
                if (bl4) {
                    n = 39;
                    if (object != null) {
                        string = object.toString();
                    }
                } else {
                    n = 40;
                    string = metaDataRecordList.getStringValue(i);
                    if (object != null) {
                        string2 = object.toString();
                    }
                    if ((object = metaDataRecordList.getValue("file annotation position")) != null) {
                        string2 = object.toString();
                    }
                }
            } else if (string4 == "directory annotation") {
                object = metaDataRecordList.getValue("directory annotation timestamp");
                if (bl4) {
                    n = 110;
                    string2 = metaDataRecordList.getStringValue(i);
                    if (object != null) {
                        string = object.toString();
                    }
                } else {
                    n = 111;
                    string = metaDataRecordList.getStringValue(i);
                    if (object != null) {
                        string2 = object.toString();
                    }
                }
            } else if (string4 == "file owner") {
                n = 15;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "PATH_NAME") {
                n = 126;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file modification date") {
                n = 42;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file last access timestamp") {
                n = 76;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "file class name") {
                if (bl4) {
                    n = 43;
                } else {
                    n = 44;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "index name for file") {
                if (bl4) {
                    n = 45;
                } else {
                    n = 46;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "index name for datatype") {
                if (bl4) {
                    n = 47;
                } else {
                    n = 48;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "index name for directory") {
                if (bl4) {
                    n = 49;
                } else {
                    n = 50;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "method name for file") {
                if (bl4) {
                    n = 51;
                } else {
                    n = 52;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "method name for datatype") {
                if (bl4) {
                    n = 53;
                } else {
                    n = 54;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "method name for directory") {
                if (bl4) {
                    n = 55;
                } else {
                    n = 56;
                    string = metaDataRecordList.getStringValue(i);
                }
            } else if (string4 == "definable metadata for files") {
                if (bl4) {
                    if (string8 == null) {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), null, null, "-1", "", 63);
                    } else {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.getName(), this.getParent(), this.resource, string8, "-1", "", 63);
                    }
                } else {
                    object = metaDataRecordList.getTableValue(i);
                    string2 = MODIFY_DEFINABLE_METADATA_SEPARATOR;
                    for (n4 = 0; n4 < ((MetaDataTable)object).getRowCount(); ++n4) {
                        string = "";
                        n3 = ((MetaDataTable)object).getColumnCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string = n2 == n3 - 1 ? string + ((MetaDataTable)object).getStringValue(n4, n2) : string + ((MetaDataTable)object).getStringValue(n4, n2) + string2;
                        }
                        if (string8 == null) {
                            this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), null, null, string, string2, 147);
                            continue;
                        }
                        this.srbFileSystem.srbModifyDataset(catalogType, this.getName(), this.getParent(), this.resource, string8, string, string2, 147);
                    }
                }
            } else if (string4 == "definable metadata for directories") {
                if (bl4) {
                    this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), "-1", string2, string3, 72);
                } else {
                    object = metaDataRecordList.getTableValue(i);
                    string2 = MODIFY_DEFINABLE_METADATA_SEPARATOR;
                    for (n4 = 0; n4 < ((MetaDataTable)object).getRowCount(); ++n4) {
                        string = "";
                        n3 = ((MetaDataTable)object).getColumnCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            string = n2 == n3 - 1 ? string + ((MetaDataTable)object).getStringValue(n4, n2) : string + ((MetaDataTable)object).getStringValue(n4, n2) + string2;
                        }
                        this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), string, string2, string3, 148);
                    }
                }
            } else if (string4 == "container for directory") {
                n = 146;
                string = metaDataRecordList.getStringValue(i);
            } else if (string4 == "guid") {
                if (bl4) {
                    n = 169;
                } else {
                    if (string8 == null) {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), null, null, string, string2, 169);
                    } else {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.getName(), this.getParent(), this.resource, string8, string, string2, 169);
                    }
                    n = 168;
                    string = metaDataRecordList.getStringValue(i);
                    string2 = "1";
                }
            } else if (string4 == "directory link number") {
                if (bl4) {
                    n = 3212;
                    string = "0";
                } else {
                    n = 3212;
                    string = metaDataRecordList.getStringValue(i) == "0" ? "0" : "1";
                }
            } else if (metaDataRecordList.getField(i).isExtensible(sRBProtocol)) {
                if (string5 == null) {
                    string5 = metaDataRecordList.getField(i).getExtensibleName(sRBProtocol);
                }
                if (string6 == null) {
                    string6 = "DATA_ID";
                }
                string6 = string6 + "|" + metaDataRecordList.getFieldName(i).toUpperCase();
                if (string7 == null) {
                    string7 = "0";
                }
                string7 = string7 + "|'" + metaDataRecordList.getStringValue(i) + "'";
            }
            if (n < 0) continue;
            if (bl3) {
                if (!bl2) {
                    if (string8 == null) {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), null, null, string, string2, n);
                    } else {
                        this.srbFileSystem.srbModifyDataset(catalogType, this.getName(), this.getParent(), this.resource, string8, string, string2, n);
                    }
                }
            } else if (!bl) {
                this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), string, string2, string3, n);
            }
            n = -1;
        }
        if (string5 == null) return;
        if (this.isFile(false)) {
            if (bl4) {
                this.srbFileSystem.srbModifyExtMetaData(catalogType, this.fileName, this.getParent(), string5, string6, string7, "", "", 170);
                return;
            } else {
                this.srbFileSystem.srbModifyExtMetaData(catalogType, this.fileName, this.getParent(), string5, string6, string7, "", "", 171);
            }
            return;
        } else {
            if (!this.isDirectory(false)) return;
            if (bl4) {
                this.srbFileSystem.srbModifyExtMetaData(catalogType, null, this.getAbsolutePath(), string5, string6, string7, "", "", 170);
                return;
            } else {
                this.srbFileSystem.srbModifyExtMetaData(catalogType, null, this.getAbsolutePath(), string5, string6, string7, "", "", 171);
            }
        }
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyTo(generalFile, bl, USE_BULKCOPY);
    }

    public void copyTo(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException();
        }
        FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath()).getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyTo(generalFile, bl);
            return;
        }
        if (this.isDirectory()) {
            Object[] objectArray;
            if (generalFile instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bl2 && (USE_BULKCOPY || bl2)) {
                MetaDataSelect[] metaDataSelectArray;
                if (bl2) {
                    if (bl && !generalFile.delete() && generalFile.exists()) {
                        throw new IOException(generalFile + " cannot be removed");
                    }
                    this.bulkUnload((LocalFile)generalFile);
                    return;
                }
                objectArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 10, this.getAbsolutePath() + "*")};
                MetaDataRecordList[] metaDataRecordListArray = this.query((MetaDataCondition[])objectArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file size")});
                if (metaDataRecordListArray != null) {
                    block0: do {
                        for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                            if (metaDataRecordListArray[i].getIntValue(0) <= 0x200000) continue;
                            bl2 = false;
                            continue block0;
                        }
                    } while ((metaDataRecordListArray = metaDataRecordListArray[0].getMoreResults()) != null && bl2 && !metaDataRecordListArray[0].isQueryComplete());
                }
                if (bl2) {
                    this.bulkUnload((LocalFile)generalFile);
                    return;
                }
            }
            objectArray = this.listFiles();
            generalFile.mkdir();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), objectArray[i].getName()), bl);
                }
            }
        } else if (this.isFile(false)) {
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            if (!bl && generalFile.exists()) {
                super.copyTo(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                int n = (int)this.length() / MIN_THREAD_SIZE;
                if (n > MAX_NUMBER_OF_PARALLEL_THREADS) {
                    n = MAX_NUMBER_OF_PARALLEL_THREADS;
                }
                this.srbFileSystem.srbObjGetClientInitiated(this.fileName, this.getParent(), generalFile, 0, n, bl);
            } else if (generalFile instanceof SRBFile) {
                if (bl && !generalFile.delete() && generalFile.exists()) {
                    throw new IOException(generalFile + " cannot be removed");
                }
                this.srbFileSystem.srbObjCopy(this.fileName, this.getParent(), ((SRBFile)generalFile).fileName, generalFile.getParent(), ((SRBFile)generalFile).getResource());
            } else {
                super.copyTo(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source file is not valid: " + this);
        }
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        this.copyFrom(generalFile, bl, USE_BULKCOPY);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        if (generalFile == null) {
            throw new NullPointerException();
        }
        this.getParentFile().mkdirs();
        if (this.srbFileSystem.getVersionNumber() < 2.0f) {
            super.copyFrom(generalFile, bl);
            return;
        }
        if (generalFile.isDirectory()) {
            if (generalFile instanceof LocalFile && this.srbFileSystem.getVersionNumber() >= 3.0f && bl2 && (USE_BULKCOPY || bl2)) {
                LocalFile[] localFileArray = null;
                localFileArray = this.isDirectory() ? new LocalFile[]{(LocalFile)generalFile} : (LocalFile[])generalFile.listFiles();
                this.bulkLoad(localFileArray, bl);
            } else {
                GeneralFile[] generalFileArray = generalFile.listFiles();
                this.mkdir();
                if (generalFileArray != null) {
                    for (int i = 0; i < generalFileArray.length; ++i) {
                        FileFactory.newFile(this, generalFileArray[i].getName()).copyFrom(generalFileArray[i], bl);
                    }
                }
            }
        } else if (generalFile.isFile()) {
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile, bl);
                return;
            }
            if (!bl && this.exists()) {
                super.copyFrom(generalFile, bl);
                return;
            }
            if (generalFile instanceof LocalFile) {
                if (bl && !this.delete() && this.exists()) {
                    throw new IOException(generalFile + " cannot be removed");
                }
                long l = generalFile.length();
                int n = 1;
                int n2 = 50000000;
                n = l / (long)n2 > (long)(MAX_NUMBER_OF_PARALLEL_THREADS - 1) ? MAX_NUMBER_OF_PARALLEL_THREADS : (int)l / n2 + 1;
                long l2 = bl ? this.srbFileSystem.srbObjPutClientInitiated(this.getName(), this.getParent(), this.resource, "", this.serverLocalPath, generalFile.getAbsolutePath(), l, 1, n) : this.srbFileSystem.srbObjPutClientInitiated(this.getName(), this.getParent(), this.resource, "", this.serverLocalPath, generalFile.getAbsolutePath(), l, 0, n);
                if (l2 == -99999999L) {
                    super.copyFrom(generalFile, bl);
                } else if (l2 < 0L) {
                    throw new SRBException("", (int)l2);
                }
            } else if (generalFile instanceof SRBFile) {
                if (bl && !this.delete() && this.exists()) {
                    throw new IOException(generalFile + " cannot be removed");
                }
                this.srbFileSystem.srbObjCopy(((SRBFile)generalFile).fileName, generalFile.getParent(), this.fileName, this.getParent(), this.getResource());
            } else {
                super.copyFrom(generalFile, bl);
            }
        } else {
            throw new FileNotFoundException("Source File is not valid: " + generalFile);
        }
    }

    public long fileCopyStatus() {
        return this.srbFileSystem.fileCopyStatus();
    }

    public long[] getStat() throws IOException {
        long[] lArray = null;
        if (!this.exists()) {
            return null;
        }
        lArray = this.isDirectory() ? this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 3) : this.srbFileSystem.srbObjStat(0, this.getAbsolutePath(), 0);
        if (lArray != null) {
            return lArray;
        }
        throw new IOException("Unable to obtain file stat");
    }

    void bulkLoad(LocalFile[] localFileArray, boolean bl) throws IOException {
        Vector vector;
        Vector vector2;
        block13: {
            int n;
            long l = -1L;
            long l2 = 0L;
            byte[] byArray = new byte[0x200000];
            GeneralFile[] generalFileArray = new GeneralFile[MAX_NUMBER_OF_BULK_THREADS];
            GeneralRandomAccessFile[] generalRandomAccessFileArray = new GeneralRandomAccessFile[MAX_NUMBER_OF_BULK_THREADS];
            LoadThread loadThread = null;
            vector2 = new Vector();
            vector = new Vector();
            this.mkdir();
            for (int i = 0; i < MAX_NUMBER_OF_BULK_THREADS; ++i) {
                generalFileArray[i] = FileFactory.newFile(this, "placeholder");
            }
            generalFileArray[0] = SRBFile.createTempFile("BLoad", ".tmp", this);
            generalRandomAccessFileArray[0] = FileFactory.newRandomAccessFile(generalFileArray[0], "rw");
            RegistrationThread[] registrationThreadArray = new RegistrationThread[MAX_NUMBER_OF_BULK_THREADS];
            Thread[] threadArray = new Thread[MAX_NUMBER_OF_BULK_THREADS];
            for (n = 0; n < MAX_NUMBER_OF_BULK_THREADS; ++n) {
                registrationThreadArray[n] = new RegistrationThread(generalFileArray[n].getAbsolutePath(), this);
            }
            threadArray[0] = new Thread(registrationThreadArray[0]);
            loadThread = new LoadThread(generalRandomAccessFileArray, byArray, this);
            for (n = 0; n < localFileArray.length; ++n) {
                this.loadBuffer(localFileArray[n], loadThread, generalFileArray, threadArray, registrationThreadArray, null, vector2, vector);
            }
            loadThread.keepLoading = false;
            loadThread.sendBuffer(0);
            try {
                for (n = 0; n < MAX_NUMBER_OF_BULK_THREADS; ++n) {
                    if (generalRandomAccessFileArray[n] != null) {
                        generalRandomAccessFileArray[n].close();
                    }
                    if (registrationThreadArray[n] != null) {
                        if (new SRBFile(this.srbFileSystem, registrationThreadArray[n].bloadFilePath).exists()) {
                            registrationThreadArray[n].register();
                        } else {
                            registrationThreadArray[n].bloadFilePath = generalFileArray[n].getAbsolutePath();
                            registrationThreadArray[n].register();
                        }
                    }
                    if (generalFileArray[n] == null) continue;
                    ((SRBFile)generalFileArray[n]).delete(true);
                }
                for (n = 0; n < MAX_NUMBER_OF_BULK_THREADS; ++n) {
                    if (threadArray[n] == null || !threadArray[n].isAlive()) continue;
                    threadArray[n].join();
                }
            }
            catch (InterruptedException interruptedException) {
                if (SRBCommands.DEBUG <= 0) break block13;
                interruptedException.printStackTrace();
            }
        }
        if (vector2.size() > 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                ((SRBFile)vector.get(i)).copyFrom((GeneralFile)vector2.get(i), bl, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuffer(GeneralFile generalFile, LoadThread loadThread, GeneralFile[] generalFileArray, Thread[] threadArray, RegistrationThread[] registrationThreadArray, String string, Vector vector, Vector vector2) throws IOException {
        long l = generalFile.length();
        boolean bl = generalFile.exists();
        boolean bl2 = generalFile.isDirectory();
        String string2 = generalFile.getName();
        if (generalFile == null || !bl) {
            return;
        }
        if (bl2) {
            if (string == null || string.equals("")) {
                string = string2;
                new SRBFile(this.srbFileSystem, this.getAbsolutePath(), string).mkdir();
            } else {
                string = string + separator + string2;
                new SRBFile(this.srbFileSystem, this.getAbsolutePath(), string).mkdir();
            }
            GeneralFile[] generalFileArray2 = generalFile.listFiles();
            if (generalFileArray2 == null) {
                return;
            }
            for (int i = 0; i < generalFileArray2.length; ++i) {
                this.loadBuffer(generalFileArray2[i], loadThread, generalFileArray, threadArray, registrationThreadArray, string, vector, vector2);
            }
        } else if (l > 0x200000L) {
            string = string == null || string.equals("") ? string2 : string + separator + string2;
            vector.add(generalFile);
            vector2.add(FileFactory.newFile(this, string));
        } else {
            int n = 0;
            ++this.filesReadyToRegister;
            if (string == null) {
                registrationThreadArray[this.activeRegistrationThread].addFile(generalFile, "");
            } else {
                registrationThreadArray[this.activeRegistrationThread].addFile(generalFile, string);
            }
            long l2 = l;
            int n2 = 0;
            GeneralFileInputStream generalFileInputStream = null;
            try {
                generalFileInputStream = FileFactory.newFileInputStream(generalFile);
            }
            catch (SecurityException securityException) {
                if (SRBCommands.DEBUG > 0) {
                    securityException.printStackTrace();
                }
                return;
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG > 0) {
                    iOException.printStackTrace();
                }
                return;
            }
            while (l2 > 0L) {
                if (l2 + (long)loadThread.loadBufferLength <= 0x200000L) {
                    SRBFile sRBFile = this;
                    synchronized (sRBFile) {
                        this.loadBufferCount = -1;
                    }
                    n2 = generalFileInputStream.read(loadThread.loadBuffer, loadThread.loadBufferLength, (int)l2);
                    if (n2 > 0) {
                        l2 -= (long)n2;
                        n += n2;
                        loadThread.loadBufferLength += n2;
                    }
                }
                if ((long)loadThread.loadBufferLength + l2 < 0x200000L) continue;
                loadThread.sendBuffer(0);
            }
            generalFileInputStream.close();
            if (this.filesReadyToRegister % 300 == 0) {
                loadThread.sendBuffer(0);
                loadThread.out[loadThread.randomIndex].close();
                threadArray[this.activeRegistrationThread].start();
                ++this.activeRegistrationThread;
                if (this.activeRegistrationThread >= MAX_NUMBER_OF_BULK_THREADS) {
                    this.activeRegistrationThread = 0;
                }
                if (threadArray[this.activeRegistrationThread] == null) {
                    threadArray[this.activeRegistrationThread] = new Thread(registrationThreadArray[this.activeRegistrationThread]);
                } else {
                    block29: {
                        try {
                            if (threadArray[this.activeRegistrationThread].isAlive()) {
                                threadArray[this.activeRegistrationThread].join();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (SRBCommands.DEBUG <= 0) break block29;
                            interruptedException.printStackTrace();
                        }
                    }
                    threadArray[this.activeRegistrationThread] = new Thread(registrationThreadArray[this.activeRegistrationThread]);
                }
                generalFileArray[this.activeRegistrationThread] = SRBFile.createTempFile("BLoad", ".tmp", generalFileArray[this.activeRegistrationThread].getParentFile());
                registrationThreadArray[this.activeRegistrationThread].setBloadFilePath(generalFileArray[this.activeRegistrationThread].getAbsolutePath());
                loadThread.restartRandom = true;
                loadThread.newRandom = generalFileArray[this.activeRegistrationThread];
                loadThread.randomIndex = this.activeRegistrationThread;
            }
        }
    }

    void bulkUnload(LocalFile localFile) throws IOException {
        int n = 0x8000000;
        if (this.exists()) {
            if (localFile.exists()) {
                localFile = new LocalFile(localFile, this.getName());
            } else {
                localFile.mkdir();
            }
            this.srbFileSystem.srbBulkUnload(catalogType, n, this.getAbsolutePath(), localFile.getAbsolutePath());
        }
        boolean bl = false;
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 10, this.getAbsolutePath() + "*")};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
        metaDataSelectArray[1] = null;
        MetaDataRecordList[] metaDataRecordListArray2 = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            for (int i = 0; i < metaDataRecordListArray2.length; ++i) {
                String string = metaDataRecordListArray2[i].getStringValue(0).substring(this.getAbsolutePath().length());
                for (int j = 0; j < metaDataRecordListArray.length; ++j) {
                    String string2 = metaDataRecordListArray[j].getStringValue(1).substring(this.getAbsolutePath().length());
                    if (!string2.equals(string)) continue;
                    bl = true;
                }
                if (!bl) {
                    new LocalFile(localFile, string).mkdirs();
                }
                bl = false;
            }
        }
    }

    public String getPermissions() throws IOException {
        block4: {
            MetaDataSelect[] metaDataSelectArray;
            String string;
            String string2;
            MetaDataRecordList[] metaDataRecordListArray;
            block3: {
                MetaDataSelect[] metaDataSelectArray2;
                metaDataRecordListArray = null;
                string2 = this.srbFileSystem.getUserName();
                string = this.srbFileSystem.getDomainName();
                if (!this.isDirectory()) break block3;
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath()), MetaDataSet.newCondition("user name", 0, string2), MetaDataSet.newCondition("user domain", 0, string)};
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("access directory name"), MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
                if (metaDataRecordListArray == null) break block4;
                for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                    if (!metaDataRecordListArray[i].getValue("user name").equals(string2) || !metaDataRecordListArray[i].getValue("user domain").equals(string)) continue;
                    return metaDataRecordListArray[i].getValue("directory access constraint").toString();
                }
                break block4;
            }
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, string2), MetaDataSet.newCondition("user domain", 0, string)};
            metaDataRecordListArray = this.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")});
            if (metaDataRecordListArray != null) {
                for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                    if (!metaDataRecordListArray[i].getValue("user name").equals(string2) || !metaDataRecordListArray[i].getValue("user domain").equals(string)) continue;
                    return metaDataRecordListArray[i].getValue("file access constraint").toString();
                }
            }
        }
        return null;
    }

    public MetaDataRecordList[] getPermissions(boolean bl) throws IOException {
        if (bl) {
            if (this.isDirectory()) {
                MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath())};
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
                return this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
            }
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
            return this.query(metaDataSelectArray);
        }
        String string = this.srbFileSystem.getUserName();
        String string2 = this.srbFileSystem.getDomainName();
        if (this.isDirectory()) {
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("access directory name", 0, this.getAbsolutePath()), MetaDataSet.newCondition("user name", 0, string), MetaDataSet.newCondition("user domain", 0, string2)};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("access directory name"), MetaDataSet.newSelection("directory access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
            return this.fileSystem.query(metaDataConditionArray, metaDataSelectArray);
        }
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, string), MetaDataSet.newCondition("user domain", 0, string2)};
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint"), MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain")};
        return this.query(metaDataConditionArray, metaDataSelectArray);
    }

    public void changePermissions(String string, String string2, String string3) throws IOException {
        this.changePermissions(string, string2, string3, false);
    }

    public void changePermissions(String string, String string2, String string3, boolean bl) throws IOException {
        int n = -1;
        if (string == null) {
            string = "";
        }
        if ((string = string.toLowerCase()).equals("n") || string.equals("null") || string.equals("")) {
            string = "";
        } else if (string.equals("r") || string.equals("read")) {
            string = "read";
        } else if (string.equals("w") || string.equals("write")) {
            string = "write";
        } else if (string.equals("rw")) {
            string = "all";
        } else if (string.equals("all") || string.equals("ownership")) {
            string = "all";
        } else if (string.equals("t") || string.equals("annotate")) {
            string = "annotate";
        } else if (string.equals("c") || string.equals("curate")) {
            string = "curate";
        } else {
            throw new IllegalArgumentException("Permission type not valid: " + string);
        }
        if (this.isDirectory()) {
            n = string == "" ? (bl ? 130 : 28) : (bl ? 128 : 27);
            this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), string2, string3, string, n);
        } else {
            n = string == "" ? 9 : 8;
            this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), "", "", string2 + "@" + string3, string, n);
        }
    }

    public void replicate(String string) throws IOException {
        if (this.isDirectory()) {
            SRBFile[] sRBFileArray = (SRBFile[])this.listFiles();
            for (int i = 0; i < sRBFileArray.length; ++i) {
                if (sRBFileArray[i].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(catalogType, this.fileName, this.getParent(), string, null);
                    continue;
                }
                sRBFileArray[i].replicate(string, false);
            }
        } else {
            this.srbFileSystem.srbObjReplicate(catalogType, this.fileName, this.getParent(), string, null);
        }
    }

    private void replicate(String string, boolean bl) throws IOException {
        if (this.isDirectory(bl)) {
            SRBFile[] sRBFileArray = (SRBFile[])this.listFiles();
            for (int i = 0; i < sRBFileArray.length; ++i) {
                if (sRBFileArray[i].isFile(false)) {
                    this.srbFileSystem.srbObjReplicate(catalogType, this.fileName, this.getParent(), string, null);
                    continue;
                }
                sRBFileArray[i].replicate(string, false);
            }
        } else {
            this.srbFileSystem.srbObjReplicate(catalogType, this.fileName, this.getParent(), string, null);
        }
    }

    public void backup(String string) throws IOException {
        if (this.isDirectory()) {
            String[] stringArray = this.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("/")) {
                    new SRBFile(this.srbFileSystem, stringArray[i]).backup(string);
                    continue;
                }
                new SRBFile(this.srbFileSystem, this.getAbsolutePath() + "/" + stringArray[i]).backup(string);
            }
        } else {
            this.srbFileSystem.srbBackupData(catalogType, this.fileName, this.getParent(), string, 0);
        }
    }

    public String checksum() throws IOException {
        if (this.isFile()) {
            byte[] byArray = this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 16, null);
            if (byArray == null) {
                return this.checksum(true, true);
            }
            return new String(byArray);
        }
        return null;
    }

    public String checksum(boolean bl) throws IOException {
        return this.checksum(false, true);
    }

    private String checksum(boolean bl, boolean bl2) throws IOException {
        if (this.isFile(bl2)) {
            if (bl) {
                return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 32, null));
            }
            return new String(this.srbFileSystem.srbObjChksum(this.getName(), this.getParent(), 128, null));
        }
        return null;
    }

    public void register(String string, long l) throws IOException {
        if (l < 0L) {
            l = 0L;
        }
        this.srbFileSystem.srbRegisterDataset(catalogType, this.getName(), this.dataType, this.resource, this.getParent(), string, l);
    }

    public InputStream executeProxyCommand(String string, String string2) throws IOException {
        return this.srbFileSystem.executeProxyCommand(string, string2, null, this.getPath(), -1);
    }

    public void link(SRBFile sRBFile) throws IOException {
        if (this.isDirectory()) {
            GeneralFile[] generalFileArray = this.listFiles();
            sRBFile.mkdir();
            for (int i = 0; i < generalFileArray.length; ++i) {
                SRBFile sRBFile2 = new SRBFile(sRBFile, generalFileArray[i].getName());
                ((SRBFile)generalFileArray[i]).link(sRBFile2);
            }
        } else {
            this.srbFileSystem.srbModifyDataset(0, this.fileName, this.getParent(), "", "", sRBFile.getName(), sRBFile.getParent(), 83);
        }
    }

    public boolean canRead() {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                        if (metaDataRecordListArray[i].getValue("directory access constraint") == null || !(string = metaDataRecordListArray[i].getValue("directory access constraint").toString()).equals("all") && !string.equals("write") && !string.equals("read")) continue;
                        return true;
                    }
                } else if (this.isFile(false)) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string = metaDataRecordListArray[0].getValue("file access constraint").toString();
                    if (string.equals("all") || string.equals("write") || string.equals("read")) {
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block9;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    boolean canRead(String string) {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                        if (metaDataRecordListArray[i].getValue("directory access constraint") == null || !(string2 = metaDataRecordListArray[i].getValue("directory access constraint").toString()).equals("all") && !string2.equals("write") && !string2.equals("read")) continue;
                        return true;
                    }
                    break block8;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("file access constraint").toString();
                    if (string2.equals("all") || string2.equals("write") || string2.equals("read")) {
                        return true;
                    }
                    break block8;
                }
                return this.canRead();
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block8;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean canWrite() {
        block9: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string = null;
            String string2 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (this.isDirectory()) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                        if (metaDataRecordListArray[i].getValue("directory access constraint") == null || !(string = metaDataRecordListArray[i].getValue("directory access constraint").toString()).equals("all") && !string.equals("write")) continue;
                        return true;
                    }
                } else if (this.isFile(false)) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string2), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string = metaDataRecordListArray[0].getValue("file access constraint").toString();
                    if (string.equals("all") || string.equals("write")) {
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block9;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    boolean canWrite(String string) {
        block8: {
            MetaDataRecordList[] metaDataRecordListArray = null;
            String string2 = null;
            String string3 = this.srbFileSystem.getUserName();
            int n = 0;
            try {
                if (string.equals("isDir")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("access directory name", n, this.getAbsolutePath())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    for (int i = 0; i < metaDataRecordListArray.length; ++i) {
                        if (metaDataRecordListArray[i].getValue("directory access constraint") == null || !(string2 = metaDataRecordListArray[i].getValue("directory access constraint").toString()).equals("all") && !string2.equals("write")) continue;
                        return true;
                    }
                    break block8;
                }
                if (string.equals("isFile")) {
                    MetaDataSelect[] metaDataSelectArray;
                    MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", n, string3), MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file access constraint")}, 3);
                    if (metaDataRecordListArray == null) {
                        return false;
                    }
                    string2 = metaDataRecordListArray[0].getValue("file access constraint").toString();
                    if (string2.equals("all") || string2.equals("write")) {
                        return true;
                    }
                    break block8;
                }
                return this.canWrite();
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block8;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean createNewFile() throws IOException {
        block4: {
            try {
                if (!this.isFile()) {
                    this.getParentFile().mkdirs();
                    int n = this.srbFileSystem.srbObjCreate(catalogType, this.getName(), this.dataType, this.resource, this.getParent(), this.serverLocalPath, -1L);
                    this.srbFileSystem.srbObjClose(n);
                    return true;
                }
            }
            catch (SRBException sRBException) {
                if (SRBCommands.DEBUG > 0) {
                    sRBException.printStackTrace();
                }
                if (sRBException.getType() == -3210) break block4;
                throw sRBException;
            }
        }
        return false;
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException, IllegalArgumentException {
        GeneralFile generalFile2;
        String string3 = "";
        for (int i = 0; i < 8; ++i) {
            string3 = string3 + (char)(65.0 + Math.random() * 25.0);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (generalFile == null) {
            SRBFileSystem sRBFileSystem = new SRBFileSystem();
            generalFile = FileFactory.newFile((GeneralFileSystem)sRBFileSystem, sRBFileSystem.getHomeDirectory(), "temp");
            generalFile.mkdir();
        }
        if ((generalFile2 = FileFactory.newFile(generalFile, string + string3 + string2)).createNewFile()) {
            return generalFile2;
        }
        throw new IOException("The temp file already exists.");
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean bl) {
        try {
            if (!bl && this.srbFileSystem.getVersionNumber() > 3.0f) {
                if (this.isDirectory()) {
                    this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), "", "", "", 31);
                    return true;
                }
                if (this.isFile(false) && this.getReplicaNumber() < 0) {
                    this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), "", "", "", "", 174);
                    return true;
                }
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
            if (this.isDirectory()) {
                this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), "", "", "", 31);
                return true;
            }
            if (this.isFile(false)) {
                this.srbFileSystem.srbObjUnlink(this.fileName, this.getParent());
                return true;
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    public boolean equals(Object object) {
        block4: {
            try {
                if (object == null) {
                    return false;
                }
                if (object instanceof SRBFile) {
                    SRBFile sRBFile = (SRBFile)object;
                    return this.getAbsolutePath().equals(sRBFile.getAbsolutePath());
                }
            }
            catch (ClassCastException classCastException) {
                if (SRBCommands.DEBUG <= 0) break block4;
                classCastException.printStackTrace();
            }
        }
        return false;
    }

    public boolean exists() {
        block6: {
            try {
                MetaDataRecordList[] metaDataRecordListArray = null;
                int n = 0;
                MetaDataCondition[] metaDataConditionArray = null;
                if (this.getReplicaNumber() >= 0) {
                    metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                    metaDataConditionArray[1] = MetaDataSet.newCondition("File Replica Number", n, this.replicaNumber);
                } else {
                    metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getParent()), MetaDataSet.newCondition("file name", n, this.getName())};
                }
                MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
                metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", n, this.getAbsolutePath())};
                metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public String getCanonicalPath() throws IOException {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            for (int i = 1; i < n; ++i) {
                string = string + separator + this.directory.get(i);
            }
            return string + separator + this.fileName;
        }
        return this.fileName;
    }

    public String getName() {
        int n = this.fileName.indexOf("&COPY=");
        if (n >= 0) {
            return this.fileName.substring(0, n);
        }
        return this.fileName;
    }

    public String getPath() {
        return this.originalFilePath;
    }

    public int hashCode() {
        return this.getAbsolutePath().toLowerCase().hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDirectory() {
        if (this.useCache) {
            return this.isDirectory(false);
        }
        return this.isDirectory(true);
    }

    public boolean isDirectory(boolean bl) {
        block6: {
            if (!bl && this.pathNameType != 0) {
                if (this.pathNameType == 1) {
                    return false;
                }
                if (this.pathNameType == 2) {
                    return true;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getAbsolutePath())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("directory name")};
            try {
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    this.pathNameType = 2;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isFile() {
        if (this.useCache) {
            return this.isFile(false);
        }
        return this.isFile(true);
    }

    public boolean isFile(boolean bl) {
        block6: {
            if (this.pathNameType != 0 && !bl) {
                if (this.pathNameType == 1) {
                    return true;
                }
                if (this.pathNameType == 2) {
                    return false;
                }
            }
            MetaDataRecordList[] metaDataRecordListArray = null;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("directory name", 0, this.getParent()), MetaDataSet.newCondition("file name", 0, this.getName())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
            try {
                metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
                if (metaDataRecordListArray != null) {
                    this.pathNameType = 1;
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block6;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        long l = 0L;
        String string = null;
        try {
            string = this.firstQueryResult("file modification date");
            if (string != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
                l = simpleDateFormat.parse(string).getTime();
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
        catch (ParseException parseException) {
            if (SRBCommands.DEBUG > 0) {
                parseException.printStackTrace();
            }
            return 0L;
        }
        return l;
    }

    public String[] list() {
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[1];
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray[0] = MetaDataSet.newCondition("directory name", 0, string);
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 300);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray[0] = MetaDataSet.newCondition("parent directory name", 0, string);
            metaDataRecordListArray2 = this.fileSystem.query(metaDataConditionArray, metaDataSelectArray, 300);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                for (int i = 0; i < metaDataRecordListArray2.length; ++i) {
                    string2 = metaDataRecordListArray2[i].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf("/") + 1);
                    metaDataRecordListArray2[i].setValue(0, string3);
                }
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new SRBMetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        for (int i = 0; i < metaDataRecordListArray3.length; ++i) {
            if (metaDataRecordListArray3[i].getStringValue(0) == null) continue;
            vector.add(metaDataRecordListArray3[i].getStringValue(0));
        }
        return vector.toArray(new String[0]);
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        if (metaDataConditionArray == null) {
            return this.list();
        }
        MetaDataCondition[] metaDataConditionArray2 = null;
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("file name")};
        MetaDataRecordList[] metaDataRecordListArray = null;
        MetaDataRecordList[] metaDataRecordListArray2 = null;
        MetaDataRecordList[] metaDataRecordListArray3 = null;
        Vector<String> vector = null;
        String string = null;
        try {
            string = this.isDirectory() ? this.getAbsolutePath() : this.getParent();
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("directory name", 0, string), metaDataConditionArray);
            metaDataRecordListArray = this.fileSystem.query(metaDataConditionArray2, metaDataSelectArray);
            if (this.completeDirectoryList) {
                metaDataRecordListArray = MetaDataRecordList.getAllResults(metaDataRecordListArray);
            }
            metaDataSelectArray[0] = MetaDataSet.newSelection("directory name");
            metaDataConditionArray2 = MetaDataSet.mergeConditions(MetaDataSet.newCondition("parent directory name", 0, string), (MetaDataCondition)null);
            metaDataRecordListArray2 = this.fileSystem.query(metaDataConditionArray2, metaDataSelectArray);
            if (this.completeDirectoryList) {
                metaDataRecordListArray2 = MetaDataRecordList.getAllResults(metaDataRecordListArray2);
            }
            if (metaDataRecordListArray2 != null) {
                String string2 = null;
                String string3 = null;
                for (int i = 0; i < metaDataRecordListArray2.length; ++i) {
                    string2 = metaDataRecordListArray2[i].getStringValue(0);
                    string3 = string2.substring(string2.lastIndexOf("/") + 1);
                    metaDataRecordListArray2[i].setValue(0, string3);
                }
            }
        }
        catch (IOException iOException) {
            if (SRBCommands.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return null;
        }
        if (metaDataRecordListArray != null && metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = new MetaDataRecordList[metaDataRecordListArray.length + metaDataRecordListArray2.length];
            System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray3, 0, metaDataRecordListArray.length);
            System.arraycopy(metaDataRecordListArray2, 0, metaDataRecordListArray3, metaDataRecordListArray.length, metaDataRecordListArray2.length);
        } else if (metaDataRecordListArray != null) {
            metaDataRecordListArray3 = metaDataRecordListArray;
        } else if (metaDataRecordListArray2 != null) {
            metaDataRecordListArray3 = metaDataRecordListArray2;
        } else {
            return new String[0];
        }
        vector = new Vector<String>();
        for (int i = 0; i < metaDataRecordListArray3.length; ++i) {
            if (metaDataRecordListArray3[i].getStringValue(0) == null) continue;
            vector.add(metaDataRecordListArray3[i].getStringValue(0));
        }
        return vector.toArray(new String[0]);
    }

    public boolean mkdir() {
        block3: {
            try {
                if (!this.isDirectory()) {
                    this.srbFileSystem.srbCreateCollect(catalogType, this.getParent(), this.getName());
                    return true;
                }
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG <= 0) break block3;
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException {
        block20: {
            if (generalFile instanceof SRBFile) {
                try {
                    if (this.isFile()) {
                        if (this.getParent().equals(generalFile.getParent())) {
                            this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, generalFile.getName(), "", 29);
                        } else if (this.getName().equals(generalFile.getName())) {
                            this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, generalFile.getParent(), "", 6);
                        } else {
                            String string = generalFile.getName() + (long)Math.random();
                            this.srbFileSystem.srbModifyDataset(catalogType, this.fileName, this.getParent(), "", this.serverLocalPath, string, "", 29);
                            try {
                                this.srbFileSystem.srbModifyDataset(catalogType, string, this.getParent(), "", this.serverLocalPath, generalFile.getParent(), "", 6);
                            }
                            catch (IOException iOException) {
                                if (SRBCommands.DEBUG > 0) {
                                    iOException.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(catalogType, string, this.getParent(), "", this.serverLocalPath, this.fileName, "", 29);
                            }
                            try {
                                this.srbFileSystem.srbModifyDataset(catalogType, string, generalFile.getParent(), "", this.serverLocalPath, generalFile.getName(), "", 29);
                            }
                            catch (IOException iOException) {
                                if (SRBCommands.DEBUG > 0) {
                                    iOException.printStackTrace();
                                }
                                this.srbFileSystem.srbModifyDataset(catalogType, string, generalFile.getParent(), "", this.serverLocalPath, this.getParent(), "", 6);
                                this.srbFileSystem.srbModifyDataset(catalogType, string, this.getParent(), "", this.serverLocalPath, this.fileName, "", 29);
                            }
                        }
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    if (this.isDirectory(false)) {
                        this.srbFileSystem.srbModifyCollect(catalogType, this.getAbsolutePath(), generalFile.getAbsolutePath(), null, null, 30);
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    if (!this.exists()) {
                        this.directory = new Vector();
                        this.setFileName(generalFile.getAbsolutePath());
                        return true;
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG > 0) {
                        iOException.printStackTrace();
                    }
                    break block20;
                }
            }
            try {
                this.copyTo(generalFile, false);
                this.delete();
                this.directory = new Vector();
                this.setFileName(generalFile.getAbsolutePath());
                return true;
            }
            catch (IOException iOException) {
                if (SRBCommands.DEBUG > 0) {
                    iOException.printStackTrace();
                }
                return false;
            }
        }
        return false;
    }

    public boolean setLastModified(long l) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public URI toURI() {
        URI uRI;
        block2: {
            uRI = null;
            try {
                uRI = this.isDirectory() ? new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath() + "/", "", "") : new URI("srb", this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName(), this.srbFileSystem.getHost(), this.srbFileSystem.getPort(), this.getAbsolutePath(), "", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                if (SRBCommands.DEBUG <= 0) break block2;
                uRISyntaxException.printStackTrace();
            }
        }
        return uRI;
    }

    public URL toURL() throws MalformedURLException {
        URL uRL = null;
        uRL = this.isDirectory() ? new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath() + "/") : new URL("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
        return uRL;
    }

    public String toString() {
        return new String("srb://" + this.srbFileSystem.getUserName() + "." + this.srbFileSystem.getDomainName() + "@" + this.srbFileSystem.getHost() + ":" + this.srbFileSystem.getPort() + this.getAbsolutePath());
    }

    class RegistrationThread
    implements Runnable {
        String bloadFilePath;
        Object mainThread;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(String string, Object object) throws IOException {
            this.bloadFilePath = string;
            this.mainThread = object;
        }

        void setBloadFilePath(String string) {
            this.bloadFilePath = string;
        }

        void addFile(GeneralFile generalFile, String string) {
            this.files.add(generalFile);
            this.paths.add(string);
        }

        public void run() {
            block2: {
                try {
                    this.register();
                }
                catch (IOException iOException) {
                    if (SRBCommands.DEBUG <= 0) break block2;
                    iOException.printStackTrace();
                }
            }
        }

        SRBMetaDataRecordList[] getFileRegistry(int n) throws IOException {
            int n2;
            SRBMetaDataRecordList sRBMetaDataRecordList = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[n];
            GeneralFile generalFile = null;
            Object var5_5 = null;
            Object var6_6 = null;
            Object var7_7 = null;
            String string = null;
            long l = 0L;
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                generalFile = (GeneralFile)this.files.get(n2);
                n3 = (int)((long)n3 + l);
                l = generalFile.length();
                string = (String)this.paths.get(n2);
                string = string == null || string.equals("") ? SRBFile.this.getAbsolutePath() : SRBFile.this.getAbsolutePath() + GeneralFile.separator + string;
                sRBMetaDataRecordList = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), generalFile.getName());
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("directory name"), string);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("file size"), l);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("offset"), n3);
                sRBMetaDataRecordListArray[n2] = sRBMetaDataRecordList;
            }
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (SRBCommands.DEBUG <= 0) break;
                    arrayIndexOutOfBoundsException.printStackTrace();
                    break;
                }
            }
            return sRBMetaDataRecordListArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register() throws IOException {
            Object object;
            int n = this.files.size();
            if (n > 0) {
                object = this.mainThread;
                synchronized (object) {
                    this.mainThread.notify();
                }
                SRBFile.this.srbFileSystem.srbBulkLoad(catalogType, this.bloadFilePath, this.getFileRegistry(n));
            }
            object = this.mainThread;
            synchronized (object) {
                this.mainThread.notify();
            }
        }
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile[] out;
        byte[] loadBuffer;
        byte[] buffer2;
        boolean writeLoadBuffer = false;
        int loadBufferLength = 0;
        boolean keepLoading = true;
        boolean restartRandom = false;
        GeneralFile newRandom;
        int randomIndex;
        Object mainThread;

        LoadThread(GeneralRandomAccessFile[] generalRandomAccessFileArray, byte[] byArray, Object object) {
            this.out = generalRandomAccessFileArray;
            this.loadBuffer = byArray;
            this.mainThread = object;
        }

        public void run() {
            int n = Integer.MIN_VALUE;
        }

        void restartRandomAccessFile() throws IOException {
            this.out[this.randomIndex] = FileFactory.newRandomAccessFile(this.newRandom, "rw");
            this.restartRandom = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int sendBuffer(int n) throws IOException {
            if (this.loadBufferLength <= 0) {
                return n;
            }
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.restartRandom) {
                    this.restartRandomAccessFile();
                }
            }
            this.out[SRBFile.this.activeRegistrationThread].write(this.loadBuffer, 0, this.loadBufferLength);
            this.loadBufferLength = 0;
            SRBFile.this.loadBufferCount = 0;
            return n;
        }
    }
}

