/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.dcm;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageio.stream.SegmentedImageInputStream;
import com.sun.media.imageio.stream.StreamSegmentMapper;
import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.ColorModelFactory;
import org.dcm4che2.image.LookupTable;
import org.dcm4che2.image.OverlayUtils;
import org.dcm4che2.image.VOIUtils;
import org.dcm4che2.imageio.ImageReaderFactory;
import org.dcm4che2.imageio.ItemParser;
import org.dcm4che2.imageio.plugins.dcm.DicomImageReadParam;
import org.dcm4che2.imageio.plugins.dcm.DicomStreamMetaData;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DicomImageReader
extends ImageReader {
    private static final Logger log = LoggerFactory.getLogger(DicomImageReader.class);
    private static final String J2KIMAGE_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    private static final int[] OFFSETS_0 = new int[]{0};
    private static final int[] OFFSETS_0_0_0 = new int[]{0, 0, 0};
    private static final int[] OFFSETS_0_1_2 = new int[]{0, 1, 2};
    private ImageInputStream iis;
    private DicomInputStream dis;
    private DicomObject ds;
    private int width;
    private int height;
    private int frames;
    private int allocated;
    private int dataType;
    private int samples;
    private boolean monochrome;
    private boolean banded;
    private long pixelDataPos;
    private int pixelDataLen;
    protected boolean compressed;
    private DicomStreamMetaData streamMetaData;
    protected ImageReader reader;
    private ItemParser itemParser;
    private SegmentedImageInputStream siis;
    protected String tsuid;

    protected DicomImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.resetLocal();
        if (input != null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("Input not an ImageInputStream!");
            }
            this.iis = (ImageInputStream)input;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resetLocal();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    private void resetLocal() {
        this.iis = null;
        this.dis = null;
        this.ds = null;
        this.streamMetaData = null;
        this.width = 0;
        this.height = 0;
        this.frames = 0;
        this.allocated = 0;
        this.dataType = 0;
        this.samples = 0;
        this.banded = false;
        this.pixelDataPos = 0L;
        this.pixelDataLen = 0;
        this.tsuid = null;
        this.compressed = false;
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
        this.itemParser = null;
        this.siis = null;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new DicomImageReadParam();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.readMetaData();
        return this.streamMetaData;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.readMetaData();
        return this.frames;
    }

    private void readMetaData() throws IOException {
        if (this.iis == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.ds != null) {
            return;
        }
        this.dis = new DicomInputStream(this.iis);
        this.dis.setHandler((DicomInputHandler)new StopTagInputHandler(2145386512));
        this.ds = this.dis.readDicomObject();
        this.streamMetaData = new DicomStreamMetaData();
        this.streamMetaData.setDicomObject(this.ds);
        this.tsuid = this.ds.getString(131088);
        this.width = this.ds.getInt(2621457);
        this.height = this.ds.getInt(2621456);
        this.frames = this.ds.getInt(0x280008);
        this.allocated = this.ds.getInt(2621696, 8);
        this.banded = this.ds.getInt(2621446) != 0;
        this.dataType = this.allocated <= 8 ? 0 : 1;
        this.samples = this.ds.getInt(0x280002, 1);
        this.monochrome = ColorModelFactory.isMonochrome((DicomObject)this.ds);
        if (this.dis.tag() == 2145386512) {
            if (this.frames == 0) {
                this.frames = 1;
            }
            this.pixelDataPos = this.dis.getStreamPosition();
            this.pixelDataLen = this.dis.valueLength();
            boolean bl = this.compressed = this.pixelDataLen == -1;
            if (this.compressed) {
                ImageReaderFactory f = ImageReaderFactory.getInstance();
                log.debug("Transfer syntax for image is " + this.tsuid + " with image reader class " + f.getClass());
                f.adjustDatasetForTransferSyntax(this.ds, this.tsuid);
            }
        }
    }

    protected void initImageReader(int imageIndex) throws IOException {
        if (this.reader != null) {
            return;
        }
        this.readMetaData();
        if (this.compressed) {
            this.initCompressedImageReader(imageIndex);
            this.itemParser.seekFrame(this.siis, imageIndex);
            this.reader.setInput(this.siis);
        } else {
            this.initRawImageReader();
        }
    }

    private void initCompressedImageReader(int imageIndex) throws IOException {
        ImageReaderFactory f = ImageReaderFactory.getInstance();
        this.reader = f.getReaderForTransferSyntax(this.tsuid);
        this.itemParser = new ItemParser(this.dis, this.iis, this.frames, this.tsuid);
        this.siis = new SegmentedImageInputStream(this.iis, (StreamSegmentMapper)this.itemParser);
    }

    private void initRawImageReader() {
        long[] frameOffsets = new long[this.frames];
        int frameLen = this.width * this.height * this.samples * (this.allocated >> 3);
        frameOffsets[0] = this.pixelDataPos;
        for (int i = 1; i < frameOffsets.length; ++i) {
            frameOffsets[i] = frameOffsets[i - 1] + (long)frameLen;
        }
        Object[] imageDimensions = new Dimension[this.frames];
        Arrays.fill(imageDimensions, new Dimension(this.width, this.height));
        RawImageInputStream riis = new RawImageInputStream(this.iis, this.createImageTypeSpecifier(), frameOffsets, (Dimension[])imageDimensions);
        riis.setByteOrder(this.ds.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.reader = ImageIO.getImageReadersByFormatName("RAW").next();
        this.reader.setInput(riis);
    }

    protected ImageTypeSpecifier createImageTypeSpecifier() {
        ColorModel cm = ColorModelFactory.createColorModel((DicomObject)this.ds);
        SampleModel sm = this.createSampleModel();
        return new ImageTypeSpecifier(cm, sm);
    }

    private SampleModel createSampleModel() {
        if (this.samples == 1) {
            return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, 1, this.width, OFFSETS_0);
        }
        if (this.banded) {
            return new BandedSampleModel(this.dataType, this.width, this.height, this.width, OFFSETS_0_1_2, OFFSETS_0_0_0);
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, 3, this.width * 3, OFFSETS_0_1_2);
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readMetaData();
        if (OverlayUtils.isOverlay((int)imageIndex)) {
            return OverlayUtils.getOverlayHeight((DicomObject)this.ds, (int)imageIndex);
        }
        return this.height;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readMetaData();
        if (OverlayUtils.isOverlay((int)imageIndex)) {
            return OverlayUtils.getOverlayWidth((DicomObject)this.ds, (int)imageIndex);
        }
        return this.width;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.initImageReader(1);
        return this.reader.getImageTypes(0);
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.initImageReader(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if (this.compressed) {
            ImageReadParam param1 = this.reader.getDefaultReadParam();
            this.copyReadParam(param, param1);
            return this.decompressRaster(imageIndex, param1);
        }
        return this.reader.readRaster(imageIndex, param);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        WritableRaster raster;
        DataBuffer data;
        LookupTable lut;
        BufferedImage bi;
        if (OverlayUtils.isOverlay((int)imageIndex)) {
            this.readMetaData();
            String rgbs = param != null ? ((DicomImageReadParam)param).getOverlayRGB() : null;
            return OverlayUtils.extractOverlay((DicomObject)this.ds, (int)imageIndex, (ImageReader)this, (String)rgbs);
        }
        this.initImageReader(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        if (this.compressed) {
            ImageReadParam param1 = this.reader.getDefaultReadParam();
            this.copyReadParam(param, param1);
            bi = this.reader.read(0, param1);
            this.postDecompress();
        } else {
            bi = this.reader.read(imageIndex, param);
        }
        if (this.monochrome && (lut = this.createLut((DicomImageReadParam)param, imageIndex + 1, data = (raster = bi.getRaster()).getDataBuffer())) != null) {
            DataBuffer dest = data;
            if (!(dest instanceof DataBufferByte) && lut instanceof ByteLookupTable) {
                BufferedImage ret = new BufferedImage(bi.getWidth(), bi.getHeight(), 10);
                dest = ret.getRaster().getDataBuffer();
                bi = ret;
            }
            lut.lookup(data, dest);
            if (dest.getDataType() == 2) {
                ColorModel cm = bi.getColorModel();
                short[] ss = ((DataBufferShort)data).getData();
                return new BufferedImage(cm, Raster.createWritableRaster(raster.getSampleModel(), new DataBufferUShort(ss, ss.length), null), cm.isAlphaPremultiplied(), new Hashtable());
            }
        }
        return bi;
    }

    public byte[] readBytes(int imageIndex, ImageReadParam param) throws IOException {
        this.initImageReader(imageIndex);
        if (this.compressed) {
            return this.itemParser.readFrame(this.siis, imageIndex);
        }
        int frameLen = this.width * this.height * this.samples * (this.allocated >> 3);
        byte[] ret = new byte[frameLen];
        long offset = this.pixelDataPos + (long)imageIndex * (long)frameLen;
        this.iis.seek(offset);
        this.iis.read(ret);
        return ret;
    }

    protected void copyReadParam(ImageReadParam src, ImageReadParam dst) {
        dst.setDestination(src.getDestination());
        dst.setSourceRegion(src.getSourceRegion());
        dst.setSourceSubsampling(src.getSourceXSubsampling(), src.getSourceYSubsampling(), src.getSubsamplingXOffset(), src.getSubsamplingYOffset());
        dst.setDestinationOffset(src.getDestinationOffset());
        if (ImageReaderFactory.getInstance().needsImageTypeSpecifier(this.tsuid)) {
            dst.setDestinationType(this.createImageTypeSpecifier());
        }
    }

    private Raster decompressRaster(int imageIndex, ImageReadParam param) throws IOException {
        this.itemParser.seekFrame(this.siis, imageIndex);
        this.reader.setInput(this.siis);
        if (!this.reader.canReadRaster()) {
            BufferedImage bi = this.reader.read(0, param);
            this.postDecompress();
            return bi.getRaster();
        }
        Raster raster = this.reader.readRaster(0, param);
        this.postDecompress();
        return raster;
    }

    protected void postDecompress() {
        if (this.reader.getClass().getName().startsWith(J2KIMAGE_READER)) {
            this.reader.dispose();
            ImageReaderFactory f = ImageReaderFactory.getInstance();
            this.reader = f.getReaderForTransferSyntax(this.tsuid);
        } else {
            this.reader.reset();
        }
    }

    private LookupTable createLut(DicomImageReadParam param, int frame, DataBuffer data) {
        DicomObject voiObj;
        short[] pval2gray = param.getPValue2Gray();
        DicomObject pr = param.getPresentationState();
        float c = param.getWindowCenter();
        float w = param.getWindowWidth();
        String vlutFct = param.getVoiLutFunction();
        if (param.isAutoWindowing() && (voiObj = VOIUtils.selectVoiObject((DicomObject)this.ds, (DicomObject)pr, (int)frame)) == null) {
            float[] cw = VOIUtils.getMinMaxWindowCenterWidth((DicomObject)this.ds, (DicomObject)pr, (int)frame, (DataBuffer)data);
            c = cw[0];
            w = cw[1];
            vlutFct = "LINEAR";
        }
        return LookupTable.createLutForImageWithPR((DicomObject)this.ds, (DicomObject)pr, (int)frame, (float)c, (float)w, (String)vlutFct, (int)8, (short[])pval2gray);
    }
}

