#!/usr/bin/perl -w

# $Id: lock_unlock.pl,v 1.2 2004/07/10 00:58:35 bozyurt Exp $
use strict;
use Fcntl ':flock'; # import LOCK_* constants

sub lock {
    my ($lock_file) = @_;
    open(LOCK_HANDLE,"+>> $lock_file") or croak("cannot open $lock_file:$!");
    flock(LOCK_HANDLE, LOCK_EX);       
}

sub unlock() {
    flock(LOCK_HANDLE, LOCK_UN);
    close(LOCK_HANDLE);
}

sub main() {
    my $cache_root = shift @ARGV;
    my $container = shift @ARGV;
    my $cmd = shift @ARGV;
    
    my $lock_file = "$cache_root/.$container";

    if ($cmd =~ /get_rl/) {
        lock($lock_file);
	print ("creating read lock file ${lock_file}_r\n");
        open(PH,">${lock_file}_r");
        close(PH);
        unlock(); 
    } elsif ($cmd =~ /rel_rl/) {
        lock($lock_file);
        unlink("${lock_file}_r");
        unlock(); 
    }   
}

main();
