package dcmutils;

# $Id: dcmutils.pm,v 1.1 2003/12/04 20:03:45 bozyurt Exp $

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);

use Exporter;

$VERSION = 1.00; 
@ISA = qw(Exporter);

@EXPORT = ();
@EXPORT_OK = ();
%EXPORT_TAGS = ();

use strict;
use Carp;



sub load_commands {
    my $fname = $_[0];
    my %dictname2cmd = ();
    open(FD, "$fname") or croak("Cannot open file $fname:$!");
    while(<FD>) {
	chomp;
	s/^\s+//;
	s/\s+$//;
        next if ( length $_ == 0 || /^#/ );
	croak("Not a valid command '$_'") unless (/(replace|delete|add)\s/);
	my ($cmd, @args) = split;
	if ( $cmd =~ /replace/ && scalar(@args) != 2 ) {
		      croak("replace command requires two arguments: tag name and value");	  
	} elsif ( $cmd =~ /add/ && scalar(@args) != 2) {
	    croak("add command requires two arguments: tag name and value");
	} elsif ( $cmd =~ /delete/ && scalar(@args) != 1) {
	    croak("delete command requires one argument: tag name");
	}
		  
	 my @arg_arr = @args;
	 unshift @arg_arr , ($cmd);
	 $dictname2cmd{$args[0]} = \@arg_arr; 

     }
     close(FD);
     return %dictname2cmd;
}


    sub prep_dict_maps {
	my ($dict_file, %dictname2cmd) = @_;
	my @map_arr = ();
	
	my %dictname2tag = ();
	my %dicttag2name = ();
	my %dictname2vr = ();
	open(FD, $dict_file) or croak("Cannot open file $dict_file:$!");
	while(<FD>) {
	    chomp;
	    /^(\(....,(\"[^\"]+\",)?....\))\s+(..)\s+([^\s]+)/ || next;
	    my ($tag, $vr, $name) = ($1,$3,$4);
	    if (exists $dictname2cmd{$name} ) {
		$dictname2tag{$name} = $tag;
		$dictname2vr{$name} = $vr;
		$dicttag2name{$tag} = $name; 
            }
	}
	close(FD);
	my @badnames = grep { my $matchthis = $_; scalar(grep(/^$matchthis$/, keys %dictname2tag)) == 0 } 
	keys %dictname2cmd;
	if (scalar(@badnames) > 0) {
	    croak "The following tag names do not exist in the DICOM dictionary:\n" .
		join(", ", sort @badnames) . "\n";
	}
        @map_arr = ( \%dictname2tag, \%dicttag2name, \%dictname2vr);
	return @map_arr;
    }


sub fix_dcm {
    my ($in_file, $out_file, $dictname2cmd_ref, @map_arr) = @_;
    my %dictname2cmd = %{$dictname2cmd_ref};
    my %dictname2tag = %{$map_arr[0]};
    my %dicttag2name = %{$map_arr[1]};
    my %dictname2vr =  %{$map_arr[2]};
    open(OUT,">${out_file}.dump") or croak("Cannot write to file '${out_file}.dump':$!");
    open(IN,"dcmtkdump --print-all --write-pixel /tmp $in_file |") or croak("Cannot start process dcmdump:$!");
    my $pixel_file = undef;
    my $in_image_comments = 0;
    my $in_tag = 0;
    while(<IN>) {
        # for the replace bug in dccp (IBO) introduced by dcanon 
        if ($in_image_comments) {
           $in_image_comments=0;
           next unless(/^(\(....,(\"[^\"]+\",)?....\))\s+(..)/);
	}
	/^(\(....,(\"[^\"]+\",)?....\))\s+(..)/ || do {
	 # if (defined($1) && $1 eq '(0020,4000)') {
	 #    $in_image_comments = 1;
	 #    print OUT "$1 $3 [anon]\n"; 
	 #    next;
         # }
	  print OUT $_; next; 
	};
	
	my ($tag, $vr) = ($1, $3);
	if ($tag eq '(7fe0,0010)') {
	    ($pixel_file) = /=([^\s]+)/;
	}
        if ($tag eq '(0020,4000)') {
          $in_image_comments = 1;
	  print OUT "$1 $3 [anon]\n"; 
	  next;
        }
        #if ($tag eq '(0020,000e)') {
        #    print " $dictname2cmd{ $dicttag2name{uc $tag} }\n";  
	#}
	exists($dicttag2name{uc $tag}) || do { print OUT $_; next; };
	my $name = $dicttag2name{uc $tag};
	exists($dictname2cmd{$name}) || do { print OUT $_; next; };
        my $ref = $dictname2cmd{$name};
        my @cmd_arr = @{$ref};
        if ($cmd_arr[0] =~ /replace/) {
            #print("replacing $tag! ( $tag $vr $cmd_arr[2] )\n");
	    print OUT "$tag $vr $cmd_arr[2]\n";
	    next;
	}
	next if ($cmd_arr[0] =~ /delete/) ;
    }
    close(IN);
    my @addcmds = grep { my $ref = $_; $ref->[0] =~ /add/ } values %dictname2cmd;
    foreach my $cmd_ref (@addcmds) {
        my $vr = $dictname2vr{ $cmd_ref->[1] };
	my $tag = $dictname2tag{ $cmd_ref->[1] };
        # print("$tag $vr $cmd_ref->[2]\n");
	print OUT "$tag $vr $cmd_ref->[2]\n";
    }
    close(OUT);
    fix_wrong_tag_lines("${out_file}.dump");
    
    system("dump2dcm --line 65536 $out_file.dump $out_file");
    if (defined($pixel_file)) {
	unlink($pixel_file);
    }
    unlink("$out_file.dump");
}

sub fix_wrong_tag_lines {
  my ($dump_file) = @_;
  my $last_line;
  my @lines = ();
  my $count = 0;
  open(IN,$dump_file) or  croak("Cannot read file '$dump_file':$!");
  while(<IN>) {
    chomp;
    s/^\s+//;
    s/\s+$//;
    next if ( length($_) == 0);
    if (/^#/) {
      push @lines, $_;
      $count++;
      next;
    }
    unless( /^\(\w{4,4},\w{4,4}\)\s+\w\w/ ) {
      $lines[$#lines] .= $_;
      next;
    }
    push @lines, $_;
    $count++;
  }
  close(IN);
  #system("mv -f $dump_file ${dump_file}.old");

  open(OUT, ">$dump_file") or croak("Cannot write file '$dump_file':$!");
  foreach my $line (@lines) {
    print OUT "$line\n";
  }
  close(OUT);
}
sub get_dicom_header_value {
    my ($fname, $field) = @_;
    my $value = undef; 
    open(PROC,"dcmtkdump $fname | ") or croak("Cannot start process:$!");
    my $key = undef;
    while(<PROC>) {
	chomp;
        if ( /(\w+)$/) {
	    $key = $1;
	}
        next unless ( defined($key) && $key eq $field );
        my $r;
	if ( /\[([^\[]+)\]/) {
	    $r = $1;
	} elsif ( /US\s+(\d+)/) {
	    $r = $1; 
	}
        if (defined($r)) {
	    $value = $r;
	    last;
        } 
    }
    close(PROC);
    return $value;
}       


sub get_dicom_header_values {
    my ($fname, @fields) = @_;
    my %value_map = ();
    my %field_map = map { $_ => $_ } @fields;
    open(PROC,"dcmtkdump $fname | ") or croak("Cannot start process:$!");
    while(<PROC>) {
	chomp;
        my $key;
        if ( /(\w+)$/) {
	    $key = $1;
	}
        next unless ( defined($key) && exists $field_map{$key} );
        my $r;
	if ( /\[([^\[]+)\]/) {
	    $r = $1;
	} elsif ( /US\s+(\d+)/) {
	    $r = $1; 
	}
        $value_map{$key} = $r;
    }

    close(PROC);
    return %value_map;
}

1;

=head1 NAME

    dcmutils.pm 

=cut

=head1 SYNOPSIS

    use dcmutils;
    
    
    dcmutils::fix_dcm($in_file, $out_file, $dictname2cmd_ref, @map_arr)

   
    dcmutils::get_dicom_header_values($fname, @fields);

=cut

=head1 DESCRIPTION

  dcmutils::get_dicom_header_values($fname, @fields)

  Given a DICOM file name and a list of DICOM header field 
  dictionary names, returns an associative array of header 
  values keyed by DICOM header field dictionary name

  

=cut

=head1 AUTHOR

    fix_dcm is extended from a perl script written by Syam Gadde.    
    Written by I. Burak Ozyurt 

=cut

=head1 NOTES

The following external programs from DCMTK 3.5.2  are used by dcmutils.pm

=over 4

=item I<dcmtkdump>

renamed from dcmdump to avoid name clash with  dcmdump  from dicomtools by D. Clunie.
for getting DICOM header field values

=item I<dump2dcm>

to update/add DICOM header fields


=back

=cut
