#!/bin/sh

 
if [ "$CLINICAL_HOME" == "" ]
then
  CLINICAL_HOME=$HOME/dev/java/BIRN/clinical
fi
if [ ! -d "$CLINICAL_HOME" ]
then 
  echo ""
  echo "Cannot continue"
  echo "Please set the environment var CLINICAL_HOME to a valid directory:$CLINICAL_HOME"
  exit 1;
fi

unset CLASSPATH

for lib in $CLINICAL_HOME/lib/*.jar
do
  if [ "$CLASSPATH" == "" ]
  then
    CLASSPATH=$lib
  else
    CLASSPATH=${CLASSPATH}:$lib
  fi
done

PARAMS="-Djavax.net.debug=none -Djava.protocol.handler.pkgs=com.sun.net.internal.www.protocol"

java $PARAMS -cp $CLASSPATH clinical.xml.gui.ExportImportClient -https $* 

