CREATE OR REPLACE PACKAGE BODY ASSESSMENT_MAN 
AS

FUNCTION get_assessments(subject_id_in VARCHAR2,experiment_id_in NUMBER) RETURN ref_as_cur 
AS
 as_cursor ref_as_cur;
BEGIN
  OPEN as_cursor FOR
     SELECT  distinct a.assessmentid, a.modtime, name, b.componentid, b.segmentid 
     from nc_assessment a, nc_storedassessment b
     where a.assessmentid = b.assessmentid and b.subjectid = subject_id_in and 
       b.NC_EXPERIMENT_UNIQUEID = experiment_id_in;
  RETURN as_cursor;
END get_assessments;
  

FUNCTION get_assessment_scores_for(as_id_list_in as_id_list_type) RETURN ref_as_cur
AS
  as_score_cursor ref_as_cur;
  query VARCHAR2(1000);
  idx INTEGER;
BEGIN
  query := ' select assessmentid, scorename, scoretype, scorelevel, parentasid, parentscore,scoresequence from nc_assessmentscore where ';
    
  query := query || ' assessmentid in (';
  idx := as_id_list_in.FIRST;
  while idx IS NOT NULL
  LOOP
    query := query || as_id_list_in(idx);
    idx := as_id_list_in.NEXT(idx);
    IF idx IS NOT NULL THEN
       query := query || ',';
    END IF;
  END LOOP;
  query := query || ') order by assessmentid';

  OPEN as_score_cursor FOR query;
  RETURN as_score_cursor; 
END get_assessment_scores_for;

FUNCTION get_assessment_values(subject_id_in VARCHAR2, experiment_id_in NUMBER, as_id_list_in as_id_list_type, 
   visit_id_in NUMBER := -1,
   segment_id_in NUMBER := -1) RETURN ref_as_cur
AS
  as_value_cursor ref_as_cur;
  TYPE as_rec_type IS RECORD (
     as_id NC_ASSESSMENT.ASSESSMENTID%TYPE,
     modtime NC_ASSESSMENT.MODTIME%TYPE,
     name NC_ASSESSMENT.NAME%TYPE,
     description NC_ASSESSMENT.DESCRIPTION%TYPE     
  );
  TYPE as_rec_list_type IS TABLE OF as_rec_type INDEX BY BINARY_INTEGER;
  as_rec_list as_rec_list_type; 
  CURSOR as_cur IS select assessmentid from nc_assessment;
  in_sql VARCHAR2(1000);
  out_sql VARCHAR2(4000);
  idx INTEGER;
BEGIN
  in_sql := 'select uniqueid from nc_storedassessment where assessmentid in(';
  idx := as_id_list_in.FIRST;
  WHILE idx IS NOT NULL
  LOOP
    in_sql := in_sql || as_id_list_in(idx);
    idx := as_id_list_in.NEXT(idx);
    IF idx IS NOT NULL THEN
       in_sql := in_sql || ',';
    END IF;
  END LOOP;
  in_sql := in_sql || ') AND SUBJECTID=''' || subject_id_in || '''';
  IF experiment_id_in >= 0 THEN
    in_sql := in_sql || ' AND NC_EXPERIMENT_UNIQUEID=' || experiment_id_in; 
  END IF;
  IF visit_id_in >= 0 THEN
    in_sql := in_sql || ' AND COMPONENTID=' || visit_id_in;
  END IF;
  IF segment_id_in >= 0 THEN
     in_sql := in_sql || ' AND SEGMENTID=' || segment_id_in;
  END IF;

  out_sql := 'select assessmentid, scorename, scoretype, textvalue, scoreorder from nc_assessmentdata where NC_STOREDASSESSMENT_UNIQUEID IN (' || in_sql || ')';
  DBMS_OUTPUT.PUT_LINE('out_sql = ' || out_sql);
  OPEN as_value_cursor FOR out_sql;
  
  return as_value_cursor;
END get_assessment_values;

procedure test_get_assessment_values 
AS
 subject_id VARCHAR2(100);
 as_id_list as_id_list_type := as_id_list_type(1263);
 as_value_cursor ref_as_cur;
 TYPE as_value_rec_type IS RECORD (
     scorename NC_ASSESSMENTDATA.SCORENAME%TYPE,
     scoretype NC_ASSESSMENTDATA.SCORETYPE%TYPE,
     textvalue NC_ASSESSMENTDATA.TEXTVALUE%TYPE,
     scoreorder NC_ASSESSMENTDATA.SCOREORDER%TYPE     
  );
  as_value_rec as_value_rec_type;
BEGIN
  subject_id := 'UCSD98268869';
  as_value_cursor := get_assessment_values(subject_id, 7, as_id_list);
  LOOP
    FETCH as_value_cursor into as_value_rec.scorename, as_value_rec.scoretype, as_value_rec.textvalue, as_value_rec.scoreorder;
    EXIT WHEN as_value_cursor%NOTFOUND;
    DBMS_OUTPUT.PUT_LINE('scorename=' || as_value_rec.scorename);
    
  END LOOP;
END  test_get_assessment_values;  


END;
/
