
-- 
-- deletes a a visit for a subject including the clinical assessments done during this visit
--

create or replace function del_subject_visit(varchar, varchar, numeric) returns integer as '
declare
  exp_name_in alias for $1;
  subject_id_in alias for $2;
  visit_id_in alias for $3;
  v_exp_id numeric := -1;
  v_sa_id numeric := -1;
  exp_cur cursor for select uniqueid from nc_experiment where name = exp_name_in;
  sa_cur cursor for select a.uniqueid from nc_storedassessment a, nc_experiment b 
  where a.nc_experiment_uniqueid = b.uniqueid and  
  a.subjectid = subject_id_in and a.componentid = visit_id_in and b.name = exp_name_in; 
    
begin
  open exp_cur;
  fetch exp_cur into v_exp_id;
  if v_exp_id is NULL then
     v_exp_id := -1;
  end if;
  close exp_cur;
  raise notice ''expID:%'', v_exp_id;
  if v_exp_id = -1 then
     return -1;
   end if;
   
   open sa_cur;
   loop
     fetch sa_cur into v_sa_id;
     if v_sa_id is NULL then
	exit;
     end if;
     delete from nc_assessmentinteger where storedassessmentid = v_sa_id;
     delete from nc_assessmentvarchar where storedassessmentid = v_sa_id;
     delete from nc_assessmentfloat where storedassessmentid = v_sa_id;
     delete from nc_assessmenttimestamp where storedassessmentid = v_sa_id;
     delete from nc_assessmentboolean where storedassessmentid = v_sa_id;
     delete from nc_storedassessment where uniqueid = v_sa_id;
   end loop;
   close sa_cur;
   
   delete from nc_dataobject where dataid in (select uniqueid from nc_rawdata where nc_experiment_uniqueid = v_exp_id and subjectid = subject_id_in and componentid = visit_id_in);
   delete from nc_rawdata where nc_experiment_uniqueid = v_exp_id and subjectid = subject_id_in and componentid = visit_id_in;
   delete from nc_expsegment where nc_experiment_uniqueid = v_exp_id and subjectid = subject_id_in and componentid = visit_id_in;
   delete from nc_expstudy where experimentid = v_exp_id and subjectid = subject_id_in and componentid = visit_id_in;
   delete from nc_expcomponent where nc_experiment_uniqueid = v_exp_id and subjectid = subject_id_in and componentid = visit_id_in;
   
  return 0;
end;
' LANGUAGE plpgsql;

--
-- Deletes a subject from an experiment including all her assessments , visits. However the subject record
-- is not deleted from nc_humansubject table, since a subject can be associated with more than one experiment. 
--

create or replace function del_subject(varchar, varchar) returns integer as '
declare
  exp_name_in alias for $1;
  subject_id_in alias for $2;
  v_comp_id numeric := -1;
  v_exp_id numeric := -1;
  v_rc numeric := -1;
  exp_cur cursor for select uniqueid from nc_experiment where name = exp_name_in;
  visit_cur cursor for select a.componentid from nc_expcomponent a, nc_experiment b where a.nc_experiment_uniqueid = b.uniqueid and a.subjectid = subject_id_in and b.name = exp_name_in;
begin
  open exp_cur;
  fetch exp_cur into v_exp_id;
  if v_exp_id is NULL then
     v_exp_id := -1;
  end if;
  close exp_cur;
  if v_exp_id = -1 then
     return -1;
   end if;
  open visit_cur;
  loop
    fetch visit_cur into v_comp_id;
    if v_comp_id is NULL then
       exit;
    end if;
    v_rc := del_subject_visit(exp_name_in, subject_id_in, v_comp_id);
  end loop;
  close visit_cur;
  delete from nc_subjexperiment where nc_experiment_uniqueid = v_exp_id and subjectid = subject_id_in;

  return 0;
end;
' LANGUAGE plpgsql;


