#!/usr/bin/perl

#
# a simple wrapper around gr and gr_8ph for creating AFNI briks in the specified directory
# I. Burak Ozyurt

use warnings;
use strict;
use Cwd;

sub usage() {
die<<EOS
  $0 <p-file-full-path> <prefix> <dest-dir> [-use-8ph]
EOS
}


sub get_pfile_version {
	my ($pfile_path) = @_;
	open(PROC,"/usr/local/bin/rdgehdr $pfile_path |") or die "cannot run program: $!\n";
	my $version = undef;
   while(<PROC>) {
		chomp;
		my $line = $_;
		if (/\/(\d\dx)\//) {
			$version = $1;
		}
		last;
	}
	close(PROC);
	return $version;
}

sub get_speprev_value {
   my ($pfile_path) = @_;
   open(PROC,"/usr/local/bin/gr22_header_dump $pfile_path x |") 
   #open(PROC,"/usr/local/bin/gr20_header_dump $pfile_path x |") 
    or die "cannot run program: $!\n";
   my $speprev = undef;
   while(<PROC>) {
     chomp;
     my $line = $_;
     if (/speprev:(\d+(\.\d+))/) {
        $speprev = $1;
     }
   }
   close(PROC);
   return $speprev;
}


usage() unless (@ARGV >= 3);

my $pfile_path = shift @ARGV;
my $prefix = shift @ARGV;
my $dest_dir = shift @ARGV;
my $use_8ph = 0;
my $arg = undef;

$arg = shift @ARGV if (@ARGV);

if ($arg && $arg =~ /^-use-8ph/) {
     $use_8ph = 1;
}   

usage() unless (-e $pfile_path);
usage() unless (-d $dest_dir);

my $version =  get_pfile_version($pfile_path);

my $cur_dir = getcwd;
chdir($dest_dir);
my $cmd = undef;
#if ($use_8ph) {
#  $cmd = "/usr/local/bin/gr_8ph $pfile_path $prefix";
#} else {
  if ($version eq "11x") {
     $cmd = "/usr/local/bin/grSR11x $pfile_path $prefix";
  } elsif ($version eq "14x") {
     $cmd = "/usr/local/bin/grSR14x $pfile_path $prefix";
  } elsif ($version eq "12x") {
     $cmd = "/usr/local/bin/gr17.3 $pfile_path $prefix";
  } elsif ($version eq "20x") {
     my $speprev = get_speprev_value($pfile_path);
     print "speprev=$speprev\n";
     if ($speprev >= 50.7) {
         $cmd = "/usr/local/bin/gr18.1 $pfile_path $prefix";
     } elsif ($speprev > 50.3) {
         $cmd = "/usr/local/bin/gr17.7b $pfile_path $prefix";
      } else {
         $cmd = "/usr/local/bin/gr17.6 $pfile_path $prefix";
      }
  } else {
	  die("Not a supported GE version:$version\n");
  }

  #$cmd = "/usr/local/bin/gr $pfile_path $prefix";
#}
print ">> $cmd\n";
if (exists $ENV{'PATH'}) {
  print $ENV{'PATH'} . "\n";
} else {
  $ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin:/data/apps/afni/linux_gcc33_64';
}

system($cmd);
chdir($cur_dir);


