#!/usr/bin/perl

use warnings;
use strict;
use File::Basename;


my $in_root = "/data/share/tom_caffeine_processed";
my $out_dir = "/data/share/tom_caffeine_processed/out";


sub cp_anat {
   my ($from, $to, $brik_name) = @_;
   run("cp $from/${brik_name}.BRIK $to/anat+orig.BRIK");
   run("cp $from/${brik_name}.HEAD $to/anat+orig.HEAD");
}

sub run {
   my ($cmd) = @_;
   print "$cmd\n";
   system($cmd);
}
sub prep_subject {
   my ($subject) = @_;
   my $out_subj_dir = "$out_dir/$subject";
   mkdir $out_subj_dir;
   my @files = <$in_root/$subject/*>;
   foreach my $vd (@files) {
      next unless -d $vd;
      my $visit_name = basename $vd;
      my $out_vd = "$out_subj_dir/$visit_name";
      my @to_pre_dirs = ("$out_vd/pre/ec","$out_vd/pre/eo");
      my @to_post_dirs = ("$out_vd/post/ec","$out_vd/post/eo");
      mkdir $out_vd;
      mkdir "$out_vd/pre";
      mkdir "$out_vd/post";
      mkdir "$out_vd/pre/ec";
      mkdir "$out_vd/pre/eo";
      mkdir "$out_vd/post/ec";
      mkdir "$out_vd/post/eo";
      my $in_proc_dir = "$vd/fmri/processed";
      my $in_fmri_dir = "$vd/fmri";

      foreach my $to_dir (@to_pre_dirs) {
        run("cp $in_fmri_dir/CSF1+dbl+orig.{BRIK,HEAD} $to_dir"); 
        run("cp $in_fmri_dir/MinCon1+dbl+orig.{BRIK,HEAD} $to_dir"); 
      }
      
      foreach my $to_dir (@to_post_dirs) {
        run("cp $in_fmri_dir/CSF2+dbl+orig.{BRIK,HEAD} $to_dir"); 
        run("cp $in_fmri_dir/MinCon2+dbl+orig.{BRIK,HEAD} $to_dir"); 
      }
      cp_anat($in_fmri_dir, "$out_vd/pre/ec", "04_csf_anat+nuc+orig");
      cp_anat($in_fmri_dir, "$out_vd/pre/eo", "04_csf_anat+nuc+orig");
      cp_anat($in_fmri_dir, "$out_vd/post/ec", "20_csf_anat+nuc+orig");
      cp_anat($in_fmri_dir, "$out_vd/post/eo", "20_csf_anat+nuc+orig");

      run("cp $in_fmri_dir/08_rest_EC_optPCASL+dbl+orig.{BRIK,HEAD} $out_vd/pre/ec");
      run("cp $in_fmri_dir/07_rest_EO_optPCASL+dbl+orig.{BRIK,HEAD} $out_vd/pre/eo");
      run("cp $in_fmri_dir/24_rest_EC_optPCASL+dbl+orig.{BRIK,HEAD} $out_vd/post/ec");
      run("cp $in_fmri_dir/23_rest_EO_optPCASL+dbl+orig.{BRIK,HEAD} $out_vd/post/eo");
   }
}

sub prep_masks() {
  my $mask_name = "04_aparc+aseg+reg+rs+orig";
  my $mask_dir = "$out_dir/Masks";
  mkdir $mask_dir;
  my @subject_dirs = <$in_root/11*>;
  foreach my $sd (@subject_dirs) {
     my $subject_name = basename $sd;
     my $mask_sd = "$mask_dir/$subject_name";
     mkdir $mask_sd;
     my @files = <$sd/*>;
     foreach my $vd (@files) {
        next unless -d $vd;
        my $visit_name = basename $vd;
        my $mask_vd = "$mask_sd/$visit_name";
        mkdir $mask_vd;
        my $in_proc_dir = "$vd/fmri/processed";
        run("cp $in_proc_dir/${mask_name}.{BRIK,HEAD} $mask_vd");
     }
  }
} 

sub prep_masks_final() {
   my $pre_mask_name = "04_aparc+aseg_+reg+rs+orig";
   my $post_mask_name = "20_aparc+aseg_+reg+rs+orig";
   my $mask_dir = "$out_dir/Masks";
   mkdir $mask_dir;
   my @subject_dirs = <$in_root/11*>;
   foreach my $sd (@subject_dirs) {
     my $subject_name = basename $sd;
     my $mask_sd = "$mask_dir/$subject_name";
     mkdir $mask_sd;
     my @files = <$sd/*>;
     foreach my $vd (@files) {
        next unless -d $vd;
        my $visit_name = basename $vd;
        my $mask_vd = "$mask_sd/$visit_name";
        mkdir $mask_vd;
        my $pre_mask_vd = "$mask_vd/pre";
        my $post_mask_vd = "$mask_vd/post";
        mkdir $pre_mask_vd;
        mkdir $post_mask_vd;

        my $in_proc_dir = "$vd/fmri/aparc_cbfbirn";
        run("cp $in_proc_dir/${pre_mask_name}.{BRIK,HEAD} $pre_mask_vd");
        run("cp $in_proc_dir/${post_mask_name}.{BRIK,HEAD} $post_mask_vd");
     }
   }


}
sub prep_subjects() {
 mkdir $out_dir;
 my @subject_dirs = <$in_root/11*>;
 foreach my $sd (@subject_dirs) {
    next unless -d $sd;
    prep_subject(basename $sd);
 }
}

prep_subjects();
prep_masks_final();

