import gtools.utils.DBUtils;
import gtools.utils.GenUtils;

import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.IDataSet;


/**
  @author I. Burak Ozyurt
  @version $Id: HIDTestUtils.groovy,v 1.3 2008/09/10 18:15:22 bozyurt Exp $
*/

class HIDTestUtils {
   def db;
   public HIDTestUtils() {
      def props = [:]
      def usersXMLFile = this.class.getResource('users.xml').getPath()
      println "usersXMLFile:$usersXMLFile"
      db = DBUtils.getDb(usersXMLFile, props);

      // props.each {key,value -> println "$key => $value" }
   }

      public void exportDB2FlatSet(String flatSetFile, tableNames = null, String schemaName = null) {
          flatSetFile = GenUtils.adjustPath(flatSetFile);
          def IDatabaseConnection ic = new  DatabaseConnection(db.connection, schemaName);
          def dataSet = null
          if (tableNames != null) {
             dataSet = new QueryDataSet(ic);
             for(tn in tableNames) {
                 partialDataSet.addTable(tn);
             }
          } else {
             dataSet = ic.createDataSet();
          }
          FlatXmlDataSet.write(dataSet, new FileOutputStream(flatSetFile));
   }

   public void prepDBDTD(String dtdFilename, String schemaName=null) {
         dtdFilename = GenUtils.adjustPath(dtdFilename);
         def IDatabaseConnection ic = new  DatabaseConnection(db.connection, schemaName);
         FlatDtdDataSet.write(ic.createDataSet(), new FileOutputStream(dtdFilename));
   }

    public static getNonEmptyTables(String xmlFile, boolean filterBigTables = false) {
       xmlFile = GenUtils.adjustPath(xmlFile)
          def tableNames = [];
          def reader = new FileReader(xmlFile);
          def recs = new XmlParser().parse(reader);
          def count = 0;
          for(te in recs.table) {
             if (te.'@numRows'.toInteger() > 0) {
                 println te.'@name' << ' ' << te.'@numRows' ;
                 if ( filterBigTables &&
                       (te.'@numRows'.toInteger() < 50 || te.'@name' == 'NC_TABLEID') ) {
                      tableNames << te.'@name';
                      println 'adding table ' << te.'@name';
                 }
                 ++count
             }
          }
          println "# of non-empty tables: $count"
          return tableNames;
    }

    public static prepPath(String path) {
       def fileSep = System.getProperty('file.separator');
       if (path.startsWith(fileSep)) return path;
       return new File(System.getProperty('user.dir'),path).absolutePath;
    }


    static void execute(args) {
       def cli = new CliBuilder(usage:"run.groovy HIDTestUtils [-c create -s <schema-dtd-file>]|[-c export -o <flat-set-file>]");
       cli.c(argName: 'command', args : 1, required: true, "command <create|export>");
       cli.s(argName :'schema-dtd', args : 1, 'schema-dtd-file')
       cli.o(argName : 'output' , args : 1, "output <flat-set-file>");

       def opt = cli.parse(args)
       if (!opt) {
          return
       }


       def command = opt.c;

       def h = new HIDTestUtils();
       println "command:$command"
       if (command == 'create') {
           def dtdFileName = prepPath( opt.s );
           h.prepDBDTD(dtdFileName);
       } else if (command == 'export') {
          def flatSetFile = prepPath( opt.o )
          h.exportDB2FlatSet(flatSetFile);
       }

    }
}

// HIDTestUtils.execute(args)



