class InputUtils {
   public static List selectMultiple(objList, pageSize = 10) {
      def list = []
      def numLines = objList.size().intdiv(2) + objList.size() % 2
      def numPages = numLines.intdiv(pageSize);
      numPages += (numLines % pageSize) == 0 ? 0 : 1;

      println "numPages:$numPages numLines:$numLines"
      def console = new BufferedReader(new InputStreamReader(System.in))
      def curLines = 0
      def idx = 0
      for(p in 0..<numPages) {
         def lines = (numLines - curLines) > pageSize ? pageSize : numLines - curLines
         def entries = (idx + lines * 2) < objList.size() ? lines * 2 : objList.size() - idx
	     while(true) {
	       for(i in 0..<entries) {
	         def c = idx + i
              print "$c) " + objList[idx + i] + '\t'
             if (i > 0 && (i % 2) ==1) println ''
	       }
	       print "\nSelection[Single, range, comma-separated,s or q]: "
	       def ans = console.readLine().trim()
	       if (ans ==~ /q/) return list
	       if (ans ==~ /s/) break
	       def rlist = parseSelection(ans)
	       if (rlist == null) continue;
	       rlist.each { list << objList[(int)it] }
	       break
	     }
	     idx += entries
      }
      return list
   }

   static parseSelection(ans) {
      if ( ans ==~ /\d+-\d+/) {
         def m = (ans =~ /(\d+)-(\d+)/)
         if (m.find()) {
	       def list = []
           int start = Integer.parseInt(m[0][1]);
           int end = Integer.parseInt(m[0][2]);
	       (start..end).each { list << it }
	       return list
         }
      } else if (ans ==~ /\d+/) {
          return [Integer.parseInt(ans)]
      } else if (ans ==~ /\d+(\s*,\s*\d+)+/) {
          def slist = ans.split(",")
	      def list = []
	      slist.each { list << Integer.parseInt( it.trim() ) }
	      return list
      }
      return null
   }

   static void main(String[] args) {
     def list = []
     (0..50).each { i -> list.add(i + ". Entry") }
     def slist = InputUtils.selectMultiple(list)
     slist.each { println it }
   }
}//;


