package fbirn;

import java.io.StringWriter;

import fbirn.db.AssessmentDAO;
import fbirn.db.AssessmentdataDAO;
import fbirn.db.AssessmentitemDAO;
import fbirn.db.AssessmentscoreDAO;
import fbirn.db.AssessmentscorecodeDAO;
import fbirn.db.CollectionequipmentDAO;
import fbirn.db.DBUtils;
import fbirn.db.ExpcomponentDAO;
import fbirn.db.ExperimentDAO;
import fbirn.db.ProtocolDAO;
import fbirn.db.RawdataDAO;
import fbirn.db.ResearchgroupDAO;
import fbirn.db.ResearchgrouptypeDAO;
import fbirn.db.StoredassessmentDAO;
import fbirn.db.SubjexperimentDAO;
import fbirn.util.GenUtils;
import groovy.sql.Sql;
import groovy.util.CliBuilder;
import groovy.xml.MarkupBuilder;


class ExpSubjectExtractor {
	
	def public static extractAssessmentData(db, String expName, String site) {
		def asIds = getAssessmentIds4Exp(db,expName)
		if (asIds.isEmpty()) {
			println "No assessments for experiment:$expName"
			return
		}
		def expDAO = new ExperimentDAO(db: db)
		def expList = expDAO.find("where name='$expName'")
		def expVO = expList[0];
		def seDAO = new SubjexperimentDAO(db : db)
		def seList = seDAO.find("where nc_experiment_uniqueid = " + expVO.uniqueid)
		dumpVOs(seDAO, seList)
		def rgDAO = new ResearchgroupDAO(db: db)
		def rgList = rgDAO.find("where nc_experiment_uniqueid=${expVO.uniqueid}")
		
		def visitDAO = new ExpcomponentDAO(db :db)
		String wp = "where nc_experiment_uniqueid=${expVO.uniqueid} and ";
		wp += buildWhereInPart('subjectid', seList,'subjectid',false)
		wp += " order by subjectid,componentid"
		def vList = visitDAO.find(wp)
		dumpVOs(visitDAO,vList)
		
		
		wp = "where nc_experiment_uniqueid=${expVO.uniqueid} and " + buildWhereInList('assessmentid', asIds) + " order by subjectid,componentid,assessmentid"
		def saDAO = new StoredassessmentDAO(db: db)
		def saList = saDAO.find(wp)
		dumpVOs(saDAO,saList)
		def saIds = []
		saList.each { saIds << it.uniqueid }
		wp = "where " + buildWhereInList('nc_storedassessment_uniqueid', saIds)
		
		def adDAO = new AssessmentdataDAO(db : db)
		def adList = adDAO.find(wp)
		dumpVOs(adDAO,adList)
		
		def asMap = [:]
		def asDAO = new AssessmentDAO(db : db)
		def asList = asDAO.find("where " + buildWhereInList('assessmentid', asIds))
		asList.each { a -> asMap[a.uniqueid] = a }
		
		def workDir = System.properties['user.dir']
		def resultsDir = new File(workDir,'results')
		resultsDir.mkdir()
		
		def xml = asData2Xml(expVO, seList, rgList, saList, adList, vList, asMap)
		writeFile(new File(resultsDir,"as_data_${expName}_${site}.xml"), xml)
	}
	
	static class SAData {
		def sa;
		def adList = [];
	}
	
	
	def public static String asData2Xml(expVO, seList, rgList, saList, adList, vList, asMap) {
		def rgMap = [:]
		def sadMap = [:]
		def saMap = [:]
		def visitMap = [:]
		
		rgList.each { rg -> rgMap[rg.uniqueid]  = rg }
		saList.each { sa -> saMap[sa.uniqueid] = sa }
		adList.each { ad -> 
			def sa = saMap[ad.nc_storedassessment_uniqueid]
			assert sa
			def sad = sadMap[sa.uniqueid]
			if (sad == null) { 
				sad = new SAData(sa: sa);
				sadMap[sa.uniqueid] = sad
			}
			sad.adList << ad
		}
		vList.each { v ->  
		    def list = visitMap[v.subjectid]
			if (list == null) {
				list = [];
				visitMap.put v.subjectid, list
			}
			list << v
		}
		
		def writer = new StringWriter()
		def builder = new MarkupBuilder(writer)
		def asData = builder.asData(expName: expVO.name) {
			subjects() {
				for(se in seList) {
					def rg = rgMap[se.nc_researchgroup_uniqueid]
					assert rg
					subjExp(uniqueid:se.uniqueid, subjectid:se.subjectid, group:rg.name) {
						def list = visitMap[se.subjectid]
						for(v in list) {
							visit(componentid:v.componentid,subjectid:v.subjectid,name:v.name,timeStamp:v.time_stamp, 
								visittype:v.visittype, description:v.description) 
						}
					}
				}
			}
			values() {
				for(sa in saList) {
					def sad = sadMap[sa.uniqueid]
					def assessment = asMap[sad.sa.assessmentid]
					storedas(subjectid:sad.sa.subjectid, componentid:sad.sa.componentid, assessmentid:sad.sa.assessmentid, 
						    asName: assessment.name,
							segmentid:sad.sa.segmentid, timeStamp:sad.sa.time_stamp,informantrelation:sad.sa.informantrelation,
							isvalidated:sad.sa.isvalidated) {
								for(asv in sad.adList) {
									asval(scorename:asv.scorename,textvalue:asv.textvalue,scoretype:asv.scoretype, 
											scoreorder:asv.scoreorder, isvalidated:asv.isvalidated,classification:asv.classification)
								}
							}
				}
			}
		}
		String s = writer.toString()
		println s
		return s
	}
	
	def public static extractAssessmentMetaData(db, String expName, String site) {
		def asIds = getAssessmentIds4Exp(db,expName)
		if (asIds.isEmpty()) {
			println "No assessments for experiment:$expName"
			return
		}
		def expDAO = new ExperimentDAO(db: db)
		def expList = expDAO.find("where name='$expName'")
		def expVO = expList[0];
		
		def asDAO = new AssessmentDAO(db: db)
		String wp = "where " + buildWhereInList('assessmentid', asIds)
		def asList = asDAO.find(wp)
		dumpVOs(asDAO, asList)
		
		def scoreDAO = new AssessmentscoreDAO(db : db)
		def scoreList = scoreDAO.find(wp)
		dumpVOs(scoreDAO,scoreList)
		
		def scDAO = new AssessmentscorecodeDAO(db : db)
		def scList = scDAO.find(wp)
		dumpVOs scDAO, scList
		
		def aiDAO = new AssessmentitemDAO(db : db)
		def aiList = aiDAO.find(wp)
		dumpVOs aiDAO, aiList
		
		def workDir = System.properties['user.dir']
		def resultsDir = new File(workDir,'results')
		resultsDir.mkdir()
		
		def xml = asMeta2Xml(expVO, asList, scoreList, scList, aiList)
		writeFile(new File(resultsDir,"as_meta_${expName}_${site}.xml"), xml)
	}
	
	def public static String asMeta2Xml(expVO, asList, scoreList, scList, aiList) {
		def scMap  = [:]
		def scoreMap = [:]
		def aiMap = [:]
		scoreList.each { s -> 
			def list = scoreMap[s.assessmentid]
			if (list == null) { list = []; scoreMap[s.assessmentid] = list
			}
			list << s
		}
		scList.each { s -> 
			def key = "${s.assessmentid}:${s.scorename}"
			def list = scMap[key]
			if (list == null) { list = []; scMap[key] = list
			}
			list << s
		}
		aiList.each { s ->
			def key = "${s.assessmentid}:${s.scorename}"
			aiMap[key] = s
		}
		def writer = new StringWriter()
		def builder = new MarkupBuilder(writer)
		def assessmentMeta = builder.assessmentMeta(expName: expVO.name) {
			assessments() {
				for(aso in asList) {
					assessment(uniqueid:aso.uniqueid, assessmentid:aso.assessmentid, name:aso.name) {
						description aso.description
						def sList = scoreMap[aso.assessmentid]
						assert sList
						sList.sort{ a,b -> a.scoresequence <=> b.scoresequence }
						scores() {
							for(sc in sList) {
								def scKey="${sc.assessmentid}:${sc.scorename}"
								def scodeList = scMap[scKey]
								def que = aiMap[scKey]
								score(uniqueid:sc.uniqueid,scorename:sc.scorename,scoresequence:sc.scoresequence,
										scoretype:sc.scoretype, scorelevel:sc.scorelevel, parentasid:sc.parentasid,
										defaultvalue:sc.defaultvalue,parentscore:sc.parentscore,
										nullable:sc.nullable,assessmentontology:sc.assessmentontology,
										assessmentconcept:sc.assessmentconcept,
										securityclassification:sc.securityclassification,minanswers:sc.minanswers,
										maxanswers:sc.maxanswers,isrequired:sc.isrequired,isexcluded:sc.isexcluded,
										isnew:sc.isnew,ismodified:sc.ismodified,
										) {
											description sc.description
											if (que != null) {
												question(itemleadingtext:que.itemleadingtext, itemtrailingtext:que.itemtrailingtext)
											}
											if (scodeList != null) {
												for(scode in scodeList) {
													code(scorecode:scode.scorecode,scorecodelabel:scode.scorecodelabel,
															scorecodevalue:scode.scorecodevalue,
															scorecodetype:scode.scorecodetype, desc:scode.description)
												}
											}
										}
							}
						}
					}
				}
			}
		}
		println writer.toString()
		return writer.toString()
	}
	
	def public static extractExpAndImageData(db, String expName, String site) {
		def expDAO = new ExperimentDAO(db: db)
		def expList = expDAO.find("where name='$expName'")
		def expVO = expList[0];
		def rgDAO = new ResearchgroupDAO(db: db)
		def rgList = rgDAO.find("where nc_experiment_uniqueid=${expVO.uniqueid}")
		dumpVOs(rgDAO, rgList)
		String wp = buildWhereInPart('nc_researchgrouptype_uniqueid', rgList,'uniqueid')
		println "wp=$wp"
		def rgtDAO = new ResearchgrouptypeDAO(db: db)
		def rgtList = rgtDAO.find(wp)
		dumpVOs(rgtDAO, rgtList)
		
		def seDAO = new SubjexperimentDAO(db : db)
		def seList = seDAO.find("where nc_experiment_uniqueid = " + expVO.uniqueid)
		dumpVOs(seDAO, seList)
		def visitDAO = new ExpcomponentDAO(db :db)
		wp = "where nc_experiment_uniqueid=${expVO.uniqueid} and ";
		wp += buildWhereInPart('subjectid', seList,'subjectid',false)
		wp += " order by subjectid,componentid"
		def vList = visitDAO.find(wp)
		dumpVOs(visitDAO,vList)
		
		def rdDAO = new RawdataDAO(db: db)
		def rdList = rdDAO.find("where nc_experiment_uniqueid=${expVO.uniqueid}")
		// dumpVOs(rdDAO, rdList)
		rdList = rdList.findAll { item -> item.protocolid =~ /asl/ || item.protocolid =~ /t1/ || item.protocolid =~ /t2/ || item.protocolid.toLowerCase() =~ /^b0/}
		dumpVOs(rdDAO, rdList)
		def proDAO = new ProtocolDAO(db: db)
		wp = buildWhereInPart('protocolid', rdList, 'protocolid')
		def protocolList = proDAO.find(wp)
		dumpVOs(proDAO,protocolList)
		wp = buildWhereInPart('nc_colequipment_uniqueid', rdList, 'uniqueid')
		def ceDAO = new CollectionequipmentDAO(db: db)
		def ceList = ceDAO.find(wp)
		dumpVOs(ceDAO, ceList)
		
		def workDir = System.properties['user.dir']
		def resultsDir = new File(workDir,'results')
		resultsDir.mkdir()
		
		String xml = expInfo2Xml(expVO, rgList, rgtList,seList,vList)
		writeFile(new File(resultsDir,"exp_${expName}_${site}.xml"), xml)
		println ""
		xml = imageData2Xml(expVO, rdList, protocolList, ceList)
		writeFile(new File(resultsDir,"img_paths_${expName}_${site}.xml"), xml)
		
		println System.properties['user.dir']
	} 
	
	def static writeFile(File outFile, String content) {
		outFile.withWriter { out -> out.write(content); out.append("\n") }
		println "wrote file:$outFile"
	}
	
	
	def public static String imageData2Xml(expVO, rdList, protocolList, ceList) {
		def id2ProtocolMap = [:]
		def id2CEMap = [:]
		protocolList.each { id2ProtocolMap[it.protocolid] = it }
		ceList.each { id2CEMap[it.uniqueid] = it }
		def writer = new StringWriter()
		def builder = new MarkupBuilder(writer)
		def imgData = builder.imgData(expName: expVO.name) {
			for(pr in protocolList) {
				protocol(uniqueid:pr.uniqueid, protocolid:pr.protocolid, 
						protocolversion: pr.protocolversion, name:pr.name) { description pr.description }
			}
			for(ce in ceList) {
				collectionEquipment(uniqueid:ce.uniqueid, make:ce.make, model:ce.model)
			}
			for(rd in rdList) {
				def ce = id2CEMap[rd.nc_colequipment_uniqueid]
				assert ce
				rawData(uniqueid: rd.uniqueid, subjectid: rd.subjectid, segmentid: rd.segmentid, 
						componentid: rd.componentid, protocolid:rd.protocolid, protocolversion: rd.protocolversion,
						ontologysource: rd.ontologysource, conceptid: rd.conceptid, israw: rd.israw, 
						isbad: rd.isbad, make:ce.make, model:ce.model) { datauri  rd.datauri }
			}
		}
		println writer.toString()
		return writer.toString()
	}
	
	def public static String expInfo2Xml(expVO, rgList, rgtList,seList,vList) {
		def id2RgtMap = [:]
		def visitMap = [:]
		def rgMap = [:]
		rgList.each { rg -> rgMap[rg.uniqueid]  = rg }
		rgtList.each { rgt -> id2RgtMap[rgt.uniqueid] = rgt }
		vList.each { v ->
			def list = visitMap[v.subjectid]
			if (list == null) {
				list = [];
				visitMap.put v.subjectid, list
			}
			list << v
		}
		def writer = new StringWriter()
		def builder = new MarkupBuilder(writer)
		def expInfo = builder.expInfo(uniqueid:expVO.uniqueid, name: expVO.name, isregressiondata: expVO.isregressiondata) {
			baseuri expVO.baseuri
			description expVO.description
			rgList.each { rgo ->
				def rgt = id2RgtMap[rgo.nc_researchgrouptype_uniqueid]
				assert rgt
				rg(uniqueid: rgo.uniqueid, name: rgo.name, type: rgt.name) { description rgo.description }
			}
			subjects() {
				for(se in seList) {
					def rg = rgMap[se.nc_researchgroup_uniqueid]
					subjExp(uniqueid:se.uniqueid, subjectid:se.subjectid, group:rg.name) {
						def list = visitMap[se.subjectid]
						for(v in list) {
							visit(componentid:v.componentid,subjectid:v.subjectid,name:v.name,timeStamp:v.time_stamp,
								visittype:v.visittype, description:v.description)
						}
					}
				}
			}
		} 
		println writer.toString()
		return writer.toString()
	}
	
	def public static dumpVOs(dao, voList) {
		println '-' * 40
		voList.eachWithIndex { vo, i ->
			print "$i) ";
			dao.dumpVO(vo)
		}
	}
	def public static String buildWhereInPart(String colName, voList, String whereColName, includeWhere=true) {
		def values = []
		voList.each { vo -> 
			String val = vo[colName].toString();
			if (! val.isNumber() || colName == 'subjectid') { val = "'" + val + "'"
			} 
			values << val
		}
		
		String s = "$whereColName in (" +  values.unique().join(',') + ")"
		if (includeWhere) s = "where " + s
		return s
	}
	
	def public static String buildWhereInList(String colName, valList) {
		def values = []
		valList.each { 
			def val = it.toString();
			if (! val.isNumber()) { val = "'" + val + "'"
			}
			values << val
		}
		String s = " $colName in (" +  values.unique().join(',') + ")"
	}
	
	def public static getExperiments(db) {
		def dao = new ExperimentDAO(db: db)
		def expList = dao.find()
		expList.eachWithIndex { vo, i ->  
			print "$i) ";
			dao.dumpVO(vo)
		}
	}
	def public static getSubjExps(db, String expName) {
		def expDAO = new ExperimentDAO(db: db)
		def expList = expDAO.find("where name='$expName'")
		if (expList.empty) {
			return
		}
		def expVO = expList[0];
		def dao = new SubjexperimentDAO(db : db);
		def seList = dao.find("where nc_experiment_uniqueid=${expVO.uniqueid}")
		dumpVOs dao, seList
	}
	
	def public static getSubjExperiments(db) {
		def dao = new SubjexperimentDAO(db : db);
		def seList = dao.find()
		seList.eachWithIndex { vo, i ->  
			print "$i) ";
			dao.dumpVO(vo)
		}
	}
	
	def static getAssessmentIds4Exp(db, String expName) {
		def sql = """ select distinct b.assessmentid from nc_assessmentdata a, nc_storedassessment s,
			nc_experiment e, nc_assessment b where a.nc_storedassessment_uniqueid = s.uniqueid and
			s.nc_experiment_uniqueid = e.uniqueid and b.assessmentid = a.assessmentid and
			 e.name = '$expName' """;
		def asIds = []
		db.eachRow(sql.toString()) { rs-> asIds << rs.assessmentid }
		return asIds
	}
	
	def public static getAssessmentsForExp(db, String expName) {
		def sql = """ select distinct b.assessmentid, b.name from nc_assessmentdata a, nc_storedassessment s,
		       nc_experiment e, nc_assessment b where a.nc_storedassessment_uniqueid = s.uniqueid and
		       s.nc_experiment_uniqueid = e.uniqueid and b.assessmentid = a.assessmentid and 
		        e.name = '$expName' """;
		println "sql:$sql"
		println '-' * 40
		db.eachRow(sql.toString()) { rs ->
			println rs.assessmentid + ',' + rs.name
		}
	}
	
	def public static checkAllForExp(String expName) {
		def props = GenUtils.loadProperties("fbirn.properties");
		assert props
		(1..8).each { idx ->
			println "=" * 80
			def dbUrl = props.getProperty("db.url.$idx")
			println "dbURL:$dbUrl"
			try {
				def db = Sql.newInstance(dbUrl,
						props.getProperty('db.user'),props.getProperty('db.pwd'),
						'org.postgresql.Driver')
				println 'SubjExperiments'
				println '-' * 20
				getSubjExps(db,expName)
			} catch(Throwable t) {
				println t.message
			}
			println "=" * 80
		}
	}
	
	static void testIt(dbIdx, expName) {
		def props = GenUtils.loadProperties("fbirn.properties");
		assert props
		def dbUrl = props.getProperty("db.url.$dbIdx")
		println "dbURL:$dbUrl"
		String site = props.getProperty("site.$dbIdx")
		
		def db = Sql.newInstance(dbUrl,
				props.getProperty('db.user'),props.getProperty('db.pwd'),
				'org.postgresql.Driver')
		getExperiments(db)
		// def dbu = DBUtils.getDatabaseUser(db)
		println 'SubjExperiments'
		println '-' * 20
		getSubjExps(db,expName)
		// getSubjExperiments(db)
		println '-' * 20
		//getAssessmentsForExp(db,'FBIRNSubject2007TW__0051')
		//getAssessmentsForExp db, 'FBIRNSubject2007TE__0050'
		
		extractExpAndImageData(db,expName, site)
	}
	
	static void extractAssessment(dbIdx, String expName) {
		def props = GenUtils.loadProperties("fbirn.properties");
		assert props
		def dbUrl = props.getProperty("db.url.$dbIdx")
		println "dbURL:$dbUrl"
		String site = props.getProperty("site.$dbIdx")
		def db = Sql.newInstance(dbUrl,
				props.getProperty('db.user'),props.getProperty('db.pwd'),
				'org.postgresql.Driver')
		
		extractAssessmentMetaData(db, expName, site)
	}
	
	static void extractAsData(dbIdx, String expName) {
		def props = GenUtils.loadProperties("fbirn.properties");
		assert props
		def dbUrl = props.getProperty("db.url.$dbIdx")
		println "dbURL:$dbUrl"
		String site = props.getProperty("site.$dbIdx")
		def db = Sql.newInstance(dbUrl,
				props.getProperty('db.user'),props.getProperty('db.pwd'),
				'org.postgresql.Driver')
		
		extractAssessmentData(db, expName, site)
	}
	
	static void execute(args) {
		def cli = new CliBuilder(usage:"""exp_subj_extractor.sh -c <cmd>  -s <site-id> [-e <exp-name> ]
		""")
		cli.h(longOpt:'help','usage information')
		cli.c(argName: 'command', args:1,required:true,"command <extract-ei|chk-all4-exp|extract-asmeta|extract-asdata>")
		cli.s(argName:'siteid', args:1, "siteid [1..8] 1:duke 2:ucla 3:ucsd 4:uci 5:mrn 6:uiowa 7:umn 8:ucsf")
		cli.e(argName:'expname', args:1, "experiment name [FBIRNSubject2007TW__0051, FBIRNSubject2007TE__0050,fBIRNPhaseIII__0090]")
		def opt = cli.parse(args)
		if (!opt) {
			return
		}	
		if (opt.h) cli.usage()
		def cmd = opt.c;
		if (cmd == 'extract-ei') {
			if (!opt.s) cli.usage()
			if (opt.e) {
				testIt(opt.s,opt.e)
			} else {
				testIt(opt.s, 'FBIRNSubject2007TW__0051')
			}
		} else if (cmd == 'chk-all4-exp') {
			if (opt.e){
				checkAllForExp(opt.e)
			} else {
				checkAllForExp('FBIRNSubject2007TW__0051')
			}
		} else if (cmd =~ /asmeta$/) {
		   if (!opt.s || !opt.e) cli.usage()
		   extractAssessment(opt.s, opt.e)
		} else if (cmd =~ /asdata$/) {
		   if (!opt.s || !opt.e) cli.usage()
		   extractAsData(opt.s, opt.e)
		}
	}
	
	
	static void main(args) {
		// checkAllForExp('FBIRNSubject2007TW__0051')
		// checkAllForExp('FBIRNSubject2007TE__0050')
		// testIt(3)
		// execute(args)
		// extractAssessment(4, 'FBIRNSubject2007TW__0051')
		//extractAsData(4, 'FBIRNSubject2007TW__0051')
		
		// testIt(4, 'FBIRNSubject2007TW__0051')
		execute(args)
	}
}
