package fbirn

import java.text.SimpleDateFormat;

class MiscUtils {
	static class SubjectRec {
		String subjectID;
		String age;
		String gender;
		String birthDate;
		
		@Override
		public String toString() {
			return "subjectID:$subjectID, gender:$gender, birthDate:$birthDate";
		}
	}
	
	static class SubjectScanner {
		String subjectID;
		def scannersMap = [:];
		
		public String toString() {
			def s = "subjectID:$subjectID\nScanners\n";
			scannersMap.values().each { sc -> s += "\tsite:${sc.site} scanner:${sc.scanner}\n" }
			return s
		}
	}
	
	static class ScannerInfo {
		String scanner;
		String site;
	}
	
	
	static class ECTSSubjectSource {
		def map = [:]
		def subjects = [
			'001820672607',
			'001893148803',
			'001881882360',
			'001808502197',
			'001890679931',
			'001830175781',
			'001849957275',
			'001877319335',
			'001884195185',
			'001899862363',
			'001802407836',
			'001864309692',
			'001848974609',
			'001812020874',
			'001839071655',
			'001895248413',
			'001883554077',
			'001848715209'
		]
		
		def ECTSSubjectSource() {
			subjects.each { map[it] = it }
		}
		
		boolean isEligible(String subjectID) {
			return map[subjectID] != null
		}
	}
	
	def static void createSubjectTable(xmlFile) {
		def srMap = [:]
		def xml = new XmlSlurper().parse(xmlFile)
		xml.ds.each { ds ->  
			SubjectRec sr = new SubjectRec(subjectID: ds.'@subjectID',gender: ds.'@gender', birthDate: ds.'@birthDate');
			srMap[sr.subjectID] = sr
		}
		println  "# of subjects:" + srMap.size()
		srMap.keySet().sort().each { key -> def sr = srMap[key]; println sr }
	}
	
	def static void createScannerTable(xmlFile) {
		def sMap = [:]
		def xml = new XmlSlurper().parse(xmlFile)
		xml.ds.each { ds ->
			String expName = ds.'@expName'	
			String scannerInfo = ds.'@scannerInfo'
			String subjectID = ds.'@subjectID'
			def m = expName =~ /_([^_]+)$/
			String site = m[0][1]
			ScannerInfo si = new ScannerInfo(site:site, scanner:scannerInfo)
			SubjectScanner ss = sMap[subjectID]
			if (ss == null) {
				ss = new SubjectScanner(subjectID: subjectID)
				sMap[subjectID] = ss
			}
			ss.scannersMap[site] = si
		}
		println  "# of subjects:" + sMap.size()
		sMap.keySet().sort().each { key ->  
			def ss = sMap[key]
			println ss
		}
	} 
	
	static class ECTSSubjectRow {
		String subjectID;
		def visitMap = [:]
		def static sites2 = [
			'duke',
			'yale-v1',
			'yale-v2','bwh','mgh'
		]
		
		@Override
		public String toString() {
			String s = "$subjectID"
			for(String vs : sites2) {
				if (visitMap.containsKey(vs)) {
					s += ",X"
				} else {
					s += ","
				}
			}
			return s;
		}
	}
	
	def static void createECTSTable() {
		def rowMap = [:]
		
		File importFile = new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_import.xml")
		def xml = new XmlSlurper().parse(importFile)
		int xCount = 0
		xml.ds.each { ds ->
			String subjectID = ds.'@subjectID'
			String expName = ds.'@expName'
			String scanner = ds.'@scannerInfo'
			String visitDate = ds.'@visitDate'
			ECTSSubjectRow row = rowMap[subjectID]
			if (row == null) {
				row = new ECTSSubjectRow(subjectID:subjectID)
				rowMap[subjectID] = row
			}
			String site = extractSite(expName)
			if (site == 'yale') {
				String s = "${site}-v1"
				if (row.visitMap[s] != null) {
					println "multiple visit for $subjectID of  $expName at $visitDate (" + s + ")"
					s = "${site}-v2"
					if (row.visitMap[s] != null) {
						println "** multiple visit for $subjectID of $expName at $visitDate (" + s + ")"
						s = "${site}-v3"
					}
				}
				
				row.visitMap[s] = "X";
			} else {
				row.visitMap[site] = "X";
			}
			xCount++
		}
		
		println "X count:$xCount"
		print "Subject ID"
		ECTSSubjectRow.sites2.each { s -> print ",$s" }
		println ""
		rowMap.keySet().sort().each { key ->
			ECTSSubjectRow row = rowMap[key]
			println row
		}
	}
	
	static class Phase3SubjectRow extends WCTSSubjectRow {
		def static sites2 = [
			'duke',
			'mrn',
			'uci',
			'ucsd-v1',
			'ucsd-v2',
			'ucsf',
			'uiowa',
			'umn']
		@Override
		public String toString() {
			String s = "$subjectID"
			for(String vs : sites2) {
				if (visitMap.containsKey(vs)) {
					s += ",X"
				} else {
					s += ","
				}
			}
			return s;
		}
	}
	
	
	def static void createPhase3Table() {
		def rowMap = [:]
		
		File importFile = new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/phase3_import.xml")
		def xml = new XmlSlurper().parse(importFile)
		int xCount = 0
		xml.ds.each { ds ->
			String subjectID = ds.'@subjectID'
			String expName = ds.'@expName'
			String scanner = ds.'@scannerInfo'
			String visitDate = ds.'@visitDate'
			Phase3SubjectRow row = rowMap[subjectID]
			if (row == null) {
				row = new Phase3SubjectRow(subjectID:subjectID)
				rowMap[subjectID] = row
			}
			String site = extractSite(expName)
			if (site == 'ucsd') {
				String s = "${site}-v1"
				if (row.visitMap[s] != null) {
					println "multiple visit for $expName at $visitDate"
					s = "${site}-v2"
				}
				row.visitMap[s] = "X";
			} else {
				row.visitMap[site] = "X";
			}
			xCount++
		}
		
		println "X count:$xCount"
		print "Subject ID"
		Phase3SubjectRow.sites2.each { s -> print ",$s" }
		println ""
		rowMap.keySet().sort().each { key ->
			Phase3SubjectRow row = rowMap[key]
			println row
		}
	}
	
	static class WCTSSubjectRow {
		static SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
		String subjectID;
		def visitMap = [:]
		def static sites2 = [
			'ucsd-east',
			'ucsd-west',
			'uci-v1',
			'uci-v2',
			'uci-v3'
		]
		
		def orderVisits() {
		    def map = [:]
			for(String key in visitMap.keySet()) {
				if (key.startsWith("uci")) {
					def toks = key.split(/:/)
					Date date = df.parse(toks[1])
					map[key] = date
				}
			}
			def orderedKeys = []
			orderedKeys.addAll(map.keySet())
			orderedKeys.sort {a, b -> map[a] <=> map[b] }
			map.keySet().each {key ->  visitMap.remove(key) }
			
			
		}
		
		@Override
		public String toString() {
			String s = "$subjectID"
			for(String vs : sites2) {
				if (visitMap.containsKey(vs)) {
					s += ",X"
				} else {
					s += ","
				}
			}
			return s;
		}
	}
	
	def static void createWCTSTable() {
		def sites2 = [
			'ucsd-east',
			'ucsd-west',
			'uci-v1',
			'uci-v2',
			'uci-v3'
		]
		def rowMap = [:]
		
		File wctsImportFile = new File("/home/bozyurt/dev/java/clinical/scripts/fbirn_import/wcts_import.xml")
		def xml = new XmlSlurper().parse(wctsImportFile)
		int xCount = 0
		xml.ds.each { ds -> 
			String subjectID = ds.'@subjectID'
			String expName = ds.'@expName'
			String scanner = ds.'@scannerInfo'
			String visitDate = ds.'@visitDate'
			WCTSSubjectRow row = rowMap[subjectID]
			if (row == null) {
				row = new WCTSSubjectRow(subjectID:subjectID)
				rowMap[subjectID] = row
			}
			String site = extractSite(expName)
			if (scanner.endsWith("East")) {
				site += "-east"
			} else if (scanner.endsWith("West")) {
				site += "-west"
			} else if (site == "uci") {
			   String s = "uci-v1"
			   if (row.visitMap[s] != null) {
				   s = "uci-v2"
			   } 
			   if (row.visitMap[s] != null) {
				   s = "uci-v3"
			   }
			   if (row.visitMap[s] != null) {
				   println "There is already a visit for $subjectID of $expName for site:$site"
			   }
			   site = s;
			}
			row.visitMap[site] = "X";
			xCount++
		}
		
		println "X count:$xCount"
		print "Subject ID"
		sites2.each { s -> print ",$s" }
		println ""
		rowMap.keySet().sort().each { key ->
			WCTSSubjectRow row = rowMap[key]
			println row
		}
	}
	
	def static extractSite(String expName) {
		def m = expName =~ /_([^_]+)$/
		return m[0][1]
	}
	
	
	def static  countEligibleVisits() {
		File rootDir = new File('/data/bozyurt/fbirn/ASL_from_tomlab/ECTS')
		def visitDirs = []
		rootDir.eachDirRecurse { dir -> if (dir.name.startsWith("scanVisit__")) visitDirs << dir }
		println "# visitDir:" + visitDirs.size()
		
		ECTSSubjectSource ess = new ECTSSubjectSource()
		def eligibleVisits = [];
		for(File vd in visitDirs) {
			def subjectID = vd.parentFile.name
			if (!ess.isEligible(subjectID)) {
				continue
			}
			def seriesDirs = []
			vd.eachDir { dir -> if (dir.name != 'matlab') seriesDirs << dir }
			if (seriesDirs.size() > 3) {
				assert containsSeries('asl1', seriesDirs)
				assert containsSeries('aslmincon1', seriesDirs)
				assert containsSeries('aslcal1', seriesDirs)
				eligibleVisits.add(vd)
			}
		}
		println "# eligible visitDir:" + eligibleVisits.size()
		eligibleVisits.each {  println it }
		return eligibleVisits
	}
	
	static boolean containsSeries(String seriesName, dirs) {
		for(dir in dirs) {
			if (dir.name.equals(seriesName)) {
				return true
			}
		}
		return false;
	}
	
	
	
	
	static void main(args) {
		File importXmlFile = new File('/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_import.xml')
		//	createSubjectTable(importXmlFile)
		// createScannerTable(importXmlFile)
		
		//countEligibleVisits()
		
	 // createWCTSTable()
		// createPhase3Table()
       createECTSTable()
	}
}
