package fbirn

import java.io.File;

class UploadSeriesIntegrityChecker {
    
	def static getMatchingDirs(String startDir, String dirName) {
		def cmd = """find ${startDir} -name ${dirName} -type d"""
		def proc = cmd.execute()
		proc.waitFor()
		def list = []
		proc.in.text.eachLine { 
			list << it
		}
		return list
	}
	
	def static  assertFileCount(String dir,pattern, assertedSize) {
		def files = []
		def count = 0
		new File(dir).eachFile { f -> if (f.name =~ /$pattern/) { files << f; count++ }}
		// println "count:$count"
		assert count == assertedSize , "No dicom file size match:$dir"
	}
	
	def static getEmptyDirs(File rootDir) {
		def subjectDirList = []
		rootDir.eachFile { f ->  if (f.directory) subjectDirList << f}
		def emptySubjectDir = []
		for(File sd in subjectDirList) {
			def visitDir = []
			sd.eachFile { f -> if (f.directory) visitDir << f}
			if (visitDir.empty) {
				println "empty ${sd}"
			}
			for(File vd : visitDir) {
				def files = []
				vd.eachFileRecurse { f -> files << f }
				if (files.empty) {
					println "empty visit:${vd}"
				}
			}
		}
	}
	
	
	static void main(args) {
		File dir = new File('/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TW__0051')
		/*
		def list = getMatchingDirs(dir.canonicalPath,'fm2')
		list.each { 
			println it
		    assertFileCount(it,/MRDC\./,120)	 
		}
		*/
		
		dir = new File('/data/bozyurt/cbfbirn/upload/FBIRNSubject2007TE__0050')
		getEmptyDirs(dir)
	}
}
