package gtools.utils;

import groovy.sql.Sql;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.IDataSet;



/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DBStaticDataChecker.groovy,v 1.2 2007/10/10 01:14:41 bozyurt Exp $
 */

class DBStaticDataChecker  {
    def db;
	public DBStaticDataChecker() {
		def props = GenUtils.loadProperties("gtools-oracle.properties")
		assert props
	    db = Sql.newInstance(props.getProperty('db.url'), 
	    		 props.getProperty('db.user'),props.getProperty('db.pwd'),  
	    		 'oracle.jdbc.driver.OracleDriver')		
	}
	
	protected IDataSet getDataSet() {
		  return new FlatXmlDataSet( new FileInputStream( 
				  GenUtils.adjustPath("/home/bozyurt/dev/groovy/gtools/static_2.xml") ) );	
	}
	
		
   public void exportDB2FlatSet(String flatSetFile, tableNames, String schemaName = null) {
	  flatSetFile = GenUtils.adjustPath(flatSetFile); 
	  def IDatabaseConnection ic = new  DatabaseConnection(db.connection, schemaName);
	  def partialDataSet = new QueryDataSet(ic);
	  for(tn in tableNames) {
		 partialDataSet.addTable(tn); 
	  }
	  FlatXmlDataSet.write(partialDataSet, new FileOutputStream(flatSetFile));
   }
	
   public void prepDBDTD(String dtdFilename, String schemaName=null) {
	 dtdFilename = GenUtils.adjustPath(dtdFilename);  
	 def IDatabaseConnection ic = new  DatabaseConnection(db.connection, schemaName);
	 FlatDtdDataSet.write(ic.createDataSet(), new FileOutputStream(dtdFilename));
   }

	
	public static getNonEmptyTables(String xmlFile, boolean filterBigTables = false) {
		xmlFile = GenUtils.adjustPath(xmlFile)
		def tableNames = [];
		def reader = new FileReader(xmlFile);
		def recs = new XmlParser().parse(reader);
		def count = 0;
		for(te in recs.table) {
			if (te.'@numRows'.toInteger() > 0) {
				println te.'@name' << ' ' << te.'@numRows' ;
				if ( filterBigTables && 
						(te.'@numRows'.toInteger() < 50 || te.'@name' == 'NC_TABLEID') ) {				
				   tableNames << te.'@name';
				   println 'adding table ' << te.'@name';
				} 
				++count
			}
		}
		println "# of non-empty tables: $count"
		return tableNames;
	}
	
	
  static void main(args) {
	  def schemaXmlFile = '/home/bozyurt/dev/java/branch/BIRN/clinical/conf/gtools/schema.xml';
	  def dbSchemaDTD = '/home/bozyurt/dev/java/branch/BIRN/clinical/conf/gtools/schema.dtd';
	  def flatSetFile = '/home/bozyurt/dev/java/branch/BIRN/clinical/conf/gtools/clinical_data.xml';
      def tableNames = DBStaticDataChecker.getNonEmptyTables( schemaXmlFile, true );
    
      DBStaticDataChecker d = new DBStaticDataChecker();
      // d.prepDBDTD( dbSchemaDTD, "FBIRN_TEST2" );
      //d.exportDB2FlatSet(flatSetFile, tableNames, "FBIRN_TEST2");
  }

}