package gtools.utils;

import java.sql.SQLException;
import groovy.sql.Sql;
import clinical.server.utils.OracleUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DataObjectTypeAppConfig.groovy,v 1.5 2009/02/11 20:39:42 bozyurt Exp $
 */




class DataObjectTypeAppConfig {
   String dbType;
   def dbu;


   public def selectDOT(db) {
      DataobjecttypeDAO dao = new DataobjecttypeDAO(db : db);
      def dotList = dao.find();
      dotList.eachWithIndex { dot, i ->
         println "$i) ${dot.objecttype}"
      }
      def ans = DBUtils.getAnswer("Please select a Data object type");
      return dotList.get( Integer.parseInt(ans) );
   }

   public def  selectParam(db, msg) {
      ConfParamsDAO dao = new  ConfParamsDAO(db);
      def cpList = dao.find("where name like 'download.object.types%'", null);
      cpList.eachWithIndex { cp, i ->
         println "$i) ${cp.name} -> ${cp.value}"
      }
      def ans = DBUtils.getAnswer(msg);
      return cpList.get( Integer.parseInt(ans) );
   }

   public void listParams(db) {
       ConfParamsDAO dao = new  ConfParamsDAO(db);
       println '-' * 72
       def cpList = dao.find("where name like 'download.object.types%'", null);
       cpList.each { cp -> dao.dumpVO(cp) }
       println '-' * 72
   }

   public void addParam(db) {
      ConfParamsDAO cpDAO = new  ConfParamsDAO(db);
      ConfParamsGroupDAO cpgDAO = new ConfParamsGroupDAO(db);

      def cpgList = cpgDAO.find("where group_name = 'Advanced'",null);
      assert !cpgList.isEmpty()
      def cpg = cpgList.get(0);

      cpDAO.setDBType(dbType);
      cpDAO.setOwner(dbu);

      def dot = selectDOT(db);
      assert dot
      def cpList = cpDAO.find("where name like 'download.object.types.%'", null);
      int maxIdx = 0;
      cpList.each { cp ->
         int val = Integer.parseInt( cp.name.substring(cp.name.lastIndexOf('.')+1) );
         if ( maxIdx < val) maxIdx = val;
      }
      ++maxIdx;

      cpDAO.create( [name : "'download.object.types.$maxIdx'",
          value : "'${dot.objecttype}'",  param_group_id : cpg.unique_id,
          description : "'Downloadable object type'"]);
   }

   public void deleteParam(db) {
      ConfParamsDAO cpDAO = new  ConfParamsDAO(db);
      cpDAO.setDBType(dbType);
      cpDAO.setOwner(dbu);

      def cp2Del = selectParam(db,"Please select a parameter to delete");
      if (cp2Del) {
          cpDAO.delete([name : "'${cp2Del.name}'"]);
      }
      listParams(db);
   }


   public static void manage(String usersXMLFile) {
       // println "manage: $usersXMLFile"
       def props = [:];
       def db =  DBUtils.getDb(usersXMLFile, props);

       DataObjectTypeAppConfig app = new DataObjectTypeAppConfig(dbType : props.'db.type');

       db.connection.autoCommit = false;
       try {
         while(true) {
            def ans = DBUtils.getAnswer("Select operation (list,add,delete,exit)");
            if ( ans == 'list' || ans == 'l') {
               app.listParams(db);
            } else if ( ans == 'add' || ans == 'a') {
               if ( app.dbu == null) {
                   app.dbu = DBUtils.getDatabaseUser(db);
               }
               app.addParam(db)
            } else if (ans == 'exit' || ans == 'e' || ans == 'q') {
               break;
            } else if ( ans == 'delete' || ans == 'del') {
               if ( app.dbu == null) {
                   app.dbu = DBUtils.getDatabaseUser(db);
               }
               app.deleteParam(db)
            }
         }

         db.commit()
       } catch(SQLException e) {
          e.printStackTrace();
          db.rollback();
       } finally {
          db.connection.close();
       }
   }
}//;


   class DataobjecttypeDAO extends DataAccessObject {
	  List getFields() {
		return ['uniqueid','tableid', 'owner', 'modtime', 'moduser',
		        'objecttype','applicableactions','description'];
	  }
	} //;

	class ConfParamsGroupDAO extends DataAccessObject {
	   public ConfParamsGroupDAO(db) {
	     this.db = db;
	     this.tableName = 'nc_conf_params_group';
	   }

	   List getFields() {
	     return ['unique_id','group_name','description','owner','mod_time','mod_user'];
	  }
	} //;

	class ConfParamsDAO extends DataAccessObject {
	   public ConfParamsDAO(db) {
	     this.db = db;
	     this.tableName = 'nc_conf_params';
	   }

	   List getFields() {
	     return ['name','value','type','description', 'param_group_id'];
	  }

	  def create(Map argMap) {
	    def uid = nextUID();
	    def map = [name : null, value : null, type : "'string'" , description : null,
	               owner : ownerID, mod_time : modTimeCmd, mod_user : ownerID];
	    def sql = prepInsertQuery(argMap, map, true);
	    db.executeUpdate sql, [];
	  }
	} //;

