package clinical.comm;

import org.jdom.*;

/**
 * A Wrapper around any string of text (must be well formed XML text)
 * interchanged between server and client using this XML based messaging framework.
 * The string can be upto 64Kb long. This is useful to interchange arbitary XML
 * between client and server.
 *
 * @author I. Burak Ozyurt
 * @version $Id: Envelope.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class Envelope implements IXMLSerializer {
  protected String content;

  public Envelope() {}

  public Element toXML() {
    Element e = new Element("envelope");
    Element bodyElem = new Element("body");
    e.addContent(bodyElem);
    CDATA cd = new CDATA(content);
    bodyElem.setContent(cd);
    return e;
  }

  public void initializeFromXML(Element e) {
     Element be = e.getChild("body");
     this.content = be.getText();
  }

  //---------------------- setters --------------
  public void setContent(String newContent) { this.content = newContent; }
  //---------------------- getters --------------
  public String getContent() { return this.content; }

}


