package clinical.server;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Expsegment;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class VisitInfo {
	protected Expcomponent visit;
	protected List<Expsegment> segments = new LinkedList<Expsegment>();
	protected Collectionequipment equipment;
	protected Map<String, Collectionequipment> equipmentMap = new HashMap<String, Collectionequipment>(
			3);

	public VisitInfo(Expcomponent visit) {
		this.visit = visit;
	}

	public Expcomponent getVisit() {
		return this.visit;
	}

	public void addSegment(Expsegment segment) {
		if (!segments.contains(segment))
			segments.add(segment);
	}

	public boolean hasSegments() {
		return !segments.isEmpty();
	}

	public List<Expsegment> getSegments() {
		return segments;
	}

	public void setEquipment(Expsegment segment,
			Collectionequipment newEquipment) {
		System.out.println("registering equipment for segment "
				+ segment.getSegmentid().toString());
		equipmentMap.put(segment.getSegmentid().toString(), newEquipment);
	}

	public void setEquipment(int segmentID, Collectionequipment newEquipment) {
		equipmentMap.put(String.valueOf(segmentID), newEquipment);
	}

	public Collectionequipment getEquipment(Expsegment segment) {
		return equipmentMap.get(segment.getSegmentid().toString());
	}

	public Collectionequipment getEquipment(int segmentID) {
		return equipmentMap.get(String.valueOf(segmentID));
	}
}
